#pragma ident "@(#)cgpcompress.h	1.6 98/09/09 SMI"

/*
 * Copyright (c) 1997 by Sun Microsystems, Inc.
 * All Rights Reserved
 */


/******************************************************************************
 *
 * cgpcompress.h
 *
 * All internal data structures and constants used by the compression routine.
 *
 *****************************************************************************/


#define CGP_NUM_TABLE_ENTRIES 512
#define CGP_NUM_ENTRIES       64

typedef struct
{
    CGuint count;
    CGuint overrideSize;
    CGuint overrideShift;
    CGint  huffmanTablePos;
} CGPstats;


typedef struct
{
    CGint freq;
    CGint len;
    CGint shift;
    CGint abs;
    CGint merge;
    CGint amerge;
    CGint huffCodeSize;
    CGuint huffCode;
}  CGPtabledata;


CGvoid cgpCompressStream(CGPcommandstream *, CGint, CGint, CGint);

#define CGP_MAX_CODE_SIZE   (CGP_NUM_TABLE_ENTRIES+1)


extern void cgpCompHuffman(CGPtabledata *, int);
