/*
	Copyright 08/18/98 Sun Microsystems, Inc. All Rights Reserved

	@(#)demangle.h	1.3 08/18/98 16:53:40
*/

#ifndef _DEMANGLE_H
#define _DEMANGLE_H

#include <stddef.h>

#ifdef __cplusplus
extern "C" {
#endif

/* NOTE: the function demangle() is obsolete; use cplus_demangle() */

#ifdef __STDC__
/* return 0 if valid mangled name, -1 if not a valid mangled name */
int demangle(const char *in, char *out);

/* return 0 if valid mangled name, DEMANGLE_ESPACE or DEMANGLE_ENAME 
   otherwise 
*/
int cplus_demangle(const char *symbol, char *prototype, size_t size);

/* cplus_demangle_noret is the same as cplus_demangle except that
   function return types are not printed
*/
int cplus_demangle_noret(const char *symbol, char *prototype, size_t size);

#else
int demangle();
int cplus_demangle();
int cplus_demangle_noret();
#endif

#define DEMANGLE_ESPACE  -1  /* outsize is too small */
#define DEMANGLE_ENAME   1   /* name is not mangled properly */

#ifdef __cplusplus
}
#endif

#endif  /* _DEMANGLE_H */

