// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
// PARTICULAR PURPOSE.
//
// Copyright (C) 1993-1995  Microsoft Corporation.  All Rights Reserved.
//
//  MODULE:     initproc.c   
//
//  PURPOSE:    Contains application initialization routines.
//
//  PLATFORMS:  Windows 95, Windows NT
//
//  FUNCTIONS:
//      InitApplication()   - Register window classes
//      InitInstance()      - Create and display main windows
//
//  COMMENTS:
//
//

#include <windows.h>
#include <commctrl.h>
#include "globals.h"
#include "resource.h"

//----------------------------------------------------------------------------
// Application global variables

HANDLE g_hInstance = NULL;


//
//  FUNCTION:   InitApplication(HINSTANCE)
//
//  PURPOSE:    Registers the application's window class(es).
//
//  PARAMETERS: 
//      hInstance   - handle that uniquely identifies this application instance
//
//  RETURN VALUE:
//      (BOOL) Returns TRUE if the window classes are registered successfully
//             Returns FALSE otherwise
//
//  COMMENTS:
//

#define DEFBKGDCOLOR (COLOR_WINDOW + 1)
BOOL InitApplication(HINSTANCE hInstance)
{
    WNDCLASSEX  wcx;

    // The window class is not registered yet, so we have to fill a
    // window class structure with parameters that describe the
    // window class.
    wcx.cbSize        = sizeof(WNDCLASSEX);
    wcx.style         = 0;
    wcx.lpfnWndProc   = MainWndProc;     
    wcx.cbClsExtra    = 0;             
    wcx.cbWndExtra    = 0;             
    wcx.hInstance     = hInstance;     
    wcx.hIcon         = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_APPICON));
    wcx.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wcx.hbrBackground = (HBRUSH)DEFBKGDCOLOR;
    wcx.lpszMenuName  = MAKEINTRESOURCE( IDR_GENERIC );
    wcx.lpszClassName = "Win32Generic";  
    wcx.hIconSm       = LoadImage(hInstance,		
	                              MAKEINTRESOURCE(IDI_APPICON),
	                              IMAGE_ICON,
	                              16, 16,
	                              0);

    // Attempt to register the class first with the WNDCLASSEX structure
    // and if that doesn't work try just the WNDCLASS for NT and Win32s.
    if (!RegisterClassEx(&wcx))
    {   
        if (!RegisterClass((LPWNDCLASS)&wcx.style))
        {
            ErrorHandler();
            return (FALSE);
        }
    }        

    return (TRUE);
}


//
//  FUNCTION:   InitInstance(HINSTANCE, int)
//
//  PURPOSE:    Creates and displays the application's initial window(s).
//
//  PARAMETERS:
//      hInstance   - handle which uniquely identifies this instance
//      nCmdShow    - determines the state which the window should be initially
//                    shown in
//
//  RETURN VALUE:
//      (BOOL) Returns TRUE if the window(s) are created successfully.
//             Returns FALSE otherwise.
//
//  COMMENTS:
//

BOOL InitInstance(HANDLE  hInstance, int nCmdShow)
{
    HWND hwnd;                       // temporary window handle
    BOOL bStatus = FALSE;            // holds return status for function

    // Save the instance handle in global variable, which will be used in
    // many subsequent calls from this application to Windows
    g_hInstance = hInstance;

    // Create a main window for this application instance
    hwnd = CreateWindowEx(WS_EX_CLIENTEDGE,
    					  "Win32Generic",                 
                          "Treeview Sample Application",    
                          WS_OVERLAPPEDWINDOW,            
                          CW_USEDEFAULT,                  
                          CW_USEDEFAULT,                  
                          CW_USEDEFAULT,                  
                          CW_USEDEFAULT,                  
                          NULL,                           
                          NULL,                           
                          hInstance,                      
                          NULL                            
                         );

    // If the window was successfully created, make the window visible,
    // update its client area, and return "success".  If the window
    // was not created, return "failure"
    if (hwnd)
    {
        ShowWindow(hwnd, nCmdShow); // Set to visible & paint non-client area
        UpdateWindow(hwnd);         // Tell window to paint client area

        bStatus = TRUE;             // Indicate success, default is failure
    }
	else
	{
		ErrorHandler();
	}

    return bStatus;                  // Return status code
}




