/*
 *  IFrame.h
 *
 *  Purpose:
 *      Definition of the frame window IOleInPlaceFrame interface
 *      for RichEdit OLE support.
 */

class COleInPlaceFrame : public IOleInPlaceFrame
{
public:
    UINT m_cRef;                        // Reference count
    HWND m_hwndFrame;                   // Application frame window
    BOOL m_fCSHMode;                    // Context-sensitive help mode flag

    COleInPlaceFrame(HWND hwndFrame = NULL)
        : m_hwndFrame(hwndFrame), m_cRef(0), m_fCSHMode(FALSE) {}
    virtual ~COleInPlaceFrame() {}

    // IUnknown methods
    STDMETHODIMP QueryInterface(REFIID riid, LPVOID* ppvObj);
    STDMETHODIMP_(ULONG) AddRef();
    STDMETHODIMP_(ULONG) Release();

    // IOleWindow methods
    STDMETHODIMP GetWindow(HWND* phwnd);
    STDMETHODIMP ContextSensitiveHelp(BOOL fEnterMode);

    // IOleInPlaceUIWindow methods
    STDMETHODIMP GetBorder(LPRECT prcBorder);
    STDMETHODIMP RequestBorderSpace(LPCBORDERWIDTHS pbw);
    STDMETHODIMP SetBorderSpace(LPCBORDERWIDTHS pbw);
    STDMETHODIMP SetActiveObject(LPOLEINPLACEACTIVEOBJECT pipaobj, LPCOLESTR szObjName);

    // IOleInPlaceFrame methods
    STDMETHODIMP InsertMenus(HMENU hmenuShared, LPOLEMENUGROUPWIDTHS pmgw);
    STDMETHODIMP SetMenu(HMENU hmenuShared, HOLEMENU holemenu, HWND hwndActiveObject);
    STDMETHODIMP RemoveMenus(HMENU hmenuShared);
    STDMETHODIMP SetStatusText(LPCOLESTR szStatusText);
    STDMETHODIMP EnableModeless(BOOL fEnable);
    STDMETHODIMP TranslateAccelerator(LPMSG pmsg, WORD wID);

    // UI helpers
public:
    void ShowUIAndTools(BOOL fShow, BOOL fMenu);
    void ReinstateUI(void);

    // Implementation
private:
    void MoveClient(LPRECT prc, int dx, int dy);
};
