// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
// PARTICULAR PURPOSE.
//
// Copyright (C) 1993-1995  Microsoft Corporation.  All Rights Reserved.
//
//  MODULE: filedlg.c
//
//  PURPOSE: Shows basic use of "Open" and "Save As" common dialogs.
//
//
//  FUNCTIONS:
//    CmdFileOpen   - Uses Open common dialog to prompt user for filename
//    CmdFileSaveAs - Uses Save common dialog to prompt user for filename
//
//
//  COMMENTS:
//
//
//
//  SPECIAL INSTRUCTIONS: N/A
//

#include <windows.h>            // required for all Windows applications
#include <windowsx.h>
#include "globals.h"            // prototypes specific to this application
#include "resource.h"

static char szDirName[256] = {0};    // directory string
void SetDirectory(LPOPENFILENAME);

//
//  FUNCTION: CmdFileOpen(HWND, WORD, WORD, HWND)
//
//  PURPOSE: Call the open common dialog and show its results.
//
//  PARAMETERS:
//    hwnd     - The window handle.
//    wCommand - IDM_OPEN (Unused)
//    wNotify  - (Unused)
//    hwndCtrl - NULL (Unused)
//
//  RETURN VALUE:
//    Always returns 0
//
//  COMMENTS:
//
//

LRESULT CmdFileOpen(HWND hwnd, WORD wCommand, WORD wNotify, HWND hwndCtrl)
{
    OPENFILENAME ofn = {0};         // common dialog box structure
    TCHAR szFile[MAX_PATH];         // filename string
    TCHAR szFileTitle[MAX_PATH];    // file-title string
    TCHAR szFilter[MAX_PATH];       // filter string
    TCHAR chReplace;                // separator for szFilter
    int i, cbString;                // integer count variables

    // Retrieve the current directory name and store it in szDirName.

    if (szDirName[0] == 0)
    {
        GetCurrentDirectory(sizeof(szDirName), szDirName);
    }

    // Place the terminating null character in the szFile.

    szFile[0] = 0;

    // Load the filter string from the resource file.

    cbString = LoadString(hInst, IDS_FILTERSTRING, szFilter, MAX_PATH);

    // Add a terminating null character to the filter string.

    chReplace = szFilter[cbString - 1];
    for (i = 0; szFilter[i] != 0; i++)
    {
        if (szFilter[i] == chReplace)
            szFilter[i] = 0;
    }

    // Set the members of the OPENFILENAME structure.

    ofn.lStructSize = sizeof(OPENFILENAME);
    ofn.hwndOwner = hwnd;
    ofn.lpstrFilter = szFilter;
    ofn.nFilterIndex = 1;
    ofn.lpstrFile = szFile;
    ofn.nMaxFile = MAX_PATH;
    ofn.lpstrFileTitle = szFileTitle;
    ofn.nMaxFileTitle = MAX_PATH;
    ofn.lpstrInitialDir = szDirName;
    ofn.Flags = OFN_SHOWHELP | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

    // Display the Open dialog box.

    if (GetOpenFileName(&ofn))
    {
        CreateMDIChild(ofn.lpstrFile);
        Open(ofn.lpstrFile,
             MAKEBOOL(!(ofn.Flags && OFN_NOREADONLYRETURN)),
             hwnd);
        SetDirectory(&ofn);
    }
    return 0;
}


//
//  FUNCTION: CmdFileSaveAs(HWND, WORD, WORD, HWND)
//
//  PURPOSE: Call the SaveAs common dialog and show the results.
//
//  PARAMETERS:
//    hwnd     - The window handle.
//    wCommand - IDM_SAVEAS (Unused)
//    wNotify  - (Unused)
//    hwndCtrl - NULL (Unused)
//
//  RETURN VALUE:
//    Always returns 0
//
//  COMMENTS:
//
//

LRESULT CmdFileSaveAs(HWND hwnd, 
                      WORD wCommand, 
                      WORD wNotify, 
                      HWND hwndCtrl) 
{
    OPENFILENAME ofn = {0};         // common dialog box structure
    TCHAR szFile[MAX_PATH];         // filename string
    TCHAR szFileTitle[MAX_PATH];    // file-title string
    TCHAR szFilter[MAX_PATH];       // filter string
    TCHAR chReplace;                // string separator for szFilter
    int  i, cbString;               // integer count variables

    // Retrieve the current directory name and store it in szDirName.

    if (szDirName[0] == 0)
    {
        GetCurrentDirectory(sizeof(szDirName), szDirName);
    }

    // Place the terminating null character in szFile.

    szFile[0] = 0;

    // Load the filter string from the .RC file.

    cbString = LoadString(hInst, IDS_FILTERSTRING, szFilter, MAX_PATH);

    // Add a terminating null character to the filter string.

    chReplace = szFilter[cbString - 1];

    for (i = 0; szFilter[i] != 0; i++)
    {
        if (szFilter[i] == chReplace)
            szFilter[i] = 0;
    }

    // Set the members of the OPENFILENAME structure.

    ofn.lStructSize = sizeof(OPENFILENAME);
    ofn.hwndOwner = hwnd;
    ofn.lpstrFilter = szFilter;
    ofn.nFilterIndex = 1;
    ofn.lpstrFile = szFile;
    ofn.nMaxFile = MAX_PATH;

    ofn.lpstrFileTitle = szFileTitle;
    ofn.nMaxFileTitle = MAX_PATH;
    ofn.lpstrInitialDir = szDirName;
    ofn.lpstrDefExt = TEXT("rtf");
    ofn.Flags = OFN_SHOWHELP | OFN_OVERWRITEPROMPT;

    // Display the Save As dialog box.

    if (GetSaveFileName(&ofn))
    {
        SaveAs(ofn.lpstrFile, GetActiveMDIChild());
        SetDirectory(&ofn);
        return TRUE;
    }

    return 0;
}


//
//  FUNCTION: SetDirectory(LPOPENFILENAME)
//
//  PURPOSE: Saves the path to the current directory for future use
//
//  PARAMETERS:
//    lpofn - Long pointer to the OPENFILENAME structure
//
//  RETURN VALUE:
//    void
//
//  COMMENTS:
//
//

void SetDirectory(LPOPENFILENAME lpofn)
{
    lpofn->lpstrFile[lpofn->nFileOffset] = 0;
    lstrcpy(szDirName, lpofn->lpstrFile);
}
