#include <windows.h>
#include <dirent.h>
#include <string.h>
typedef struct tagWin32Dir {
    DIR		dir;
    struct dirent dent;
    char      	namefill[MAX_PATH];
    BOOL	fscase;
    BOOL        notfirst;
    long        topfill;
} Win32Dir;

typedef Win32Dir   * PW32DIR;

DIR * opendir(path)
char * path;
{
    DIR 	*dir=0;
    char 	fpath[MAX_PATH],full[MAX_PATH];
    LPTSTR	end,put;
    DWORD	fulllen;
    DWORD	fileattr,volattr;
    char	tmp[4];
    WIN32_FIND_DATA  first;
    HANDLE      fhand;
    struct dirent *entry;

    strcpy(fpath,path);
    end=fpath;
    while(((end=strchr(fpath,'/'))))
	*end='\\';
    GetFullPathName(fpath,
		    MAX_PATH,
		    full,
		    0);
   strcat(full,"\\*");
    if((fhand=FindFirstFile(full,
			    &first))==INVALID_HANDLE_VALUE)
	return(0);
    dir=malloc(sizeof(Win32Dir));
    memset(dir,0,sizeof(Win32Dir));
    dir->dd_fd=fhand;
    dir->dd_len=sizeof(struct dirent)*100;
    dir->dd_buf=entry=malloc(dir->dd_len);
    memset(dir->dd_buf,0,dir->dd_len);
    end=strstr(full,":");
    if (!end) {
      end=strstr(full,"\\");
      if (end)
	end++;
    }
    if (end) {
      end++;
      *end=0;
    }
    if (GetVolumeInformation(full,
			     0,
			     0,
			     0,
			     0,
			     &volattr,
			     0,
			     0))
      if (!(volattr & FS_CASE_SENSITIVE))
	  ((PW32DIR)dir)->fscase=TRUE;
    strcpy(entry->d_name,first.cFileName);
    if (((PW32DIR)dir)->fscase)
      strlwr(entry->d_name);
    entry->d_namlen=strlen(entry->d_name);
    ((PW32DIR)dir)->topfill=entry->d_reclen=sizeof(struct dirent);
    return(dir);
}

struct dirent * readdir(DIR * dir)
{
  struct dirent * retdir;
    
  if (dir->dd_loc>=((PW32DIR)dir)->topfill) {
    WIN32_FIND_DATA  findnew;
    if (!FindNextFile(dir->dd_fd,
		  &findnew))
      return(0);
    if (dir->dd_size<=dir->dd_loc) {
      dir->dd_size+=sizeof(struct dirent) * 100;
      dir->dd_buf=realloc(dir->dd_buf,dir->dd_size);
    }
    retdir=dir->dd_buf+dir->dd_loc;
    ((PW32DIR)dir)->topfill+=sizeof(struct dirent);
    dir->dd_loc+=sizeof(struct dirent);
    strcpy(retdir->d_name,findnew.cFileName);
    retdir->d_fileno=0;
    retdir->d_reclen=sizeof(struct dirent);
    retdir->d_namlen=strlen(retdir->d_name);
    if (((PW32DIR)dir)->fscase)
      strlwr(retdir->d_name);
  }
/*  retdir=dir->dd_buf+dir->dd_loc; */
  dir->dd_loc+=sizeof(struct dirent);
  return(retdir);
}

void rewinddir(DIR *dirp)
{
    if (dirp)
      dirp->dd_loc=0;
}

void seekdir(DIR *dirp,long pos)
{
  if (dirp) 
    {
      pos=(pos/sizeof(struct dirent))*sizeof(struct dirent);
      if (pos<dirp->dd_size)
	dirp->dd_loc=pos;
    }
}


long telldir(DIR * dirp)
{
    if (dirp)
	return(dirp->dd_loc);
    else
	return(0xffffffff);
}


	       

int closedir(DIR *dirp)
{
  if (dirp) {
    FindClose(dirp->dd_fd);
    free(dirp->dd_buf);
    free(dirp);
  }
  return(0);
}
