/*-
 * Copyright (c) 1990, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)rec_close.c	8.2 (Berkeley) 9/7/93";
#endif /* LIBC_SCCS and not lint */

#include <sys/types.h>

#ifndef WIN32
#include <sys/uio.h>
#include <sys/mman.h>
#endif

#include <errno.h>
#include <limits.h>
#include <stdio.h>
#include <unistd.h>

#include <db.h>
#include "recno.h"

/*
 * __REC_CLOSE -- Close a recno tree.
 *
 * Parameters:
 *	dbp:	pointer to access method
 *
 * Returns:
 *	RET_ERROR, RET_SUCCESS
 */
int
__rec_close(dbp)
	DB *dbp;
{
	BTREE *t;
	int rval;

	t = dbp->internal;
        printf("rec_close:\n");
	/* Toss any page pinned across calls. */
	if (t->bt_pinned != NULL) {
		mpool_put(t->bt_mp, t->bt_pinned, 0);
		t->bt_pinned = NULL;
	}

        printf("rec_close:about to rec_sync\n");
	if (__rec_sync(dbp, 0) == RET_ERROR)
		return (RET_ERROR);

	/* Committed to closing. */
	rval = RET_SUCCESS;
        
#ifndef WIN32
	if (ISSET(t, R_MEMMAPPED) && munmap(t->bt_smap, t->bt_msize))
		rval = RET_ERROR;
#else

	if (ISSET(t, R_MEMMAPPED) && 
                (TRUE != UnmapViewOfFile(t->bt_smap))) {
            printf("rec_close:UnmapViewOfFile failed\n");
		rval = RET_ERROR;
            }
#endif

	if (!ISSET(t, R_INMEM))
		if (ISSET(t, R_CLOSEFP)) {
                    printf("rec_close: close file ptr\n");
			if (fclose(t->bt_rfp))
				rval = RET_ERROR;
		} else
#ifndef WIN32
			if (close(t->bt_rfd))
				rval = RET_ERROR;
#else
			if (CloseHandle(t->bt_Hrfd)!=TRUE)
				rval = RET_ERROR;
#endif
        printf("rec_close: about to bt_close\n");
	if (__bt_close(dbp) == RET_ERROR)
		rval = RET_ERROR;

	return (rval);
}

#ifdef WIN32
/* define writev call */
/* with Hfd, write records pointed to by iov, returning the 
   # of bytes written */

int    writev(Hfd,iov,nrecs)
HANDLE Hfd;
struct iovec *iov;
int    nrecs;
{
    int    recno,bytes_written,total_written;

    total_written = 0;
    bytes_written = 0;

    if (recno == 0) {
        return (0);
    }

    for (recno=1;recno<=nrecs;recno++) {
        /* printf("In writev, nrecs %d recno %d size %d\n",
            nrecs,recno,iov->iov_len); */
        if (WriteFile(Hfd,iov->iov_base,iov->iov_len,
                    &bytes_written,NULL)!=TRUE) {
            return (total_written);
            }
        if (bytes_written != iov->iov_len) {
            return (total_written);
            }
        total_written+=bytes_written;
        iov++; /* point to next structure */
    }
    /* printf("writev returning %d\n",total_written); */
    return (total_written);
}

#endif

/*
 * __REC_SYNC -- sync the recno tree to disk.
 *
 * Parameters:
 *	dbp:	pointer to access method
 *
 * Returns:
 *	RET_SUCCESS, RET_ERROR.
 */
int
__rec_sync(dbp, flags)
	const DB *dbp;
	u_int flags;
{
	struct iovec iov[2];
	BTREE *t;
	DBT data, key;
	off_t off;
	recno_t scursor, trec;
	int status;

	t = dbp->internal;
        /* printf("rec_sync:\n"); */
	/* Toss any page pinned across calls. */
	if (t->bt_pinned != NULL) {
		mpool_put(t->bt_mp, t->bt_pinned, 0);
		t->bt_pinned = NULL;
	}

        /* printf("rec_sync:about to bt_sync\n"); */
	if (flags == R_RECNOSYNC)
		return (__bt_sync(dbp, 0));

	if (ISSET(t, R_RDONLY | R_INMEM) || !ISSET(t, R_MODIFIED))
		return (RET_SUCCESS);

	/* Read any remaining records into the tree. */
        printf("rec_sync:about to bt_irec\n");
	if (!ISSET(t, R_EOF) && t->bt_irec(t, MAX_REC_NUMBER) == RET_ERROR)
		return (RET_ERROR);

	/* Rewind the file descriptor. */
#ifndef WIN32
	if (lseek(t->bt_rfd, (off_t)0, SEEK_SET) != 0)
		return (RET_ERROR);
#else
        printf("rec_sync:about to SetFilePointer\n");
	if (SetFilePointer(t->bt_Hrfd, 0,NULL,FILE_BEGIN) != 0) {
            printf("rec_sync:SetFilePointer fail\n");
            printf("GetLastError %d\n",GetLastError());
            printf("Handle - %x\n",t->bt_Hrfd);
		return (RET_ERROR);
            }
#endif

	iov[1].iov_base = "\n";
	iov[1].iov_len = 1;
	scursor = t->bt_rcursor;

	key.size = sizeof(recno_t);
	key.data = &trec;

        printf("rec_sync:about seq\n");
	status = (dbp->seq)(dbp, &key, &data, R_FIRST);

        printf("rec_sync:about to writev\n");
        printf("rec_sync:status %d\n",status);
        while (status == RET_SUCCESS) {
		iov[0].iov_base = data.data;
		iov[0].iov_len = data.size;
#ifndef WIN32
		if (writev(t->bt_rfd, iov, 2) != data.size + 1)
#else
    		if (writev(t->bt_Hrfd, iov, 2) != data.size + 1)
#endif
			return (RET_ERROR);
                /* printf("rec_sync:about to seq\n"); */
                status = (dbp->seq)(dbp, &key, &data, R_NEXT);
                /* printf("rec_sync:status %d\n",status); */
        }
        printf("rec_sync:done with writev\n");

	t->bt_rcursor = scursor;
	if (status == RET_ERROR)
		return (RET_ERROR);
#ifndef WIN32
	if ((off = lseek(t->bt_rfd, (off_t)0, SEEK_CUR)) == -1)
		return (RET_ERROR);
	if (ftruncate(t->bt_rfd, off))
		return (RET_ERROR);
#else
        if (SetFilePointer(t->bt_Hrfd, 0, NULL,FILE_CURRENT) == 0xffffffff)
		return (RET_ERROR);
        /* truncate to this point */
        printf("rec_sync:about to truncate\n");
        if (SetEndOfFile(t->bt_Hrfd)!=TRUE)
		return (RET_ERROR);
#endif
	CLR(t, R_MODIFIED);
	return (RET_SUCCESS);
}








