/*
 * Decompiled with CFR 0.152.
 */
package netscape.plugin.composer;

import netscape.plugin.composer.Composer;
import netscape.plugin.composer.ComposerDocument;
import netscape.plugin.composer.Plugin;
import netscape.plugin.composer.PluginManager;

class PluginRunner
implements Runnable {
    private Plugin plugin;
    private ComposerDocument document;
    private PluginManager manager;

    public PluginRunner(Plugin plugin, ComposerDocument composerDocument, PluginManager pluginManager) {
        this.plugin = plugin;
        this.document = composerDocument;
        this.manager = pluginManager;
    }

    public void run() {
        Composer composer = this.document.getComposer();
        try {
            boolean bl = this.plugin.perform(this.document);
            this.manager.pluginFinished(composer, bl ? 2 : 1, null);
            return;
        }
        catch (ThreadDeath threadDeath) {
            System.err.println("Composer plugin " + this.plugin + " was killed.");
            return;
        }
        catch (Throwable throwable) {
            System.err.println("Composer plugin " + this.plugin + " threw this exception:");
            throwable.printStackTrace();
            this.manager.pluginFinished(composer, 0, throwable.toString());
            return;
        }
    }
}

