/*
 * Decompiled with CFR 0.152.
 */
package symantec.tools.debug;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.Socket;
import java.util.Hashtable;
import symantec.tools.debug.Agent;
import symantec.tools.debug.AgentConstants;
import symantec.tools.debug.AgentIn;
import symantec.tools.debug.DebuggerCallback;
import symantec.tools.debug.ExecReRouter;
import symantec.tools.debug.InvalidPCException;
import symantec.tools.debug.LocalCommStream;
import symantec.tools.debug.LocalVariable;
import symantec.tools.debug.NoSessionException;
import symantec.tools.debug.RemoteArray;
import symantec.tools.debug.RemoteBoolean;
import symantec.tools.debug.RemoteByte;
import symantec.tools.debug.RemoteChar;
import symantec.tools.debug.RemoteClass;
import symantec.tools.debug.RemoteDouble;
import symantec.tools.debug.RemoteField;
import symantec.tools.debug.RemoteFloat;
import symantec.tools.debug.RemoteInt;
import symantec.tools.debug.RemoteLong;
import symantec.tools.debug.RemoteObject;
import symantec.tools.debug.RemoteShort;
import symantec.tools.debug.RemoteStackFrame;
import symantec.tools.debug.RemoteString;
import symantec.tools.debug.RemoteThread;
import symantec.tools.debug.RemoteThreadGroup;
import symantec.tools.debug.RemoteValue;
import symantec.tools.debug.SymDbgExec;
import symantec.tools.debug.SymDbgExprFindContext;
import symantec.tools.debug.SymDbgExprResult;
import symantec.tools.debug.SymDbgLoadExpr;
import symantec.tools.debug.SymDbgProcess;

class RemoteAgent
implements AgentConstants {
    private Socket socket;
    private LocalCommStream localComm1;
    private InputStream localCommIn1;
    private InputStream localCommIn2;
    private OutputStream localCommOut1;
    private DataInputStream in;
    private DataOutputStream out;
    private Hashtable objects = new Hashtable();
    private DebuggerCallback client;
    private AgentIn debugIn;
    private Thread debugInThread;
    private RemoteClass classObject;
    RemoteClass classClass;
    RemoteClass classString;
    boolean closeRemoteInterpreter = false;
    private RemoteThreadGroup systemThreadGroup;
    private boolean verbose = false;
    private boolean closing = false;
    private SymDbgProcess thisProcess;
    private boolean closed = false;

    private int readPassword(String string) {
        int n;
        int n2 = 0;
        int n3 = "23456789abcdefghijkmnpqrstuvwxyz".length();
        int n4 = 0;
        while (n4 < string.length()) {
            n = "23456789abcdefghijkmnpqrstuvwxyz".indexOf(string.charAt(n4));
            if (n == -1) {
                return 0;
            }
            n2 = n2 * n3 + n;
            ++n4;
        }
        n = 0;
        int n5 = 0;
        while (n5 < 8) {
            int n6 = n2 & 6 << n5 * 3;
            n |= n6 >> n5 + 1;
            ++n5;
        }
        return n;
    }

    private void initSession(boolean bl) throws Exception {
        int n = this.in.readInt();
        if (n != 71) {
            System.err.println("Version mismatch between debugger and remote agent.");
            System.exit(1);
        }
        this.classObject = (RemoteClass)this.readValue(this.in);
        this.classClass = (RemoteClass)this.readValue(this.in);
        this.classString = (RemoteClass)this.readValue(this.in);
        this.message("loading classes ...");
        int n2 = this.in.readInt();
        int n3 = 0;
        while (n3 < n2) {
            RemoteClass cfr_ignored_0 = (RemoteClass)this.readValue(this.in);
            ++n3;
        }
        this.systemThreadGroup = (RemoteThreadGroup)this.readValue(this.in);
        this.setVerbose(bl);
        this.closed = false;
        this.closing = false;
    }

    RemoteAgent(String string, String string2, String string3, DebuggerCallback debuggerCallback, boolean bl) throws Exception {
        Object object;
        this.verbose = bl;
        String string4 = null;
        if (string2 == null) {
            SymDbgProcess symDbgProcess;
            object = System.getProperty("file.separator");
            SymDbgExec symDbgExec = new SymDbgExec();
            String string5 = String.valueOf(System.getProperty("java.home")) + (String)object + "bin" + (String)object + (new ExecReRouter().check() ? "javaw_g" : "java_g") + ".exe";
            String string6 = new String(String.valueOf(symDbgExec.getShortPath(string5)) + " -debug -debugport -1 " + string3 + " symantec.tools.debug.EmptyApp");
            this.message("starting child: " + string6);
            this.thisProcess = symDbgProcess = symDbgExec.exec(string6);
            DataInputStream dataInputStream = new DataInputStream(symDbgProcess.getInputStream());
            String string7 = dataInputStream.readLine();
            if (string7 == null) {
                this.error("Failed to exec a child java interpreter.");
                System.exit(1);
            }
            if ((string2 = string7.substring(string7.indexOf("=") + 1)).charAt(0) == '/') {
                string4 = new String(string2.substring(1));
                string2 = null;
            } else {
                this.message("password returned: " + string2);
            }
            this.closeRemoteInterpreter = true;
        }
        this.client = debuggerCallback;
        if (string2 == null) {
            this.localComm1 = new LocalCommStream();
            object = new LocalCommStream();
            try {
                this.localComm1.open(String.valueOf(string4) + "1");
                ((LocalCommStream)object).open(String.valueOf(string4) + "2");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.socket = null;
            this.localCommIn1 = this.localComm1.getInputStream();
            this.in = new DataInputStream(this.localCommIn1);
            this.localCommOut1 = this.localComm1.getOutputStream();
            this.out = new DataOutputStream(this.localCommOut1);
            this.localCommIn2 = ((LocalCommStream)object).getInputStream();
            this.debugIn = new AgentIn(this, new DataInputStream(this.localCommIn2), debuggerCallback, bl);
            this.debugInThread = new Thread((Runnable)this.debugIn, "Agent input");
            this.debugInThread.start();
            this.localComm1.termwatch(this.getProcessHandle());
        } else {
            this.socket = new Socket(string, this.readPassword(string2));
            object = new DataInputStream(new BufferedInputStream(new Socket(string, this.getDebugPort()).getInputStream()));
            this.debugIn = new AgentIn(this, (DataInputStream)object, debuggerCallback, bl);
            this.debugInThread = new Thread((Runnable)this.debugIn, "Agent input");
            this.debugInThread.start();
            this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
            this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.localCommIn2 = null;
            this.localCommIn1 = null;
            this.localCommOut1 = null;
        }
        this.message("connected");
        this.initSession(bl);
    }

    RemoteAgent(DebuggerCallback debuggerCallback, boolean bl) throws Exception {
        if (!Agent.isDebuggable()) {
            throw new IllegalAccessError();
        }
        this.verbose = bl;
        this.client = debuggerCallback;
        PipedInputStream pipedInputStream = new PipedInputStream();
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream2 = new PipedInputStream();
        Agent.connectToAgent(pipedOutputStream, pipedInputStream, pipedInputStream2);
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(pipedInputStream2));
        this.debugIn = new AgentIn(this, dataInputStream, debuggerCallback, bl);
        this.debugInThread = new Thread((Runnable)this.debugIn, "Agent input");
        this.debugInThread.start();
        this.in = new DataInputStream(pipedInputStream);
        this.out = new DataOutputStream(pipedOutputStream);
        this.message("connected");
        Agent.addSystemThread(Thread.currentThread());
        this.initSession(bl);
    }

    public int getProcessId() {
        return this.thisProcess.getProcessId();
    }

    public int getProcessHandle() {
        return this.thisProcess.getProcessHandle();
    }

    public void closeDebugSocket() {
        try {
            if (this.socket != null) {
                this.socket.close();
                return;
            }
        }
        catch (Exception exception) {}
    }

    public void debugBreak() throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(78);
            this.getReply(78);
            return;
        }
    }

    int getDebugPort() {
        return this.socket.getPort();
    }

    InputStream getSourceFile(String string, String string2) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(59);
            this.out.writeUTF(string2);
            this.out.writeUTF(string);
            try {
                this.getReply(59);
            }
            catch (Exception exception) {
                InputStream inputStream = null;
                Object var5_8 = null;
                return inputStream;
            }
            int n = this.in.readInt();
            if (n == -1) {
                InputStream inputStream = null;
                Object var5_9 = null;
                return inputStream;
            }
            this.message("getSourceFile: allocating " + n + " bytes.");
            byte[] byArray = new byte[n];
            try {
                this.in.readFully(byArray);
            }
            catch (IOException iOException) {
                this.error("unable to read " + string2);
                InputStream inputStream = null;
                Object var5_10 = null;
                return inputStream;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            Object var5_11 = null;
            return byteArrayInputStream;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String objectToString(int n) {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            try {
                this.out.write(60);
                this.out.writeInt(n);
                this.getReply(60);
                if (this.in.readInt() != 0) return this.in.readUTF();
                return null;
            }
            catch (Exception exception) {
                return "<communication error>";
            }
        }
    }

    void close() {
        this.message("close(" + this.closeRemoteInterpreter + ")");
        this.closing = true;
        try {
            this.debugInThread.stop();
            if (this.closeRemoteInterpreter) {
                if (this.thisProcess != null) {
                    this.thisProcess.destroy();
                } else {
                    DataOutputStream dataOutputStream = this.out;
                    synchronized (dataOutputStream) {
                        this.out.write(58);
                        this.getReply(58);
                    }
                }
            }
            if (this.socket == null) {
                if (this.localComm1 != null) {
                    this.localComm1.termwait();
                }
            } else {
                this.socket.close();
            }
        }
        catch (Exception exception) {}
        this.closed = true;
    }

    RemoteObject get(Integer n) {
        return (RemoteObject)this.objects.get(n);
    }

    private void put(Integer n, RemoteObject remoteObject) {
        this.objects.put(n, remoteObject);
    }

    RemoteValue readValue(DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readInt();
        switch (n) {
            case 17: {
                RemoteObject remoteObject;
                int n2 = dataInputStream.readInt();
                if (n2 == 0) {
                    return null;
                }
                Integer n3 = new Integer(n2);
                RemoteClass remoteClass = (RemoteClass)this.get(n3);
                if (remoteClass == null) {
                    remoteClass = new RemoteClass(this, n2);
                    this.put(n3, remoteClass);
                }
                if ((remoteObject = this.get(n3 = new Integer(n2 = dataInputStream.readInt()))) == null) {
                    remoteObject = new RemoteObject(this, n2, remoteClass);
                    this.put(n3, remoteObject);
                }
                return remoteObject;
            }
            case 16: {
                int n4 = dataInputStream.readInt();
                Integer n5 = new Integer(n4);
                RemoteClass remoteClass = (RemoteClass)this.get(n5);
                if (remoteClass == null) {
                    remoteClass = new RemoteClass(this, n4);
                    this.put(n5, remoteClass);
                }
                return remoteClass;
            }
            case 19: {
                RemoteThread remoteThread;
                int n6 = dataInputStream.readInt();
                Integer n7 = new Integer(n6);
                RemoteClass remoteClass = (RemoteClass)this.get(n7);
                if (remoteClass == null) {
                    remoteClass = new RemoteClass(this, n6);
                    this.put(n7, remoteClass);
                }
                if ((remoteThread = (RemoteThread)this.get(n7 = new Integer(n6 = dataInputStream.readInt()))) == null) {
                    remoteThread = new RemoteThread(this, n6, remoteClass);
                    this.put(n7, remoteThread);
                }
                return remoteThread;
            }
            case 15: {
                RemoteThreadGroup remoteThreadGroup;
                int n8 = dataInputStream.readInt();
                Integer n9 = new Integer(n8);
                RemoteClass remoteClass = (RemoteClass)this.get(n9);
                if (remoteClass == null) {
                    remoteClass = new RemoteClass(this, n8);
                    this.put(n9, remoteClass);
                }
                if ((remoteThreadGroup = (RemoteThreadGroup)this.get(n9 = new Integer(n8 = dataInputStream.readInt()))) == null) {
                    remoteThreadGroup = new RemoteThreadGroup(this, n8, remoteClass);
                    this.put(n9, remoteThreadGroup);
                }
                return remoteThreadGroup;
            }
            case 18: {
                int n10 = dataInputStream.readInt();
                Integer n11 = new Integer(n10);
                RemoteString remoteString = (RemoteString)this.get(n11);
                if (remoteString == null) {
                    remoteString = new RemoteString(this, n10);
                    this.put(n11, remoteString);
                }
                return remoteString;
            }
            case 9: {
                int n12 = dataInputStream.readInt();
                if (n12 == 0) {
                    return null;
                }
                Integer n13 = new Integer(n12);
                RemoteClass remoteClass = (RemoteClass)this.get(n13);
                if (remoteClass == null) {
                    remoteClass = new RemoteClass(this, n12);
                    this.put(n13, remoteClass);
                }
                n12 = dataInputStream.readInt();
                n13 = new Integer(n12);
                int n14 = dataInputStream.readInt();
                RemoteArray remoteArray = (RemoteArray)this.get(n13);
                if (remoteArray == null) {
                    remoteArray = new RemoteArray(this, n12, remoteClass, n14);
                    this.put(n13, remoteArray);
                }
                return remoteArray;
            }
            case 0: {
                return new RemoteBoolean(dataInputStream.readBoolean());
            }
            case 1: {
                return new RemoteByte(dataInputStream.readByte());
            }
            case 2: {
                return new RemoteChar(dataInputStream.readChar());
            }
            case 3: {
                return new RemoteShort(dataInputStream.readShort());
            }
            case 4: {
                return new RemoteInt(dataInputStream.readInt());
            }
            case 5: {
                return new RemoteLong(dataInputStream.readLong());
            }
            case 6: {
                return new RemoteFloat(dataInputStream.readFloat());
            }
            case 7: {
                return new RemoteDouble(dataInputStream.readDouble());
            }
        }
        this.error("invalid type code: " + n);
        return null;
    }

    private void getReply(int n) throws Exception {
        if (this.closed) {
            throw new NoSessionException();
        }
        this.out.flush();
        while (true) {
            int n2 = 0;
            try {
                n2 = this.in.readInt();
            }
            catch (EOFException eOFException) {
                if (!this.closing) {
                    this.error("unexpected eof");
                }
                return;
            }
            catch (IOException iOException) {
                if (this.closing) {
                    return;
                }
                throw iOException;
            }
            if (n2 == -2) {
                Exception exception = new Exception(this.in.readUTF());
                throw exception;
            }
            if (n2 == n) break;
            this.error("unexpected reply: wanted " + n + ", got " + n2);
        }
    }

    RemoteClass[] listClasses() throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(49);
            this.getReply(49);
            int n = this.in.readInt();
            this.message("reading " + n + " classes...");
            RemoteClass[] remoteClassArray = new RemoteClass[n];
            int n2 = 0;
            while (n2 < n) {
                remoteClassArray[n2] = (RemoteClass)this.readValue(this.in);
                ++n2;
            }
            RemoteClass[] remoteClassArray2 = remoteClassArray;
            Object var3_6 = null;
            return remoteClassArray2;
        }
    }

    RemoteClass findClass(String string) throws Exception {
        RemoteClass[] remoteClassArray = this.listClasses();
        int n = 0;
        while (n < remoteClassArray.length) {
            String string2 = remoteClassArray[n].getName();
            if (string.equals(string2)) {
                return remoteClassArray[n];
            }
            int n2 = string2.lastIndexOf(".");
            if (n2 >= 0 && string2.length() > n2) {
                string2 = string2.substring(n2 + 1);
            }
            if (string.equals(string2)) {
                return remoteClassArray[n];
            }
            ++n;
        }
        return this.getClassByName(string);
    }

    RemoteThreadGroup[] listThreadGroups(RemoteThreadGroup remoteThreadGroup) throws Exception {
        RemoteThreadGroup[] remoteThreadGroupArray = null;
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(47);
            this.out.writeInt(remoteThreadGroup == null ? 0 : remoteThreadGroup.getId());
            this.getReply(47);
            int n = this.in.readInt();
            remoteThreadGroupArray = new RemoteThreadGroup[n];
            this.message("listThreadGroups: " + n + " groups");
            int n2 = 0;
            while (n2 < n) {
                remoteThreadGroupArray[n2] = (RemoteThreadGroup)this.readValue(this.in);
                ++n2;
            }
        }
        return remoteThreadGroupArray;
    }

    RemoteThread[] listThreads(RemoteThreadGroup remoteThreadGroup, boolean bl) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(25);
            this.out.writeInt(remoteThreadGroup == null ? this.systemThreadGroup.getId() : remoteThreadGroup.getId());
            this.out.writeBoolean(bl);
            this.getReply(25);
            int n = this.in.readInt();
            RemoteThread[] remoteThreadArray = new RemoteThread[n];
            int n2 = 0;
            while (n2 < n) {
                remoteThreadArray[n2] = (RemoteThread)this.readValue(this.in);
                ++n2;
            }
            RemoteThread[] remoteThreadArray2 = remoteThreadArray;
            Object var5_8 = null;
            return remoteThreadArray2;
        }
    }

    void suspendThread(int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(27);
            this.out.writeInt(n);
            this.getReply(27);
            return;
        }
    }

    void resumeThread(int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(28);
            this.out.writeInt(n);
            this.getReply(28);
            return;
        }
    }

    void resumeLastSuspendedThreads() throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(29);
            this.getReply(29);
            return;
        }
    }

    RemoteStackFrame[] dumpStack(RemoteThread remoteThread) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(32);
            this.out.writeInt(remoteThread.getId());
            this.getReply(32);
            int n = this.in.readInt();
            RemoteStackFrame[] remoteStackFrameArray = new RemoteStackFrame[n];
            int n2 = 0;
            while (n2 < n) {
                RemoteObject remoteObject = (RemoteObject)this.readValue(this.in);
                remoteStackFrameArray[n2] = new RemoteStackFrame(remoteObject, remoteThread, n2, this);
                remoteStackFrameArray[n2].className = this.in.readUTF();
                remoteStackFrameArray[n2].methodName = this.in.readUTF();
                remoteStackFrameArray[n2].lineno = this.in.readInt();
                remoteStackFrameArray[n2].pc = this.in.readInt();
                remoteStackFrameArray[n2].setRemoteClass((RemoteClass)this.readValue(this.in));
                int n3 = this.in.readInt();
                remoteStackFrameArray[n2].localVariables = new LocalVariable[n3];
                int n4 = 0;
                while (n4 < n3) {
                    LocalVariable localVariable = new LocalVariable();
                    localVariable.slot = this.in.readInt();
                    localVariable.name = this.in.readUTF();
                    localVariable.signature = this.in.readUTF();
                    localVariable.methodArgument = this.in.readBoolean();
                    this.message("lvar " + n4 + ": slot=" + localVariable.slot + ", name=" + localVariable.name + ", sig=" + localVariable.signature + ", arg=" + localVariable.methodArgument);
                    remoteStackFrameArray[n2].localVariables[n4] = localVariable;
                    ++n4;
                }
                ++n2;
            }
            RemoteStackFrame[] remoteStackFrameArray2 = remoteStackFrameArray;
            Object var4_11 = null;
            return remoteStackFrameArray2;
        }
    }

    void stopThread(int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(56);
            this.out.writeInt(n);
            this.getReply(56);
            return;
        }
    }

    void stopThreadGroup(int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(57);
            this.out.writeInt(n);
            this.getReply(57);
            return;
        }
    }

    void getClassInfo(RemoteClass remoteClass) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(20);
            this.out.writeInt(remoteClass.id);
            this.getReply(20);
            remoteClass.name = this.in.readUTF();
            remoteClass.sourceName = this.in.readUTF();
            remoteClass.intf = this.in.readInt() != 0;
            remoteClass.superclass = (RemoteClass)this.readValue(this.in);
            remoteClass.loader = (RemoteObject)this.readValue(this.in);
            remoteClass.interfaces = new RemoteClass[this.in.readInt()];
            int n = 0;
            while (n < remoteClass.interfaces.length) {
                remoteClass.interfaces[n] = (RemoteClass)this.readValue(this.in);
                ++n;
            }
            return;
        }
    }

    RemoteClass getClassByName(String string) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(22);
            this.out.writeUTF(string);
            this.getReply(22);
            RemoteClass remoteClass = (RemoteClass)this.readValue(this.in);
            Object var4_4 = null;
            return remoteClass;
        }
    }

    void getThreadGroupInfo(RemoteThreadGroup remoteThreadGroup) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(48);
            this.out.writeInt(remoteThreadGroup.id);
            this.getReply(48);
            remoteThreadGroup.parent = (RemoteThreadGroup)this.readValue(this.in);
            remoteThreadGroup.name = this.in.readUTF();
            remoteThreadGroup.maxPriority = this.in.readInt();
            remoteThreadGroup.daemon = this.in.readBoolean();
            return;
        }
    }

    String getThreadName(int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(21);
            this.out.writeInt(n);
            this.getReply(21);
            String string = this.in.readUTF();
            Object var4_4 = null;
            return string;
        }
    }

    int getThreadStatus(int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(31);
            this.out.writeInt(n);
            this.getReply(31);
            int n2 = this.in.readInt();
            Object var4_4 = null;
            return n2;
        }
    }

    void gc(RemoteObject[] remoteObjectArray) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(23);
            this.out.writeInt(remoteObjectArray.length);
            int n = 0;
            while (n < remoteObjectArray.length) {
                if (remoteObjectArray[n] == null) {
                    this.out.writeInt(0);
                } else {
                    this.out.writeInt(remoteObjectArray[n].id);
                }
                ++n;
            }
            this.getReply(23);
            this.out.write(24);
            this.getReply(24);
            this.objects = new Hashtable();
            while (this.readValue(this.in) != null) {
            }
            return;
        }
    }

    void trace(boolean bl) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(34);
            this.out.writeInt(3);
            this.out.writeInt(bl ? 1 : 0);
            this.getReply(34);
            return;
        }
    }

    void itrace(boolean bl) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(34);
            this.out.writeInt(4);
            this.out.writeInt(bl ? 1 : 0);
            this.getReply(34);
            return;
        }
    }

    int totalMemory() throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(34);
            this.out.writeInt(1);
            this.getReply(34);
            int n = this.in.readInt();
            Object var3_3 = null;
            return n;
        }
    }

    int freeMemory() throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(34);
            this.out.writeInt(2);
            this.getReply(34);
            int n = this.in.readInt();
            Object var3_3 = null;
            return n;
        }
    }

    RemoteThreadGroup run(int n, String[] stringArray) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(26);
            this.out.write(n);
            int n2 = 0;
            while (n2 < n) {
                this.out.writeUTF(stringArray[n2]);
                ++n2;
            }
            this.getReply(26);
            RemoteThreadGroup remoteThreadGroup = (RemoteThreadGroup)this.readValue(this.in);
            Object var5_6 = null;
            return remoteThreadGroup;
        }
    }

    RemoteField[] getFields(int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(35);
            this.out.writeInt(n);
            this.getReply(35);
            int n2 = this.in.readInt();
            RemoteField[] remoteFieldArray = new RemoteField[n2];
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.in.readInt();
                String string = this.in.readUTF();
                String string2 = this.in.readUTF();
                short s = this.in.readShort();
                RemoteClass remoteClass = (RemoteClass)this.readValue(this.in);
                remoteFieldArray[n3] = new RemoteField(this, n4, string, string2, s, remoteClass);
                ++n3;
            }
            RemoteField[] remoteFieldArray2 = remoteFieldArray;
            Object var4_12 = null;
            return remoteFieldArray2;
        }
    }

    RemoteValue[] getElements(int n, int n2, int n3, int n4) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(40);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(n3);
            this.out.writeInt(n4);
            this.getReply(40);
            RemoteValue[] remoteValueArray = new RemoteValue[this.in.readInt()];
            int n5 = 0;
            while (n5 < remoteValueArray.length) {
                remoteValueArray[n5] = this.readValue(this.in);
                ++n5;
            }
            RemoteValue[] remoteValueArray2 = remoteValueArray;
            Object var7_9 = null;
            return remoteValueArray2;
        }
    }

    RemoteField[] getMethods(int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(36);
            this.out.writeInt(n);
            this.getReply(36);
            int n2 = this.in.readInt();
            this.message("getting (" + n2 + ") methods");
            RemoteField[] remoteFieldArray = new RemoteField[n2];
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.in.readInt();
                String string = this.in.readUTF();
                String string2 = this.in.readUTF();
                short s = this.in.readShort();
                RemoteClass cfr_ignored_0 = (RemoteClass)this.readValue(this.in);
                remoteFieldArray[n3] = new RemoteField(this, n4, string, string2, s, null);
                ++n3;
            }
            RemoteField[] remoteFieldArray2 = remoteFieldArray;
            Object var4_11 = null;
            return remoteFieldArray2;
        }
    }

    int getMethodLineNumber(int n, int n2) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(72);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.getReply(72);
            int n3 = this.in.readInt();
            Object var5_5 = null;
            return n3;
        }
    }

    int[] getSlotSignature(int n, int n2) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(38);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.getReply(38);
            int[] nArray = new int[this.in.readInt()];
            int n3 = 0;
            while (n3 < nArray.length) {
                nArray[n3] = this.in.readInt();
                ++n3;
            }
            int[] nArray2 = nArray;
            Object var5_7 = null;
            return nArray2;
        }
    }

    RemoteValue getSlotValue(int n, int n2) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(39);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.getReply(39);
            RemoteValue remoteValue = this.readValue(this.in);
            if (remoteValue != null && remoteValue.isObject() && remoteValue.getClass().getName().equals("java.lang.ArrayIndexOutOfBoundsException")) {
                throw new ArrayIndexOutOfBoundsException("invalid slot index " + n2);
            }
            RemoteValue remoteValue2 = remoteValue;
            Object var5_6 = null;
            return remoteValue2;
        }
    }

    RemoteValue getStackValue(int n, int n2, int n3, char c) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(50);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(n3);
            this.out.writeChar(c);
            this.getReply(50);
            RemoteValue remoteValue = this.readValue(this.in);
            Object var7_7 = null;
            return remoteValue;
        }
    }

    void setSlotValue(int n, int n2, int n3) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(68);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(4);
            this.out.writeInt(n3);
            this.getReply(68);
            return;
        }
    }

    void setSlotValue(int n, int n2, boolean bl) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(68);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(0);
            this.out.writeBoolean(bl);
            this.getReply(68);
            return;
        }
    }

    void setSlotValue(int n, int n2, char c) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(68);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(4);
            this.out.writeInt(c);
            this.getReply(68);
            return;
        }
    }

    void setSlotValue(int n, int n2, long l) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(68);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(5);
            this.out.writeLong(l);
            this.getReply(68);
            return;
        }
    }

    void setSlotValue(int n, int n2, float f) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(68);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(7);
            this.out.writeDouble(f);
            this.getReply(68);
            return;
        }
    }

    void setSlotValue(int n, int n2, double d) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(68);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(7);
            this.out.writeDouble(d);
            this.getReply(68);
            return;
        }
    }

    void setStackValue(int n, int n2, int n3, int n4) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(69);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(n3);
            this.out.writeInt(4);
            this.out.writeInt(n4);
            this.getReply(69);
            return;
        }
    }

    void setStackValue(int n, int n2, int n3, boolean bl) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(69);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(n3);
            this.out.writeInt(0);
            this.out.writeBoolean(bl);
            this.getReply(69);
            return;
        }
    }

    void setStackValue(int n, int n2, int n3, char c) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(69);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(n3);
            this.out.writeInt(4);
            this.out.writeInt(c);
            this.getReply(69);
            return;
        }
    }

    void setStackValue(int n, int n2, int n3, long l) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(69);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(n3);
            this.out.writeInt(5);
            this.out.writeLong(l);
            this.getReply(69);
            return;
        }
    }

    void setStackValue(int n, int n2, int n3, float f) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(69);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(n3);
            this.out.writeInt(7);
            this.out.writeDouble(f);
            this.getReply(69);
            return;
        }
    }

    void setStackValue(int n, int n2, int n3, double d) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(69);
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(n3);
            this.out.writeInt(7);
            this.out.writeDouble(d);
            this.getReply(69);
            return;
        }
    }

    String setBreakpointLine(RemoteClass remoteClass, int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(41);
            this.out.writeInt(remoteClass.getId());
            this.out.writeInt(n);
            this.getReply(41);
            String string = this.in.readUTF();
            Object var5_5 = null;
            return string;
        }
    }

    String setCondBreakpointLine(RemoteClass remoteClass, int n, int n2, int n3) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(81);
            this.out.writeInt(remoteClass.getId());
            this.out.writeInt(n);
            this.out.writeInt(n2);
            this.out.writeInt(n3);
            this.getReply(81);
            String string = this.in.readUTF();
            Object var7_7 = null;
            return string;
        }
    }

    int getCondBreakpointLimitCount(RemoteClass remoteClass, int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(82);
            this.out.writeInt(remoteClass.getId());
            this.out.writeInt(n);
            this.getReply(82);
            if (this.in.readInt() != 0) {
                throw new InvalidPCException();
            }
            int n2 = this.in.readInt();
            Object var5_5 = null;
            return n2;
        }
    }

    String setBreakpointMethod(RemoteClass remoteClass, RemoteField remoteField) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(42);
            this.out.writeInt(remoteClass.getId());
            this.out.writeInt(remoteField.slot);
            this.getReply(42);
            String string = this.in.readUTF();
            Object var5_5 = null;
            return string;
        }
    }

    String[] listBreakpoints() throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(65);
            this.getReply(65);
            String[] stringArray = new String[this.in.readInt()];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = this.in.readUTF();
                ++n;
            }
            String[] stringArray2 = stringArray;
            Object var3_5 = null;
            return stringArray2;
        }
    }

    String clearBreakpoint(RemoteClass remoteClass, int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.message("clearing bkpt at " + remoteClass.getName() + ", pc " + n);
            this.out.write(43);
            this.out.writeInt(remoteClass.getId());
            this.out.writeInt(n);
            this.getReply(43);
            String string = this.in.readUTF();
            Object var5_5 = null;
            return string;
        }
    }

    String clearBreakpointLine(RemoteClass remoteClass, int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.message("clearing bkpt at " + remoteClass.getName() + ":" + n);
            this.out.write(44);
            this.out.writeInt(remoteClass.getId());
            this.out.writeInt(n);
            this.getReply(44);
            String string = this.in.readUTF();
            Object var5_5 = null;
            return string;
        }
    }

    String clearBreakpointMethod(RemoteClass remoteClass, RemoteField remoteField) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.message("clearing bkpt at " + remoteClass.getName() + ":" + remoteField.getName());
            this.out.write(45);
            this.out.writeInt(remoteClass.getId());
            this.out.writeInt(remoteField.slot);
            this.getReply(45);
            String string = this.in.readUTF();
            Object var5_5 = null;
            return string;
        }
    }

    void catchExceptionClass(RemoteClass remoteClass) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(53);
            this.out.writeInt(remoteClass.getId());
            this.getReply(53);
            return;
        }
    }

    void ignoreExceptionClass(RemoteClass remoteClass) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(54);
            this.out.writeInt(remoteClass.getId());
            this.getReply(54);
            return;
        }
    }

    String[] getExceptionCatchList() throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(55);
            this.getReply(55);
            int n = this.in.readInt();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                RemoteClass remoteClass = (RemoteClass)this.readValue(this.in);
                stringArray[n2] = remoteClass.getName();
                ++n2;
            }
            String[] stringArray2 = stringArray;
            Object var3_7 = null;
            return stringArray2;
        }
    }

    RemoteClass[] getExceptionCatchClassList() throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(55);
            this.getReply(55);
            int n = this.in.readInt();
            RemoteClass[] remoteClassArray = new RemoteClass[n];
            int n2 = 0;
            while (n2 < n) {
                remoteClassArray[n2] = (RemoteClass)this.readValue(this.in);
                ++n2;
            }
            RemoteClass[] remoteClassArray2 = remoteClassArray;
            Object var3_6 = null;
            return remoteClassArray2;
        }
    }

    String getSourcePath() throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(61);
            this.getReply(61);
            String string = this.in.readUTF();
            Object var3_3 = null;
            return string;
        }
    }

    void setSourcePath(String string) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(62);
            this.out.writeUTF(string);
            this.getReply(62);
            return;
        }
    }

    void stepThread(int n, boolean bl) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(63);
            this.out.writeInt(n);
            this.out.writeBoolean(bl);
            this.getReply(63);
            return;
        }
    }

    void stepNextThread(int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(64);
            this.out.writeInt(n);
            this.getReply(64);
            return;
        }
    }

    void stepOutThread(int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(77);
            this.out.writeInt(n);
            this.getReply(77);
            return;
        }
    }

    void goPopThread(int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(86);
            this.out.writeInt(n);
            this.getReply(86);
            return;
        }
    }

    private void setVerbose(boolean bl) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(51);
            this.out.writeBoolean(bl);
            this.getReply(51);
            return;
        }
    }

    void objectFinalize(int n) throws Exception {
    }

    int[] getLineNumbers(RemoteClass remoteClass) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(71);
            this.out.writeInt(remoteClass.getId());
            this.getReply(71);
            int n = this.in.readInt();
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = this.in.readInt();
                ++n2;
            }
            int[] nArray2 = nArray;
            Object var4_7 = null;
            return nArray2;
        }
    }

    SymDbgLoadExpr loadExpressionClass(byte[] byArray) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            String string;
            int n;
            this.out.write(79);
            this.out.writeInt(byArray.length);
            this.out.writeInt(16384);
            int n2 = byArray.length / 16384;
            int n3 = byArray.length % 16384;
            this.getReply(79);
            this.out.write(87);
            int n4 = 0;
            while (n4 < n2) {
                this.out.write(byArray, n4 * 16384, 16384);
                this.getReply(87);
                this.out.write(87);
                ++n4;
            }
            this.out.write(byArray, n2 * 16384, n3);
            this.getReply(87);
            int n5 = this.in.readInt();
            if (n5 == 0) {
                n = this.in.readInt();
                string = this.in.readUTF();
            } else {
                n = 0;
                string = null;
            }
            SymDbgLoadExpr symDbgLoadExpr = new SymDbgLoadExpr(n5, n, string);
            Object var4_10 = null;
            return symDbgLoadExpr;
        }
    }

    SymDbgExprFindContext getExpressionContextLines(int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(84);
            this.out.writeInt(n);
            this.getReply(84);
            int n2 = this.in.readInt();
            if (n2 < 0) {
                SymDbgExprFindContext symDbgExprFindContext = null;
                Object var4_6 = null;
                return symDbgExprFindContext;
            }
            int n3 = this.in.readInt();
            int n4 = this.in.readInt();
            SymDbgExprFindContext symDbgExprFindContext = new SymDbgExprFindContext(n2, n3, n4);
            Object var4_7 = null;
            return symDbgExprFindContext;
        }
    }

    SymDbgExprResult evaluateExpression(RemoteThread remoteThread, int n) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(80);
            this.out.writeInt(remoteThread.getId());
            this.out.writeInt(n);
            this.getReply(80);
            int n2 = this.in.readInt();
            SymDbgExprResult symDbgExprResult = new SymDbgExprResult(n2, this.readValue(this.in));
            Object var5_6 = null;
            return symDbgExprResult;
        }
    }

    int reloadMethod(String string, String string2, String string3, byte[] byArray) throws Exception {
        DataOutputStream dataOutputStream = this.out;
        synchronized (dataOutputStream) {
            this.out.write(85);
            this.out.writeUTF(string);
            if (string2 != null) {
                this.out.writeInt(1);
                this.out.writeUTF(string2);
            } else {
                this.out.writeInt(0);
            }
            if (string3 != null) {
                this.out.writeInt(1);
                this.out.writeUTF(string3);
            } else {
                this.out.writeInt(0);
            }
            this.out.writeInt(byArray.length);
            this.out.write(byArray, 0, byArray.length);
            this.getReply(85);
            int n = this.in.readInt();
            Object var7_7 = null;
            return n;
        }
    }

    void error(String string) {
        try {
            this.client.printToConsole("[Internal error: " + string + "]\n");
            return;
        }
        catch (Exception exception) {
            System.out.println("[Internal error: " + string + "]");
            return;
        }
    }

    void message(String string) {
        if (this.verbose) {
            try {
                this.client.printToConsole("[debugger: " + string + "]\n");
                return;
            }
            catch (Exception exception) {
                System.out.println("[debugger: " + string + "]");
                return;
            }
        }
    }
}

