/*
 * Decompiled with CFR 0.152.
 */
package netscape.applet;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import netscape.applet.CastanetChannelInfo;
import netscape.applet.MozillaAppletContext;
import netscape.misc.WeakLink;
import netscape.security.AppletSecurity;
import netscape.security.AppletSecurityException;
import netscape.security.Principal;
import netscape.security.PrivilegeManager;
import netscape.security.Target;

public class AppletClassLoader
extends ClassLoader {
    URL codeBaseURL;
    URL archiveURL;
    MozillaAppletContext context;
    static boolean wantTiming;
    long loaderTime;
    String scriptOrigin = null;
    boolean isReusable = true;
    Principal codeBasePrincipal;
    Principal[] matchPrincipalAry;
    public static final String MANIFEST_FILENAME = "META-INF/manifest.mf";
    private String archiveFile;
    private boolean capturedArchive = false;
    private int nativeArchive;
    private int nativeZig;
    byte[] inputBuf;
    static Vector classloaders;
    private static boolean capturingClasses;
    private static final boolean MARIMBA_ENABLED = true;
    private CastanetChannelInfo channelInfo;
    private Hashtable codebaseEnv;

    String grabArchiveFile() throws IOException {
        long l;
        FileOutputStream fileOutputStream;
        String string;
        block17: {
            String string2 = this.archiveURL.getFile();
            if (!string2.endsWith(".jar") && !string2.endsWith(".zip")) {
                return null;
            }
            if (capturingClasses) {
                int n = string2.lastIndexOf(47);
                String string3 = string2.substring(n + 1);
                string = String.valueOf(this.getCaptureDir()) + "/" + string3;
            } else {
                string = this.getTempName();
                if (string == null) {
                    return null;
                }
            }
            SecurityManager.enablePrivilege("UniversalFileAccess");
            SecurityManager.enablePrivilege("UniversalConnect");
            fileOutputStream = new FileOutputStream(string);
            l = 0L;
            if (wantTiming) {
                l = System.currentTimeMillis();
            }
            InputStream inputStream = null;
            try {
                int n;
                URLConnection uRLConnection = this.archiveURL.openConnection();
                uRLConnection.setAllowUserInteraction(false);
                inputStream = uRLConnection.getInputStream();
                if (this.inputBuf == null) {
                    this.inputBuf = new byte[4096];
                }
                Thread thread = Thread.currentThread();
                while ((n = inputStream.read(this.inputBuf)) >= 0 && !thread.isInterrupted()) {
                    fileOutputStream.write(this.inputBuf, 0, n);
                }
                if (thread.isInterrupted()) {
                    throw new IOException("interrupted: " + this);
                }
                Object var8_12 = null;
                if (inputStream == null) break block17;
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                throw throwable;
            }
            inputStream.close();
        }
        if (fileOutputStream != null) {
            fileOutputStream.close();
        }
        SecurityManager.revertPrivilege();
        if (wantTiming) {
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            this.loaderTime += l3;
            System.err.println("# Archive download time: " + this.archiveURL + ": " + l3 + " (total = " + this.loaderTime + ")");
        }
        if (capturingClasses) {
            System.err.println("#\tCaptured archive " + string);
            this.capturedArchive = true;
        } else if (this.context != null && MozillaAppletContext.debug >= 2) {
            System.err.println("# Loading classes from downloaded archive file: " + this.archiveURL);
        }
        return string;
    }

    native String getTempName();

    private native int openArchive0(String var1) throws IOException;

    private native byte[] loadFromArchive0(int var1, String var2) throws IOException;

    private native void closeArchive0(int var1) throws IOException;

    void openArchive() {
        try {
            this.archiveFile = this.grabArchiveFile();
            if (this.archiveFile == null) {
                return;
            }
            this.nativeArchive = this.openArchive0(this.archiveFile);
            if (this.nativeArchive != 0) {
                this.nativeZig = this.setupZignature();
                if (this.nativeZig != 0) {
                    if (!this.loadManifest(this.nativeArchive, this.nativeZig, this.codeBaseURL.getFile()) || this.loadSignatures(this.nativeArchive, this.nativeZig, this.codeBaseURL.getFile()) <= 0) {
                        this.nativeZig = 0;
                    }
                    return;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println("# Unable to load archive " + this.archiveURL + ": " + iOException);
            this.nativeZig = 0;
        }
    }

    byte[] loadFromArchive(String string) throws IOException {
        if (this.nativeArchive != 0) {
            return this.loadFromArchive0(this.nativeArchive, string);
        }
        return null;
    }

    void closeArchive() {
        if (this.nativeArchive != 0) {
            block7: {
                try {
                    this.closeArchive0(this.nativeArchive);
                    if (this.context != null && MozillaAppletContext.debug >= 5) {
                        System.err.println("# Closed downloaded archive: " + this.archiveURL);
                    }
                }
                catch (IOException iOException) {
                    if (this.context == null || MozillaAppletContext.debug < 5) break block7;
                    System.err.println("# Failed to close downloaded archive: " + this.archiveURL);
                }
            }
            this.nativeArchive = 0;
            if (!this.capturedArchive) {
                File file = new File(this.archiveFile);
                SecurityManager.enablePrivilege("UniversalFileRead");
                SecurityManager.enablePrivilege("UniversalFileDelete");
                boolean bl = file.delete();
                SecurityManager.revertPrivilege();
                if (this.context != null && MozillaAppletContext.debug >= 5) {
                    if (bl) {
                        System.err.println("# Deleted downloaded archive: " + this.archiveFile);
                        return;
                    }
                    System.err.println("# Failed to delete downloaded archive: " + this.archiveFile);
                }
            }
        }
    }

    static synchronized AppletClassLoader getClassLoader(MozillaAppletContext mozillaAppletContext, URL uRL, URL uRL2, String string, boolean bl) {
        Object object;
        boolean bl2 = false;
        Object object2 = null;
        SecurityManager.enablePrivilege("UniversalConnect");
        int n = 0;
        while (n < classloaders.size()) {
            block17: {
                URL uRL3;
                block22: {
                    boolean bl3;
                    block23: {
                        block21: {
                            block19: {
                                boolean bl4;
                                block20: {
                                    block18: {
                                        block16: {
                                            WeakLink weakLink = (WeakLink)classloaders.elementAt(n);
                                            object = (AppletClassLoader)weakLink.get();
                                            if (object != null) break block16;
                                            bl2 = true;
                                            break block17;
                                        }
                                        String string2 = uRL.getFile();
                                        int n2 = string2.lastIndexOf(47);
                                        uRL3 = uRL;
                                        if (n2 > 0 && n2 < string2.length() - 1) {
                                            try {
                                                uRL3 = new URL(uRL, string2.substring(0, n2 + 1));
                                            }
                                            catch (MalformedURLException malformedURLException) {}
                                        }
                                        if (!uRL3.equals(((AppletClassLoader)object).codeBaseURL)) break block17;
                                        if (uRL2 != null) break block18;
                                        if (((AppletClassLoader)object).archiveURL == null) break block19;
                                        bl4 = false;
                                        break block20;
                                    }
                                    bl4 = uRL2.equals(((AppletClassLoader)object).archiveURL);
                                }
                                if (!bl4) break block17;
                            }
                            if (string != null) break block21;
                            if (((AppletClassLoader)object).scriptOrigin == null) break block22;
                            bl3 = false;
                            break block23;
                        }
                        bl3 = string.equals(((AppletClassLoader)object).scriptOrigin);
                    }
                    if (!bl3) break block17;
                }
                if ((string == null || mozillaAppletContext == ((AppletClassLoader)object).context) && ((AppletClassLoader)object).isReusable) {
                    if (bl) {
                        if (MozillaAppletContext.debug >= 8) {
                            System.err.println("#   preventing reuse of " + object);
                        }
                        ((AppletClassLoader)object).isReusable = false;
                    } else {
                        object2 = object;
                        if (MozillaAppletContext.debug < 8) break;
                        System.err.println("#   reusing class loader " + object2 + "\n" + "#\tcontext = " + mozillaAppletContext + "\n" + "#\tcodebase = " + uRL3 + "\n" + "#\tarchive = " + uRL2 + "\n" + "#\tscriptOrigin = " + string);
                        break;
                    }
                }
            }
            ++n;
        }
        SecurityManager.revertPrivilege();
        if (object2 == null) {
            object2 = new AppletClassLoader(mozillaAppletContext, uRL, uRL2);
            ((AppletClassLoader)object2).scriptOrigin = string;
            classloaders.addElement(new WeakLink(object2));
        }
        if (bl2) {
            int n3 = classloaders.size() - 1;
            while (n3 >= 0) {
                object = (WeakLink)classloaders.elementAt(n3);
                if (((WeakLink)object).get() == null) {
                    classloaders.removeElementAt(n3);
                }
                if (MozillaAppletContext.debug >= 8) {
                    System.err.println("#   classloader was removed");
                }
                --n3;
            }
        }
        return object2;
    }

    AppletClassLoader(MozillaAppletContext mozillaAppletContext, URL uRL, URL uRL2) {
        this.codeBasePrincipal = new Principal(uRL);
        String string = uRL.getFile();
        int n = string.lastIndexOf(47);
        if (n > 0 && n < string.length() - 1) {
            try {
                uRL = new URL(uRL, string.substring(0, n + 1));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        this.codeBaseURL = uRL;
        this.archiveURL = uRL2;
        this.context = mozillaAppletContext;
        if (MozillaAppletContext.debug > 5) {
            System.err.println("#   new class loader " + this + "\n" + "#\tcontext = " + mozillaAppletContext + "\n" + "#\tcodebase = " + uRL + "\n" + "#\tarchive = " + uRL2);
        }
        if (this.archiveURL != null) {
            this.openArchive();
        }
    }

    void close() {
        if (this.archiveURL != null) {
            this.closeArchive();
        }
        if (this.channelInfo != null) {
            this.channelInfo.closeZips();
        }
    }

    protected void finalize() {
        this.close();
        if (MozillaAppletContext.debug >= 8) {
            System.err.println("# finalized: " + this);
        }
    }

    protected AppletClassLoader(URL uRL) {
        this(null, uRL, null);
    }

    String getScriptOrigin() {
        return this.scriptOrigin;
    }

    public URL getCodeBase() {
        return this.codeBaseURL;
    }

    private Class loadClass(String string, URL uRL, String string2) throws IOException {
        SecurityManager.enablePrivilege("UniversalConnect");
        byte[] byArray = uRL.getData();
        SecurityManager.revertPrivilege();
        if (capturingClasses) {
            this.captureClassFile(string, byArray);
        }
        return this.defineClass(string, byArray, 0, byArray.length, this.nativeZig, string2);
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, true);
    }

    protected final Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz;
        if (wantTiming) {
            long l = System.currentTimeMillis();
            clazz = this.loadClass1(string, bl);
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            this.loaderTime += l3;
            System.err.println("# Class load time: " + string + ": " + l3 + " (total = " + this.loaderTime + ")");
        } else {
            clazz = this.loadClass1(string, bl);
        }
        return clazz;
    }

    private Class loadClass1(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            int n;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && (n = string.lastIndexOf(46)) >= 0) {
                securityManager.checkPackageAccess(string.substring(0, n));
            }
            try {
                return this.findSystemClass(string);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (this.channelInfo == null) {
                    throw noClassDefFoundError;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
            clazz = this.findClass(string);
        }
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        if (this.nativeArchive != 0) {
            System.getSecurityManager().checkURLConnect(this.codeBaseURL, this.archiveURL);
        }
        if (bl) {
            try {
                this.resolveClass(clazz);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                if (this.channelInfo == null) {
                    throw noClassDefFoundError;
                }
                throw new ClassNotFoundException(string);
            }
            catch (UnknownError unknownError) {
                if (this.channelInfo == null) {
                    throw unknownError;
                }
                throw new ClassNotFoundException(string);
            }
        }
        return clazz;
    }

    private synchronized Class findClass(String string) throws ClassNotFoundException {
        Object object;
        String string2;
        Class clazz;
        boolean bl;
        block22: {
            int n;
            SecurityManager securityManager;
            bl = true;
            clazz = this.findLoadedClass(string);
            if (clazz != null) {
                return clazz;
            }
            if (MozillaAppletContext.debug >= 2) {
                System.err.println("# Loading class " + string);
            }
            if ((securityManager = System.getSecurityManager()) != null && (n = string.lastIndexOf(46)) >= 0) {
                securityManager.checkPackageDefinition(string.substring(0, n));
            }
            string2 = String.valueOf(string.replace('.', '/')) + ".class";
            if (this.nativeArchive != 0) {
                try {
                    object = this.loadFromArchive(string2);
                    if (object != null) {
                        clazz = this.defineClass(string, (byte[])object, 0, ((byte[])object).length, this.nativeZig, string2);
                        if (clazz != null && this.context != null && MozillaAppletContext.debug >= 2) {
                            System.err.println("# Loaded " + string2 + " from " + this.archiveURL);
                        }
                        bl = false;
                    }
                }
                catch (IOException iOException) {
                    if (MozillaAppletContext.debug < 2) break block22;
                    System.err.println("# Failed to load " + string2 + " from " + this.archiveURL);
                }
            }
        }
        if (clazz == null) {
            try {
                object = new URL(this.codeBaseURL, string2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ClassNotFoundException(string);
            }
            if (this.context != null && MozillaAppletContext.debug >= 5) {
                System.err.println("# Fetching " + object);
            }
            try {
                clazz = this.loadClass(string, (URL)object, string2);
                bl = false;
            }
            catch (IOException iOException) {
                if (this.channelInfo != null) {
                    try {
                        clazz = this.marimbaLoad(string);
                        bl = false;
                    }
                    catch (IOException iOException2) {}
                }
                if (clazz == null) {
                    throw new ClassNotFoundException(string);
                }
            }
            catch (SecurityException securityException) {
                if (this.context != null && MozillaAppletContext.debug >= 5) {
                    System.err.println("# Exception while loading " + string2 + " from downloaded archive " + ((URL)object).toString() + "\n#   Exception: " + securityException.toString());
                }
                throw securityException;
            }
        }
        if (!string.equals(clazz.getName())) {
            object = clazz;
            clazz = null;
            throw new ClassFormatError(String.valueOf(string) + " != " + ((Class)object).getName());
        }
        if (!bl) {
            this.setPrincipalAry(clazz, string2);
        }
        return clazz;
    }

    static boolean getCaptureClassFiles() {
        return capturingClasses;
    }

    static void setCaptureClassFiles(boolean bl) {
        capturingClasses = bl;
    }

    String getCaptureDir() throws IOException {
        String string = this.codeBaseURL.toString();
        if (string.startsWith("http://")) {
            string = string.substring(7);
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        string = string.replace('/', '_').replace(':', '_');
        SecurityManager.enablePrivilege("UniversalFileRead");
        SecurityManager.enablePrivilege("UniversalFileWrite");
        File file = new File(string);
        if (!(file.exists() && file.isDirectory() || file.mkdir())) {
            throw new IOException(file + " is not a directory");
        }
        return string;
    }

    void captureClassFile(String string, byte[] byArray) {
        try {
            Object object;
            int n;
            String string2 = this.getCaptureDir();
            SecurityManager.enablePrivilege("UniversalFileRead");
            SecurityManager.enablePrivilege("UniversalFileWrite");
            while ((n = string.indexOf(46)) != -1) {
                object = string.substring(0, n);
                string = string.substring(n + 1);
                File file = new File(string2 = String.valueOf(string2) + "/" + (String)object);
                if (file.exists() && file.isDirectory() || file.mkdir()) continue;
                throw new IOException("Can't create " + file);
            }
            File file = new File(String.valueOf(string2) + "/" + string + ".class");
            object = new FileOutputStream(file);
            ((FileOutputStream)object).write(byArray, 0, byArray.length);
            System.err.println("#\tCaptured class " + file);
            ((FileOutputStream)object).close();
            return;
        }
        catch (SecurityException securityException) {
            System.err.println("#\tCan't capture class: " + securityException);
            return;
        }
        catch (IOException iOException) {
            System.err.println("#\tCan't capture class: " + iOException);
            return;
        }
    }

    byte[] getResource(URL uRL) {
        byte[] byArray;
        block5: {
            String string;
            byArray = null;
            String string2 = uRL.getFile();
            if (!string2.startsWith(string = this.codeBaseURL.getFile())) {
                return null;
            }
            String string3 = string2.substring(string.length());
            try {
                byArray = this.loadFromArchive(string3);
                if (byArray != null && this.context != null && MozillaAppletContext.debug >= 5) {
                    System.err.println("# Loaded " + string3 + " from " + this.archiveURL);
                }
                if (byArray == null && this.context != null && MozillaAppletContext.debug >= 5) {
                    System.err.println("# " + string3 + " in " + this.archiveURL + " not found.");
                }
            }
            catch (IOException iOException) {
                if (MozillaAppletContext.debug < 5) break block5;
                System.err.println("# Failed to load " + string3 + " from " + this.archiveURL);
            }
        }
        return byArray;
    }

    public InputStream getResourceAsStream(String string) {
        System.getSecurityManager().checkResourceAccess(string);
        URL uRL = null;
        try {
            uRL = new URL(this.codeBaseURL, string);
            byte[] byArray = this.getResource(uRL);
            if (byArray == null) {
                return null;
            }
            return new ByteArrayInputStream(byArray);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private boolean setPrincipalAry(Class clazz, String string) {
        Principal[] principalArray = null;
        int n = 1;
        Object[] objectArray = AppletClassLoader.getCertificates(this.nativeZig, clazz, string);
        if (objectArray != null) {
            n += objectArray.length;
        }
        principalArray = new Principal[n];
        int n2 = n - 1;
        while (n2-- > 0) {
            principalArray[n2] = new Principal(14, (byte[])objectArray[n2], clazz);
        }
        principalArray[n - 1] = this.codeBasePrincipal;
        try {
            PrivilegeManager privilegeManager;
            if (this.matchPrincipalAry != null && (privilegeManager = AppletSecurity.getPrivilegeManager()) != null && privilegeManager.comparePrincipalArray(principalArray, this.matchPrincipalAry) == 1) {
                principalArray = new Principal[]{this.codeBasePrincipal};
                throw new AppletSecurityException("mismatch of principals");
            }
            Object var8_8 = null;
            this.setPrincipals(clazz, principalArray);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.setPrincipals(clazz, principalArray);
            throw throwable;
        }
        return true;
    }

    public boolean checkMatchPrincipalAlways(int n) {
        PrivilegeManager privilegeManager = AppletSecurity.getPrivilegeManager();
        if (privilegeManager == null) {
            return true;
        }
        this.matchPrincipalAry = privilegeManager.getClassPrincipalsFromStack(n + 1);
        Enumeration enumeration = this.getClassNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Class clazz = this.findLoadedClass(string);
            if (clazz == null || privilegeManager.checkMatchPrincipal(clazz, n + 1)) continue;
            return false;
        }
        return true;
    }

    private native int setupZignature();

    private native int destroyZignature(int var1);

    private native boolean loadManifest(int var1, int var2, String var3);

    private native int loadSignatures(int var1, int var2, String var3);

    private native boolean verifySignature(int var1, Class var2, String var3);

    private static native Object[] getCertificates(int var0, Class var1, String var2);

    private native void setPrincipals(Class var1, Principal[] var2);

    public AppletClassLoader(URL uRL, CastanetChannelInfo castanetChannelInfo) {
        this(null, uRL, null);
        this.channelInfo = castanetChannelInfo;
    }

    public Class classFromBytes(byte[] byArray, String string) {
        PrivilegeManager privilegeManager;
        int n;
        if (this.channelInfo == null) {
            return null;
        }
        Class clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = this.findSystemClass(string);
            if (clazz != null) {
                return clazz;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (ClassNotFoundException classNotFoundException) {}
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null && (n = string.lastIndexOf(46)) >= 0) {
            securityManager.checkPackageDefinition(string.substring(0, n));
        }
        if ((privilegeManager = PrivilegeManager.getPrivilegeManager()) != null) {
            Target target = Target.findTarget("MarimbaInternalTarget");
            if (target == null) {
                throw new AppletSecurityException("classFromBytes call denied");
            }
            privilegeManager.checkPrivilegeEnabled(target);
        }
        try {
            clazz = this.defineClass(string, byArray, 0, byArray.length);
            return clazz;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return null;
        }
    }

    private Class marimbaLoad(String string) throws IOException, ClassNotFoundException {
        if (this.channelInfo == null) {
            return null;
        }
        Class clazz = null;
        int n = this.channelInfo.getPathlen();
        if (n != 0) {
            String string2 = String.valueOf(string.replace('.', '/')) + ".class";
            int n2 = 0;
            while (n2 < n) {
                ZipEntry zipEntry;
                ZipFile zipFile;
                URL uRL = this.channelInfo.getURL(n2);
                if (uRL != null) {
                    try {
                        clazz = this.loadClass(string, new URL(uRL, string2), string2);
                        if (clazz != null) {
                            return clazz;
                        }
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                    }
                    catch (MalformedURLException malformedURLException) {
                    }
                    catch (FileNotFoundException fileNotFoundException) {}
                }
                if ((zipFile = this.channelInfo.getZip(n2)) != null && (zipEntry = zipFile.getEntry(string2)) != null) {
                    int n3 = (int)zipEntry.getSize();
                    byte[] byArray = new byte[n3];
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    int n4 = 0;
                    while (n4 < n3) {
                        n4 += inputStream.read(byArray, n4, n3 - n4);
                    }
                    inputStream.close();
                    try {
                        clazz = this.defineClass(string, byArray, 0, byArray.length);
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {}
                    if (clazz != null) {
                        return clazz;
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean marimbaCheckRead(String string, boolean bl) {
        if (this.channelInfo != null) {
            return this.channelInfo.checkRead(string, bl);
        }
        return false;
    }

    public boolean marimbaCheckWrite(String string, boolean bl) {
        if (this.channelInfo != null) {
            return this.channelInfo.checkWrite(string, bl);
        }
        return false;
    }

    public String marimbaGetHost() {
        if (this.channelInfo != null) {
            return this.channelInfo.getHost();
        }
        return null;
    }

    boolean marimbaCheckThreadGroup(ThreadGroup threadGroup) {
        if (this.channelInfo == null) {
            return false;
        }
        return this.channelInfo.checkThreadGroup(threadGroup);
    }

    void marimbaCheckTopLevelWindow(Object object) {
        if (this.channelInfo == null) {
            return;
        }
        this.channelInfo.checkTopLevelWindow(object);
    }

    Hashtable getCodebaseEnv() {
        if (this.codebaseEnv == null) {
            this.initCodebaseEnv();
        }
        return this.codebaseEnv;
    }

    synchronized void initCodebaseEnv() {
        if (this.codebaseEnv == null) {
            this.codebaseEnv = new Hashtable();
        }
    }

    static {
        classloaders = new Vector(10);
    }
}

