/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayoutInfo;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Hashtable;

public class GridBagLayout
implements LayoutManager {
    protected static final int MAXGRIDSIZE = 128;
    protected static final int MINSIZE = 1;
    protected static final int PREFERREDSIZE = 2;
    protected Hashtable comptable = new Hashtable();
    protected GridBagConstraints defaultConstraints = new GridBagConstraints();
    protected GridBagLayoutInfo layoutInfo;
    public int[] columnWidths;
    public int[] rowHeights;
    public double[] columnWeights;
    public double[] rowWeights;

    public void setConstraints(Component component, GridBagConstraints gridBagConstraints) {
        this.comptable.put(component, gridBagConstraints.clone());
    }

    public GridBagConstraints getConstraints(Component component) {
        GridBagConstraints gridBagConstraints = (GridBagConstraints)this.comptable.get(component);
        if (gridBagConstraints == null) {
            this.setConstraints(component, this.defaultConstraints);
            gridBagConstraints = (GridBagConstraints)this.comptable.get(component);
        }
        return (GridBagConstraints)gridBagConstraints.clone();
    }

    protected GridBagConstraints lookupConstraints(Component component) {
        GridBagConstraints gridBagConstraints = (GridBagConstraints)this.comptable.get(component);
        if (gridBagConstraints == null) {
            this.setConstraints(component, this.defaultConstraints);
            gridBagConstraints = (GridBagConstraints)this.comptable.get(component);
        }
        return gridBagConstraints;
    }

    public Point getLayoutOrigin() {
        Point point = new Point(0, 0);
        if (this.layoutInfo != null) {
            point.x = this.layoutInfo.startx;
            point.y = this.layoutInfo.starty;
        }
        return point;
    }

    public int[][] getLayoutDimensions() {
        if (this.layoutInfo == null) {
            return new int[2][0];
        }
        int[][] nArray = new int[][]{new int[this.layoutInfo.width], new int[this.layoutInfo.height]};
        System.arraycopy(this.layoutInfo.minWidth, 0, nArray[0], 0, this.layoutInfo.width);
        System.arraycopy(this.layoutInfo.minHeight, 0, nArray[1], 0, this.layoutInfo.height);
        return nArray;
    }

    public double[][] getLayoutWeights() {
        if (this.layoutInfo == null) {
            return new double[2][0];
        }
        double[][] dArray = new double[][]{new double[this.layoutInfo.width], new double[this.layoutInfo.height]};
        System.arraycopy(this.layoutInfo.weightX, 0, dArray[0], 0, this.layoutInfo.width);
        System.arraycopy(this.layoutInfo.weightY, 0, dArray[1], 0, this.layoutInfo.height);
        return dArray;
    }

    public Point location(int n, int n2) {
        Point point = new Point(0, 0);
        if (this.layoutInfo == null) {
            return point;
        }
        int n3 = this.layoutInfo.startx;
        int n4 = 0;
        while (n4 < this.layoutInfo.width) {
            if ((n3 += this.layoutInfo.minWidth[n4]) > n) break;
            ++n4;
        }
        point.x = n4;
        n3 = this.layoutInfo.starty;
        n4 = 0;
        while (n4 < this.layoutInfo.height) {
            if ((n3 += this.layoutInfo.minHeight[n4]) > n2) break;
            ++n4;
        }
        point.y = n4;
        return point;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container container) {
        GridBagLayoutInfo gridBagLayoutInfo = this.GetLayoutInfo(container, 2);
        return this.GetMinSize(container, gridBagLayoutInfo);
    }

    public Dimension minimumLayoutSize(Container container) {
        GridBagLayoutInfo gridBagLayoutInfo = this.GetLayoutInfo(container, 1);
        return this.GetMinSize(container, gridBagLayoutInfo);
    }

    public void layoutContainer(Container container) {
        this.ArrangeGrid(container);
    }

    public String toString() {
        return this.getClass().getName();
    }

    protected void DumpLayoutInfo(GridBagLayoutInfo gridBagLayoutInfo) {
        System.out.println("Col\tWidth\tWeight");
        int n = 0;
        while (n < gridBagLayoutInfo.width) {
            System.out.println(String.valueOf(n) + "\t" + gridBagLayoutInfo.minWidth[n] + "\t" + gridBagLayoutInfo.weightX[n]);
            ++n;
        }
        System.out.println("Row\tHeight\tWeight");
        n = 0;
        while (n < gridBagLayoutInfo.height) {
            System.out.println(String.valueOf(n) + "\t" + gridBagLayoutInfo.minHeight[n] + "\t" + gridBagLayoutInfo.weightY[n]);
            ++n;
        }
    }

    protected void DumpConstraints(GridBagConstraints gridBagConstraints) {
        System.out.println("wt " + gridBagConstraints.weightx + " " + gridBagConstraints.weighty + ", " + "box " + gridBagConstraints.gridx + " " + gridBagConstraints.gridy + " " + gridBagConstraints.gridwidth + " " + gridBagConstraints.gridheight + ", " + "min " + gridBagConstraints.minWidth + " " + gridBagConstraints.minHeight + ", " + "pad " + gridBagConstraints.insets.bottom + " " + gridBagConstraints.insets.left + " " + gridBagConstraints.insets.right + " " + gridBagConstraints.insets.top + " " + gridBagConstraints.ipadx + " " + gridBagConstraints.ipady);
    }

    protected GridBagLayoutInfo GetLayoutInfo(Container container, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        GridBagConstraints gridBagConstraints;
        Component component;
        GridBagLayoutInfo gridBagLayoutInfo = new GridBagLayoutInfo();
        int n9 = container.countComponents();
        gridBagLayoutInfo.height = 0;
        gridBagLayoutInfo.width = 0;
        int n10 = -1;
        int n11 = -1;
        int[] nArray = new int[128];
        int[] nArray2 = new int[128];
        int n12 = 0;
        while (n12 < n9) {
            component = container.getComponent(n12);
            gridBagConstraints = this.lookupConstraints(component);
            n8 = gridBagConstraints.gridx;
            n7 = gridBagConstraints.gridy;
            n6 = gridBagConstraints.gridwidth;
            if (n6 <= 0) {
                n6 = 1;
            }
            if ((n5 = gridBagConstraints.gridheight) <= 0) {
                n5 = 1;
            }
            if (n8 < 0 && n7 < 0) {
                if (n11 >= 0) {
                    n7 = n11;
                } else if (n10 >= 0) {
                    n8 = n10;
                } else {
                    n7 = 0;
                }
            }
            if (n8 < 0) {
                n4 = 0;
                n3 = n7;
                while (n3 < n7 + n5) {
                    n4 = Math.max(n4, nArray[n3]);
                    ++n3;
                }
                if ((n8 = n4 - n8 - 1) < 0) {
                    n8 = 0;
                }
            } else if (n7 < 0) {
                n2 = 0;
                n3 = n8;
                while (n3 < n8 + n6) {
                    n2 = Math.max(n2, nArray2[n3]);
                    ++n3;
                }
                if ((n7 = n2 - n7 - 1) < 0) {
                    n7 = 0;
                }
            }
            n4 = n8 + n6;
            while (gridBagLayoutInfo.width < n4) {
                ++gridBagLayoutInfo.width;
            }
            n2 = n7 + n5;
            while (gridBagLayoutInfo.height < n2) {
                ++gridBagLayoutInfo.height;
            }
            n3 = n8;
            while (n3 < n8 + n6) {
                nArray2[n3] = n2;
                ++n3;
            }
            n3 = n7;
            while (n3 < n7 + n5) {
                nArray[n3] = n4;
                ++n3;
            }
            Dimension dimension = n == 2 ? component.preferredSize() : component.minimumSize();
            gridBagConstraints.minWidth = dimension.width;
            gridBagConstraints.minHeight = dimension.height;
            if (gridBagConstraints.gridheight == 0 && gridBagConstraints.gridwidth == 0) {
                n10 = -1;
                n11 = -1;
            }
            if (gridBagConstraints.gridheight == 0 && n11 < 0) {
                n10 = n8 + n6;
            } else if (gridBagConstraints.gridwidth == 0 && n10 < 0) {
                n11 = n7 + n5;
            }
            ++n12;
        }
        if (this.columnWidths != null && gridBagLayoutInfo.width < this.columnWidths.length) {
            gridBagLayoutInfo.width = this.columnWidths.length;
        }
        if (this.rowHeights != null && gridBagLayoutInfo.height < this.rowHeights.length) {
            gridBagLayoutInfo.height = this.rowHeights.length;
        }
        n10 = -1;
        n11 = -1;
        nArray = new int[128];
        nArray2 = new int[128];
        n12 = 0;
        while (n12 < n9) {
            component = container.getComponent(n12);
            gridBagConstraints = this.lookupConstraints(component);
            n8 = gridBagConstraints.gridx;
            n7 = gridBagConstraints.gridy;
            n6 = gridBagConstraints.gridwidth;
            n5 = gridBagConstraints.gridheight;
            if (n8 < 0 && n7 < 0) {
                if (n11 >= 0) {
                    n7 = n11;
                } else if (n10 >= 0) {
                    n8 = n10;
                } else {
                    n7 = 0;
                }
            }
            if (n8 < 0) {
                if (n5 <= 0 && (n5 += gridBagLayoutInfo.height - n7) < 1) {
                    n5 = 1;
                }
                n4 = 0;
                n3 = n7;
                while (n3 < n7 + n5) {
                    n4 = Math.max(n4, nArray[n3]);
                    ++n3;
                }
                if ((n8 = n4 - n8 - 1) < 0) {
                    n8 = 0;
                }
            } else if (n7 < 0) {
                if (n6 <= 0 && (n6 += gridBagLayoutInfo.width - n8) < 1) {
                    n6 = 1;
                }
                n2 = 0;
                n3 = n8;
                while (n3 < n8 + n6) {
                    n2 = Math.max(n2, nArray2[n3]);
                    ++n3;
                }
                if ((n7 = n2 - n7 - 1) < 0) {
                    n7 = 0;
                }
            }
            if (n6 <= 0 && (n6 += gridBagLayoutInfo.width - n8) < 1) {
                n6 = 1;
            }
            if (n5 <= 0 && (n5 += gridBagLayoutInfo.height - n7) < 1) {
                n5 = 1;
            }
            n4 = n8 + n6;
            n2 = n7 + n5;
            n3 = n8;
            while (n3 < n8 + n6) {
                nArray2[n3] = n2;
                ++n3;
            }
            n3 = n7;
            while (n3 < n7 + n5) {
                nArray[n3] = n4;
                ++n3;
            }
            if (gridBagConstraints.gridheight == 0 && gridBagConstraints.gridwidth == 0) {
                n10 = -1;
                n11 = -1;
            }
            if (gridBagConstraints.gridheight == 0 && n11 < 0) {
                n10 = n8 + n6;
            } else if (gridBagConstraints.gridwidth == 0 && n10 < 0) {
                n11 = n7 + n5;
            }
            gridBagConstraints.tempX = n8;
            gridBagConstraints.tempY = n7;
            gridBagConstraints.tempWidth = n6;
            gridBagConstraints.tempHeight = n5;
            ++n12;
        }
        int n13 = Integer.MAX_VALUE;
        n3 = 1;
        while (n3 != Integer.MAX_VALUE) {
            n12 = 0;
            while (n12 < n9) {
                int n14;
                double d;
                double d2;
                double d3;
                int n15;
                double d4;
                component = container.getComponent(n12);
                gridBagConstraints = this.lookupConstraints(component);
                if (gridBagConstraints.tempWidth == n3) {
                    n4 = gridBagConstraints.tempX + gridBagConstraints.tempWidth;
                    d4 = gridBagConstraints.weightx;
                    n15 = gridBagConstraints.tempX;
                    while (n15 < n4) {
                        d4 -= gridBagLayoutInfo.weightX[n15];
                        ++n15;
                    }
                    if (d4 > 0.0) {
                        d3 = 0.0;
                        n15 = gridBagConstraints.tempX;
                        while (n15 < n4) {
                            d3 += gridBagLayoutInfo.weightX[n15];
                            ++n15;
                        }
                        n15 = gridBagConstraints.tempX;
                        while (d3 > 0.0) {
                            d2 = gridBagLayoutInfo.weightX[n15];
                            d = d2 * d4 / d3;
                            int n16 = n15++;
                            gridBagLayoutInfo.weightX[n16] = gridBagLayoutInfo.weightX[n16] + d;
                            d4 -= d;
                            d3 -= d2;
                        }
                        int n17 = n4 - 1;
                        gridBagLayoutInfo.weightX[n17] = gridBagLayoutInfo.weightX[n17] + d4;
                    }
                    n14 = gridBagConstraints.minWidth + gridBagConstraints.ipadx + gridBagConstraints.insets.left + gridBagConstraints.insets.right;
                    n15 = gridBagConstraints.tempX;
                    while (n15 < n4) {
                        n14 -= gridBagLayoutInfo.minWidth[n15];
                        ++n15;
                    }
                    if (n14 > 0) {
                        d3 = 0.0;
                        n15 = gridBagConstraints.tempX;
                        while (n15 < n4) {
                            d3 += gridBagLayoutInfo.weightX[n15];
                            ++n15;
                        }
                        n15 = gridBagConstraints.tempX;
                        while (d3 > 0.0) {
                            d2 = gridBagLayoutInfo.weightX[n15];
                            int n18 = (int)(d2 * (double)n14 / d3);
                            int n19 = n15++;
                            gridBagLayoutInfo.minWidth[n19] = gridBagLayoutInfo.minWidth[n19] + n18;
                            n14 -= n18;
                            d3 -= d2;
                        }
                        int n20 = n4 - 1;
                        gridBagLayoutInfo.minWidth[n20] = gridBagLayoutInfo.minWidth[n20] + n14;
                    }
                } else if (gridBagConstraints.tempWidth > n3 && gridBagConstraints.tempWidth < n13) {
                    n13 = gridBagConstraints.tempWidth;
                }
                if (gridBagConstraints.tempHeight == n3) {
                    n2 = gridBagConstraints.tempY + gridBagConstraints.tempHeight;
                    d4 = gridBagConstraints.weighty;
                    n15 = gridBagConstraints.tempY;
                    while (n15 < n2) {
                        d4 -= gridBagLayoutInfo.weightY[n15];
                        ++n15;
                    }
                    if (d4 > 0.0) {
                        d3 = 0.0;
                        n15 = gridBagConstraints.tempY;
                        while (n15 < n2) {
                            d3 += gridBagLayoutInfo.weightY[n15];
                            ++n15;
                        }
                        n15 = gridBagConstraints.tempY;
                        while (d3 > 0.0) {
                            d2 = gridBagLayoutInfo.weightY[n15];
                            d = d2 * d4 / d3;
                            int n21 = n15++;
                            gridBagLayoutInfo.weightY[n21] = gridBagLayoutInfo.weightY[n21] + d;
                            d4 -= d;
                            d3 -= d2;
                        }
                        int n22 = n2 - 1;
                        gridBagLayoutInfo.weightY[n22] = gridBagLayoutInfo.weightY[n22] + d4;
                    }
                    n14 = gridBagConstraints.minHeight + gridBagConstraints.ipady + gridBagConstraints.insets.top + gridBagConstraints.insets.bottom;
                    n15 = gridBagConstraints.tempY;
                    while (n15 < n2) {
                        n14 -= gridBagLayoutInfo.minHeight[n15];
                        ++n15;
                    }
                    if (n14 > 0) {
                        d3 = 0.0;
                        n15 = gridBagConstraints.tempY;
                        while (n15 < n2) {
                            d3 += gridBagLayoutInfo.weightY[n15];
                            ++n15;
                        }
                        n15 = gridBagConstraints.tempY;
                        while (d3 > 0.0) {
                            d2 = gridBagLayoutInfo.weightY[n15];
                            int n23 = (int)(d2 * (double)n14 / d3);
                            int n24 = n15++;
                            gridBagLayoutInfo.minHeight[n24] = gridBagLayoutInfo.minHeight[n24] + n23;
                            n14 -= n23;
                            d3 -= d2;
                        }
                        int n25 = n2 - 1;
                        gridBagLayoutInfo.minHeight[n25] = gridBagLayoutInfo.minHeight[n25] + n14;
                    }
                } else if (gridBagConstraints.tempHeight > n3 && gridBagConstraints.tempHeight < n13) {
                    n13 = gridBagConstraints.tempHeight;
                }
                ++n12;
            }
            n3 = n13;
            n13 = Integer.MAX_VALUE;
        }
        if (this.columnWidths != null) {
            n3 = 0;
            while (n3 < this.columnWidths.length) {
                if (gridBagLayoutInfo.minWidth[n3] < this.columnWidths[n3]) {
                    gridBagLayoutInfo.minWidth[n3] = this.columnWidths[n3];
                }
                ++n3;
            }
        }
        if (this.rowHeights != null) {
            n3 = 0;
            while (n3 < this.rowHeights.length) {
                if (gridBagLayoutInfo.minHeight[n3] < this.rowHeights[n3]) {
                    gridBagLayoutInfo.minHeight[n3] = this.rowHeights[n3];
                }
                ++n3;
            }
        }
        if (this.columnWeights != null) {
            n3 = 0;
            while (n3 < gridBagLayoutInfo.width && n3 < this.columnWeights.length) {
                if (gridBagLayoutInfo.weightX[n3] < this.columnWeights[n3]) {
                    gridBagLayoutInfo.weightX[n3] = this.columnWeights[n3];
                }
                ++n3;
            }
        }
        if (this.rowWeights != null) {
            n3 = 0;
            while (n3 < gridBagLayoutInfo.height && n3 < this.rowWeights.length) {
                if (gridBagLayoutInfo.weightY[n3] < this.rowWeights[n3]) {
                    gridBagLayoutInfo.weightY[n3] = this.rowWeights[n3];
                }
                ++n3;
            }
        }
        return gridBagLayoutInfo;
    }

    protected void AdjustForGravity(GridBagConstraints gridBagConstraints, Rectangle rectangle) {
        rectangle.x += gridBagConstraints.insets.left;
        rectangle.width -= gridBagConstraints.insets.left + gridBagConstraints.insets.right;
        rectangle.y += gridBagConstraints.insets.top;
        rectangle.height -= gridBagConstraints.insets.top + gridBagConstraints.insets.bottom;
        int n = 0;
        if (gridBagConstraints.fill != 2 && gridBagConstraints.fill != 1 && rectangle.width > gridBagConstraints.minWidth + gridBagConstraints.ipadx) {
            n = rectangle.width - (gridBagConstraints.minWidth + gridBagConstraints.ipadx);
            rectangle.width = gridBagConstraints.minWidth + gridBagConstraints.ipadx;
        }
        int n2 = 0;
        if (gridBagConstraints.fill != 3 && gridBagConstraints.fill != 1 && rectangle.height > gridBagConstraints.minHeight + gridBagConstraints.ipady) {
            n2 = rectangle.height - (gridBagConstraints.minHeight + gridBagConstraints.ipady);
            rectangle.height = gridBagConstraints.minHeight + gridBagConstraints.ipady;
        }
        switch (gridBagConstraints.anchor) {
            case 10: {
                rectangle.x += n / 2;
                rectangle.y += n2 / 2;
                return;
            }
            case 11: {
                rectangle.x += n / 2;
                return;
            }
            case 12: {
                rectangle.x += n;
                return;
            }
            case 13: {
                rectangle.x += n;
                rectangle.y += n2 / 2;
                return;
            }
            case 14: {
                rectangle.x += n;
                rectangle.y += n2;
                return;
            }
            case 15: {
                rectangle.x += n / 2;
                rectangle.y += n2;
                return;
            }
            case 16: {
                rectangle.y += n2;
                return;
            }
            case 17: {
                rectangle.y += n2 / 2;
                return;
            }
            default: {
                throw new IllegalArgumentException("illegal anchor value");
            }
            case 18: 
        }
    }

    protected Dimension GetMinSize(Container container, GridBagLayoutInfo gridBagLayoutInfo) {
        Dimension dimension = new Dimension();
        Insets insets = container.insets();
        int n = 0;
        int n2 = 0;
        while (n2 < gridBagLayoutInfo.width) {
            n += gridBagLayoutInfo.minWidth[n2];
            ++n2;
        }
        dimension.width = n + insets.left + insets.right;
        n = 0;
        n2 = 0;
        while (n2 < gridBagLayoutInfo.height) {
            n += gridBagLayoutInfo.minHeight[n2];
            ++n2;
        }
        dimension.height = n + insets.top + insets.bottom;
        return dimension;
    }

    protected void ArrangeGrid(Container container) {
        int n;
        int n2;
        double d;
        Insets insets = container.insets();
        int n3 = container.countComponents();
        Rectangle rectangle = new Rectangle();
        if (!(n3 != 0 || this.columnWidths != null && this.columnWidths.length != 0 || this.rowHeights != null && this.rowHeights.length != 0)) {
            return;
        }
        GridBagLayoutInfo gridBagLayoutInfo = this.GetLayoutInfo(container, 2);
        Dimension dimension = this.GetMinSize(container, gridBagLayoutInfo);
        if (dimension.width < container.width || dimension.height < container.height) {
            gridBagLayoutInfo = this.GetLayoutInfo(container, 1);
            dimension = this.GetMinSize(container, gridBagLayoutInfo);
        }
        this.layoutInfo = gridBagLayoutInfo;
        rectangle.width = dimension.width;
        rectangle.height = dimension.height;
        int n4 = container.width - rectangle.width;
        if (n4 != 0) {
            d = 0.0;
            n2 = 0;
            while (n2 < gridBagLayoutInfo.width) {
                d += gridBagLayoutInfo.weightX[n2];
                ++n2;
            }
            if (d > 0.0) {
                n2 = 0;
                while (n2 < gridBagLayoutInfo.width) {
                    n = (int)((double)n4 * gridBagLayoutInfo.weightX[n2] / d);
                    int n5 = n2;
                    gridBagLayoutInfo.minWidth[n5] = gridBagLayoutInfo.minWidth[n5] + n;
                    rectangle.width += n;
                    if (gridBagLayoutInfo.minWidth[n2] < 0) {
                        rectangle.width -= gridBagLayoutInfo.minWidth[n2];
                        gridBagLayoutInfo.minWidth[n2] = 0;
                    }
                    ++n2;
                }
            }
            n4 = container.width - rectangle.width;
        } else {
            n4 = 0;
        }
        int n6 = container.height - rectangle.height;
        if (n6 != 0) {
            d = 0.0;
            n2 = 0;
            while (n2 < gridBagLayoutInfo.height) {
                d += gridBagLayoutInfo.weightY[n2];
                ++n2;
            }
            if (d > 0.0) {
                n2 = 0;
                while (n2 < gridBagLayoutInfo.height) {
                    n = (int)((double)n6 * gridBagLayoutInfo.weightY[n2] / d);
                    int n7 = n2;
                    gridBagLayoutInfo.minHeight[n7] = gridBagLayoutInfo.minHeight[n7] + n;
                    rectangle.height += n;
                    if (gridBagLayoutInfo.minHeight[n2] < 0) {
                        rectangle.height -= gridBagLayoutInfo.minHeight[n2];
                        gridBagLayoutInfo.minHeight[n2] = 0;
                    }
                    ++n2;
                }
            }
            n6 = container.height - rectangle.height;
        } else {
            n6 = 0;
        }
        gridBagLayoutInfo.startx = n4 / 2 + insets.left;
        gridBagLayoutInfo.starty = n6 / 2 + insets.top;
        int n8 = 0;
        while (n8 < n3) {
            Component component = container.getComponent(n8);
            GridBagConstraints gridBagConstraints = this.lookupConstraints(component);
            rectangle.x = gridBagLayoutInfo.startx;
            n2 = 0;
            while (n2 < gridBagConstraints.tempX) {
                rectangle.x += gridBagLayoutInfo.minWidth[n2];
                ++n2;
            }
            rectangle.y = gridBagLayoutInfo.starty;
            n2 = 0;
            while (n2 < gridBagConstraints.tempY) {
                rectangle.y += gridBagLayoutInfo.minHeight[n2];
                ++n2;
            }
            rectangle.width = 0;
            n2 = gridBagConstraints.tempX;
            while (n2 < gridBagConstraints.tempX + gridBagConstraints.tempWidth) {
                rectangle.width += gridBagLayoutInfo.minWidth[n2];
                ++n2;
            }
            rectangle.height = 0;
            n2 = gridBagConstraints.tempY;
            while (n2 < gridBagConstraints.tempY + gridBagConstraints.tempHeight) {
                rectangle.height += gridBagLayoutInfo.minHeight[n2];
                ++n2;
            }
            this.AdjustForGravity(gridBagConstraints, rectangle);
            if (rectangle.width <= 0 || rectangle.height <= 0) {
                component.hide();
            } else {
                if (component.x != rectangle.x || component.y != rectangle.y || component.width != rectangle.width || component.height != rectangle.height) {
                    component.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                component.show();
            }
            ++n8;
        }
    }
}

