/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Event;
import java.awt.Font;
import java.awt.MenuContainer;
import java.awt.peer.MenuComponentPeer;
import java.io.Serializable;

public abstract class MenuComponent
implements Serializable {
    transient MenuComponentPeer peer;
    transient MenuContainer parent;
    Font font;

    public MenuContainer getParent() {
        return this.parent;
    }

    public MenuComponentPeer getPeer() {
        return this.peer;
    }

    public Font getFont() {
        Font font = this.font;
        if (font != null) {
            return font;
        }
        MenuContainer menuContainer = this.parent;
        if (menuContainer != null) {
            return menuContainer.getFont();
        }
        return null;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void removeNotify() {
        MenuComponentPeer menuComponentPeer = this.peer;
        if (menuComponentPeer != null) {
            menuComponentPeer.dispose();
            this.peer = null;
        }
    }

    public boolean postEvent(Event event) {
        MenuContainer menuContainer = this.parent;
        if (menuContainer != null) {
            menuContainer.postEvent(event);
        }
        return false;
    }

    protected String paramString() {
        return "";
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.paramString() + "]";
    }
}

