/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.controls;

import java.io.ByteArrayInputStream;
import netscape.ldap.LDAPControl;
import netscape.ldap.ber.stream.BERBoolean;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEREnumerated;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.client.JDAPBERTagDecoder;
import netscape.ldap.controls.LDAPEntryChangeControl;

public class LDAPPersistentSearchControl
extends LDAPControl {
    private int m_changeTypes = 1;
    private boolean m_changesOnly = false;
    private boolean m_returnECs = false;
    public static int ADDTYPE = 1;
    public static int DELETETYPE = 2;
    public static int MODIFYTYPE = 4;
    public static int MODDNTYPE = 8;

    public LDAPPersistentSearchControl() {
    }

    public LDAPPersistentSearchControl(int n, boolean bl, boolean bl2, boolean bl3) {
        super("2.16.840.1.113730.3.4.3", bl3, null);
        this.m_value = this.createPersistentSearchSpecification(n, bl, bl2);
    }

    public int getChangeTypes() {
        return this.m_changeTypes;
    }

    public boolean getChangesOnly() {
        return this.m_changesOnly;
    }

    public boolean getReturnECs() {
        return this.m_returnECs;
    }

    public void setChangeTypes(int n) {
        this.m_changeTypes = n;
    }

    public void setChangesOnly(boolean bl) {
        this.m_changesOnly = bl;
    }

    public void setReturnECs(boolean bl) {
        this.m_returnECs = bl;
    }

    public LDAPEntryChangeControl parseResponse(byte[] byArray) {
        LDAPEntryChangeControl lDAPEntryChangeControl = new LDAPEntryChangeControl();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        new BERSequence();
        JDAPBERTagDecoder jDAPBERTagDecoder = new JDAPBERTagDecoder();
        int[] nArray = new int[]{0};
        try {
            BERSequence bERSequence = (BERSequence)BERElement.getElement(jDAPBERTagDecoder, byteArrayInputStream, nArray);
            BEREnumerated bEREnumerated = (BEREnumerated)bERSequence.elementAt(0);
            lDAPEntryChangeControl.setChangeType(bEREnumerated.getValue());
        }
        catch (Throwable throwable) {
            return null;
        }
        return lDAPEntryChangeControl;
    }

    public static LDAPEntryChangeControl parseResponse(LDAPControl[] lDAPControlArray) {
        LDAPPersistentSearchControl lDAPPersistentSearchControl = new LDAPPersistentSearchControl();
        int n = 0;
        while (lDAPControlArray != null && n < lDAPControlArray.length) {
            if (lDAPControlArray[n].getID().equals("2.16.840.1.113730.3.4.7")) {
                return lDAPPersistentSearchControl.parseResponse(lDAPControlArray[n].getValue());
            }
            ++n;
        }
        return null;
    }

    private byte[] createPersistentSearchSpecification(int n, boolean bl, boolean bl2) {
        BERSequence bERSequence = new BERSequence();
        bERSequence.addElement(new BERInteger(n));
        bERSequence.addElement(new BERBoolean(bl));
        bERSequence.addElement(new BERBoolean(bl2));
        return this.flattenBER(bERSequence);
    }
}

