/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Range;
import netscape.application.Rect;
import netscape.application.TextParagraphFormat;
import netscape.application.TextStyleRun;

class TextPositionInfo {
    public TextStyleRun _textRun;
    public int _x;
    public int _y;
    public int _lineNumber;
    public int _lineHeight;
    public int _absPosition;
    public int _positionInRun;
    public int _updateLine;
    public boolean _redrawCurrentLineOnly;
    public boolean _redrawCurrentParagraphOnly;
    public boolean _nextLine;
    public boolean _endOfLine;
    public boolean _endOfParagraph;

    TextPositionInfo() {
    }

    TextPositionInfo(TextStyleRun textStyleRun, int n, int n2, int n3, int n4, int n5, int n6) {
        this();
        this.init(textStyleRun, n, n2, n3, n4, n5, n6);
    }

    TextPositionInfo(TextPositionInfo textPositionInfo) {
        this();
        this.init(textPositionInfo._textRun, textPositionInfo._x, textPositionInfo._y, textPositionInfo._lineNumber, textPositionInfo._lineHeight, textPositionInfo._positionInRun, textPositionInfo._absPosition);
    }

    public String toString() {
        return "run is " + this._textRun + " x is " + this._x + " y is " + this._y + " lineNumber is " + this._lineNumber + "line height is: " + this._lineHeight + "positionInRun is " + this._positionInRun + "position is:" + this._absPosition + "endOfLine is " + this._endOfLine + "_endOfParagraph is " + this._endOfParagraph;
    }

    void init(TextStyleRun textStyleRun, int n, int n2, int n3, int n4, int n5, int n6) {
        this._textRun = textStyleRun;
        this._x = n;
        this._y = n2;
        this._lineNumber = n3;
        this._lineHeight = n4;
        this._positionInRun = n5;
        this._absPosition = n6;
        this._updateLine = this._lineNumber;
    }

    void init(TextPositionInfo textPositionInfo) {
        this.init(textPositionInfo._textRun, textPositionInfo._x, textPositionInfo._y, textPositionInfo._lineNumber, textPositionInfo._lineHeight, textPositionInfo._positionInRun, textPositionInfo._absPosition);
    }

    void representCharacterAfterEndOfLine() {
        if (this._endOfLine) {
            TextParagraphFormat textParagraphFormat = this._textRun.paragraph().currentParagraphFormat();
            this._x = textParagraphFormat._leftMargin + textParagraphFormat._leftIndent;
            if (textParagraphFormat.wrapsUnderFirstCharacter()) {
                this._x = textParagraphFormat._leftMargin + (this._textRun.paragraph().addWidthOfInitialTabs(textParagraphFormat._leftMargin + textParagraphFormat._leftIndent) - textParagraphFormat._leftIndent);
            }
            this._y += this._lineHeight;
            ++this._lineNumber;
            this._lineHeight = this._textRun.paragraph()._lineHeights[this._lineNumber];
            this._endOfLine = false;
        }
    }

    void representCharacterBeforeEndOfLine() {
        TextPositionInfo textPositionInfo = this._textRun._paragraph._owner.positionInfoForIndex(this._absPosition);
        if (textPositionInfo._endOfLine) {
            this._textRun = textPositionInfo._textRun;
            this._x = textPositionInfo._x;
            this._y = textPositionInfo._y;
            this._absPosition = textPositionInfo._absPosition;
            this._lineNumber = textPositionInfo._lineNumber;
            this._lineHeight = textPositionInfo._lineHeight;
            this._positionInRun = textPositionInfo._positionInRun;
            this._updateLine = textPositionInfo._updateLine;
            this._redrawCurrentLineOnly = textPositionInfo._redrawCurrentLineOnly;
            this._redrawCurrentParagraphOnly = textPositionInfo._redrawCurrentParagraphOnly;
            this._nextLine = textPositionInfo._nextLine;
            this._endOfLine = textPositionInfo._endOfLine;
            this._endOfParagraph = textPositionInfo._endOfParagraph;
        }
    }

    void setUpdateLine(int n) {
        this._updateLine = n;
    }

    void setRedrawCurrentLineOnly(boolean bl) {
        this._redrawCurrentLineOnly = bl;
    }

    void setRedrawCurrentParagraphOnly(boolean bl) {
        this._redrawCurrentParagraphOnly = bl;
    }

    void setX(int n) {
        this._x = n;
    }

    void setAbsPosition(int n) {
        this._absPosition = n;
    }

    void setPositionInRun(int n) {
        this._positionInRun = n;
    }

    void moveBy(int n, int n2) {
        this._x += n;
        this._y += n2;
    }

    int maxY() {
        return this._y + this._lineHeight;
    }

    Rect lineBounds() {
        return this._textRun._paragraph.rectForLine(this._lineNumber);
    }

    Range lineRange() {
        return this._textRun._paragraph.rangeForLine(this._lineNumber);
    }

    void setNextLine(boolean bl) {
        this._nextLine = bl;
    }

    void setAtEndOfLine(boolean bl) {
        this._endOfLine = bl;
    }

    void setAtEndOfParagraph(boolean bl) {
        this._endOfParagraph = bl;
    }
}

