/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.controls;

import java.io.ByteArrayInputStream;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPSortKey;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEREnumerated;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.JDAPBERTagDecoder;

public class LDAPSortControl
extends LDAPControl {
    public LDAPSortControl(LDAPSortKey lDAPSortKey, boolean bl) {
        super("1.2.840.113556.1.4.473", bl, null);
        LDAPSortKey[] lDAPSortKeyArray = new LDAPSortKey[]{lDAPSortKey};
        this.m_value = this.createSortSpecification(lDAPSortKeyArray);
    }

    public LDAPSortControl(LDAPSortKey[] lDAPSortKeyArray, boolean bl) {
        super("1.2.840.113556.1.4.473", bl, null);
        this.m_value = this.createSortSpecification(lDAPSortKeyArray);
    }

    public static String parseResponse(LDAPControl[] lDAPControlArray, int[] nArray) {
        String string = null;
        LDAPControl lDAPControl = null;
        int n = 0;
        while (lDAPControlArray != null && n < lDAPControlArray.length) {
            if (lDAPControlArray[n].getID().equals("1.2.840.113556.1.4.474")) {
                lDAPControl = lDAPControlArray[n];
                break;
            }
            ++n;
        }
        if (lDAPControl != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(lDAPControl.getValue());
            new BERSequence();
            JDAPBERTagDecoder jDAPBERTagDecoder = new JDAPBERTagDecoder();
            int[] nArray2 = new int[]{0};
            try {
                BERSequence bERSequence = (BERSequence)BERElement.getElement(jDAPBERTagDecoder, byteArrayInputStream, nArray2);
                int n2 = ((BEREnumerated)bERSequence.elementAt(0)).getValue();
                if (nArray != null && nArray.length > 0) {
                    nArray[0] = n2;
                }
                BEROctetString bEROctetString = (BEROctetString)bERSequence.elementAt(1);
                string = new String(bEROctetString.getValue(), "UTF8");
            }
            catch (Throwable throwable) {}
        }
        return string;
    }

    private byte[] createSortSpecification(LDAPSortKey[] lDAPSortKeyArray) {
        BERSequence bERSequence = new BERSequence();
        int n = 0;
        while (n < lDAPSortKeyArray.length) {
            BERSequence bERSequence2 = new BERSequence();
            bERSequence2.addElement(new BEROctetString(lDAPSortKeyArray[n].getKey()));
            if (lDAPSortKeyArray[n].getMatchRule() != null) {
                bERSequence2.addElement(new BERTag(160, new BEROctetString(lDAPSortKeyArray[n].getMatchRule()), true));
            }
            if (lDAPSortKeyArray[n].getReverse()) {
                bERSequence2.addElement(new BERTag(129, new BEREnumerated(129), true));
            }
            bERSequence.addElement(bERSequence2);
            ++n;
        }
        return this.flattenBER(bERSequence);
    }
}

