/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Range;
import netscape.application.Rect;
import netscape.application.Target;
import netscape.application.TextParagraph;
import netscape.application.TextPositionInfo;
import netscape.application.TextView;
import netscape.application.Timer;
import netscape.util.Vector;

class TextSelection
implements Target {
    TextView _owner;
    private TextParagraph _editParagraph;
    TextPositionInfo _insertionPointInfo;
    TextPositionInfo _anchorPositionInfo;
    TextPositionInfo _endPositionInfo;
    Timer _blinkTimer;
    long _lastFlashTime;
    int _anchorPosition;
    int _endPosition;
    boolean _flashInsertionPoint;
    boolean _insertionPointShowing;
    boolean _ignoreNextFlash;
    boolean _selectionDefined = false;
    int _insertionPointDisabled;

    TextSelection() {
    }

    TextSelection(TextView textView) {
        this();
        this.init(textView);
        this._selectionDefined = false;
    }

    void init(TextView textView) {
        this._owner = textView;
    }

    void _startFlashing() {
        if (this._insertionPointDisabled != 0) {
            return;
        }
        if (!this._owner.isEditable()) {
            return;
        }
        if (!this._selectionDefined) {
            return;
        }
        if (this._blinkTimer == null) {
            this._blinkTimer = new Timer(this, "blinkCaret", 700);
        }
        if (this._owner.isEditing()) {
            this._blinkTimer.start();
        } else if (System.currentTimeMillis() - this._lastFlashTime > 350L) {
            this._ignoreNextFlash = true;
        }
        this.showInsertionPoint();
    }

    void _stopFlashing() {
        this.hideInsertionPoint();
        if (this._blinkTimer != null) {
            this._blinkTimer.stop();
            this._ignoreNextFlash = false;
        }
    }

    public void performCommand(String string, Object object) {
        if (this._owner.isEditing() && this._selectionDefined) {
            if (this._ignoreNextFlash || !this._flashInsertionPoint || this.isARange()) {
                this._ignoreNextFlash = false;
                return;
            }
            this._lastFlashTime = this._blinkTimer.timeStamp();
            this._insertionPointShowing = !this._insertionPointShowing;
            this._owner.drawInsertionPoint();
            return;
        }
        if (this._blinkTimer != null) {
            this._blinkTimer.stop();
        }
    }

    boolean isARange() {
        return this._insertionPointInfo == null && this._anchorPositionInfo != null;
    }

    void disableInsertionPoint() {
        if (this._insertionPointDisabled == 0) {
            this.hideInsertionPoint();
        }
        ++this._insertionPointDisabled;
    }

    void enableInsertionPoint() {
        --this._insertionPointDisabled;
        if (this._insertionPointDisabled == 0) {
            this.showInsertionPoint();
        }
    }

    void showInsertionPoint() {
        if (this._insertionPointDisabled != 0) {
            return;
        }
        if (!this._owner.isEditable()) {
            return;
        }
        if (!this._owner.isEditing()) {
            return;
        }
        this._flashInsertionPoint = true;
        if (this.isARange() || this._insertionPointShowing) {
            return;
        }
        this._insertionPointShowing = true;
        this._owner.drawInsertionPoint();
        this._startFlashing();
    }

    void hideInsertionPoint() {
        this._flashInsertionPoint = false;
        if (this.isARange() || !this._insertionPointShowing) {
            return;
        }
        this._insertionPointShowing = false;
        this._owner.drawInsertionPoint();
    }

    Rect insertionPointRect() {
        if (this._insertionPointInfo == null) {
            return TextView.newRect();
        }
        return TextView.newRect(this._insertionPointInfo._x - 1, this._insertionPointInfo._y, 1, this._insertionPointInfo._lineHeight);
    }

    Rect _updateRectForInfo(int n, int n2, TextPositionInfo textPositionInfo, TextPositionInfo textPositionInfo2) {
        Rect rect;
        if (n == n2) {
            return null;
        }
        if (textPositionInfo._y == textPositionInfo2._y) {
            rect = textPositionInfo2._x < textPositionInfo._x ? TextView.newRect(textPositionInfo2._x, textPositionInfo2._y, textPositionInfo._x - textPositionInfo2._x, textPositionInfo2._lineHeight) : TextView.newRect(textPositionInfo._x, textPositionInfo2._y, textPositionInfo2._x - textPositionInfo._x, textPositionInfo2._lineHeight);
        } else {
            rect = textPositionInfo.lineBounds();
            Rect rect2 = textPositionInfo2.lineBounds();
            rect.unionWith(rect2);
            TextView.returnRect(rect2);
        }
        return rect;
    }

    void setRange(int n, int n2, TextPositionInfo textPositionInfo, boolean bl, boolean bl2) {
        TextPositionInfo textPositionInfo2;
        TextPositionInfo textPositionInfo3;
        int n3;
        TextPositionInfo textPositionInfo4;
        TextPositionInfo textPositionInfo5;
        int n4;
        this._selectionDefined = n != -1 && n2 != -1;
        if (this._anchorPosition != this._endPosition) {
            n4 = this._anchorPosition < this._endPosition ? this._anchorPosition : this._endPosition;
            textPositionInfo5 = this._anchorPosition < this._endPosition ? this._anchorPositionInfo : this._endPositionInfo;
            int n5 = this._anchorPosition > this._endPosition ? this._anchorPosition : this._endPosition;
            textPositionInfo4 = this._anchorPosition > this._endPosition ? this._anchorPositionInfo : this._endPositionInfo;
        } else {
            int n6 = -1;
            n4 = -1;
            textPositionInfo4 = null;
            textPositionInfo5 = null;
        }
        if (n < 0) {
            n = 0;
        } else if (n >= this._owner._charCount) {
            n = this._owner._charCount - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this._owner._charCount) {
            n2 = this._owner._charCount - 1;
        }
        this._anchorPosition = n;
        this._endPosition = n2;
        if (this._anchorPosition == this._endPosition) {
            TextParagraph textParagraph;
            this._editParagraph = this._owner._paragraphForIndex(this._anchorPosition);
            this._insertionPointInfo = this._editParagraph.infoForPosition(this._anchorPosition, -1);
            if (bl2 && this._insertionPointInfo._endOfLine && this._anchorPosition < this._owner.length() - 1 && (textParagraph = this._owner._paragraphForIndex(this._anchorPosition + 1)) == this._editParagraph) {
                TextPositionInfo textPositionInfo6 = this._editParagraph.infoForPosition(this._anchorPosition + 1, -1);
                if (textPositionInfo6._y > this._insertionPointInfo._y) {
                    this._insertionPointInfo = this._editParagraph.infoForPosition(this._anchorPosition, textPositionInfo6._y);
                }
            }
            this._endPositionInfo = null;
            this._anchorPositionInfo = null;
        } else {
            TextParagraph textParagraph = this._owner._paragraphForIndex(this._anchorPosition);
            this._anchorPositionInfo = textParagraph.infoForPosition(this._anchorPosition, -1);
            if (this._anchorPositionInfo._endOfLine && !bl) {
                this._anchorPositionInfo = textParagraph.infoForPosition(this._anchorPosition, this._anchorPositionInfo.maxY());
            }
            this._endPositionInfo = textPositionInfo == null ? this._owner._paragraphForIndex(this._endPosition).infoForPosition(this._endPosition, -1) : textPositionInfo;
            this._insertionPointInfo = null;
            this._editParagraph = null;
        }
        if (this._anchorPosition != this._endPosition) {
            n3 = this._anchorPosition < this._endPosition ? this._anchorPosition : this._endPosition;
            textPositionInfo3 = this._anchorPosition < this._endPosition ? this._anchorPositionInfo : this._endPositionInfo;
            int n7 = this._anchorPosition > this._endPosition ? this._anchorPosition : this._endPosition;
            textPositionInfo2 = this._anchorPosition > this._endPosition ? this._anchorPositionInfo : this._endPositionInfo;
        } else {
            int n8 = -1;
            n3 = -1;
            textPositionInfo2 = null;
            textPositionInfo3 = null;
        }
        if (n4 == -1) {
            if (n3 == -1) {
                this._startFlashing();
                this._updateCurrentFont();
                return;
            }
            this.dirtyRangeForSelection(this._anchorPositionInfo, this._endPositionInfo, null, null);
            this._updateCurrentFont();
            return;
        }
        if (n3 == -1) {
            this.dirtyRangeForSelection(textPositionInfo5, textPositionInfo4, null, null);
            this._startFlashing();
            this._updateCurrentFont();
            return;
        }
        this.dirtyRangeForSelection(textPositionInfo3, textPositionInfo2, textPositionInfo5, textPositionInfo4);
        this._updateCurrentFont();
    }

    void dirtyRangeForSelection(TextPositionInfo textPositionInfo, TextPositionInfo textPositionInfo2, TextPositionInfo textPositionInfo3, TextPositionInfo textPositionInfo4) {
        TextPositionInfo textPositionInfo5;
        Range range;
        Rect rect = null;
        Rect rect2 = this._owner.bounds();
        Range range2 = Range.rangeFromIndices(textPositionInfo._absPosition, textPositionInfo2._absPosition);
        if (textPositionInfo3 == null || textPositionInfo4 == null) {
            range = range2;
        } else {
            Range range3 = Range.rangeFromIndices(textPositionInfo3._absPosition, textPositionInfo4._absPosition);
            if (range3.equals(range2)) {
                return;
            }
            if (range2.index == range3.index) {
                range = range2.length > range3.length ? new Range(range2.index + range3.length, range2.length - range3.length) : new Range(range2.index + range2.length, range3.length - range2.length);
            } else if (range2.index + range2.length == range3.index + range3.length) {
                range = range2.length > range3.length ? new Range(range2.index, range2.length - range3.length) : new Range(range3.index, range3.length - range2.length);
            } else {
                this.dirtyRangeForSelection(textPositionInfo, textPositionInfo2, null, null);
                this.dirtyRangeForSelection(textPositionInfo3, textPositionInfo4, null, null);
                return;
            }
        }
        Vector vector = this._owner.rectsForRange(range);
        int n = 0;
        int n2 = vector.count();
        while (n < n2) {
            Rect rect3 = (Rect)vector.elementAt(n);
            rect3.x = 0;
            rect3.width = rect2.width;
            if (rect3.height > 0) {
                if (rect == null) {
                    rect = new Rect(rect3);
                } else {
                    rect.unionWith(rect3);
                }
            }
            ++n;
        }
        if (rect == null) {
            return;
        }
        if (range.contains(textPositionInfo._absPosition) && !rect.contains(textPositionInfo._x, textPositionInfo._y) && textPositionInfo._absPosition > 0 && (textPositionInfo5 = this._owner.positionInfoForIndex(textPositionInfo._absPosition - 1)) != null) {
            rect.y -= textPositionInfo5._lineHeight;
            rect.height += textPositionInfo5._lineHeight;
        }
        if (range.contains(textPositionInfo2._absPosition) && !rect.contains(textPositionInfo2._x, textPositionInfo2._y) && textPositionInfo2._absPosition > 0 && (textPositionInfo5 = this._owner.positionInfoForIndex(textPositionInfo2._absPosition - 1)) != null) {
            rect.y -= textPositionInfo5._lineHeight;
            rect.height += textPositionInfo5._lineHeight;
        }
        if (textPositionInfo3 != null && range.contains(textPositionInfo3._absPosition) && !rect.contains(textPositionInfo3._x, textPositionInfo3._y) && textPositionInfo3._absPosition > 0 && (textPositionInfo5 = this._owner.positionInfoForIndex(textPositionInfo3._absPosition - 1)) != null) {
            rect.y -= textPositionInfo5._lineHeight;
            rect.height += textPositionInfo5._lineHeight;
        }
        if (textPositionInfo4 != null && range.contains(textPositionInfo4._absPosition) && !rect.contains(textPositionInfo4._x, textPositionInfo4._y) && textPositionInfo4._absPosition > 0 && (textPositionInfo5 = this._owner.positionInfoForIndex(textPositionInfo4._absPosition - 1)) != null) {
            rect.y -= textPositionInfo5._lineHeight;
            rect.height += textPositionInfo5._lineHeight;
        }
        this._owner.addDirtyRect(rect);
    }

    void setRange(int n, int n2, TextPositionInfo textPositionInfo, boolean bl) {
        this.setRange(n, n2, textPositionInfo, bl, false);
    }

    void setRange(int n, int n2) {
        this.setRange(n, n2, null, false, false);
    }

    void setRange(int n, int n2, boolean bl) {
        this.setRange(n, n2, null, false, bl);
    }

    void clearRange() {
        this.hideInsertionPoint();
        this.setRange(-1, -1);
        this._stopFlashing();
    }

    void setInsertionPoint(TextPositionInfo textPositionInfo) {
        Rect rect = null;
        if (textPositionInfo == null) {
            return;
        }
        this._selectionDefined = true;
        if (this._anchorPosition != this._endPosition) {
            rect = this._anchorPositionInfo.lineBounds();
            Rect rect2 = this._endPositionInfo.lineBounds();
            rect.unionWith(rect2);
            rect.x = 0;
            rect.width = this._owner.bounds.width;
            TextView.returnRect(rect2);
        }
        this._anchorPosition = this._endPosition = textPositionInfo._absPosition;
        this._insertionPointInfo = textPositionInfo;
        this._editParagraph = this._insertionPointInfo._textRun._paragraph;
        this._endPositionInfo = null;
        this._anchorPositionInfo = null;
        if (rect != null) {
            this._owner.draw(rect);
            TextView.returnRect(rect);
        }
        if (this._insertionPointShowing) {
            this._startFlashing();
        }
    }

    int insertionPoint() {
        if (this.isARange()) {
            return -1;
        }
        return this._anchorPosition;
    }

    TextPositionInfo insertionPointInfo() {
        if (this.isARange()) {
            return null;
        }
        return this._insertionPointInfo;
    }

    int selectionStart() {
        if (!this._selectionDefined) {
            return -1;
        }
        if (this._anchorPosition <= this._endPosition) {
            return this._anchorPosition;
        }
        return this._endPosition;
    }

    TextPositionInfo selectionStartInfo() {
        if (!this.isARange()) {
            return this._insertionPointInfo;
        }
        if (this._anchorPosition <= this._endPosition) {
            return this._anchorPositionInfo;
        }
        return this._endPositionInfo;
    }

    int selectionEnd() {
        if (!this._selectionDefined) {
            return -1;
        }
        if (this._endPosition > this._anchorPosition) {
            return this._endPosition;
        }
        return this._anchorPosition;
    }

    TextPositionInfo selectionEndInfo() {
        if (!this.isARange()) {
            return this._insertionPointInfo;
        }
        if (this._endPosition > this._anchorPosition) {
            return this._endPositionInfo;
        }
        return this._anchorPositionInfo;
    }

    void _updateCurrentFont() {
    }

    int orderedSelectionStart() {
        if (!this._selectionDefined) {
            return -1;
        }
        return this._anchorPosition;
    }

    TextPositionInfo orderedSelectionStartInfo() {
        if (!this.isARange()) {
            return this._insertionPointInfo;
        }
        return this._anchorPositionInfo;
    }

    int orderedSelectionEnd() {
        if (!this._selectionDefined) {
            return -1;
        }
        return this._endPosition;
    }

    TextPositionInfo orderedSelectionEndInfo() {
        if (!this.isARange()) {
            return this._insertionPointInfo;
        }
        return this._endPositionInfo;
    }
}

