/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.BezelBorder;
import netscape.application.Bitmap;
import netscape.application.Button;
import netscape.application.Color;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.MouseEvent;
import netscape.application.Rect;
import netscape.application.ScrollBarOwner;
import netscape.application.Scrollable;
import netscape.application.Size;
import netscape.application.Target;
import netscape.application.Timer;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class ScrollBar
extends View
implements Target {
    Scrollable scrollableView;
    Button increaseButton;
    Button decreaseButton;
    Image knobImage;
    Image trayTopImage;
    Image trayBottomImage;
    Image trayLeftImage;
    Image trayRightImage;
    Timer timer;
    int scrollValue;
    int origScrollValue;
    int knobLength;
    int lastMouseValue;
    int lastAltMouseValue;
    int lineIncrement;
    int axis;
    boolean active;
    boolean enabled;
    boolean shouldRedraw;
    float pageSizeAsPercent;
    int pixelScrollValue;
    ScrollBarOwner scrollBarOwner;
    public static final int DEFAULT_LINE_INCREMENT = 12;
    public static final float DEFAULT_PAGE_SIZE = 1.0f;
    public static final int DEFAULT_WIDTH = 0;
    public static final int DEFAULT_HEIGHT = 0;
    public static final String UPDATE = "updateScrollValue";
    public static final String SCROLL_PAGE_BACKWARD = "scrollPageBackward";
    public static final String SCROLL_PAGE_FORWARD = "scrollPageForward";
    public static final String SCROLL_LINE_BACKWARD = "scrollLineBackward";
    public static final String SCROLL_LINE_FORWARD = "scrollLineForward";
    private static final String TIMER_SCROLL_PAGE = "timerScroll";
    static final String SCROLLVIEW_KEY = "scrollView";
    static final String INCREASEBUTTON_KEY = "increaseButton";
    static final String DECREASEBUTTON_KEY = "decreaseButton";
    static final String KNOBIMAGE_KEY = "image";
    static final String SCROLLVALUE_KEY = "scrollValue";
    static final String AXIS_KEY = "axis";
    static final String ACTIVE_KEY = "active";
    static final String ENABLED_KEY = "enabled";
    static final String LINE_INCREMENT_KEY = "lineIncrement";
    static final String OWNER_KEY = "owner";

    public ScrollBar() {
        this(0, 0, 0, 0);
    }

    public ScrollBar(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public ScrollBar(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, 1);
    }

    public ScrollBar(int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.axis = n5;
        this.lineIncrement = 12;
        this.pageSizeAsPercent = 1.0f;
        this.setEnabled(true);
        Button button = new Button(0, 0, 16, 16);
        button.setType(3);
        button.setBordered(true);
        button.setRaisedBorder(BezelBorder.raisedScrollButtonBezel());
        button.setLoweredBorder(BezelBorder.loweredScrollButtonBezel());
        if (this.axis == 0) {
            button.setImage(Bitmap.bitmapNamed("netscape/application/ScrollRightArrow.gif"));
            button.setAltImage(Bitmap.bitmapNamed("netscape/application/ScrollRightArrowActive.gif"));
        } else {
            button.setImage(Bitmap.bitmapNamed("netscape/application/ScrollDownArrow.gif"));
            button.setAltImage(Bitmap.bitmapNamed("netscape/application/ScrollDownArrowActive.gif"));
        }
        this.setIncreaseButton(button);
        button = new Button(0, 0, 16, 16);
        button.setType(3);
        button.setBordered(true);
        button.setRaisedBorder(BezelBorder.raisedScrollButtonBezel());
        button.setLoweredBorder(BezelBorder.loweredScrollButtonBezel());
        if (this.axis == 0) {
            button.setImage(Bitmap.bitmapNamed("netscape/application/ScrollLeftArrow.gif"));
            button.setAltImage(Bitmap.bitmapNamed("netscape/application/ScrollLeftArrowActive.gif"));
        } else {
            button.setImage(Bitmap.bitmapNamed("netscape/application/ScrollUpArrow.gif"));
            button.setAltImage(Bitmap.bitmapNamed("netscape/application/ScrollUpArrowActive.gif"));
        }
        this.setDecreaseButton(button);
        if (this.axis == 0) {
            this.setHorizResizeInstruction(2);
            this.setVertResizeInstruction(8);
        } else {
            this.setHorizResizeInstruction(1);
            this.setVertResizeInstruction(16);
        }
        if (this.axis == 0) {
            this.setKnobImage(Bitmap.bitmapNamed("netscape/application/ScrollKnobH.gif"));
        } else {
            this.setKnobImage(Bitmap.bitmapNamed("netscape/application/ScrollKnobV.gif"));
        }
        this.trayTopImage = Bitmap.bitmapNamed("netscape/application/ScrollTrayTop.gif");
        this.trayBottomImage = Bitmap.bitmapNamed("netscape/application/ScrollTrayBottom.gif");
        this.trayLeftImage = Bitmap.bitmapNamed("netscape/application/ScrollTrayLeft.gif");
        this.trayRightImage = Bitmap.bitmapNamed("netscape/application/ScrollTrayRight.gif");
        if (this.axis == 0 && this.bounds.height == 0 || this.axis != 0 && this.bounds.width == 0) {
            this._adjustToFit();
        }
        this._computeScrollValue();
        this._setupKeyboard();
    }

    public boolean isTransparent() {
        return false;
    }

    public Rect interiorRect() {
        return Rect.newRect(1, 1, this.width() - 2, this.height() - 2);
    }

    public Size minSize() {
        int n;
        int n2;
        if (this.increaseButton != null) {
            n2 = this.increaseButton.bounds.width;
            n = this.increaseButton.bounds.height;
        } else {
            n = 0;
            n2 = 0;
        }
        if (this.decreaseButton != null) {
            if (this.axis == 0) {
                n2 += this.decreaseButton.bounds.width;
                if (n < this.decreaseButton.bounds.height) {
                    n = this.decreaseButton.bounds.height;
                }
            } else {
                if (n2 < this.decreaseButton.bounds.width) {
                    n2 = this.decreaseButton.bounds.width;
                }
                n += this.decreaseButton.bounds.height;
            }
        }
        return new Size(n2 + 2, n + 2);
    }

    void _adjustToFit() {
        Size size = this.minSize();
        if (this.axis == 0) {
            this.sizeTo(this.bounds.width, size.height);
            return;
        }
        this.sizeTo(size.width, this.bounds.height);
    }

    public void didSizeBy(int n, int n2) {
        super.didSizeBy(n, n2);
        this._computeScrollValue();
    }

    public void setIncreaseButton(Button button) {
        if (this.increaseButton != null) {
            this.increaseButton.removeFromSuperview();
        }
        this.increaseButton = button;
        if (this.increaseButton != null) {
            this.increaseButton.setTarget(this);
            this.increaseButton.setCommand(SCROLL_LINE_FORWARD);
            if (this.axis == 0) {
                this.increaseButton.setHorizResizeInstruction(1);
                this.increaseButton.setVertResizeInstruction(16);
            } else {
                this.increaseButton.setHorizResizeInstruction(2);
                this.increaseButton.setVertResizeInstruction(8);
            }
            this._adjustToFit();
        }
        if (this.enabled && this.active) {
            this.addParts();
        }
    }

    public Button increaseButton() {
        return this.increaseButton;
    }

    public void setDecreaseButton(Button button) {
        if (this.decreaseButton != null) {
            this.decreaseButton.removeFromSuperview();
        }
        this.decreaseButton = button;
        if (this.decreaseButton != null) {
            this.decreaseButton.setTarget(this);
            this.decreaseButton.setCommand(SCROLL_LINE_BACKWARD);
            if (this.axis == 0) {
                this.decreaseButton.setHorizResizeInstruction(0);
                this.decreaseButton.setVertResizeInstruction(16);
            } else {
                this.decreaseButton.setHorizResizeInstruction(2);
                this.decreaseButton.setVertResizeInstruction(4);
            }
            this._adjustToFit();
        }
        if (this.enabled && this.active) {
            this.addParts();
        }
    }

    public Button decreaseButton() {
        return this.decreaseButton;
    }

    public void addParts() {
        int n = 1;
        int n2 = 1;
        if (this.decreaseButton != null) {
            this.decreaseButton.moveTo(n, n2);
        }
        if (this.axis == 0) {
            if (this.increaseButton != null) {
                this.increaseButton.moveTo(this.width() - 1 - this.increaseButton.width(), n2);
            }
        } else if (this.increaseButton != null) {
            this.increaseButton.moveTo(n, this.height() - 1 - this.increaseButton.height());
        }
        this.addSubview(this.increaseButton);
        this.addSubview(this.decreaseButton);
    }

    public void removeParts() {
        if (this.increaseButton != null) {
            this.increaseButton.removeFromSuperview();
        }
        if (this.decreaseButton != null) {
            this.decreaseButton.removeFromSuperview();
        }
    }

    public void setScrollableObject(Scrollable scrollable) {
        if (this.scrollableView == scrollable) {
            return;
        }
        this.scrollableView = scrollable;
        this._computeScrollValue();
    }

    public Scrollable scrollableObject() {
        return this.scrollableView;
    }

    public void setScrollBarOwner(ScrollBarOwner scrollBarOwner) {
        this.scrollBarOwner = scrollBarOwner;
    }

    public ScrollBarOwner scrollBarOwner() {
        return this.scrollBarOwner;
    }

    public Rect scrollTrayRect() {
        if (this.axis == 0) {
            int n = 1;
            if (this.decreaseButton != null) {
                n += this.decreaseButton.bounds.width;
            }
            int n2 = this.width() - 1;
            if (this.increaseButton != null) {
                n2 -= this.increaseButton.width();
            }
            return Rect.newRect(n, 1, n2 - n, this.height() - 2);
        }
        int n = 1;
        if (this.decreaseButton != null) {
            n += this.decreaseButton.height();
        }
        int n3 = this.height() - 1;
        if (this.increaseButton != null) {
            n3 -= this.increaseButton.height();
        }
        return Rect.newRect(1, n, this.width() - 2, n3 - n);
    }

    public int scrollTrayLength() {
        Rect rect = this.scrollTrayRect();
        int n = this.axis == 0 ? rect.width : rect.height;
        Rect.returnRect(rect);
        return n;
    }

    public void setKnobImage(Image image) {
        this.knobImage = image;
        this._adjustToFit();
    }

    public Image knobImage() {
        return this.knobImage;
    }

    public Rect knobRect() {
        int n;
        int n2;
        int n3;
        int n4;
        Rect rect = this.scrollTrayRect();
        if (this.axis == 0) {
            n4 = rect.x + this.scrollValue;
            n3 = rect.y;
            n2 = this.knobLength;
            n = rect.height;
        } else {
            n4 = rect.x;
            n3 = rect.y + this.scrollValue;
            n2 = rect.width;
            n = this.knobLength;
        }
        rect.setBounds(n4, n3, n2, n);
        return rect;
    }

    public void setKnobLength(int n) {
        int n2 = this.scrollTrayLength();
        if (n < this.minKnobLength()) {
            n = this.minKnobLength();
        } else if (n > n2) {
            n = n2;
        }
        this.knobLength = n;
    }

    public int knobLength() {
        return this.knobLength;
    }

    public int minKnobLength() {
        if (this.axis == 0) {
            return this.height() - 2;
        }
        return this.width() - 2;
    }

    public void setEnabled(boolean bl) {
        if (bl == this.enabled) {
            return;
        }
        this.enabled = bl;
        if (this.active && this.enabled) {
            this.addParts();
        } else if (!this.enabled) {
            this.removeParts();
        } else {
            return;
        }
        this.setDirty(true);
        if (this.scrollBarOwner != null) {
            if (this.enabled) {
                this.scrollBarOwner.scrollBarWasEnabled(this);
                return;
            }
            this.scrollBarOwner.scrollBarWasDisabled(this);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setActive(boolean bl) {
        if (bl == this.active) {
            return;
        }
        this.active = bl;
        if (this.active && this.enabled) {
            this.addParts();
        } else if (!this.active) {
            this.removeParts();
        }
        this.setDirty(true);
        if (this.scrollBarOwner != null) {
            if (this.active) {
                this.scrollBarOwner.scrollBarDidBecomeActive(this);
                return;
            }
            this.scrollBarOwner.scrollBarDidBecomeInactive(this);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void drawViewKnobInRect(Graphics graphics, Rect rect) {
        BezelBorder.raisedScrollButtonBezel().drawInRect(graphics, rect);
        graphics.setColor(Color.lightGray);
        graphics.fillRect(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
        if (this.knobImage != null) {
            this.knobImage.drawCentered(graphics, rect);
        }
    }

    public void drawView(Graphics graphics) {
        graphics.setColor(Color.gray153);
        graphics.drawLine(0, 0, 0, this.height() - 1);
        graphics.drawLine(1, 0, this.width() - 1, 0);
        graphics.setColor(Color.gray231);
        graphics.drawLine(this.width() - 1, 0, this.width() - 1, this.height());
        graphics.drawLine(0, this.height() - 1, this.width() - 1, this.height() - 1);
        Rect rect = this.scrollTrayRect();
        int n = this.interiorRect().x;
        int n2 = this.interiorRect().y;
        int n3 = this.interiorRect().maxX();
        int n4 = this.interiorRect().maxY();
        int n5 = rect.x;
        int n6 = rect.y;
        int n7 = rect.x + rect.width;
        int n8 = rect.y + rect.height;
        if (!this.isEnabled() || !this.isActive()) {
            if (this.axis == 0) {
                graphics.setColor(Color.lightGray);
                graphics.fillRect(n + 1, n2 + 1, n5 - 3, n4 - 3);
                graphics.fillRect(n7 + 1, n2 + 1, n3 - n7 - 2, n4 - 3);
                graphics.fillRect(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
                graphics.setColor(Color.gray153);
                graphics.drawLine(n, n4 - 1, n3 - 1, n4 - 1);
                graphics.drawLine(n3 - 1, n2, n3 - 1, n4 - 2);
                graphics.drawLine(n5 - 1, n2, n5 - 1, n4 - 2);
                graphics.drawLine(n7 - 1, n2, n7 - 1, n4 - 2);
                graphics.drawLine(n + 5, n2 + 7, n + 5, n2 + 8);
                graphics.drawLine(n + 6, n2 + 6, n + 6, n2 + 9);
                graphics.drawLine(n + 7, n2 + 5, n + 7, n2 + 10);
                graphics.drawLine(n + 8, n2 + 4, n + 8, n2 + 11);
                graphics.drawLine(n + 9, n2 + 3, n + 9, n2 + 12);
                graphics.drawLine(n7 + 6, n2 + 3, n7 + 6, n2 + 12);
                graphics.drawLine(n7 + 7, n2 + 4, n7 + 7, n2 + 11);
                graphics.drawLine(n7 + 8, n2 + 5, n7 + 8, n2 + 10);
                graphics.drawLine(n7 + 9, n2 + 6, n7 + 9, n2 + 9);
                graphics.drawLine(n7 + 10, n2 + 7, n7 + 10, n2 + 8);
                graphics.setColor(Color.gray231);
                graphics.drawLine(n, n2, n, n4 - 2);
                graphics.drawLine(n + 1, n2, n5 - 2, n2);
                graphics.drawLine(n5, n2, n5, n4 - 2);
                graphics.drawLine(n5 + 1, n2, n7 - 2, n2);
                graphics.drawLine(n7, n2, n7, n4 - 2);
                graphics.drawLine(n7 + 1, n2, n3 - 2, n2);
            } else {
                graphics.setColor(Color.lightGray);
                graphics.fillRect(n + 1, n2 + 1, n3 - 3, n6 - 3);
                graphics.fillRect(n + 1, n8 + 1, n3 - 3, n4 - n8 - 2);
                graphics.fillRect(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
                graphics.setColor(Color.gray153);
                graphics.drawLine(n3 - 1, n2, n3 - 1, n4 - 1);
                graphics.drawLine(n, n4 - 1, n3 - 2, n4 - 1);
                graphics.drawLine(n, n6 - 1, n3 - 2, n6 - 1);
                graphics.drawLine(n, n8 - 1, n3 - 2, n8 - 1);
                graphics.drawLine(n + 7, n2 + 5, n + 8, n2 + 5);
                graphics.drawLine(n + 6, n2 + 6, n + 9, n2 + 6);
                graphics.drawLine(n + 5, n2 + 7, n + 10, n2 + 7);
                graphics.drawLine(n + 4, n2 + 8, n + 11, n2 + 8);
                graphics.drawLine(n + 3, n2 + 9, n + 12, n2 + 9);
                graphics.drawLine(n + 3, n8 + 6, n + 12, n8 + 6);
                graphics.drawLine(n + 4, n8 + 7, n + 11, n8 + 7);
                graphics.drawLine(n + 5, n8 + 8, n + 10, n8 + 8);
                graphics.drawLine(n + 6, n8 + 9, n + 9, n8 + 9);
                graphics.drawLine(n + 7, n8 + 10, n + 8, n8 + 10);
                graphics.setColor(Color.gray231);
                graphics.drawLine(n, n2, n3 - 2, n2);
                graphics.drawLine(n, n2 + 1, n, n6 - 2);
                graphics.drawLine(n, n6, n3 - 2, n6);
                graphics.drawLine(n, n6 + 1, n, n8 - 2);
                graphics.drawLine(n, n8, n3 - 2, n8);
                graphics.drawLine(n, n8 + 1, n, n4 - 2);
            }
            Rect.returnRect(rect);
            return;
        }
        if (this.knobLength <= this.scrollTrayLength()) {
            n = rect.x;
            n3 = rect.maxX();
            n2 = rect.y;
            n4 = rect.maxY();
            if (this.axis == 0) {
                n5 = n + this.scrollValue - 1;
                n7 = n + this.scrollValue + this.knobLength;
                if (this.scrollValue > 0) {
                    graphics.setColor(Color.gray153);
                    graphics.drawLine(n, n2, n5, n2);
                    graphics.drawLine(n, n2 + 1, n, n4 - 2);
                    this.trayTopImage.drawTiled(graphics, n + 1, n2 + 1, n5 - n, 1);
                    this.trayBottomImage.drawTiled(graphics, n + 1, n4 - 1, n5 - n, 1);
                    this.trayLeftImage.drawTiled(graphics, n + 1, n2 + 1, 1, n4 - 3);
                    graphics.setColor(Color.lightGray);
                    graphics.fillRect(n + 2, n2 + 2, n5 - n - 1, n4 - n2 - 3);
                }
                if (n7 < n3) {
                    graphics.setColor(Color.gray153);
                    graphics.drawLine(n7, n2, n3 - 2, n2);
                    graphics.drawLine(n3 - 1, n2, n3 - 1, n4 - 1);
                    this.trayTopImage.drawTiled(graphics, n7, n2 + 1, n3 - n7 - 1, 1);
                    this.trayBottomImage.drawTiled(graphics, n7, n4 - 1, n3 - n7 - 1, 1);
                    this.trayLeftImage.drawTiled(graphics, n7, n2 + 1, 1, n4 - 3);
                    this.trayRightImage.drawTiled(graphics, n3 - 2, n2 + 1, 1, n4 - 3);
                    graphics.setColor(Color.lightGray);
                    graphics.fillRect(n7 + 1, n2 + 2, n3 - n7 - 3, n4 - n2 - 3);
                }
            } else {
                n6 = n2 + this.scrollValue - 1;
                n8 = n2 + this.scrollValue + this.knobLength;
                if (this.scrollValue > 0) {
                    graphics.setColor(Color.gray153);
                    graphics.drawLine(n, n2 + 1, n, n6);
                    graphics.drawLine(n, n2, n3 - 1, n2);
                    this.trayTopImage.drawTiled(graphics, n + 1, n2 + 1, n3 - 2, 1);
                    this.trayLeftImage.drawTiled(graphics, n + 1, n2 + 1, 1, n6 - n2);
                    this.trayRightImage.drawTiled(graphics, n3 - 1, n2 + 1, 1, n6 - n2);
                    graphics.setColor(Color.lightGray);
                    graphics.fillRect(n + 2, n2 + 2, n3 - n - 3, n6 - n2 - 1);
                }
                if (n8 < n4) {
                    graphics.setColor(Color.gray153);
                    graphics.drawLine(n, n8, n, n4 - 2);
                    graphics.drawLine(n, n4 - 1, n3 - 1, n4 - 1);
                    this.trayTopImage.drawTiled(graphics, n + 1, n8, n3 - n - 2, 1);
                    this.trayBottomImage.drawTiled(graphics, n + 1, n4 - 2, n3 - n - 1, 1);
                    this.trayLeftImage.drawTiled(graphics, n + 1, n8, 1, n4 - n8 - 2);
                    this.trayRightImage.drawTiled(graphics, n3 - 1, n8, 1, n4 - n8 - 2);
                    graphics.setColor(Color.lightGray);
                    graphics.fillRect(n + 2, n8 + 1, n3 - n - 3, n4 - n8 - 3);
                }
            }
            Rect.returnRect(rect);
            Rect rect2 = this.knobRect();
            this.drawViewKnobInRect(graphics, rect2);
            Rect.returnRect(rect2);
            return;
        }
        if (this.axis == 0) {
            graphics.setColor(Color.lightGray);
            graphics.fillRect(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
            graphics.setColor(Color.gray102);
            graphics.drawLine(n, n4 - 1, n3 - 1, n4 - 1);
            graphics.drawLine(n7 - 1, n2, n7 - 1, n4 - 2);
            graphics.setColor(Color.gray231);
            graphics.drawLine(n5, n2, n5, n4 - 2);
            graphics.drawLine(n5 + 1, n2, n7 - 2, n2);
            return;
        }
        graphics.setColor(Color.lightGray);
        graphics.fillRect(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
        graphics.setColor(Color.gray102);
        graphics.drawLine(n3 - 1, n2, n3 - 1, n4 - 1);
        graphics.drawLine(n, n8 - 1, n3 - 2, n8 - 1);
        graphics.setColor(Color.gray231);
        graphics.drawLine(n, n6, n3 - 2, n6);
        graphics.drawLine(n, n6 + 1, n, n8 - 2);
    }

    public void drawScrollTray() {
        Rect rect = this.scrollTrayRect();
        this.addDirtyRect(rect);
        Rect.returnRect(rect);
    }

    void _setScrollValue(int n) {
        if (n < 0) {
            this.scrollValue = 0;
            return;
        }
        if (n > this._maxScrollValue()) {
            this.scrollValue = this._maxScrollValue();
            return;
        }
        this.scrollValue = n;
    }

    void _setScrollPercent(float f) {
        if (f < 0.0f || f > 1.0f) {
            return;
        }
        int n = (int)(f * (float)this._maxScrollValue());
        if (n != 0 || f == 0.0f) {
            this._setScrollValue(n);
            return;
        }
        this._setScrollValue((int)Math.ceil(f * (float)this._maxScrollValue()));
    }

    void _setPercentVisible(float f) {
        int n = this.scrollTrayLength();
        int n2 = (int)(f * (float)n);
        this.setKnobLength(n2);
        if (n < 1 || n <= n2) {
            this.setActive(false);
            return;
        }
        this.setActive(true);
    }

    void _computeScrollValue() {
        int n;
        int n2;
        int n3;
        int n4 = this.scrollValue;
        int n5 = this.knobLength;
        boolean bl = this.active;
        int n6 = 0;
        if (this.scrollableView != null) {
            int n7 = this.axis();
            n3 = this.scrollableView.lengthOfScrollViewForAxis(n7);
            n2 = this.scrollableView.lengthOfContentViewForAxis(n7);
            n = this.scrollableView.positionOfContentViewForAxis(n7);
        } else {
            n3 = 0;
            n2 = 0;
            n = 0;
        }
        if (n2 == 0) {
            this._setPercentVisible(1.0f);
        } else {
            this._setPercentVisible((float)n3 / (float)n2);
        }
        int n8 = n2 - n3;
        if (n8 <= 0) {
            this._setScrollPercent(0.0f);
        } else {
            this._setScrollPercent((float)(n6 - n) / (float)n8);
        }
        if ((this.scrollValue != n4 || this.knobLength != n5 || this.active != bl) && this.isActive() && this.isEnabled()) {
            this.drawScrollTray();
        }
    }

    public int scrollValue() {
        return this.scrollValue;
    }

    int pixelScrollValue() {
        return this.pixelScrollValue;
    }

    int _maxScrollValue() {
        return this.scrollTrayLength() - this.knobLength;
    }

    public float scrollPercent() {
        int n = this._maxScrollValue();
        if (n == 0) {
            return 0.0f;
        }
        return (float)this.scrollValue() / (float)n;
    }

    int _mouseValue(MouseEvent mouseEvent) {
        Rect rect = this.scrollTrayRect();
        int n = this.axis == 0 ? mouseEvent.x - rect.x : mouseEvent.y - rect.y;
        Rect.returnRect(rect);
        return n;
    }

    public boolean mouseDown(MouseEvent mouseEvent) {
        if (!this.isEnabled() || !this.isActive()) {
            return false;
        }
        this.lastMouseValue = this.lastAltMouseValue = this._mouseValue(mouseEvent);
        if (mouseEvent.isMetaKeyDown() && (this.lastMouseValue >= this.scrollValue + this.knobLength || this.lastMouseValue < this.scrollValue)) {
            int n = this.scrollValue;
            this._setScrollValue(this.lastMouseValue - this.knobLength / 2);
            int n2 = this.scrollValue - n;
            if (n2 != 0) {
                this.scrollToCurrentPosition();
            }
        } else if (this.lastMouseValue < this.scrollValue) {
            this.scrollPageBackward();
            this.timer = new Timer(this, TIMER_SCROLL_PAGE, 75);
            this.timer.setInitialDelay(300);
            if (this.lastMouseValue < this.scrollValue) {
                this.timer.start();
            } else if (this.lastMouseValue < this.scrollValue + this.knobLength) {
                this.timer = null;
            }
        } else if (this.lastMouseValue >= this.scrollValue + this.knobLength) {
            this.scrollPageForward();
            this.timer = new Timer(this, TIMER_SCROLL_PAGE, 75);
            this.timer.setInitialDelay(300);
            if (this.lastMouseValue >= this.scrollValue - this.knobLength) {
                this.timer.start();
            } else if (this.lastMouseValue >= this.scrollValue) {
                this.timer = null;
            }
        }
        this.origScrollValue = this.scrollValue;
        return true;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = this._mouseValue(mouseEvent);
        if (!this.isEnabled() || !this.isActive() || this.timer != null) {
            this.lastMouseValue = n;
            this.origScrollValue = this.scrollValue;
            return;
        }
        if (mouseEvent.isControlKeyDown()) {
            this.pixelScrollValue = this.lastAltMouseValue - n;
            this.scrollByPixel(this.pixelScrollValue);
            this.lastAltMouseValue = n;
            this.origScrollValue = this.scrollValue;
            return;
        }
        this.lastAltMouseValue = n;
        int n2 = this.scrollValue;
        this._setScrollValue(this.origScrollValue + (n - this.lastMouseValue));
        int n3 = this.scrollValue - n2;
        if (n3 != 0) {
            this.scrollToCurrentPosition();
        }
    }

    private void timerScroll() {
        if (this.lastMouseValue < this.scrollValue) {
            this.scrollPageBackward();
            if (this.lastMouseValue >= this.scrollValue) {
                this.timer.stop();
                if (this.lastMouseValue < this.scrollValue + this.knobLength) {
                    this.timer = null;
                }
            }
        } else if (this.lastMouseValue >= this.scrollValue + this.knobLength) {
            this.scrollPageForward();
            if (this.lastMouseValue < this.scrollValue - this.knobLength) {
                this.timer.stop();
                if (this.lastMouseValue >= this.scrollValue) {
                    this.timer = null;
                }
            }
        }
        this.origScrollValue = this.scrollValue;
    }

    public void mouseUp(MouseEvent mouseEvent) {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    public void performCommand(String string, Object object) {
        if (TIMER_SCROLL_PAGE.equals(string)) {
            this.timerScroll();
            return;
        }
        if (UPDATE.equals(string)) {
            this.update();
            return;
        }
        if (SCROLL_LINE_FORWARD.equals(string)) {
            this.scrollLineForward();
            return;
        }
        if (SCROLL_LINE_BACKWARD.equals(string)) {
            this.scrollLineBackward();
            return;
        }
        if (SCROLL_PAGE_FORWARD.equals(string)) {
            this.scrollPageForward();
            return;
        }
        if (SCROLL_PAGE_BACKWARD.equals(string)) {
            this.scrollPageBackward();
            return;
        }
        throw new NoSuchMethodError("unknown command: " + string);
    }

    private void update() {
        int n = this.scrollValue;
        int n2 = this.knobLength;
        boolean bl = this.active;
        bl = this.active;
        this._computeScrollValue();
        if (bl != this.active) {
            this.setDirty(true);
            return;
        }
        if (this.shouldRedraw || (this.scrollValue != n || this.knobLength != n2 || this.active != bl) && this.isActive() && this.isEnabled()) {
            this.drawScrollTray();
        }
    }

    public void describeClassInfo(ClassInfo classInfo) {
        super.describeClassInfo(classInfo);
        classInfo.addClass("netscape.application.ScrollBar", 2);
        classInfo.addField(SCROLLVIEW_KEY, (byte)18);
        classInfo.addField(INCREASEBUTTON_KEY, (byte)18);
        classInfo.addField(DECREASEBUTTON_KEY, (byte)18);
        classInfo.addField(KNOBIMAGE_KEY, (byte)18);
        classInfo.addField(SCROLLVALUE_KEY, (byte)8);
        classInfo.addField(AXIS_KEY, (byte)8);
        classInfo.addField(ACTIVE_KEY, (byte)0);
        classInfo.addField(ENABLED_KEY, (byte)0);
        classInfo.addField(LINE_INCREMENT_KEY, (byte)8);
        classInfo.addField(OWNER_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(SCROLLVIEW_KEY, this.scrollableView);
        encoder.encodeObject(INCREASEBUTTON_KEY, this.increaseButton);
        encoder.encodeObject(DECREASEBUTTON_KEY, this.decreaseButton);
        encoder.encodeObject(KNOBIMAGE_KEY, this.knobImage);
        encoder.encodeInt(SCROLLVALUE_KEY, this.scrollValue);
        encoder.encodeInt(AXIS_KEY, this.axis);
        encoder.encodeBoolean(ACTIVE_KEY, this.active);
        encoder.encodeBoolean(ENABLED_KEY, this.enabled);
        encoder.encodeInt(LINE_INCREMENT_KEY, this.lineIncrement);
        encoder.encodeObject(OWNER_KEY, this.scrollBarOwner);
    }

    public void decode(Decoder decoder) throws CodingException {
        int n = decoder.versionForClassName("netscape.application.ScrollBar");
        super.decode(decoder);
        this.scrollableView = (Scrollable)decoder.decodeObject(SCROLLVIEW_KEY);
        this.increaseButton = (Button)decoder.decodeObject(INCREASEBUTTON_KEY);
        this.decreaseButton = (Button)decoder.decodeObject(DECREASEBUTTON_KEY);
        this.knobImage = (Image)decoder.decodeObject(KNOBIMAGE_KEY);
        this.scrollValue = decoder.decodeInt(SCROLLVALUE_KEY);
        this.axis = decoder.decodeInt(AXIS_KEY);
        this.active = decoder.decodeBoolean(ACTIVE_KEY);
        this.enabled = decoder.decodeBoolean(ENABLED_KEY);
        if (n >= 2) {
            this.lineIncrement = decoder.decodeInt(LINE_INCREMENT_KEY);
            this.scrollBarOwner = (ScrollBarOwner)decoder.decodeObject(OWNER_KEY);
        } else {
            this.lineIncrement = 12;
            this.scrollBarOwner = null;
        }
        this._computeScrollValue();
    }

    public int axis() {
        return this.axis;
    }

    public float pageSizeAsPercent() {
        return this.pageSizeAsPercent;
    }

    public void setPageSizeAsPercent(float f) {
        if (f <= 0.0f || f > 1.0f) {
            return;
        }
        this.pageSizeAsPercent = f;
    }

    public void setLineIncrement(int n) {
        if (n > 0) {
            this.lineIncrement = n;
        }
    }

    public int lineIncrement() {
        return this.lineIncrement;
    }

    private void scrollTo(int n, int n2) {
        this.shouldRedraw = true;
        if (this.scrollableView != null) {
            this.scrollableView.scrollTo(n, n2);
        }
        this.shouldRedraw = false;
    }

    private void scrollBy(int n, int n2) {
        this.shouldRedraw = true;
        if (this.scrollableView != null) {
            this.scrollableView.scrollBy(n, n2);
        }
        this.shouldRedraw = false;
    }

    private void scrollByPixel(int n) {
        if (this.scrollableView != null) {
            if (this.axis == 0) {
                this.scrollBy(n, 0);
                return;
            }
            this.scrollBy(0, n);
        }
    }

    private void scrollByLine(int n) {
        if (this.scrollableView != null) {
            if (this.axis == 0) {
                this.scrollBy(n * this.lineIncrement, 0);
                return;
            }
            this.scrollBy(0, n * this.lineIncrement);
        }
    }

    private void scrollByPage(float f) {
        if (this.scrollableView != null) {
            if (this.axis == 0) {
                this.scrollBy((int)(f * (float)this.scrollableView.lengthOfScrollViewForAxis(this.axis)), 0);
                return;
            }
            this.scrollBy(0, (int)(f * (float)this.scrollableView.lengthOfScrollViewForAxis(this.axis)));
        }
    }

    private void scrollToPercent(float f) {
        if (this.scrollableView != null) {
            int n = this.scrollableView.lengthOfContentViewForAxis(this.axis);
            int n2 = this.scrollableView.lengthOfScrollViewForAxis(this.axis);
            int n3 = -((int)(f * (float)(n - n2)));
            if (this.axis == 0) {
                this.scrollTo(n3, this.scrollableView.positionOfContentViewForAxis(1));
                return;
            }
            this.scrollTo(this.scrollableView.positionOfContentViewForAxis(0), n3);
        }
    }

    public void scrollLineForward() {
        this.scrollByLine(-1);
    }

    public void scrollLineBackward() {
        this.scrollByLine(1);
    }

    public void scrollPageForward() {
        this.scrollByPage(-this.pageSizeAsPercent);
    }

    public void scrollPageBackward() {
        this.scrollByPage(this.pageSizeAsPercent);
    }

    public void scrollToCurrentPosition() {
        this.scrollToPercent(this.scrollPercent());
    }

    public void setScrollPercent(float f) {
        this._setScrollPercent(f);
        this.scrollToCurrentPosition();
    }

    void _setupKeyboard() {
        this.removeAllCommandsForKeys();
        if (this.axis() == 0) {
            this.setCommandForKey(SCROLL_LINE_FORWARD, 1007, 1);
            this.setCommandForKey(SCROLL_LINE_BACKWARD, 1006, 1);
            return;
        }
        this.setCommandForKey(SCROLL_LINE_FORWARD, 1005, 1);
        this.setCommandForKey(SCROLL_LINE_BACKWARD, 1004, 1);
    }

    public boolean hidesSubviewsFromKeyboard() {
        return true;
    }
}

