/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Bitmap;
import netscape.application.Border;
import netscape.application.Color;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.InternalWindow;
import netscape.application.MenuView;
import netscape.application.Rect;
import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class InternalWindowBorder
extends Border {
    Image indentLeftImage;
    Image indentRightImage;
    Image leftResizeImage;
    Image rightResizeImage;
    InternalWindow window;
    static final int TITLE_BAR_INDENT_OFFSET = 1;
    static final String WINDOW_KEY = "window";

    public InternalWindowBorder() {
        this(null);
    }

    public InternalWindowBorder(InternalWindow internalWindow) {
        this.window = internalWindow;
        this.indentLeftImage = Bitmap.bitmapNamed("netscape/application/TitleBarLeft.gif");
        this.indentRightImage = Bitmap.bitmapNamed("netscape/application/TitleBarRight.gif");
        this.leftResizeImage = Bitmap.bitmapNamed("netscape/application/ResizeLeft.gif");
        this.rightResizeImage = Bitmap.bitmapNamed("netscape/application/ResizeRight.gif");
    }

    public void setWindow(InternalWindow internalWindow) {
        this.window = internalWindow;
    }

    public InternalWindow window() {
        return this.window;
    }

    public int leftMargin() {
        return 3;
    }

    public int rightMargin() {
        return 2;
    }

    public int topMargin() {
        return 22;
    }

    public int bottomMargin() {
        if (this.window.isResizable()) {
            return 11;
        }
        return 2;
    }

    public int resizePartWidth() {
        if (!this.window.isResizable()) {
            return 0;
        }
        return this.leftResizeImage.width();
    }

    public void drawTitleBar(Graphics graphics, int n, int n2, int n3, int n4) {
        Rect rect;
        int n5 = this.topMargin();
        Rect rect2 = Rect.newRect(n, n2, n3, n5);
        if (!graphics.clipRect().intersects(rect2)) {
            Rect.returnRect(rect2);
            return;
        }
        Rect.returnRect(rect2);
        int n6 = n3 - 1;
        int n7 = n5 - 1;
        graphics.setColor(Color.lightGray);
        graphics.fillRect(n + 1, n2 + 1, n6 - 1, n7 - 1);
        graphics.setColor(Color.gray153);
        graphics.drawPoint(n, n2);
        graphics.drawLine(n + 1, n2, n6, n2);
        graphics.drawPoint(n + 1, n7);
        graphics.drawLine(n, n2 + 1, n, n7);
        graphics.setColor(Color.white);
        graphics.drawLine(n + 2, n2 + 1, n6 - 2, n2 + 1);
        graphics.drawPoint(n + 2, n2 + 2);
        graphics.drawLine(n + 1, n2 + 2, n + 1, n7 - 2);
        graphics.setColor(Color.gray153);
        graphics.drawLine(n + 2, n7 - 1, n6 - 2, n7 - 1);
        graphics.drawPoint(n6 - 2, n7 - 2);
        graphics.drawLine(n6 - 1, n2 + 2, n6 - 1, n7 - 2);
        graphics.setColor(Color.gray102);
        graphics.drawLine(n + 2, n7, n6, n7);
        graphics.drawLine(n6, n2 + 1, n6, n7);
        graphics.drawPoint(n6 - 1, n7 - 1);
        int n8 = 25 + this.indentLeftImage.width();
        int n9 = n3 - 25 - this.indentRightImage.width() - n8;
        boolean bl = this.window.isMain();
        if (bl) {
            this.indentLeftImage.drawAt(graphics, 25, 1);
            this.indentRightImage.drawAt(graphics, n3 - this.indentRightImage.width() - 24, 1);
            rect = Rect.newRect(n8, 3, n9, this.indentLeftImage.height() - 4);
            graphics.setColor(Color.gray153);
            graphics.drawLine(rect.x, rect.y + 1, rect.maxX(), rect.y + 1);
            graphics.setColor(Color.white);
            graphics.drawLine(rect.x + 1, rect.maxY() - 2, rect.maxX(), rect.maxY() - 2);
            Rect.returnRect(rect);
        }
        rect = Rect.newRect(n8, 0, n9, this.indentLeftImage.height() - 2);
        graphics.pushState();
        graphics.setClipRect(rect);
        graphics.setColor(Color.darkGray);
        graphics.setFont(this.window.font());
        graphics.drawStringInRect(this.window.title(), rect, 1);
        graphics.popState();
        Rect.returnRect(rect);
    }

    public void drawLeftBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        Rect rect = Rect.newRect(0, 0, this.leftMargin(), n4);
        if (!graphics.clipRect().intersects(rect)) {
            Rect.returnRect(rect);
            return;
        }
        Rect.returnRect(rect);
        int n5 = this.topMargin();
        graphics.setColor(Color.gray153);
        graphics.drawLine(0, n5, 0, n4 - 1);
        graphics.setColor(Color.white);
        graphics.drawLine(1, n5, 1, n4 - 2);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(2, n5, 2, n4 - 3);
        MenuView menuView = this.window.menuView();
        if (menuView != null) {
            graphics.setColor(Color.gray102);
            graphics.drawLine(1, n5 + menuView.height() - 1, 2, n5 + menuView.height() - 1);
        }
    }

    public void drawRightBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        Rect rect = Rect.newRect(n3 - this.rightMargin(), 0, this.rightMargin(), n4);
        if (!graphics.clipRect().intersects(rect)) {
            Rect.returnRect(rect);
            return;
        }
        Rect.returnRect(rect);
        int n5 = this.topMargin();
        int n6 = n4 - this.bottomMargin();
        graphics.setColor(Color.gray102);
        graphics.drawLine(n3 - 1, n5, n3 - 1, n6);
        graphics.setColor(Color.gray153);
        graphics.drawLine(n3 - 2, n5, n3 - 2, n6 - 1);
        MenuView menuView = this.window.menuView();
        if (menuView != null) {
            graphics.setColor(Color.gray102);
            graphics.drawPoint(n + n3 - 2, n5 + menuView.height() - 1);
        }
    }

    public void drawBottomBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        Rect rect = Rect.newRect(0, n4 - this.bottomMargin(), n3, this.bottomMargin());
        if (!graphics.clipRect().intersects(rect)) {
            Rect.returnRect(rect);
            return;
        }
        Rect.returnRect(rect);
        int n5 = this.bottomMargin();
        int n6 = n4 - n5;
        graphics.setColor(Color.gray102);
        graphics.drawLine(1, n4 - 1, n3 - 1, n4 - 1);
        graphics.setColor(Color.gray153);
        graphics.drawLine(2, n4 - 2, n3 - 2, n4 - 2);
        graphics.setColor(Color.lightGray);
        graphics.fillRect(2, n6, n3 - 3, n5 - 2);
        graphics.setColor(Color.gray102);
        graphics.drawLine(n3 - 1, n6, n3 - 1, n4 - 1);
        graphics.setColor(Color.gray153);
        graphics.drawLine(n3 - 2, n6, n3 - 2, n4 - 2);
        if (this.window.isResizable() && this.leftResizeImage != null && this.rightResizeImage != null) {
            this.leftResizeImage.drawAt(graphics, 0, n4 - this.leftResizeImage.height());
            this.rightResizeImage.drawAt(graphics, n3 - this.rightResizeImage.width(), n4 - this.rightResizeImage.height());
        }
    }

    public void drawInRect(Graphics graphics, int n, int n2, int n3, int n4) {
        this.drawTitleBar(graphics, n, n2, n3, n4);
        this.drawLeftBorder(graphics, n, n2, n3, n4);
        this.drawRightBorder(graphics, n, n2, n3, n4);
        this.drawBottomBorder(graphics, n, n2, n3, n4);
    }

    public void describeClassInfo(ClassInfo classInfo) {
        super.describeClassInfo(classInfo);
        classInfo.addClass("netscape.application.InternalWindowBorder", 1);
        classInfo.addField(WINDOW_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(WINDOW_KEY, this.window);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.window = (InternalWindow)decoder.decodeObject(WINDOW_KEY);
    }
}

