/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.Serializable;

public class Polygon
implements Shape,
Serializable {
    public int npoints;
    public int[] xpoints = new int[4];
    public int[] ypoints = new int[4];
    protected Rectangle bounds;

    public Polygon() {
    }

    public Polygon(int[] nArray, int[] nArray2, int n) {
        this.npoints = n;
        this.xpoints = new int[n];
        this.ypoints = new int[n];
        System.arraycopy(nArray, 0, this.xpoints, 0, n);
        System.arraycopy(nArray2, 0, this.ypoints, 0, n);
    }

    public void translate(int n, int n2) {
        int n3 = 0;
        while (n3 < this.npoints) {
            int n4 = n3;
            this.xpoints[n4] = this.xpoints[n4] + n;
            int n5 = n3++;
            this.ypoints[n5] = this.ypoints[n5] + n2;
        }
        if (this.bounds != null) {
            this.bounds.translate(n, n2);
        }
    }

    void calculateBounds(int[] nArray, int[] nArray2, int n) {
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MIN_VALUE;
        int n6 = 0;
        while (n6 < n) {
            int n7 = nArray[n6];
            n2 = Math.min(n2, n7);
            n4 = Math.max(n4, n7);
            int n8 = nArray2[n6];
            n3 = Math.min(n3, n8);
            n5 = Math.max(n5, n8);
            ++n6;
        }
        this.bounds = new Rectangle(n2, n3, n4 - n2, n5 - n3);
    }

    void updateBounds(int n, int n2) {
        this.bounds.x = Math.min(this.bounds.x, n);
        this.bounds.width = Math.max(this.bounds.width, n - this.bounds.x);
        this.bounds.y = Math.min(this.bounds.y, n2);
        this.bounds.height = Math.max(this.bounds.height, n2 - this.bounds.y);
    }

    public void addPoint(int n, int n2) {
        if (this.npoints == this.xpoints.length) {
            int[] nArray = new int[this.npoints * 2];
            System.arraycopy(this.xpoints, 0, nArray, 0, this.npoints);
            this.xpoints = nArray;
            nArray = new int[this.npoints * 2];
            System.arraycopy(this.ypoints, 0, nArray, 0, this.npoints);
            this.ypoints = nArray;
        }
        this.xpoints[this.npoints] = n;
        this.ypoints[this.npoints] = n2;
        ++this.npoints;
        if (this.bounds != null) {
            this.updateBounds(n, n2);
        }
    }

    public Rectangle getBounds() {
        return this.getBoundingBox();
    }

    public Rectangle getBoundingBox() {
        if (this.bounds == null) {
            this.calculateBounds(this.xpoints, this.ypoints, this.npoints);
        }
        return this.bounds;
    }

    public boolean contains(Point point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(int n, int n2) {
        return this.inside(n, n2);
    }

    public boolean inside(int n, int n2) {
        if (this.getBoundingBox().inside(n, n2)) {
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.npoints && this.ypoints[n5] == n2) {
                ++n5;
            }
            int n6 = 0;
            while (n6 < this.npoints) {
                int n7 = (n5 + 1) % this.npoints;
                int n8 = this.xpoints[n7] - this.xpoints[n5];
                int n9 = this.ypoints[n7] - this.ypoints[n5];
                if (n9 != 0) {
                    float f;
                    int n10 = n - this.xpoints[n5];
                    int n11 = n2 - this.ypoints[n5];
                    if (this.ypoints[n7] == n2 && this.xpoints[n7] >= n) {
                        n4 = this.ypoints[n5];
                    }
                    if (this.ypoints[n5] == n2 && this.xpoints[n5] >= n && n4 > n2 != this.ypoints[n7] > n2) {
                        --n3;
                    }
                    if ((double)(f = (float)n11 / (float)n9) >= 0.0 && (double)f <= 1.0 && f * (float)n8 >= (float)n10) {
                        ++n3;
                    }
                }
                n5 = n7;
                ++n6;
            }
            return n3 % 2 != 0;
        }
        return false;
    }
}

