/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.awt.Container;
import java.awt.Frame;
import java.awt.Panel;
import netscape.application.Application;
import netscape.application.ApplicationEvent;
import netscape.application.Event;
import netscape.application.Graphics;
import netscape.application.JDK11AirLock;
import netscape.application.KeyEvent;
import netscape.application.MouseEvent;
import netscape.application.Rect;
import netscape.application.RootView;

public class FoundationPanel
extends Panel {
    RootView rootView;

    public FoundationPanel() {
        this.setRootView(new RootView());
    }

    public FoundationPanel(int n, int n2) {
        this.setRootView(new RootView(0, 0, n, n2));
        this.resize(n, n2);
    }

    public RootView rootView() {
        return this.rootView;
    }

    public void setRootView(RootView rootView) {
        Application application = Application.application();
        if (this.rootView != null) {
            application.removeRootView(this.rootView);
        }
        this.rootView = rootView;
        rootView.setPanel(this);
        rootView.setVisible(!application.isPaused);
        application.addRootView(rootView);
    }

    public void resize(int n, int n2) {
        Application application = Application.application();
        super.resize(n, n2);
        if (application != null && application.eventLoop.shouldProcessSynchronously()) {
            this.rootView.processEvent(ApplicationEvent.newResizeEvent(n, n2));
            return;
        }
        this.addEvent(ApplicationEvent.newResizeEvent(n, n2));
    }

    public void reshape(int n, int n2, int n3, int n4) {
        Application application = Application.application();
        super.reshape(n, n2, n3, n4);
        if (application != null && application.eventLoop.shouldProcessSynchronously()) {
            this.rootView.processEvent(ApplicationEvent.newResizeEvent(n3, n4));
            return;
        }
        this.addEvent(ApplicationEvent.newResizeEvent(n3, n4));
    }

    public void update(java.awt.Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(java.awt.Graphics graphics) {
        if (JDK11AirLock.isPrintGraphics(graphics)) {
            Application application = Application.application();
            if (application != null) {
                if (application.eventLoop.shouldProcessSynchronously()) {
                    Rect rect = new Rect(0, 0, this.rootView.width(), this.rootView.height());
                    Graphics graphics2 = new Graphics(rect, graphics);
                    this.rootView.redraw(graphics2, rect);
                    this.rootView.redrawTransparentWindows(graphics2, rect, null);
                    return;
                }
                ApplicationEvent applicationEvent = ApplicationEvent.newPrintEvent(graphics);
                applicationEvent.processor = this.rootView;
                application.eventLoop().addEventAndWait(applicationEvent);
                return;
            }
            System.err.println("Can't print with no application");
            return;
        }
        this.addEvent(ApplicationEvent.newUpdateEvent(graphics));
        super.paint(graphics);
    }

    public boolean mouseDown(java.awt.Event event, int n, int n2) {
        this.requestFocus();
        this.addEvent(new MouseEvent(event.when, -1, n, n2, event.modifiers));
        return true;
    }

    public boolean mouseDrag(java.awt.Event event, int n, int n2) {
        this.addEvent(new MouseEvent(event.when, -2, n, n2, event.modifiers));
        return true;
    }

    public boolean mouseUp(java.awt.Event event, int n, int n2) {
        this.addEvent(new MouseEvent(event.when, -3, n, n2, event.modifiers));
        return true;
    }

    public boolean mouseEnter(java.awt.Event event, int n, int n2) {
        this.addEvent(new MouseEvent(event.when, -4, n, n2, event.modifiers));
        return true;
    }

    public boolean mouseMove(java.awt.Event event, int n, int n2) {
        this.addEvent(new MouseEvent(event.when, -5, n, n2, event.modifiers));
        return true;
    }

    public boolean mouseExit(java.awt.Event event, int n, int n2) {
        this.addEvent(new MouseEvent(event.when, -6, n, n2, event.modifiers));
        return true;
    }

    public boolean keyDown(java.awt.Event event, int n) {
        if (event.target == this) {
            this.addEvent(new KeyEvent(event.when, n, event.modifiers, true));
            return true;
        }
        return super.keyDown(event, n);
    }

    public boolean keyUp(java.awt.Event event, int n) {
        if (event.target == this) {
            this.addEvent(new KeyEvent(event.when, n, event.modifiers, false));
            return true;
        }
        return super.keyUp(event, n);
    }

    public synchronized boolean lostFocus(java.awt.Event event, Object object) {
        this.addEvent(ApplicationEvent.newFocusEvent(false));
        return true;
    }

    public boolean gotFocus(java.awt.Event event, Object object) {
        this.addEvent(ApplicationEvent.newFocusEvent(true));
        return true;
    }

    private synchronized void addEvent(Event event) {
        if (event.processor() == null) {
            event.setProcessor(this.rootView);
        }
        if (this.rootView != null && this.rootView.application() != null) {
            this.rootView.application().eventLoop().addEvent(event);
        }
    }

    Frame frame() {
        Container container = this.getParent();
        while (container != null && !(container instanceof Frame)) {
            container = container.getParent();
        }
        if (container != null) {
            return (Frame)container;
        }
        return null;
    }

    public void setCursor(int n) {
        Frame frame = this.frame();
        if (frame != null) {
            frame.setCursor(n);
        }
    }

    public void layout() {
    }

    public void printAll(java.awt.Graphics graphics) {
        this.paint(graphics);
    }
}

