/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.LDAPException;
import netscape.ldap.client.JDAPMessage;

class LDAPResponseListener {
    private JDAPMessage response;
    private LDAPException exception;
    private boolean responseReceived;
    private boolean exceptionOccured;

    public LDAPResponseListener() {
        this.reset();
    }

    public synchronized JDAPMessage getResponse() throws LDAPException {
        while (!this.responseReceived) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.exceptionOccured) {
            throw this.exception;
        }
        return this.response;
    }

    public synchronized void setResponse(JDAPMessage jDAPMessage) {
        this.response = jDAPMessage;
        this.responseReceived = true;
        this.notifyAll();
    }

    public synchronized void setException(LDAPException lDAPException) {
        this.exceptionOccured = true;
        this.responseReceived = true;
        this.exception = lDAPException;
        this.notifyAll();
    }

    public boolean isResponseReceived() {
        return this.responseReceived;
    }

    public void reset() {
        this.responseReceived = false;
        this.exceptionOccured = false;
    }
}

