/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.util.RDN;

public final class DN {
    Vector m_rdns = new Vector();
    boolean m_rfc = true;

    public DN() {
    }

    public DN(String string) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = null;
        if (string.indexOf(44) != -1) {
            stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (!RDN.isRDN(string2)) continue;
                this.m_rdns.addElement(new RDN(string2));
            }
            return;
        }
        if (string.indexOf(47) != -1) {
            this.m_rfc = false;
            stringTokenizer = new StringTokenizer(string, "/");
            Vector<RDN> vector = new Vector<RDN>();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (!RDN.isRDN(string3)) continue;
                vector.addElement(new RDN(string3));
            }
            int n = vector.size() - 1;
            while (n >= 0) {
                this.m_rdns.addElement(vector.elementAt(n));
                --n;
            }
            return;
        }
        this.m_rdns.addElement(new RDN(string));
    }

    public void addRDNToFront(RDN rDN) {
        this.m_rdns.insertElementAt(rDN, 0);
    }

    public void addRDNToBack(RDN rDN) {
        this.m_rdns.addElement(rDN);
    }

    public void addRDN(RDN rDN) {
        if (this.m_rfc) {
            this.addRDNToFront(rDN);
            return;
        }
        this.addRDNToBack(rDN);
    }

    public int countRDNs() {
        return this.m_rdns.size();
    }

    public Vector getRDNs() {
        return this.m_rdns;
    }

    public String[] explodeDN(boolean bl) {
        if (this.m_rdns.size() == 0) {
            return null;
        }
        String[] stringArray = new String[this.m_rdns.size()];
        int n = 0;
        while (n < this.m_rdns.size()) {
            stringArray[n] = bl ? ((RDN)this.m_rdns.elementAt(n)).getValue() : ((RDN)this.m_rdns.elementAt(n)).toString();
            ++n;
        }
        return stringArray;
    }

    public boolean isRFC() {
        return this.m_rfc;
    }

    public String toRFCString() {
        String string = "";
        int n = 0;
        while (n < this.m_rdns.size()) {
            if (n != 0) {
                string = String.valueOf(string) + ",";
            }
            string = String.valueOf(string) + ((RDN)this.m_rdns.elementAt(n)).toString();
            ++n;
        }
        return string;
    }

    public String toOSFString() {
        String string = "";
        int n = 0;
        while (n < this.m_rdns.size()) {
            if (n != 0) {
                string = "/" + string;
            }
            RDN rDN = (RDN)this.m_rdns.elementAt(n);
            string = String.valueOf(rDN.toString()) + string;
            ++n;
        }
        return string;
    }

    public String toString() {
        if (this.m_rfc) {
            return this.toRFCString();
        }
        return this.toOSFString();
    }

    public static boolean isDN(String string) {
        DN dN = new DN(string);
        return dN.countRDNs() > 0;
    }

    public boolean equals(DN dN) {
        return dN.toRFCString().toUpperCase().equals(this.toRFCString().toUpperCase());
    }

    public DN getParent() {
        DN dN = new DN();
        int n = this.m_rdns.size() - 1;
        while (n > 0) {
            dN.addRDN((RDN)this.m_rdns.elementAt(n));
            --n;
        }
        return dN;
    }
}

