/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ComponentPeer;
import sun.awt.ObjectPeer;
import sun.awt.ScreenUpdater;
import sun.awt.UpdateClient;
import sun.awt.motif.MToolkit;
import sun.awt.motif.X11FontMetrics;
import sun.awt.motif.X11Graphics;
import sun.awt.motif.X11Image;
import sun.awt.motif.X11OffScreenImage;
import sun.awt.motif.XEvent;

public abstract class MComponentPeer
extends ObjectPeer
implements ComponentPeer,
UpdateClient {
    Component target;
    int pData;

    abstract void create(MComponentPeer var1);

    void create(MComponentPeer mComponentPeer, Object object) {
        this.create(mComponentPeer);
    }

    native void disposeEvent(Event var1);

    native void pInitialize();

    native void pShow();

    native void pHide();

    native void pEnable();

    native void pDisable();

    native void pReshape(int var1, int var2, int var3, int var4);

    native void pAddRepaint(int var1, int var2, int var3, int var4);

    native void pTriggerRepaint();

    native void pDispose();

    void initialize() {
        Font font;
        if (this.target.isVisible()) {
            this.show();
        } else {
            this.hide();
        }
        Color color = this.target.getForeground();
        if (color != null) {
            this.setForeground(color);
        }
        if ((color = this.target.getBackground()) != null) {
            this.setBackground(color);
        }
        if ((font = this.target.getFont()) != null) {
            this.setFont(font);
        }
        if (!this.target.isEnabled()) {
            this.disable();
        }
        Rectangle rectangle = this.target.bounds();
        this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.pInitialize();
    }

    MComponentPeer(Component component, Object object) {
        this.target = component;
        Container container = component.getParent();
        this.create((MComponentPeer)(container != null ? container.getPeer() : null), object);
        this.initialize();
    }

    MComponentPeer(Component component) {
        this.target = component;
        Container container = component.getParent();
        this.create((MComponentPeer)(container != null ? container.getPeer() : null));
        this.initialize();
    }

    public native void setForeground(Color var1);

    public native void setBackground(Color var1);

    public native void setFont(Font var1);

    public ColorModel getColorModel() {
        return MToolkit.getStaticColorModel();
    }

    public void show() {
        this.pShow();
    }

    public void hide() {
        this.pHide();
    }

    public void enable() {
        this.pEnable();
    }

    public void disable() {
        this.pDisable();
    }

    public int updatePriority() {
        return 5;
    }

    public void updateClient(Object object) {
        this.pTriggerRepaint();
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
        this.pAddRepaint(n, n2, n3, n4);
        SecurityManager.enablePrivilege("UniversalThreadAccess");
        ScreenUpdater.updater.notify(this, l);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.target.getForeground());
        graphics.setFont(this.target.getFont());
        this.target.paint(graphics);
    }

    public void update(Graphics graphics) {
        graphics.setColor(this.target.getForeground());
        graphics.setFont(this.target.getFont());
        this.target.update(graphics);
    }

    public void print(Graphics graphics) {
        Dimension dimension = this.target.size();
        graphics.setColor(this.target.getForeground());
        graphics.setFont(this.target.getFont());
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        this.target.print(graphics);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.pReshape(n, n2, n3, n4);
    }

    public native boolean handleEvent(Event var1);

    public Dimension minimumSize() {
        return this.target.size();
    }

    public Dimension preferredSize() {
        return this.minimumSize();
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public Graphics getGraphics() {
        X11Graphics x11Graphics = new X11Graphics(this);
        ((Graphics)x11Graphics).setColor(this.target.getForeground());
        ((Graphics)x11Graphics).setFont(this.target.getFont());
        return x11Graphics;
    }

    public Image createImage(ImageProducer imageProducer) {
        return new X11Image(imageProducer);
    }

    public Image createImage(int n, int n2) {
        return new X11OffScreenImage(this.target, n, n2);
    }

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return MToolkit.prepareScrImage(image, n, n2, imageObserver);
    }

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return MToolkit.checkScrImage(image, n, n2, imageObserver);
    }

    public FontMetrics getFontMetrics(Font font) {
        return X11FontMetrics.getFontMetrics(font);
    }

    public void dispose() {
        if (this.applet != null) {
            this.applet.removeEvents(this);
        }
        this.pDispose();
    }

    public native void requestFocus();

    public native void nextFocus();

    protected void gotFocus() {
        if (this.applet != null) {
            XEvent xEvent = new XEvent(new Event(this.target, 1004, null), this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(new Event(this.target, 1004, null));
    }

    protected void lostFocus() {
        if (this.applet != null) {
            XEvent xEvent = new XEvent(new Event(this.target, 1005, null), this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(new Event(this.target, 1005, null));
    }

    protected void handleActionKey(long l, int n, int n2, int n3, int n4, int n5) {
        Event event = this.setData(n, new Event(this.target, l, 403, n2, n3, n4, n5, null));
        if (this.applet != null) {
            XEvent xEvent = new XEvent(event, this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(event);
        this.disposeEvent(event);
    }

    protected void handleActionKeyRelease(long l, int n, int n2, int n3, int n4, int n5) {
        Event event = this.setData(n, new Event(this.target, l, 404, n2, n3, n4, n5, null));
        if (this.applet != null) {
            XEvent xEvent = new XEvent(event, this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(event);
        this.disposeEvent(event);
    }

    protected void handleKeyPress(long l, int n, int n2, int n3, int n4, int n5) {
        Event event = this.setData(n, new Event(this.target, l, 401, n2, n3, n4, n5, null));
        if (this.applet != null) {
            XEvent xEvent = new XEvent(event, this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(event);
        this.disposeEvent(event);
    }

    protected void handleKeyRelease(long l, int n, int n2, int n3, int n4, int n5) {
        Event event = this.setData(n, new Event(this.target, l, 402, n2, n3, n4, n5, null));
        if (this.applet != null) {
            XEvent xEvent = new XEvent(event, this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(event);
        this.disposeEvent(event);
    }

    protected void handleMouseEnter(long l, int n, int n2) {
        if (this.applet != null) {
            XEvent xEvent = new XEvent(new Event(this.target, l, 504, n, n2, 0, 0, null), this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(new Event(this.target, l, 504, n, n2, 0, 0, null));
    }

    protected void handleMouseExit(long l, int n, int n2) {
        if (this.applet != null) {
            XEvent xEvent = new XEvent(new Event(this.target, l, 505, n, n2, 0, 0, null), this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(new Event(this.target, l, 505, n, n2, 0, 0, null));
    }

    protected void handleMouseDown(long l, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Event event = this.setData(n, new Event(this.target, l, 501, n2, n3, 0, n7, null));
        event.clickCount = n6;
        if (this.applet != null) {
            XEvent xEvent = new XEvent(event, this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(event);
    }

    protected void handleMouseUp(long l, int n, int n2, int n3, int n4, int n5, int n6) {
        Event event = this.setData(n, new Event(this.target, l, 502, n2, n3, 0, n6, null));
        if (this.applet != null) {
            XEvent xEvent = new XEvent(event, this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(event);
    }

    protected void handleMouseMoved(long l, int n, int n2, int n3, int n4, int n5, int n6) {
        Event event = this.setData(n, new Event(this.target, l, 503, n2, n3, 0, n6, null));
        if (this.applet != null) {
            XEvent xEvent = new XEvent(event, this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(event);
    }

    protected void handleMouseDrag(long l, int n, int n2, int n3, int n4, int n5, int n6) {
        Event event = this.setData(n, new Event(this.target, l, 506, n2, n3, 0, n6, null));
        if (this.applet != null) {
            XEvent xEvent = new XEvent(event, this);
            this.applet.sendEvent(xEvent);
            return;
        }
        this.target.postEvent(event);
    }

    native Event setData(int var1, Event var2);

    void handleExpose(int n, int n2, int n3, int n4) {
        if (this.applet != null) {
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            Event event = new Event(this.target, 202, rectangle);
            XEvent xEvent = new XEvent(event, this);
            this.applet.sendEvent(xEvent);
            return;
        }
        Graphics graphics = this.getGraphics();
        try {
            graphics.clipRect(n, n2, n3, n4);
            this.paint(graphics);
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            graphics.dispose();
            throw throwable;
        }
        Object var7_10 = null;
        graphics.dispose();
    }

    void handleRepaint(int n, int n2, int n3, int n4) {
        if (this.applet != null) {
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            Event event = new Event(this.target, 206, rectangle);
            XEvent xEvent = new XEvent(event, this);
            this.applet.sendEvent(xEvent);
            return;
        }
        Graphics graphics = this.getGraphics();
        try {
            graphics.clipRect(n, n2, n3, n4);
            this.update(graphics);
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            graphics.dispose();
            throw throwable;
        }
        Object var7_10 = null;
        graphics.dispose();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.target + "]";
    }
}

