/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.LogStream;
import java.rmi.server.ObjID;
import java.rmi.server.RMIFailureHandler;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.SocketSecurityException;
import java.rmi.server.UID;
import java.util.Enumeration;
import java.util.Hashtable;
import netscape.security.ForbiddenTargetException;
import netscape.security.PrivilegeManager;
import sun.rmi.transport.Channel;
import sun.rmi.transport.Connection;
import sun.rmi.transport.DGCAckHandler;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.RMIThread;
import sun.rmi.transport.StreamRemoteCall;
import sun.rmi.transport.Target;
import sun.rmi.transport.Transport;
import sun.rmi.transport.Utils;
import sun.rmi.transport.proxy.RMIMasterSocketFactory;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.TCPChannel;
import sun.rmi.transport.tcp.TCPConnection;
import sun.rmi.transport.tcp.TCPEndpoint;

public class TCPTransport
extends Transport
implements Runnable {
    static int logLevel = TCPTransport.getLogLevel();
    static int DefaultPort;
    private boolean listenNotAllowed = false;
    private boolean exportNotAllowed = false;
    private boolean unrestricted_connect = false;
    private boolean unrestricted_accept = false;
    private boolean unrestricted_listen = false;
    private static int threadNum;
    private static Hashtable clientConnections;
    private TCPEndpoint endpoint;
    private ServerSocket server;
    private Hashtable channelTable = new Hashtable();
    static RMISocketFactory defaultSocketFactory;

    private static int getLogLevel() {
        SecurityManager.enablePrivilege((String)"UniversalPropertyRead");
        return LogStream.parseLevel(Utils.getProperty("sun.rmi.transport.tcp.logLevel"));
    }

    TCPTransport() {
        this(0);
    }

    TCPTransport(int n) {
        if (logLevel >= 10) {
            LogStream.log("tcp").println("TCPTransport.<init>: Version = " + 2 + ", port = " + n);
        }
        this.endpoint = TCPEndpoint.getLocalEndpoint(n);
        this.unrestricted_connect = true;
        this.unrestricted_accept = true;
        this.unrestricted_listen = true;
        try {
            PrivilegeManager.checkPrivilegeEnabled((String)"UniversalAccept");
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            this.unrestricted_accept = false;
        }
        try {
            PrivilegeManager.checkPrivilegeEnabled((String)"UniversalConnect");
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            this.unrestricted_connect = false;
        }
        try {
            PrivilegeManager.checkPrivilegeEnabled((String)"UniversalListen");
            return;
        }
        catch (ForbiddenTargetException forbiddenTargetException) {
            this.unrestricted_listen = false;
            return;
        }
    }

    public Channel getChannel(Endpoint endpoint) {
        Channel channel = null;
        if (endpoint instanceof TCPEndpoint) {
            Hashtable hashtable = this.channelTable;
            synchronized (hashtable) {
                channel = (Channel)this.channelTable.get(endpoint);
                if (channel == null) {
                    channel = new TCPChannel(this, (TCPEndpoint)endpoint);
                    if (this.listenNotAllowed && !this.exportNotAllowed) {
                        try {
                            ((TCPChannel)channel).haveMultiplexer();
                        }
                        catch (RemoteException remoteException) {
                            if (logLevel >= 10) {
                                LogStream logStream;
                                LogStream logStream2 = logStream = LogStream.log("tcp");
                                synchronized (logStream2) {
                                    logStream.print("TCPTransport(" + this.endpoint.getPort() + ").getChannel: " + "failed to have multiplexed connection " + "on channel, exception: ");
                                    remoteException.printStackTrace(logStream);
                                }
                            }
                            this.exportNotAllowed = true;
                        }
                    }
                    this.channelTable.put(endpoint, channel);
                }
            }
        }
        return channel;
    }

    public Endpoint thisEndpoint() {
        return this.endpoint;
    }

    public void exportObject(ObjID objID, Target target) throws RemoteException {
        if (this.exportNotAllowed) {
            throw new ExportException("Cannot export to server outside firewall");
        }
        super.exportObject(objID, target);
        if (this.listenNotAllowed && this.endpoint.equals(TCPEndpoint.getLocalEndpoint(0))) {
            return;
        }
        try {
            this.listen();
            return;
        }
        catch (SocketSecurityException socketSecurityException) {
            if (logLevel >= 10) {
                LogStream.log("tcp").println("TCPTransport(" + this.endpoint.getPort() + ").exportObject: " + "listen failed with exception " + socketSecurityException.toString());
            }
            if (this.endpoint.getPort() != 0) {
                throw socketSecurityException;
            }
            Hashtable hashtable = this.channelTable;
            synchronized (hashtable) {
                this.listenNotAllowed = true;
                Enumeration enumeration = this.channelTable.elements();
                while (enumeration.hasMoreElements()) {
                    TCPChannel tCPChannel = (TCPChannel)enumeration.nextElement();
                    try {
                        tCPChannel.haveMultiplexer();
                    }
                    catch (RemoteException remoteException) {
                        if (logLevel >= 10) {
                            LogStream logStream;
                            LogStream logStream2 = logStream = LogStream.log("tcp");
                            synchronized (logStream2) {
                                logStream.print("TCPTransport(" + this.endpoint.getPort() + ").exportObject: " + "failed to have multiplexed connection " + "on channel, exception: ");
                                socketSecurityException.printStackTrace(logStream);
                            }
                        }
                        this.exportNotAllowed = true;
                        throw new ExportException("Cannot export to server outside firewall");
                    }
                }
                System.out.println("\n*** RMI unable to listen on socket: using multiplexed connections instead ***\n");
                return;
            }
        }
    }

    private synchronized void listen() throws RemoteException {
        if (this.server == null) {
            int n = this.endpoint.getPort();
            if (logLevel >= 10) {
                LogStream.log("tcp").println("TCPTransport(" + this.endpoint.getPort() + ").listen: " + "create socket, port = " + n);
            }
            try {
                block11: {
                    try {
                        RMISocketFactory rMISocketFactory = RMISocketFactory.getSocketFactory();
                        if (Utils.getLong("sun.rmi.transport.tcp.simulateApplet", 0L).intValue() >= 2) {
                            throw new SecurityException("socket.listen");
                        }
                        this.server = (rMISocketFactory != null ? rMISocketFactory : defaultSocketFactory).createServerSocket(n);
                    }
                    catch (IOException iOException) {
                        if (this.retryServerSocket()) break block11;
                        throw iOException;
                    }
                }
                if (DefaultPort == 0 && n == 0) {
                    DefaultPort = this.server.getLocalPort();
                    if (logLevel >= 10) {
                        LogStream.log("tcp").println("TCPTransport(" + this.endpoint.getPort() + ").listen: " + "default port set to " + DefaultPort);
                    }
                    TCPEndpoint.setDefaultPort(DefaultPort);
                }
                this.newListener();
                return;
            }
            catch (SecurityException securityException) {
                throw new SocketSecurityException("Listen disallowed on port: " + n, securityException);
            }
            catch (BindException bindException) {
                throw new ExportException("Port already in use: " + n, bindException);
            }
            catch (IOException iOException) {
                throw new ExportException("Listen failed on port: " + n, iOException);
            }
        }
    }

    private void newListener() {
        Thread thread = RMIThread.newThread(this, "TCP Accept-" + ++threadNum, true);
        thread.start();
    }

    private synchronized boolean retryServerSocket() {
        int n = this.endpoint.getPort();
        while (true) {
            try {
                RMISocketFactory rMISocketFactory = RMISocketFactory.getSocketFactory();
                this.server = (rMISocketFactory != null ? rMISocketFactory : defaultSocketFactory).createServerSocket(n);
                return true;
            }
            catch (IOException iOException) {
                RMIFailureHandler rMIFailureHandler;
                if ((rMIFailureHandler = RMISocketFactory.getFailureHandler()) != null && rMIFailureHandler.failure(iOException)) continue;
                this.server = null;
                return false;
            }
            break;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Socket socket;
        Throwable throwable;
        block47: {
            block46: {
                Closeable closeable;
                block42: {
                    if (logLevel >= 10) {
                        LogStream.log("tcp").println("TCPTransport.run: listening on port " + this.endpoint.getPort());
                    }
                    while (true) {
                        block44: {
                            ServerSocket serverSocket;
                            if ((serverSocket = this.server) == null) {
                                return;
                            }
                            throwable = null;
                            try {
                                try {
                                    if (this.unrestricted_accept) {
                                        SecurityManager.enablePrivilege((String)"UniversalAccept");
                                    }
                                    if (this.unrestricted_listen) {
                                        SecurityManager.enablePrivilege((String)"UniversalListen");
                                    }
                                    if (this.unrestricted_connect) {
                                        SecurityManager.enablePrivilege((String)"UniversalConnect");
                                    }
                                    socket = serverSocket.accept();
                                    closeable = null;
                                    if (throwable == null) break block42;
                                }
                                catch (IOException iOException) {
                                    throwable = iOException;
                                    break block44;
                                }
                                catch (RuntimeException runtimeException) {
                                    throwable = runtimeException;
                                    break block44;
                                }
                                catch (Error error) {
                                    throwable = error;
                                    break block44;
                                }
                            }
                            catch (Throwable throwable2) {
                                closeable = null;
                                if (throwable == null) throw throwable2;
                                try {
                                    this.server.close();
                                }
                                catch (IOException iOException) {}
                                if (!(throwable instanceof IOException) && !(throwable instanceof NoClassDefFoundError)) {
                                    if (!(throwable instanceof RuntimeException)) throw (Error)throwable;
                                    throw (RuntimeException)throwable;
                                }
                                if (this.retryServerSocket()) throw throwable2;
                                return;
                            }
                            try {}
                            catch (IOException iOException) {}
                            this.server.close();
                            if (!(throwable instanceof IOException) && !(throwable instanceof NoClassDefFoundError)) {
                                if (!(throwable instanceof RuntimeException)) throw (Error)throwable;
                                throw (RuntimeException)throwable;
                            }
                            if (!this.retryServerSocket()) {
                                return;
                            }
                            break block42;
                        }
                        closeable = null;
                        if (throwable == null) continue;
                        try {}
                        catch (IOException iOException) {}
                        this.server.close();
                        if (!(throwable instanceof IOException) && !(throwable instanceof NoClassDefFoundError)) {
                            if (!(throwable instanceof RuntimeException)) throw (Error)throwable;
                            throw (RuntimeException)throwable;
                        }
                        if (!this.retryServerSocket()) break;
                    }
                    return;
                }
                try {
                    socket.setTcpNoDelay(true);
                }
                catch (Exception exception) {}
                this.newListener();
                try {
                    try {
                        String string;
                        InputStream inputStream = socket.getInputStream();
                        closeable = new DataInputStream(inputStream);
                        OutputStream outputStream = socket.getOutputStream();
                        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                        int n = ((DataInputStream)closeable).readInt();
                        short s = ((DataInputStream)closeable).readShort();
                        if (n != 1246907721 || s != 2) {
                            TCPTransport.closeSocket(socket);
                            throwable = null;
                            break block46;
                        }
                        InetAddress inetAddress = socket.getInetAddress();
                        String string2 = string = inetAddress != null ? inetAddress.getHostName() : "";
                        if (logLevel >= 10) {
                            LogStream.log("tcp").println("TCPTransport.run: accepted socket from [" + string + ":" + socket.getPort() + "]");
                        }
                        byte by = ((DataInputStream)closeable).readByte();
                        switch (by) {
                            case 76: {
                                TCPEndpoint tCPEndpoint = new TCPEndpoint(string, socket.getLocalPort());
                                TCPChannel tCPChannel = new TCPChannel(this, tCPEndpoint);
                                TCPConnection tCPConnection = new TCPConnection(tCPChannel, socket);
                                this.handleMessages(tCPConnection, false);
                                break;
                            }
                            case 75: {
                                dataOutputStream.writeByte(78);
                                dataOutputStream.flush();
                                TCPEndpoint tCPEndpoint = new TCPEndpoint(string, socket.getPort());
                                if (logLevel >= 20) {
                                    LogStream.log("tcp").println("TCPTransport(" + this.endpoint.getPort() + ").run: " + "suggesting endpoint " + tCPEndpoint);
                                }
                                tCPEndpoint.write(dataOutputStream);
                                dataOutputStream.flush();
                                tCPEndpoint = TCPEndpoint.read((DataInput)((Object)closeable));
                                if (logLevel >= 20) {
                                    LogStream.log("tcp").println("TCPTransport(" + this.endpoint.getPort() + ").run: " + "using endpoint " + tCPEndpoint);
                                }
                                tCPEndpoint = new TCPEndpoint(string, socket.getLocalPort());
                                TCPChannel tCPChannel = new TCPChannel(this, tCPEndpoint);
                                TCPConnection tCPConnection = new TCPConnection(tCPChannel, socket);
                                this.handleMessages(tCPConnection, true);
                                break;
                            }
                            case 77: {
                                ConnectionMultiplexer connectionMultiplexer;
                                if (logLevel >= 20) {
                                    LogStream.log("tcp").println("TCPTransport(" + this.endpoint.getPort() + ").run: " + "accepting multiplex protocol");
                                }
                                dataOutputStream.writeByte(78);
                                TCPEndpoint tCPEndpoint = new TCPEndpoint(string, socket.getPort());
                                if (logLevel >= 20) {
                                    LogStream.log("tcp").println("TCPTransport(" + this.endpoint.getPort() + ").run: " + "suggesting endpoint " + tCPEndpoint);
                                }
                                tCPEndpoint.write(dataOutputStream);
                                dataOutputStream.flush();
                                tCPEndpoint = TCPEndpoint.read((DataInput)((Object)closeable));
                                if (logLevel >= 20) {
                                    LogStream.log("tcp").println("TCPTransport(" + this.endpoint.getPort() + ").run: " + "using endpoint " + tCPEndpoint);
                                }
                                Hashtable hashtable = this.channelTable;
                                synchronized (hashtable) {
                                    TCPChannel tCPChannel = (TCPChannel)this.getChannel(tCPEndpoint);
                                    connectionMultiplexer = new ConnectionMultiplexer(tCPChannel, inputStream, outputStream, false);
                                    tCPChannel.useMultiplexer(connectionMultiplexer);
                                }
                                connectionMultiplexer.run();
                                break;
                            }
                            default: {
                                dataOutputStream.writeByte(79);
                                dataOutputStream.flush();
                                break;
                            }
                        }
                    }
                    catch (IOException iOException) {
                        if (logLevel >= 10) {
                            closeable = LogStream.log("tcp");
                            ((PrintStream)closeable).println("TCPTransport.run: terminated with exception: ");
                            iOException.printStackTrace((PrintStream)closeable);
                        }
                        break block47;
                    }
                }
                catch (Throwable throwable3) {
                    throwable = null;
                    TCPTransport.closeSocket(socket);
                    throw throwable3;
                }
            }
            TCPTransport.closeSocket(socket);
            return;
        }
        throwable = null;
        TCPTransport.closeSocket(socket);
    }

    private static void closeSocket(Socket socket) {
        try {
            socket.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void handleMessages(Connection connection, boolean bl) {
        Thread thread;
        block17: {
            thread = Thread.currentThread();
            clientConnections.put(thread, connection);
            try {
                try {}
                catch (IOException iOException) {
                    if (logLevel >= 10) {
                        LogStream logStream = LogStream.log("tcp");
                        logStream.println("TCPTransport(" + this.endpoint.getPort() + ").handleMessages: exception: ");
                        iOException.printStackTrace(logStream);
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                Object var5_12 = null;
                clientConnections.remove(thread);
                try {
                    connection.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw throwable;
                }
            }
            block13: do {
                DataInputStream dataInputStream = new DataInputStream(connection.getInputStream());
                byte by = dataInputStream.readByte();
                if (logLevel >= 10) {
                    LogStream.log("tcp").println("TCPTransport(" + this.endpoint.getPort() + ").handleMessages: op = " + by);
                }
                switch (by) {
                    case 80: {
                        StreamRemoteCall streamRemoteCall = new StreamRemoteCall(connection);
                        if (this.serviceCall(streamRemoteCall)) continue block13;
                        Object var5_10 = null;
                        clientConnections.remove(thread);
                        try {}
                        catch (IOException iOException) {}
                        connection.close();
                        return;
                    }
                    case 82: {
                        DataOutputStream dataOutputStream = new DataOutputStream(connection.getOutputStream());
                        dataOutputStream.writeByte(83);
                        connection.releaseOutputStream();
                        break;
                    }
                    case 84: {
                        DGCAckHandler.received(UID.read(dataInputStream));
                        break;
                    }
                    default: {
                        throw new IOException("unknown transport op " + by);
                    }
                }
            } while (bl);
        }
        Object var5_11 = null;
        clientConnections.remove(thread);
        try {}
        catch (IOException iOException) {}
        connection.close();
        return;
    }

    public static Channel getCurrentChannel() {
        Thread thread = Thread.currentThread();
        Object v = clientConnections.get(thread);
        if (v != null && v instanceof Connection) {
            Channel channel = ((Connection)v).getChannel();
            return channel;
        }
        return null;
    }

    void ping() {
        Enumeration enumeration = this.channelTable.elements();
        while (enumeration.hasMoreElements()) {
            TCPChannel tCPChannel = (TCPChannel)enumeration.nextElement();
            if (tCPChannel.ping() != 1) continue;
            Endpoint endpoint = tCPChannel.getEndpoint();
            this.channelTable.remove(endpoint);
        }
    }

    static {
        clientConnections = new Hashtable(37);
        defaultSocketFactory = new RMIMasterSocketFactory();
    }
}

