/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.proxy;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.rmi.server.LogStream;
import sun.rmi.transport.proxy.HttpSendInputStream;
import sun.rmi.transport.proxy.HttpSendOutputStream;
import sun.rmi.transport.proxy.RMIMasterSocketFactory;
import sun.rmi.transport.proxy.RMISocketInfo;

class HttpSendSocket
extends Socket
implements RMISocketInfo {
    protected String host;
    protected int port;
    protected URL url;
    protected URLConnection conn;
    protected InputStream in;
    protected OutputStream out;
    protected HttpSendInputStream inNotifier;
    protected HttpSendOutputStream outNotifier;

    public HttpSendSocket(String string, int n, URL uRL) throws IOException {
        super((SocketImpl)null);
        if (RMIMasterSocketFactory.logLevel >= 20) {
            LogStream.log("proxy").println("HttpSendSocket.<init>: host = " + string + ", port = " + n + ", url = " + uRL);
        }
        this.host = string;
        this.port = n;
        this.url = uRL;
        this.inNotifier = new HttpSendInputStream(null, this);
        this.outNotifier = new HttpSendOutputStream(this.writeNotify(), this);
    }

    public HttpSendSocket(String string, int n) throws IOException {
        this(string, n, new URL("http", string, n, "/"));
    }

    public HttpSendSocket(InetAddress inetAddress, int n) throws IOException {
        this(inetAddress.getHostName(), n);
    }

    public boolean isReusable() {
        return false;
    }

    public synchronized OutputStream writeNotify() throws IOException {
        if (this.conn != null) {
            throw new IOException("attempt to write on HttpSendSocket after request has been sent");
        }
        this.conn = this.url.openConnection();
        this.conn.setDoOutput(true);
        this.conn.setUseCaches(false);
        this.conn.setRequestProperty("Content-type", "application/octet-stream");
        this.inNotifier.deactivate();
        this.in = null;
        this.out = this.conn.getOutputStream();
        return this.out;
    }

    public synchronized InputStream readNotify() throws IOException {
        if (RMIMasterSocketFactory.logLevel >= 20) {
            LogStream.log("proxy").println("HttpSendSocket.readNotify: sending request and activating input stream");
        }
        this.outNotifier.deactivate();
        this.out.close();
        this.out = null;
        try {
            this.in = this.conn.getInputStream();
        }
        catch (IOException iOException) {
            if (RMIMasterSocketFactory.logLevel >= 10) {
                LogStream logStream;
                LogStream logStream2 = logStream = LogStream.log("proxy");
                synchronized (logStream2) {
                    logStream.print("HttpSendSocket.readNotify: failed to get input stream, exception: ");
                    iOException.printStackTrace(logStream);
                }
            }
            throw new IOException("HTTP request failed");
        }
        String string = this.conn.getContentType();
        if (string == null || !this.conn.getContentType().equals("application/octet-stream")) {
            if (RMIMasterSocketFactory.logLevel >= 10) {
                LogStream logStream;
                LogStream logStream3 = logStream = LogStream.log("proxy");
                synchronized (logStream3) {
                    if (string == null) {
                        logStream.println("HttpSendSocket.readNotify: missing content type in response");
                    } else {
                        logStream.println("HttpSendSocket.readNotify: invalid content type in response: " + string);
                    }
                    logStream.print("HttpSendSocket.readNotify: response body: ");
                    try {
                        String string2;
                        DataInputStream dataInputStream = new DataInputStream(this.in);
                        while ((string2 = dataInputStream.readLine()) != null) {
                            logStream.println(string2);
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            throw new IOException("HTTP request failed");
        }
        return this.in;
    }

    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(this.host);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public InetAddress getLocalAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public int getPort() {
        return this.port;
    }

    public int getLocalPort() {
        return -1;
    }

    public InputStream getInputStream() throws IOException {
        return this.inNotifier;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.outNotifier;
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
    }

    public boolean getTcpNoDelay() throws SocketException {
        return false;
    }

    public void setSoLinger(boolean bl, int n) throws SocketException {
    }

    public int getSoLinger() throws SocketException {
        return -1;
    }

    public synchronized void setSoTimeout(int n) throws SocketException {
    }

    public synchronized int getSoTimeout() throws SocketException {
        return 0;
    }

    public synchronized void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }

    public String toString() {
        return "HttpSendSocket[host=" + this.host + ",port=" + this.port + ",url=" + this.url + "]";
    }
}

