/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Dimension;
import java.awt.Event;
import java.awt.Scrollbar;
import java.awt.peer.ScrollbarPeer;
import sun.awt.windows.WComponentPeer;

class WScrollbarPeer
extends WComponentPeer
implements ScrollbarPeer {
    int newValue;

    void create(WComponentPeer wComponentPeer) {
        Scrollbar scrollbar = (Scrollbar)this.target;
        this.newValue = scrollbar.getValue() - 1;
        this.pCreate(wComponentPeer);
        this.setValues(this.newValue + 1, scrollbar.getVisible(), scrollbar.getMinimum(), scrollbar.getMaximum());
    }

    native void pCreate(WComponentPeer var1);

    WScrollbarPeer(Scrollbar scrollbar) {
        super(scrollbar);
    }

    public Dimension minimumSize() {
        if (((Scrollbar)this.target).getOrientation() == 1) {
            return new Dimension(15, 50);
        }
        return new Dimension(50, 15);
    }

    public void setValue(int n) {
        if (n != this.newValue) {
            this.nativeSetValue(n);
            this.newValue = n;
        }
    }

    public void setValues(int n, int n2, int n3, int n4) {
        this.nativeSetData(n2, n3, n4);
        if (n != this.newValue) {
            this.nativeSetValue(n);
            this.newValue = n;
        }
    }

    public native void setLineIncrement(int var1);

    public native void setPageIncrement(int var1);

    native void nativeSetValue(int var1);

    native void nativeSetData(int var1, int var2, int var3);

    public void handleLineUp(long l, int n, int n2) {
        this.newValue = n2;
        Scrollbar scrollbar = (Scrollbar)this.target;
        scrollbar.setValue(n2);
        this.target.postEvent(new Event(this.target, 601, new Integer(n2)));
    }

    public void handleLineDown(long l, int n, int n2) {
        this.newValue = n2;
        Scrollbar scrollbar = (Scrollbar)this.target;
        scrollbar.setValue(n2);
        this.target.postEvent(new Event(this.target, 602, new Integer(n2)));
    }

    public void handlePageUp(long l, int n, int n2) {
        this.newValue = n2;
        Scrollbar scrollbar = (Scrollbar)this.target;
        scrollbar.setValue(n2);
        this.target.postEvent(new Event(this.target, 603, new Integer(n2)));
    }

    public void handlePageDown(long l, int n, int n2) {
        this.newValue = n2;
        Scrollbar scrollbar = (Scrollbar)this.target;
        scrollbar.setValue(n2);
        this.target.postEvent(new Event(this.target, 604, new Integer(n2)));
    }

    public void handleDragAbsolute(long l, int n, int n2) {
        this.newValue = n2;
        Scrollbar scrollbar = (Scrollbar)this.target;
        scrollbar.setValue(n2);
        this.target.postEvent(new Event(this.target, 605, new Integer(n2)));
    }
}

