/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.SimpleTimeZone;

public abstract class TimeZone
implements Serializable,
Cloneable {
    private String ID;
    private static TimeZone defaultZone = null;
    private static final int millisPerHour = 3600000;
    private static final SimpleTimeZone[] timeZoneData = new SimpleTimeZone[]{new SimpleTimeZone(0, "GMT", 2, -1, 1, 0x6DDD00, 9, 4, 1, 0x6DDD00), new SimpleTimeZone(3600000, "ECT", 2, -1, 1, 0x6DDD00, 8, -1, 1, 0x6DDD00), new SimpleTimeZone(0x6DDD00, "EET", 2, -1, 1, 0x6DDD00, 8, -1, 1, 0x6DDD00), new SimpleTimeZone(0x6DDD00, "ART", 4, 1, 1, 0x6DDD00, 9, 1, 1, 0x6DDD00), new SimpleTimeZone(10800000, "EAT"), new SimpleTimeZone(Integer.MIN_VALUE, "MET"), new SimpleTimeZone(14400000, "NET"), new SimpleTimeZone(18000000, "PLT"), new SimpleTimeZone(Integer.MIN_VALUE, "IST"), new SimpleTimeZone(21600000, "BST"), new SimpleTimeZone(25200000, "VST"), new SimpleTimeZone(28800000, "CTT"), new SimpleTimeZone(32400000, "JST"), new SimpleTimeZone(Integer.MIN_VALUE, "ACT", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00), new SimpleTimeZone(36000000, "AET", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00), new SimpleTimeZone(39600000, "SST"), new SimpleTimeZone(43200000, "NST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00), new SimpleTimeZone(-39600000, "MIT"), new SimpleTimeZone(-36000000, "HST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00), new SimpleTimeZone(-32400000, "AST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00), new SimpleTimeZone(-28800000, "PST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00), new SimpleTimeZone(-25200000, "PNT"), new SimpleTimeZone(-25200000, "MST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00), new SimpleTimeZone(-21600000, "CST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00), new SimpleTimeZone(-18000000, "EST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00), new SimpleTimeZone(-18000000, "IET"), new SimpleTimeZone(-14400000, "PRT"), new SimpleTimeZone(Integer.MIN_VALUE, "CNT", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00), new SimpleTimeZone(-10800000, "AGT"), new SimpleTimeZone(-10800000, "BET", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00), new SimpleTimeZone(-3600000, "CAT")};
    private static Hashtable lookup = new Hashtable(timeZoneData.length);

    public abstract int getOffset(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void setRawOffset(int var1);

    public abstract int getRawOffset();

    public String getID() {
        return this.ID;
    }

    public void setID(String string) {
        this.ID = string;
    }

    public abstract boolean useDaylightTime();

    public abstract boolean inDaylightTime(Date var1);

    public static synchronized TimeZone getTimeZone(String string) {
        try {
            return (SimpleTimeZone)lookup.get(string);
        }
        catch (MissingResourceException missingResourceException) {
            return new SimpleTimeZone(-28800000, "PST", 3, 1, 1, 0x6DDD00, 9, -1, 1, 0x6DDD00);
        }
    }

    public static synchronized String[] getAvailableIDs(int n) {
        String[] stringArray = new String[10];
        int n2 = 0;
        int n3 = 0;
        while (n3 < timeZoneData.length) {
            if (n == timeZoneData[n3].getRawOffset()) {
                stringArray[n2++] = timeZoneData[n3].getID();
            }
            ++n3;
        }
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        return stringArray2;
    }

    public static synchronized String[] getAvailableIDs() {
        String[] stringArray = new String[40];
        int n = 0;
        int n2 = 0;
        while (n2 < timeZoneData.length) {
            stringArray[n++] = timeZoneData[n2].getID();
            ++n2;
        }
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        return stringArray2;
    }

    public static synchronized TimeZone getDefault() {
        if (defaultZone == null) {
            String string = System.getProperty("user.timezone", "GMT");
            if (string != null && (defaultZone = TimeZone.getTimeZone(string)) != null) {
                return defaultZone;
            }
            String[] stringArray = TimeZone.getAvailableIDs(-28800000);
            if (stringArray != null) {
                defaultZone = TimeZone.getTimeZone(stringArray[0]);
            }
            if (defaultZone == null) {
                defaultZone = TimeZone.getTimeZone("PST");
            }
            return defaultZone;
        }
        return defaultZone;
    }

    public static synchronized void setDefault(TimeZone timeZone) {
        defaultZone = timeZone;
    }

    public Object clone() {
        try {
            TimeZone timeZone = (TimeZone)super.clone();
            timeZone.ID = this.ID;
            return timeZone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    static {
        int n = 0;
        while (n < timeZoneData.length) {
            lookup.put(timeZoneData[n].getID(), timeZoneData[n]);
            ++n;
        }
    }
}

