/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.peer.ChoicePeer;
import java.util.Vector;

public class Choice
extends Component {
    Vector pItems = new Vector();
    int selectedIndex = -1;

    public synchronized void addNotify() {
        this.peer = this.getToolkit().createChoice(this);
        super.addNotify();
    }

    public int countItems() {
        return this.pItems.size();
    }

    public String getItem(int n) {
        return (String)this.pItems.elementAt(n);
    }

    public synchronized void addItem(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.pItems.addElement(string);
        ChoicePeer choicePeer = (ChoicePeer)this.peer;
        if (choicePeer != null) {
            choicePeer.addItem(string, this.pItems.size() - 1);
        }
        if (this.selectedIndex < 0) {
            this.select(0);
        }
    }

    public String getSelectedItem() {
        int n = this.selectedIndex;
        if (n >= 0) {
            return this.getItem(n);
        }
        return null;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public synchronized void select(int n) {
        if (n >= this.pItems.size()) {
            throw new IllegalArgumentException("illegal Choice item position: " + n);
        }
        if (this.pItems.size() > 0) {
            this.selectedIndex = n;
            ChoicePeer choicePeer = (ChoicePeer)this.peer;
            if (choicePeer != null) {
                choicePeer.select(n);
            }
        }
    }

    public void select(String string) {
        int n = this.pItems.indexOf(string);
        if (n >= 0) {
            this.select(n);
        }
    }

    protected String paramString() {
        return String.valueOf(super.paramString()) + ",current=" + this.getSelectedItem();
    }
}

