/*
     spar - Show Process Accounting Records
     Copyright (C) 1993 Douglas Lee Schales, David K. Hess, David R. Safford

     Please see the file `COPYING' for the complete copyright notice.

group.c - 10/28/93

*/
#include <stdio.h>
#include <grp.h>

#include "config.h"

struct gidcache {
     char *name;
     gid_t gid;
};

struct gidcache gcache[8192];

static int gc_init = 0;

int
cgetgidname(char *name, unsigned long *gid)
{
     struct group *grent;
     int hash;
     
     if(!gc_init){
	  (void)memset((void *)gcache, 0, sizeof(gcache));
	  gc_init = 1;
     }

     if((grent = getgrnam(name))){
	  *gid = grent->gr_gid;
	  hash = (*gid) & 8191;
	  gcache[hash].gid = *gid;
	  if(!gcache[hash].name)
	       gcache[hash].name = (char *) malloc(9);
	  (void)strncpy(gcache[hash].name, name, 8);
	  gcache[hash].name[8] = 0;
	  return 0;
     }
     return -1;
}

char *
cgetnamgid(gid_t gid)
{
     struct group *grent;
     int hash = gid & 8191;

     if(!gc_init){
	  (void)memset((void *)gcache, 0, sizeof(gcache));
	  gc_init = 1;
     }

     if(gcache[hash].name && gcache[hash].gid == gid){
	  return gcache[hash].name;
     }
     else if((grent = getgrgid(gid))){
	  if(!gcache[hash].name)
	       gcache[hash].name = (char *)malloc(9);
	  (void)strcpy(gcache[hash].name, grent->gr_name);
	  gcache[hash].gid = gid;
     }
     else {
	  if(!gcache[hash].name)
	       gcache[hash].name = (char *)malloc(9);
	  (void)sprintf(gcache[hash].name, "%8lu", (unsigned long)gid);
	  gcache[hash].gid = gid;
     }
     return gcache[hash].name;
}
