/*
     spar - Show Process Accounting Records
     Copyright (C) 1993 Douglas Lee Schales, David K. Hess, David R. Safford

     Please see the file `COPYING' for the complete copyright notice.

config/next.h - 10/31/93

*/
#ifndef __NEXT_SPAR__
#define __NEXT_SPAR__

#define DEFAULT_PACCT "/usr/adm/pacct"
#define AC_COMMLEN 8
#define fromticks(t) ((((t)&0x1fff)<<(3*(((t)&0xe000)>>13)))/clockrate)

#define BSDPTY "/dev"
#define BSDTTY "/dev"

#include <string.h>
#include <memory.h>
#include <stdlib.h>
#include <sys/types.h>

#define MAJORDEV(x) major((x))
#define MINORDEV(x) minor((x))

#define MISCTTY (char *)0

#define NEED_STRDUP

#define CLKRATE AHZ

#define ACSIGEXIT(n) ((n)&127)

#endif

