############### Sources ############################
GENERIC_SRCS = \
       regcomp.c \
       regexec.c \
       regfree.c \
       regerror.c \
       tclAlloc.c \
       tclAsync.c \
       tclBasic.c \
       tclBinary.c \
       tclCkalloc.c \
       tclClock.c \
       tclCmdAH.c \
       tclCmdIL.c \
       tclCmdMZ.c \
       tclCompCmds.c \
       tclCompExpr.c \
       tclCompile.c \
       tclDate.c \
       tclEncoding.c \
       tclEnv.c \
       tclEvent.c \
       tclExecute.c \
       tclFCmd.c \
       tclFileName.c \
       tclGet.c \
       tclHash.c \
       tclHistory.c \
       tclIndexObj.c \
       tclInterp.c \
       tclIO.c \
       tclIOCmd.c \
       tclIOGT.c \
       tclIOSock.c \
       tclIOUtil.c \
       tclLink.c \
       tclListObj.c \
       tclLiteral.c \
       tclLoad.c \
       tclMain.c \
       tclNamesp.c \
       tclNotify.c \
       tclObj.c \
       tclParse.c \
       tclParseExpr.c \
       tclPipe.c \
       tclPkg.c \
       tclPosixStr.c \
       tclPreserve.c \
       tclProc.c \
       tclRegexp.c \
       tclResolve.c \
       tclResult.c \
       tclScan.c \
       tclStubInit.c \
       tclStubLib.c \
       tclStringObj.c \
       tclTest.c \
       tclTestObj.c \
       tclTestProcBodyObj.c \
       tclThread.c \
       tclTimer.c \
       tclUtil.c \
       tclVar.c \
       tclUtf.c \
       tclPanic.c \
       tclThreadTest.c

UNIX_SRCS = \
	tclAppInit.c \
	tclMtherr.c \
	tclUnixChan.c \
	tclUnixEvent.c \
	tclUnixFCmd.c \
	tclUnixFile.c \
	tclUnixNotfy.c \
	tclUnixPipe.c \
	tclUnixSock.c \
	tclUnixTest.c \
	tclUnixThrd.c \
	tclUnixTime.c \
	tclUnixInit.c

TCL_DBG_SRCS = Dbg_cmd.c Dbg.c

SCRIPTS_SRCS = libs.c scriptsA.c scriptsB.c scriptsC.c scriptsD.c scriptsE.c

THREAD_SOURCES	= threadCmd.c threadSvCmd.c threadSpCmd.c
THREAD_SOURCES += threadSvListCmd.c threadPoolCmd.c

LIB_SOURCES  = $(GENERIC_SRCS) $(UNIX_SRCS) $(TCL_DBG_SRCS) $(THREAD_SOURCES) \
	       tclLoadDl.c crctab.c

DIAG_SRCS = tclbrcm_parse_params.c dg_init.c tcl_al.c dg_os_mem.c \
            host_mem.c dg_hmem.c tcl_util.c tcl_hostmem.c \
	    tcl_help.c disputil.c tcl_device.c dg_device.c dg_dev.c \
	    dg_pcicfg.c os_util_ioctl.c dg_pci.c dg_os_pci.c debug.c \
	    ediag_drv_ioctl.c dg_reg.c tcl_reg.c tcl_driver.c dg_driver.c \
	    tcl_io.c os_disp_utils.c tcl_log.c common_nvm_tcl.c dg_nvm.c dg_vpd.c \
	    dg_delay.c dg_os_sleep.c sleep.c tcl_mcp.c parser.c dg_mcp_disasm.c \
	    $(SCRIPTS_SRCS) tcl_version.c tcl_pcicfg.c dg_pcicfg.c tcl_driver.c \
	    dg_driver.c tcl_disp64.c tcl_l2spc.c tcl_l2utl.c l2main.c l2arp.c \
	    l2bmgmt.c l2ip.c l2ipv6.c l2mac.c l2tcp.c l2udp.c l2check.c \
	    tcl_l2pkt.c dg_lmdev.c dg_send.c dg_receive.c tcl_debug.c tcl_delay.c \
	    tcl_lmdev.c dg_debug.c tcl_license.c hmacsha1.c tcl_log.c \
	    tcl_sb.c dg_sb.c tcl_value.c tcl_bar.c dg_bar.c tcl_bits.c Decompress.c \
	    dg_bits.c tcl_hex.c tcl_ioport.c dg_ioport.c dg_os_ioport.c tcl_gpio.c \
	    dg_gpio.c tcl_led.c dg_led.c tcl_keyhit.c tcl_ext_phy_fw.c dg_ext_phy_fw.c \
	    tcl_memtest.c tcl_pci.c prints.c dg_mcp.c async.c diag_stat.c tcl_l4fpath.c \
	    tcl_l4data.c tcl_l4regress.c tcl_l4spath.c tcl_l4spc.c tcl_l4spc_lang.c \
	    dg_l4data.c dg_l4fpath.c dg_l4spath.c dg_l4spc.c tcl_nictest.c tcl_fmac.c \
	    tcl_yield.c dg_yield.c tcl_perf_test.c tcl_fmodules.c tcl_traffic_spec.c tcl_multi_send.c \
	    phyfw_upgrade.c dg_intmem.c tcl_intmem_offset.c tcl_mcp_grc.c \
            decode_shmem.c  decode_license.c decode_dev_info.c  decode_ncsi_types.c  decode_ncsi_cmds.c \
	    uart.c tcl_serport.c dg_serport.c dg_os_duart.c dg_os_uart.c common_nvm_manager.c\
	    tcl_stats.c dg_stats.c dg_shmem.c duart_nvram.c tcl_vpd.c decode_grc.c tcl_hw_set.c tcl_pciechk.c checksum.c\

################# Directories ################
OBJDIR          = obj


################# Target and Co. #############
TARGET    	= lediag
ARCH            = $(shell uname -m)
LD        	= gcc
LIBS           += m c dl pthread 
TARGET_SRCS     = $(DIAG_SRCS) tclAppInit.c
ifeq ($(LDFLAGS),)
LDFLAGS  	= $(LIBDIRS:%=-L%) $(LIBS:%=-l%) $(ARCH_FLAG)
endif
TARGET_OBJS     = $(TARGET_SRCS:%.c=$(OBJDIR)/%.o)
LIB_OBJFILES 	= $(LIB_SOURCES:%.c=$(OBJDIR)/%.o)

##############################################

$(TARGET): $(TARGET_OBJS) $(LIB_OBJFILES) 
	$(LD) -o $@ $^ $(LDFLAGS)

##############################################
all default: $(TARGET)

clean:
	rm -f $(TARGET)
