#!/bin/bash

#########################################################################
#                      iSCSI Boot INITRD Creation			#
#########################################################################
#                  This script is for linux iscsi boot                  #

#*********************** Start - Global Variables ***********************
# OS         => RedHat | SuSE  				(defualt=RedHat)
# VER        => 5 | 6 | 11				(default=5)
# UPGRADE    => 0 | 1 | 2 | 3 | 4 | 5 | 6 | 7 | 8	(default=8)
#

TGPT=0
OS=RedHat
VER=5
UPGRADE=8
X64=
TG3=0
BNX2=0
BNX2X=0
BNX2i=0
INITIATOR=0
DISTRO=" "
USE_FW_LOGIC=0

LIBISCSI=libiscsi.ko

PARAMS=0
DEBUG=" "
SPEED=0
DUPLEX=" "
AUTONEG=" "
#************************** End - Global Variables **********************


#********************** Start - determine_OS function *******************
determine_OS ()	
{
 l_upgrade=0
 l_upgrade2=0
 
 if [ `cat /etc/issue | grep -i -c Red.Hat` -eq '1' ]; then	#Red Hat
   OS=RedHat
   if [ `uname -r | grep -i -c 2.6.32` -eq '1' ]; then	#Red Hat 6
     VER=6
     l_upgrade=`uname -r | cut -d - -f 2 | cut -d . -f 1`
     if [ \( $l_upgrade -ge '44' \) -a  \( $l_upgrade -lt '122' \) ]; then	#Initial release
       UPGRADE=0
     fi
     if [ \( $l_upgrade -ge '122' \)  -a  \( $l_upgrade -lt '220' \) ]; then      #Upgrade 1
       UPGRADE=1
     fi
     if [ \( $l_upgrade -ge '220' \) ]; then      #Upgrade 2
       UPGRADE=2
     fi
     RH_UNAME=`uname -r`
     RH_MAJ=`cat /lib/modules/$RH_UNAME/source/include/linux/version.h | grep RHEL_MAJ | awk '{print $3}'`
     RH_MIN=`cat /lib/modules/$RH_UNAME/source/include/linux/version.h | grep RHEL_MIN | awk '{print $3}'`
     if [ \( $RH_MAJ -eq '6' \) -a \( $RH_MIN -eq '5' \) ]; then
       USE_FW_LOGIC=1
     fi
     if [ $USE_FW_LOGIC -eq '0' ]; then
       ## If we fail to detect via version.h file, try to use kernel version
       if [ \( $l_upgrade -ge '425' \) ]; then      #Upgrade 5
         USE_FW_LOGIC=1
       fi
     fi
   elif [ `uname -r | grep -i -c 2.6.18` -eq '1' ]; then	#Red Hat 5
     VER=5
     l_upgrade=`uname -r | cut -d - -f 2 | cut -d . -f 1` 
     if [ \( $l_upgrade -ge '8' \) -a \( $l_upgrade -lt '53' \) ]; then	#Initial release
       UPGRADE=0
     fi
     if [ \( $l_upgrade -ge '53' \) -a \( $l_upgrade -lt '92' \) ]; then	#Upgrade 1
       UPGRADE=1
     fi
     if [ \( $l_upgrade -ge '92' \) -a \( $l_upgrade -lt '128' \) ]; then	#Upgrade 2
       UPGRADE=2
     fi
     if [ \( $l_upgrade -ge '128' \) -a \( $l_upgrade -lt '164' \) ]; then	#Upgrade 3
       UPGRADE=3
     fi
     if [ \( $l_upgrade -ge '164' \) -a \( $l_upgrade -lt '180' \) ]; then	#Upgrade 4
       UPGRADE=4
     fi
     if [ \( $l_upgrade -ge '180' \) -a \( $l_upgrade -lt '238' \) ]; then	#Upgrade 5
       UPGRADE=5
     fi
     if [ \( $l_upgrade -ge '238' \) -a \( $l_upgrade -lt '274' \) ]; then	#Upgrade 6
       UPGRADE=6
     fi
     if [ \( $l_upgrade -ge '274' \) -a \( $l_upgrade -lt '307' \) ]; then	#Upgrade 7
       UPGRADE=7
     fi
     if [ \( $l_upgrade -ge '307' \) ]; then      #Upgrade 8
       UPGRADE=8
     fi
   elif [ `uname -r | grep -i -c 2.6.9` -eq '1' ]; then	 #Red Hat 4	
     VER=4
     l_upgrade=`uname -r | cut -d - -f 2 | cut -d . -f 1`
     if [ $l_upgrade -eq '5' ]; then	#Initial release
       UPGRADE=0
     fi
     if [ $l_upgrade -eq '11' ]; then	#Upgrade 1
       UPGRADE=1
     fi
     if [ $l_upgrade -eq '22' ]; then	#Upgrade 2
       UPGRADE=2
     fi
     if [ $l_upgrade -eq '34' ]; then	#Upgrade 3
       UPGRADE=3
     fi
     if [ $l_upgrade -eq '42' ]; then	#Upgrade 4
       UPGRADE=4
     fi
     if [ $l_upgrade -eq '55' ]; then	#Upgrade 5
       UPGRADE=5
     fi
     if [ $l_upgrade -eq '67' ]; then	#Upgrade 6
       UPGRADE=6
     fi
     if [ $l_upgrade -eq '78' ]; then	#Upgrade 7
       UPGRADE=7
     fi
     if [ $l_upgrade -eq '89' ]; then	#Upgrade 8
       UPGRADE=8
     fi
   else
     echo "ERROR: Your Red Hat system is not version 6, 5 or 4. Can not continue...exiting"
     exit
   fi 
 elif [ `cat /etc/issue | grep -i -c SuSE` -eq '1' ]; then	#SuSE
   OS=SuSE
   if [ `uname -r | grep -i -c 3.0.76` -eq '1' ]; then     #SuSE 11 SP3
     VER=11
     l_upgrade=`uname -r | cut -d . -f 4 | cut -d - -f 1` 
     l_upgrade2=`uname -r | cut -d - -f 2 | cut -d . -f 1`
     if [ \( $l_upgrade -ge '9' \) ]; then   # Upgrade 3
       UPGRADE=2 ## Use Upgrade2 since there is not any major change
     fi
   elif [ `uname -r | grep -i -c 3.0.13` -eq '1' ]; then     #SuSE 11 SP2
     VER=11
     l_upgrade=`uname -r | cut -d . -f 4 | cut -d - -f 1` 
     l_upgrade2=`uname -r | cut -d - -f 2 | cut -d . -f 1`
     if [ \( $l_upgrade -ge '19' \) ]; then   # Upgrade 2
       UPGRADE=2
     fi
   elif [ `uname -r | grep -i -c 2.6.32` -eq '1' ]; then     #SuSE 11 SP1
     VER=11
     l_upgrade=`uname -r | cut -d . -f 4 | cut -d - -f 1` 
     l_upgrade2=`uname -r | cut -d - -f 2 | cut -d . -f 1`
     if [ \( $l_upgrade -ge '3' \) ]; then   # Upgrade 1
       UPGRADE=1
     fi
   elif [ `uname -r | grep -i -c 2.6.27` -eq '1' ]; then     #SuSE 11
     VER=11
     l_upgrade=`uname -r | cut -d . -f 4 | cut -d - -f 1` 
     l_upgrade2=`uname -r | cut -d - -f 2 | cut -d . -f 1`
     if [ \( $l_upgrade -ge '19' \) ]; then   # Initial Release
       UPGRADE=0
     fi
   elif [ `uname -r | grep -i -c 2.6.16` -eq '1' ]; then   #SuSE 10
     VER=10
     l_upgrade=`uname -r | cut -d . -f 4 | cut -d - -f 1`
     l_upgrade2=`uname -r | cut -d - -f 2 | cut -d . -f 2`
     if [ $l_upgrade -eq '21' ]; then	                                                                         #Initial Release
       UPGRADE=0
     fi
     if [ $l_upgrade -eq '46' ]; then	                                                                         #Upgrade 1
       UPGRADE=1
     fi					
     if [ \( $l_upgrade -eq '60' \) -a \( \( $l_upgrade2 -eq '21' \) -o \( $l_upgrade2 -eq '42' \) \) ]; then  #Upgrade 2	
       UPGRADE=2			
     fi
     if [ \( $l_upgrade -eq '60' \) -a \( $l_upgrade2 -eq '54' \) ]; then                                      #Upgrade 3
       UPGRADE=3
     fi
     if [ \( $l_upgrade -eq '60' \) -a \( $l_upgrade2 -eq '84' \) ]; then                                      #Upgrade 4
       UPGRADE=4
     fi
   else
     echo "ERROR: Your SuSE system is not version 10 or 11. Can not continue"
     exit       
   fi
 else
     echo "ERROR: Unable to determine distribution via /etc/issue"
     echo "       Please, run this script on Red hat or SuSE distribution"
 fi
  
 DISTRO="$OS$VER$UPGRADE"

}	
#********************** End   - determine_OS function ********************



#********************** Start - determine_ARCH function ******************
determine_ARCH ()
{
 ARCH=`uname -i`

 if [ $ARCH == "x86_64" ]; then
   X64=64
 else
   X64=
 fi
}
#********************** End - determine_ARCH function **********************



#********************** Start - determine_NIC function *********************
determine_NIC ()
{
 TG3=`lsmod | grep -i -c -w tg3`
 BNX2=`lsmod | grep -i -c -w bnx2`
 BNX2X=`lsmod | grep -i -c -w bnx2x`
 if [ \( $TG3 == '0' \) -a \( $BNX2 == '0' \) -a \( $BNX2X == '0' \) ]; then
   echo "ERROR: Unable to detect a supported network driver..."
   echo "       Load a supported network driver prior to executing this script."
   exit
 fi
}
#********************** End - determine_NIC function *************************



#******************* Start - determine_iSCSI_PATH function *******************
determine_iSCSI_PATH()
{
 if [ \( $DISTRO == 'RedHat54' \) -o \( $DISTRO == 'RedHat55' \) -o \( $DISTRO == 'RedHat56' \) -o \( $DISTRO == 'RedHat57' \) -o \( $DISTRO == 'RedHat58' \) -o \( $DISTRO == 'RedHat60' \) -o \( $DISTRO == 'RedHat61' \) -o \( $DISTRO == 'RedHat62' \) -o \( $DISTRO == 'SuSE111' \) -o \( $DISTRO == 'SuSE112' \) -o \( $DISTRO == 'SuSE113' \) ]; then
   echo "Please enter a value to indicate iSCSI path:  Non_Offload(0), Offload(1):"
   read INITIATOR
   if [ \( $INITIATOR != '0' \) -a \( $INITIATOR != '1' \) ]; then
     echo " ERROR: Invalid input received....exiting"
     exit
   fi
 elif [ \( $OS$VER == 'RedHat4' \) -o \( $OS$VER == 'RedHat5' \) -o \( $OS$VER == 'SuSE10' \) -o \( $DISTRO == 'SuSE110' \) ]; then
   INITIATOR=0
 else
   echo "ERROR: Installed OS not supported"
   echo $OS$VER
   exit
 fi
}
#********************** End - determine_iSCSI_PATH function *******************




#************************ Start - check_modules function ***********************
check_modules ()
{
  
  #................. Start - check_generic_modules function ....................
  check_generic_modules ()
  {
   ## This function is invoked with both offload and non-offload paths
   echo "Checking for necessary files"
   if [ -e /sbin/iscsid ]; then
    echo "iscsid.....................Found"
   else
     echo "ERROR: Utility \"/sbin/iscsid\" not found...Exiting"
     exit
   fi

   if [ \( $OS$VER == 'RedHat5' \) -o \( $OS$VER == 'RedHat6' \) -o \( $OS$VER == 'SuSE10' \) -o \( $OS$VER == 'SuSE11' \) ]; then
     if [ -e /sbin/iscsiadm ]; then
       echo "iscsiadm...................Found"
     else
       echo "ERROR: Utility \"/sbin/iscsiadm\" not found...Exiting"
       exit
     fi
   fi
   if [ $OS$VER == 'RedHat6' ]; then
     if [ -e /bin/bash ]; then
       echo "bash........................Found"
     else
       echo "ERROR: Utility \"/bin/bash\" not found...Exiting"
       exit
     fi
   fi
   if [ $USE_FW_LOGIC == 1 ]; then
     if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/iscsi_boot_sysfs.ko ]; then
       echo "iscsi_boot_sysfs............Found"
     else
       echo "ERROR: Module \"iscsi_boot_sysfs.ko\" not found...Exiting"
       exit
     fi
     if [ -e /lib/modules/`uname -r`/kernel/drivers/firmware/iscsi_ibft.ko ]; then
       echo "iscsi_ibft..................Found"
     else
       echo "ERROR: Module \"iscsi_ibft.ko\" not found...Exiting"
       exit
     fi
   fi
  }
  #................... End - check_generic_modules function ......................



  #.................... Start - check_offload_modules function ...................
  check_offload_modules()
  {
   ## This function is invoked with offload path only.
   LIBISCSI=libiscsi.ko
   if [ $OS$VER == 'RedHat6' ]; then  ## OS is Red hat 6
     if [ $UPGRADE -ge '0' ]; then   ## OS is Red Hat 6 and upgrade >= 0
       if [ $UPGRADE == '0' ]; then    ## upgrade is 0
         if [ -e /lib/modules/`uname -r`/kernel/drivers/uio/uio.ko ]; then
           echo "uio.ko.....................Found"
         else
           echo "ERROR: Module \"uio.ko\" not found...Exiting"
           exit
         fi
         if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/libiscsi_tcp.ko ]; then
           echo "libiscsi_tcp.ko............Found"
         else
           echo "ERROR: Module \"libiscsi_tcp.ko\" not found...Exiting"
           exit
         fi
         if [ -e /sbin/iscsiuio ]; then
           echo "iscsiuio...................Found"
         else
           echo "ERROR: Utility \"/sbin/iscsiuio\" not found...Exiting"
           exit
         fi
       fi
       if [ $UPGRADE == '1' ]; then    ## upgrade is 1
         if [ -e /lib/modules/`uname -r`/kernel/drivers/uio/uio.ko ]; then
           echo "uio.ko.....................Found"
         else
           echo "ERROR: Module \"uio.ko\" not found...Exiting"
           exit
         fi
         if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/libiscsi_tcp.ko ]; then
           echo "libiscsi_tcp.ko............Found"
         else
           echo "ERROR: Module \"libiscsi_tcp.ko\" not found...Exiting"
           exit
         fi
         if [ -e /sbin/iscsiuio ]; then
           echo "iscsiuio...................Found"
         else
           echo "ERROR: Utility \"/sbin/iscsiuio\" not found...Exiting"
           exit
         fi
       fi
       if [ $UPGRADE == '2' ]; then    ## upgrade is 2
         if [ -e /lib/modules/`uname -r`/kernel/drivers/uio/uio.ko ]; then
           echo "uio.ko.....................Found"
         else
           echo "ERROR: Module \"uio.ko\" not found...Exiting"
           exit
         fi
         if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/libiscsi_tcp.ko ]; then
           echo "libiscsi_tcp.ko............Found"
         else
           echo "ERROR: Module \"libiscsi_tcp.ko\" not found...Exiting"
           exit
         fi
         if [ -e /sbin/iscsiuio ]; then
           echo "iscsiuio...................Found"
         else
           echo "ERROR: Utility \"/sbin/iscsiuio\" not found...Exiting"
           exit
         fi
       fi
     else  ## OS is Red Hat 6 upgrade < 0
       echo "Your Operating Systems does not support Offload Path...exiting"
       exit
     fi
   elif [ $OS$VER == 'RedHat5' ]; then  ## OS is Red hat 5
     if [ $UPGRADE -ge '4' ]; then   ## OS is Red Hat 5 and upgrade >= 4
       if [ -e /lib/modules/`uname -r`/kernel/crypto/crypto_api.ko ]; then
         echo "crypto_api.ko..............Found"
       else
         echo "ERROR: Module \"crypto_api.ko\" not found...Exiting"
         exit
       fi
       if [ -e /lib/modules/`uname -r`/kernel/net/xfrm/xfrm_nalgo.ko ]; then
         echo "xfrm_nalgo.ko..............Found"
       else
         echo "ERROR: Module \"xfrm_nalgo.ko\" not found...Exiting"
         exit
       fi 
       if [ $UPGRADE == '8' ]; then    ## upgrade is 8
         LIBISCSI=libiscsi2.ko
         if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/scsi_transport_iscsi2.ko ]; then
           echo "scsi_transport_iscsi2.ko...Found"
         else
           echo "ERROR: Module \"scsi_transport_iscsi2.ko\" not found...Exiting"
           exit
         fi
         if [ -e /lib/modules/`uname -r`/kernel/drivers/uio/uio.ko ]; then
           echo "uio.ko.....................Found"
         else
           echo "ERROR: Module \"uio.ko\" not found...Exiting"
           exit
         fi
         if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/libiscsi_tcp.ko ]; then
           echo "libiscsi_tcp.ko............Found"
         else
           echo "ERROR: Module \"libiscsi_tcp.ko\" not found...Exiting"
           exit
         fi
         if [ -e /sbin/iscsiuio ]; then
           echo "iscsiuio..............Found"
         else
           echo "ERROR: Utility \"/sbin/iscsiuio\" not found...Exiting"
           exit
         fi 
       elif [ $UPGRADE == '7' ]; then    ## upgrade is 7
         LIBISCSI=libiscsi2.ko
         if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/scsi_transport_iscsi2.ko ]; then
           echo "scsi_transport_iscsi2.ko...Found"
         else
           echo "ERROR: Module \"scsi_transport_iscsi2.ko\" not found...Exiting"
           exit
         fi
         if [ -e /lib/modules/`uname -r`/kernel/drivers/uio/uio.ko ]; then
           echo "uio.ko.....................Found"
         else
           echo "ERROR: Module \"uio.ko\" not found...Exiting"
           exit
         fi
         if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/libiscsi_tcp.ko ]; then
           echo "libiscsi_tcp.ko............Found"
         else
           echo "ERROR: Module \"libiscsi_tcp.ko\" not found...Exiting"
           exit
         fi
         if [ -e /sbin/iscsiuio ]; then
           echo "iscsiuio..............Found"
         else
           echo "ERROR: Utility \"/sbin/iscsiuio\" not found...Exiting"
           exit
         fi 
       elif [ $UPGRADE == '6' ]; then    ## upgrade is 6
         LIBISCSI=libiscsi2.ko
         if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/scsi_transport_iscsi2.ko ]; then
           echo "scsi_transport_iscsi2.ko...Found"
         else
           echo "ERROR: Module \"scsi_transport_iscsi2.ko\" not found...Exiting"
           exit
         fi
         if [ -e /lib/modules/`uname -r`/kernel/drivers/uio/uio.ko ]; then
           echo "uio.ko.....................Found"
         else
           echo "ERROR: Module \"uio.ko\" not found...Exiting"
           exit
         fi
         if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/libiscsi_tcp.ko ]; then
           echo "libiscsi_tcp.ko............Found"
         else
           echo "ERROR: Module \"libiscsi_tcp.ko\" not found...Exiting"
           exit
         fi
         if [ -e /sbin/iscsiuio ]; then
           echo "iscsiuio..............Found"
         else
           echo "ERROR: Utility \"/sbin/iscsiuio\" not found...Exiting"
           exit
         fi 
       elif [ $UPGRADE == '5' ]; then    ## upgrade is 5
         LIBISCSI=libiscsi2.ko
         if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/scsi_transport_iscsi2.ko ]; then
           echo "scsi_transport_iscsi2.ko...Found"
         else
           echo "ERROR: Module \"scsi_transport_iscsi2.ko\" not found...Exiting"
           exit
         fi
         if [ -e /lib/modules/`uname -r`/kernel/drivers/uio/uio.ko ]; then
           echo "uio.ko.....................Found"
         else
           echo "ERROR: Module \"uio.ko\" not found...Exiting"
           exit
         fi
         if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/libiscsi_tcp.ko ]; then
           echo "libiscsi_tcp.ko............Found"
         else
           echo "ERROR: Module \"libiscsi_tcp.ko\" not found...Exiting"
           exit
         fi
         if [ -e /sbin/iscsiuio ]; then
           echo "iscsiuio...................Found"
         else
           echo "ERROR: Utility \"/sbin/iscsiuio\" not found...Exiting"
           exit
         fi
       elif [ $UPGRADE == '4' ]; then    ## upgrade is 4
         LIBISCSI=libiscsi2.ko
         if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/scsi_transport_iscsi2.ko ]; then
           echo "scsi_transport_iscsi2.ko...Found"
         else
           echo "ERROR: Module \"scsi_transport_iscsi2.ko\" not found...Exiting"
           exit
         fi
         if [ -e /lib/modules/`uname -r`/kernel/drivers/uio/uio.ko ]; then
           echo "uio.ko.....................Found"
         else
           echo "ERROR: Module \"uio.ko\" not found...Exiting"
           exit
         fi
         if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/libiscsi_tcp.ko ]; then
           echo "libiscsi_tcp.ko............Found"
         else
           echo "ERROR: Module \"libiscsi_tcp.ko\" not found...Exiting"
           exit
         fi
         if [ -e /sbin/iscsiuio ]; then
           echo "iscsiuio...................Found"
         else
           echo "ERROR: Utility \"/sbin/iscsiuio\" not found...Exiting"
           exit
         fi
       fi
     else  ## OS is Red Hat 5 upgrade < 4
       echo "Your Operating Systems does not support Offload Path...exiting"
       exit
     fi
   elif [ $OS$VER == 'SuSE11' ]; then  ## OS is SuSE11
     if [ $UPGRADE -ge '1' ]; then   ## OS is SuSE11 and upgrade >= 1
       if [ $UPGRADE == '2' ]; then    ## upgrade is 2
         LIBISCSI=libiscsi.ko
         if [ -e /lib/modules/`uname -r`/kernel/lib/libcrc32c.ko ]; then
           echo "libcrc32c.ko...............Found"
         else
           echo "ERROR: Module \"libcrc32c.ko\" not found...Exiting"
           exit
         fi

         if [ -e /lib/modules/`uname -r`/kernel/crypto/crc32c.ko ]; then
           echo "crc32c.ko..................Found"
         else
           echo "ERROR: Module \"crc32c.ko\" not found...Exiting"
           exit
         fi
 
         if [ -e /lib/modules/`uname -r`/kernel/drivers/net/mdio.ko ]; then
           echo "mdio.ko....................Found"
         else
           echo "ERROR: Module \"mdio.ko\" not found...Exiting"
           exit
         fi  
         if [ -e /lib/modules/`uname -r`/kernel/drivers/uio/uio.ko ]; then
           echo "uio.ko.....................Found"
         else
           echo "ERROR: Module \"uio.ko\" not found...Exiting"
           exit
         fi
         if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/libiscsi_tcp.ko ]; then
           echo "libiscsi_tcp.ko............Found"
         else
           echo "ERROR: Module \"libiscsi_tcp.ko\" not found...Exiting"
           exit
         fi
         if [ -e /sbin/iscsiuio ]; then
           echo "iscsiuio...................Found"
         else
           echo "ERROR: Utility \"/sbin/iscsiuio\" not found...Exiting"
           exit
         fi
       fi	     
       if [ $UPGRADE == '1' ]; then    ## upgrade is 1
         LIBISCSI=libiscsi.ko
         if [ -e /lib/modules/`uname -r`/kernel/lib/libcrc32c.ko ]; then
           echo "libcrc32c.ko...............Found"
         else
           echo "ERROR: Module \"libcrc32c.ko\" not found...Exiting"
           exit
         fi

         if [ -e /lib/modules/`uname -r`/kernel/crypto/crc32c.ko ]; then
           echo "crc32c.ko..................Found"
         else
           echo "ERROR: Module \"crc32c.ko\" not found...Exiting"
           exit
         fi
 
         if [ -e /lib/modules/`uname -r`/kernel/drivers/net/mdio.ko ]; then
           echo "mdio.ko....................Found"
         else
           echo "ERROR: Module \"mdio.ko\" not found...Exiting"
           exit
         fi  
         if [ -e /lib/modules/`uname -r`/kernel/drivers/uio/uio.ko ]; then
           echo "uio.ko.....................Found"
         else
           echo "ERROR: Module \"uio.ko\" not found...Exiting"
           exit
         fi
         if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/libiscsi_tcp.ko ]; then
           echo "libiscsi_tcp.ko............Found"
         else
           echo "ERROR: Module \"libiscsi_tcp.ko\" not found...Exiting"
           exit
         fi
         if [ -e /sbin/iscsiuio ]; then
           echo "iscsiuio...................Found"
         else
           echo "ERROR: Utility \"/sbin/iscsiuio\" not found...Exiting"
           exit
         fi
       fi
     else  ## OS is SuSE 11 upgrade < 1
       echo "Your Operating Systems does not support Offload Path...exiting"
       exit
     fi
   else ## all OSes besides Red Hat 5.4, 5.5, 5.6, 5.7, 5.8 and 6.0, 6.1, 6.2 and SuSE 11.1, 11.2
     echo "Your Operating Systems does not support Offload Path...exiting"
     exit
   fi

   ## check for modules common to Red Hat 5.4, 5.5, 5.6, 5.7, 5.8 Red hat 6.0, 6.1, 6.2, SuSE 11.1, 11.2.
   if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/scsi_transport_iscsi.ko ]; then
     echo "scsi_transport_iscsi.ko....Found"
   else
     echo "ERROR: Module \"scsi_transport_iscsi.ko\" not found...Exiting"
     exit
   fi

   if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/$LIBISCSI ]; then
     echo "$LIBISCSI................Found"
   else
     echo "ERROR: Module \"$LIBISCSI\" not found...Exiting"
     exit
   fi

   if [ -e /lib/modules/`uname -r`/kernel/net/ipv6/ipv6.ko ]; then
     echo "ipv6.ko....................Found"
   else
     echo "ERROR: Module \"ipv6.ko\" not found...Exiting"
     exit
   fi
   if [ \( -e /lib/modules/`uname -r`/extras/cnic.ko \) -o \( -e /lib/modules/`uname -r`/updates/cnic.ko \) -o \( -e /lib/modules/`uname -r`/kernel/drivers/net/cnic.ko \) ]; then
     echo "cnic.ko....................Found"
   else
     echo "ERROR: Module \"cnic.ko\" not found...Exiting"
     exit
   fi

   if [ \( -e /lib/modules/`uname -r`/extras/bnx2i.ko \) -o \( -e /lib/modules/`uname -r`/updates/bnx2i.ko \) -o \( -e /lib/modules/`uname -r`/kernel/drivers/scsi/bnx2i.ko \) -o \( -e /lib/modules/`uname -r`/kernel/drivers/scsi/bnx2i/bnx2i.ko \) ]; then
     echo "bnx2i.ko...................Found"
   else
     echo "ERROR: Module \"bnx2i.ko\" not found...Exiting"
     exit
   fi
  }
  #....................... End - check_offload_modules function ..................



  #.................... Start - check_nonoffload_modules function .................
  check_nonoffload_modules ()  
  {
   ## This function is invoked with non-offload path only.
   LIBISCSI=libiscsi.ko
   if [ $OS$VER == 'RedHat6' ]; then	## begin - case OS is Red Hat 6
     if [ \( $DISTRO == 'RedHat60' \) ]; then	## begin - case OS is Red Hat 6.0
       LIBISCSI=libiscsi.ko
       if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/libiscsi_tcp.ko ]; then
         echo "libiscsi_tcp.ko............Found"
       else
         echo "ERROR: Module \"libiscsi_tcp.ko\" not found...Exiting"
         exit
       fi
       if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/iscsi_tcp.ko ]; then
         echo "iscsi_tcp.ko...............Found"
       else
         echo "ERROR: Module \"iscsi_tcp.ko\" not found...Exiting"
         exit
       fi
     elif [ \( $DISTRO == 'RedHat61' \) ]; then   ## begin - case OS is Red Hat 6.1
       LIBISCSI=libiscsi.ko
       if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/libiscsi_tcp.ko ]; then
         echo "libiscsi_tcp.ko............Found"
       else
         echo "ERROR: Module \"libiscsi_tcp.ko\" not found...Exiting"
         exit
       fi
       if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/iscsi_tcp.ko ]; then
         echo "iscsi_tcp.ko...............Found"
       else
         echo "ERROR: Module \"iscsi_tcp.ko\" not found...Exiting"
         exit
       fi
     elif [ \( $DISTRO == 'RedHat62' \) ]; then   ## begin - case OS is Red Hat 6.2
       LIBISCSI=libiscsi.ko
       if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/libiscsi_tcp.ko ]; then
         echo "libiscsi_tcp.ko............Found"
       else
         echo "ERROR: Module \"libiscsi_tcp.ko\" not found...Exiting"
         exit
       fi
       if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/iscsi_tcp.ko ]; then
         echo "iscsi_tcp.ko...............Found"
       else
         echo "ERROR: Module \"iscsi_tcp.ko\" not found...Exiting"
         exit
       fi
     fi  ## end - case OS is Red Hat 6.0, 6.1 and 6.2
   elif [ $OS$VER == 'RedHat5' ]; then	## begin - case OS is Red Hat 5
     if [ $UPGRADE -ge '1' ]; then	## begin - case Red Hat 5 is upgrade >= 1
       if [ $UPGRADE == '1' ]; then	## begin - case Red Hat 5 is upgrade = 1
         if [ -e /lib/modules/`uname -r`/kernel/drivers/infiniband/core/ib_local_sa.ko ]; then
           echo "ib_local_sa.ko.............Found"
         else
           echo "ERROR: Module \"ib_local_sa.ko\" not found...Exiting"
           exit
         fi
       fi  ## end - case Red Hat 5 is upgrade = 1

       if [ -e /lib/modules/`uname -r`/kernel/drivers/infiniband/core/iw_cm.ko ]; then
         echo "iw_cm.ko...................Found"
       else
         echo "ERROR: Module \"iw_cm.ko\" not found...Exiting"
         exit
       fi
     fi  ## end - case Red Hat 5 is upgrade >= 1

     if [ \( $DISTRO == 'RedHat54' \) -o \( $DISTRO == 'RedHat55' \) -o \( $DISTRO == 'RedHat56' \) -o \( $DISTRO == 'RedHat57' \)  -o \( $DISTRO == 'RedHat58' \) ]; then	## begin - case OS is Red Hat 5.4, 5.5, 5.6, 5.7, 5.8
       LIBISCSI=libiscsi2.ko
       if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/scsi_transport_iscsi2.ko ]; then
         echo "scsi_transport_iscsi2.ko...Found"
       else
         echo "ERROR: Module \"scsi_transport_iscsi2.ko\" not found...Exiting"
         exit
       fi

       if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/libiscsi_tcp.ko ]; then
         echo "libiscsi_tcp.ko............Found"
       else
         echo "ERROR: Module \"libiscsi_tcp.ko\" not found...Exiting"
         exit
       fi
     fi  ## end - case OS is Red Hat 5.4, 5.5, 5.6, 5.7, 5.8

     ## Following applies to all upgrades of Red Hat 5
     if [ -e /lib/modules/`uname -r`/kernel/drivers/infiniband/core/iw_cm.ko ]; then
       echo "iw_cm.ko...................Found"
     else
       echo "ERROR: Module \"iw_cm.ko\" not found...Exiting"
       exit
     fi

     if [ -e /lib/modules/`uname -r`/kernel/drivers/infiniband/ulp/iser/ib_iser.ko ]; then
       echo "ib_iser.ko.................Found"
     else
       echo "ERROR: Module \"ib_iser.ko\" not found...Exiting"
       exit
     fi

     if [ -e /lib/modules/`uname -r`/kernel/drivers/infiniband/core/ib_core.ko ]; then
       echo "ib_core.ko.................Found"
     else
       echo "ERROR: Module \"ib_core.ko\" not found...Exiting"
       exit
     fi

     if [ -e /lib/modules/`uname -r`/kernel/drivers/infiniband/core/rdma_cm.ko ]; then
       echo "rdma_cm.ko.................Found"
     else
       echo "ERROR: Module \"rdma_cm.ko\" not found...Exiting"
       exit
     fi

     if [ -e /lib/modules/`uname -r`/kernel/drivers/infiniband/core/ib_addr.ko ]; then
       echo "ib_addr.ko.................Found"
     else
       echo "ERROR: Module \"ib_addr.ko\" not found...Exiting"
       exit
     fi

     if [ -e /lib/modules/`uname -r`/kernel/drivers/infiniband/core/ib_cm.ko ]; then
       echo "ib_cm.ko...................Found"
     else
       echo "ERROR: Module \"ib_cm.ko\" not found...Exiting"
       exit
     fi

     if [ -e /lib/modules/`uname -r`/kernel/drivers/infiniband/core/ib_sa.ko ]; then
       echo "ib_sa.ko...................Found"
     else
       echo "ERROR: Module \"ib_sa.ko\" not found...Exiting"
       exit
     fi

     if [ -e /lib/modules/`uname -r`/kernel/drivers/infiniband/core/ib_mad.ko ]; then
       echo "ib_mad.ko..................Found"
     else
       echo "ERROR: Module \"ib_mad.ko\" not found...Exiting"
       exit
     fi  ## end - case OS is Red Hat 5
   elif [ \( $OS$VER == 'SuSE10' \) -o \( $OS$VER == 'SuSE11' \) ]; then	## begin - case OS is SuSE 10 or 11
     if [ -e /lib/modules/`uname -r`/kernel/lib/libcrc32c.ko ]; then
       echo "libcrc32c.ko...............Found"
     else
       echo "ERROR: Module \"libcrc32c.ko\" not found...Exiting"
       exit
     fi

     if [ -e /lib/modules/`uname -r`/kernel/crypto/crc32c.ko ]; then
       echo "crc32c.ko..................Found"
     else
       echo "ERROR: Module \"crc32c.ko\" not found...Exiting"
       exit
     fi

     if [ \( $DISTRO == 'SuSE111' \) ]; then
       if [ -e /lib/modules/`uname -r`/kernel/drivers/net/mdio.ko ]; then
         echo "mdio.ko....................Found"
       else
         echo "ERROR: Module \"mdio.ko\" not found...Exiting"
         exit
       fi  ## end - case OS is SuSE 10 or 11
     fi
   elif [ \( $OS$VER == 'RedHat4' \)  ]; then  ## begin - case OS is Red hat 4
     DO_NOTHING=0
   else ##case no known OS is found 	 
     echo "ERROR: No Known OS Found.........exiting"
     exit
   fi

   ## Following applies to all upgrades of Red hat 5 and 6 and SuSE 10 and 11
   if [ \( $OS$VER == 'RedHat5' \) -o  \( $OS$VER == 'RedHat6' \) -o \( $OS$VER == 'SuSE10' \) -o \( $OS$VER == 'SuSE11' \) ]; then
     if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/$LIBISCSI ]; then
       echo "$LIBISCSI...............Found"
     else
       echo "ERROR: Module \"$LIBISCSI\" not found...Exiting"
       exit
     fi

     if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/scsi_transport_iscsi.ko ]; then
       echo "scsi_transport_iscsi.ko....Found"
     else
       echo "ERROR: Module \"scsi_transport_iscsi.ko\" not found...Exiting"
       exit
     fi

     if [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/iscsi_tcp.ko ]; then
       echo "iscsi_tcp.ko...............Found"
     else
       echo "ERROR: Module \"iscsi_tcp.ko\" not found...Exiting"
       exit
     fi
   elif [ \( $OS$VER == 'RedHat4' \) ]; then  ## begin - case OS is Red hat 4
     DO_NOTHING=0
   else ##case no known OS is found 	 
     echo "ERROR: No Known OS Found.........exiting"
     exit
   fi
  }
  #.................... End - check_nonoffload_modules function .................

check_generic_modules

if [ \( $INITIATOR == '1' \) -a \( \( $OS$VER == 'RedHat5' \) -o \( $OS$VER == 'RedHat6' \) -o \( $DISTRO == 'SuSE111' \) -o \( $DISTRO == 'SuSE112' \) \) ]; then
  check_offload_modules
elif [ \( $INITIATOR == '0' \) -a \( \( $OS == 'RedHat' \) -o \( $OS == 'SuSE' \) \) ]; then
  check_nonoffload_modules
else
  echo "ERROR: unidentified OS...exiting"
  exit
fi  

}
#*************************** End - check_modules function ***********************




#************************* Start - create_iscsi_script function ******************
create_iscsi_script ()
{
  #......................... Start - run_query_iscsi function .....................
  run_query_iscsi ()
    {
     echo "#!/bin/bash " > iscsi_script
     echo "echo \" \"" >> iscsi_script
     #echo "echo \"BEGIN - QUERY_ISCSI\" " >> iscsi_script
     echo "echo \"Querying iSCSI information...\"" >> iscsi_script
     echo "TARGET_NAME=\`query_iscsi TARGET_NAME\`" >> iscsi_script
     echo "TARGET_IP_ADDRESS=\`query_iscsi TARGET_IP_ADDRESS\`" >> iscsi_script
     echo "TARGET_TCP_PORT=\`query_iscsi TARGET_TCP_PORT\`" >> iscsi_script
     echo "INITIATOR_NAME=\`query_iscsi INITIATOR_NAME\`" >> iscsi_script
     echo "CLIENT_IP_ADDRESS=\`query_iscsi CLIENT_IP_ADDRESS\`" >> iscsi_script
     echo "DEFAULT_GATEWAY=\`query_iscsi DEFAULT_GATEWAY\`" >> iscsi_script
     echo "SUBNET_MASK=\`query_iscsi SUBNET_MASK\`" >> iscsi_script
     echo "AUTHEN_MODE=\`query_iscsi AUTHEN_MODE\`" >> iscsi_script
     echo "INITIATOR_ID=\`query_iscsi INITIATOR_ID\`" >> iscsi_script
     echo "INITIATOR_PW=\`query_iscsi INITIATOR_PW\`" >> iscsi_script
     echo "TARGET_ID=\`query_iscsi TARGET_ID\`" >> iscsi_script
     echo "TARGET_PW=\`query_iscsi TARGET_PW\`" >> iscsi_script
     echo "MAC_ADDRESS=\`query_iscsi MAC_ADDRESS\`" >> iscsi_script
     echo "L2_MAC_ADDRESS=\`query_iscsi L2_MAC_ADDRESS\`" >> iscsi_script
     echo "ISCSI_MAC_ADDRESS=\`query_iscsi ISCSI_MAC_ADDRESS\`" >> iscsi_script
     echo "VLANID=\`query_iscsi VLAN\`" >> iscsi_script
     echo "TARGET_NIC_ASSOCIATION=\`query_iscsi TARGET_NIC_ASSOCIATION\`" >> iscsi_script
     echo "TARGET_NAME2=\`query_iscsi TARGET_NAME2\`" >> iscsi_script
     echo "TARGET_IP_ADDRESS2=\`query_iscsi TARGET_IP_ADDRESS2\`" >> iscsi_script
     echo "TARGET_TCP_PORT2=\`query_iscsi TARGET_TCP_PORT2\`" >> iscsi_script
     echo "CLIENT_IP_ADDRESS2=\`query_iscsi CLIENT_IP_ADDRESS2\`" >> iscsi_script
     echo "DEFAULT_GATEWAY2=\`query_iscsi DEFAULT_GATEWAY2\`" >> iscsi_script
     echo "SUBNET_MASK2=\`query_iscsi SUBNET_MASK2\`" >> iscsi_script
     echo "AUTHEN_MODE2=\`query_iscsi AUTHEN_MODE2\`" >> iscsi_script
     echo "INITIATOR_ID2=\`query_iscsi INITIATOR_ID2\`" >> iscsi_script
     echo "INITIATOR_PW2=\`query_iscsi INITIATOR_PW2\`" >> iscsi_script
     echo "TARGET_ID2=\`query_iscsi TARGET_ID2\`" >> iscsi_script
     echo "TARGET_PW2=\`query_iscsi TARGET_PW2\`" >> iscsi_script
     echo "MAC_ADDRESS2=\`query_iscsi MAC_ADDRESS2\`" >> iscsi_script
     echo "L2_MAC_ADDRESS2=\`query_iscsi L2_MAC_ADDRESS2\`" >> iscsi_script
     echo "ISCSI_MAC_ADDRESS2=\`query_iscsi ISCSI_MAC_ADDRESS2\`" >> iscsi_script
     echo "VLANID2=\`query_iscsi VLAN2\`" >> iscsi_script
     echo "TARGET_NIC_ASSOCIATION2=\`query_iscsi TARGET2_NIC_ASSOCIATION\`" >> iscsi_script
     if [ $INITIATOR == '1' ]; then
       echo "if [ \$L2_MAC_ADDRESS == \$ISCSI_MAC_ADDRESS ]; then" >> iscsi_script
       echo "  if [ \$L2_MAC_ADDRESS == \"00:00:00:00:00:00\" ]; then" >> iscsi_script
       echo "    FFA=0" >> iscsi_script
       echo "  else" >> iscsi_script
       echo "    FFA=1" >> iscsi_script
       echo "  fi" >> iscsi_script
       echo "else" >> iscsi_script
       echo "  FFA=0" >> iscsi_script
       echo "fi" >> iscsi_script
     else
       echo "FFA=0" >> iscsi_script
     fi

     echo "" >> iscsi_script
     echo "echo \"Target Name = \" \$TARGET_NAME" >> iscsi_script
     echo "echo \"Target IP Address = \" \$TARGET_IP_ADDRESS" >> iscsi_script
     echo "echo \"Target TCP Port = \" \$TARGET_TCP_PORT" >> iscsi_script
     echo "echo \"Initiator Name = \" \$INITIATOR_NAME" >> iscsi_script
     echo "echo \"Client IP Address = \" \$CLIENT_IP_ADDRESS" >> iscsi_script
     echo "echo \"Default Gateway = \" \$DEFAULT_GATEWAY" >> iscsi_script
     echo "echo \"Subnet Mask = \" \$SUBNET_MASK" >> iscsi_script
     echo "echo \"Authen Method = \" \$AUTHEN_MODE" >> iscsi_script
     echo "echo \"Initiator ID = \" \$INITIATOR_ID" >> iscsi_script
     echo "echo \"Target ID = \" \$TARGET_ID" >> iscsi_script
     echo "echo \"MAC Address = \" \$MAC_ADDRESS" >> iscsi_script
     echo "echo \"VLAN ID = \" \$VLANID" >> iscsi_script
     #echo "echo \"END - QUERY_ISCSI\" " >> iscsi_script
     echo "echo \" \"" >> iscsi_script
    } 
  #............................. End - run_query_iscsi function .......................

  
  #........................... Start - load_NIC_drivers function.......................
  load_NIC_drivers ()
    {
     echo "echo \" \"" >> iscsi_script
     #echo "echo \"BEGIN - LOAD NIC DRIVERS\" " >> iscsi_script
     # If Offload Path load bnx2 or bnx2x only
     if [  \( $INITIATOR == '1' \) -a \( \( $OS$VER == 'RedHat5' \) -o \( $OS$VER == 'RedHat6' \) -o \( $DISTRO == 'SuSE111' \) -o \( $DISTRO == 'SuSE112' \) \) ]; then
       if [ \( $OS$VER  == 'SuSE11' \) ]; then    ## load these 3 modules for SuSE 11 only
         echo "echo \"Loading support modules for 8021q.ko\"" >> iscsi_script
         if [ \( $DISTRO  == 'SuSE111' \) -o \( $DISTRO == 'SuSE112' \) ]; then 
           echo "insmod /lib/llc.ko > /dev/null 2>&1" >> iscsi_script
         fi
         echo "insmod /lib/stp.ko > /dev/null 2>&1" >> iscsi_script
         echo "insmod /lib/garp.ko > /dev/null 2>&1" >> iscsi_script
       fi

       echo "echo \"Loading 8021q.ko module\"" >> iscsi_script
       if [ $OS$VER == 'RedHat6' ]; then
         echo "modprobe 8021q" >> iscsi_script
       else
         echo "insmod /lib/8021q.ko > /dev/null 2>&1" >> iscsi_script
       fi

       if [ $BNX2 != '0' ]; then
         echo "echo \"Loading bnx2.ko module\"" >> iscsi_script
         if [ $DISTRO == 'SuSE112' ]; then
           echo "rmmod bnx2" >> iscsi_script
         fi
         if [ $OS$VER == 'RedHat6' ]; then
           echo "modprobe bnx2" >> iscsi_script
         else
           echo "insmod /lib/bnx2.ko > /dev/null 2>&1" >> iscsi_script
         fi
       fi

       if [ $BNX2X != '0' ]; then
         if [ \( $OS$VER == 'SuSE10' \) -o \( $OS$VER == 'SuSE11' \) ]; then
           echo "echo \"Loading crc32c.ko module\"" >> iscsi_script
           echo "insmod /lib/crc32c.ko > /dev/null 2>&1" >> iscsi_script
           echo "echo \"Loading libcrc32c.ko module\"" >> iscsi_script
           echo "insmod /lib/libcrc32c.ko > /dev/null 2>&1" >> iscsi_script
           echo "echo \"Loading mdio.ko module\"" >> iscsi_script
           echo "insmod /lib/mdio.ko > /dev/null 2>&1" >> iscsi_script
         fi

	 echo "echo \"Loading bnx2x.ko module\"" >> iscsi_script
         if [ $DISTRO == 'SuSE112' ]; then
           echo "rmmod bnx2x" >> iscsi_script
         fi

         if [ $OS$VER == 'RedHat6' ]; then
           echo "modprobe bnx2x" >> iscsi_script
         else
           echo "insmod /lib/bnx2x.ko > /dev/null 2>&1" >> iscsi_script
         fi
       fi
     else  # If Non-Offload Path load bnx2, bnx2x or tg3
       if [ \( $OS$VER  == 'SuSE11' \) ]; then    ## load these 3 modules for SuSE 11 only
         echo "echo \"Loading support modules for 8021q.ko\"" >> iscsi_script
         if [ \( $DISTRO  == 'SuSE111' \) -o \( $DISTRO == 'SuSE112' \) ]; then
           echo "insmod /lib/llc.ko > /dev/null 2>&1" >> iscsi_script
         fi
         echo "insmod /lib/stp.ko > /dev/null 2>&1" >> iscsi_script
         echo "insmod /lib/garp.ko > /dev/null 2>&1" >> iscsi_script
       fi

       echo "echo \"Loading 8021q.ko module\"" >> iscsi_script
       if [ $OS$VER == 'RedHat6' ]; then
         echo "modprobe 8021q" >> iscsi_script
       else
         echo "insmod /lib/8021q.ko > /dev/null 2>&1" >> iscsi_script
       fi

       if [ $TG3 != '0' ]; then
         if [ \( $OS$VER == 'SuSE11' \) -a \( $UPGRADE == '0' \) ]; then
           echo "echo \"Loading libphy.ko module\"" >> iscsi_script
           echo "insmod /lib/libphy.ko > /dev/null 2>&1" >> iscsi_script
         fi
         HWMON=`modinfo tg3 | grep -c hwmon`
         if [ $HWMON != '0' ]; then
           echo "echo \"Loading hwmon.ko module\"" >> iscsi_script
           echo "insmod /lib/hwmon.ko > /dev/null 2>&1" >> iscsi_script
         fi
         echo "echo \"Loading tg3.ko module\"" >> iscsi_script
         if [ $DISTRO == 'SuSE112' ]; then
           echo "rmmod tg3" >> iscsi_script
         fi
         if [ $OS$VER == 'RedHat6' ]; then
           echo "modprobe tg3" >> iscsi_script
         else
           echo "insmod /lib/tg3.ko > /dev/null 2>&1" >> iscsi_script
         fi
       fi

       if [ $BNX2 != '0' ]; then
         echo "echo \"Loading bnx2.ko module\"" >> iscsi_script
         if [ $DISTRO == 'SuSE112' ]; then
           echo "rmmod bnx2" >> iscsi_script
         fi
         if [ $OS$VER == 'RedHat6' ]; then
           echo "modprobe bnx2" >> iscsi_script
         else
           echo "insmod /lib/bnx2.ko > /dev/null 2>&1" >> iscsi_script
         fi
       fi

       if [ $BNX2X != '0' ]; then
         if [ \( $OS$VER == 'SuSE10' \) -o \( $OS$VER == 'SuSE11' \) ]; then
           if [ \( $DISTRO == 'SuSE111' \) -o \( $DISTRO == 'SuSE112' \) ]; then
             echo "echo \"Loading crc32c.ko module\"" >> iscsi_script
             echo "insmod /lib/crc32c.ko > /dev/null 2>&1" >> iscsi_script
	   fi
           echo "echo \"Loading libcrc32c.ko module\"" >> iscsi_script
           echo "insmod /lib/libcrc32c.ko > /dev/null 2>&1" >> iscsi_script
           if [ \( $DISTRO == 'SuSE111' \) -o \( $DISTRO == 'SuSE112' \) ]; then
             echo "echo \"Loading mdio.ko module\"" >> iscsi_script
             echo "insmod /lib/mdio.ko > /dev/null 2>&1" >> iscsi_script
	   fi
         fi

         echo "echo \"Loading bnx2x.ko module\"" >> iscsi_script
         if [ $DISTRO == 'SuSE112' ]; then
           echo "rmmod bnx2x" >> iscsi_script
         fi
         if [ $OS$VER == 'RedHat6' ]; then
           echo "modprobe bnx2x" >> iscsi_script
         else
           echo "insmod /lib/bnx2x.ko > /dev/null 2>&1" >> iscsi_script
         fi
       fi
     fi
     #echo "echo \"END - LOAD NIC DRIVERS\" " >> iscsi_script
     echo "echo \" \"" >> iscsi_script
    }
  #............................ End - load_NIC_drivers function........................



  #......................... Start - load_generic_modules function.....................
  load_generic_modules ()
    {
     ## start - load ipv6 module if required
     echo "echo \" \"" >> iscsi_script
     #echo "echo \"BEGIN -LOAD GENERIC MODULES\" " >> iscsi_script
     echo "# Determine IPv6 support based on CLIENT_IP_ADDRESS " >> iscsi_script
     echo "IPV6=\`echo \$CLIENT_IP_ADDRESS | grep -c :\`" >> iscsi_script
     echo "if [ \$IPV6 -ge '1' ]; then" >> iscsi_script
     if [ \( $OS$VER == 'RedHat5' \) -a \( $UPGRADE -ge '2' \) ]; then
         echo "  insmod /lib/crypto_api.ko > /dev/null 2>&1" >> iscsi_script
         echo "  insmod /lib/xfrm_nalgo.ko > /dev/null 2>&1" >> iscsi_script
     fi
     echo "  echo \"Loading ipv6.ko module\"" >> iscsi_script
     if [ $OS$VER == 'RedHat6' ]; then
       echo "  modprobe ipv6" >> iscsi_script
     else
       if [ $DISTRO == 'SuSE112' ]; then
         echo "  insmod /lib/ipv6_lib.ko > /dev/null 2>&1" >> iscsi_script
       fi
       echo "  insmod /lib/ipv6.ko > /dev/null 2>&1" >> iscsi_script
     fi
     echo "fi" >> iscsi_script
     echo "" >> iscsi_script
     ## End - load ipv6 module if required

     ## Start - load iscsi_ibft/iscsi_boot_sysfs for RH65
     if [ $USE_FW_LOGIC == 1 ]; then
       echo "  echo \"Loading iscsi_boot_sysfs.ko module\"" >> iscsi_script
       echo "  modprobe iscsi_boot_sysfs" >> iscsi_script
       echo "  echo \"Loading iscsi_ibft.ko module\"" >> iscsi_script
       echo "  modprobe iscsi_ibft" >> iscsi_script
     fi
     ## End - load iscsi_ibft/iscsi_boot_sysfs for RH65

     ## start - Determine iSCSI Boot ethernet interface
     if [ \( $INITIATOR == '1' \) ]; then 
       echo "if [ \$L2_MAC_ADDRESS == \"00:00:00:00:00:00\" ]; then" >> iscsi_script
       echo "  INTERFACE=\`ifconfig -a | grep \$MAC_ADDRESS | awk '{print \$1}'\`" >> iscsi_script
       echo "else" >> iscsi_script
       echo "  INTERFACE=\`ifconfig -a | grep \$L2_MAC_ADDRESS | awk '{print \$1}'\`" >> iscsi_script
       echo "fi" >> iscsi_script

     else
       echo "  INTERFACE=\`ifconfig -a | grep \$MAC_ADDRESS | awk '{print \$1}'\`" >> iscsi_script
     fi

     ## For SuSE11, find 2nd NIC interface if applicable
     echo "  INTERFACE2=\`ifconfig -a | grep \$MAC_ADDRESS2 | awk '{print \$1}'\`" >> iscsi_script

     echo " " >> iscsi_script  
     
     #echo "echo \"Interface :\"\$INTERFACE" >> iscsi_script
     #echo "echo \"MAC Address :\"\$MAC_ADDRESS" >> iscsi_script

     echo "DHCPSTATIC=1" >> iscsi_script

     echo " " >> iscsi_script
     if [ \( $INITIATOR == '1' \) ]; then ## All OSes offload
       echo " " >> iscsi_script
       echo "ifconfig \$INTERFACE up > /dev/null" >> iscsi_script
       echo " " >> iscsi_script
       echo "if [ \$IPV6 -ge '1' ]; then" >> iscsi_script
       echo "  # Give adapter a chance to setup Link Local" >> iscsi_script
       echo "  sleep 10" >> iscsi_script
       echo "  if [ \$FFA -eq '0' ]; then" >> iscsi_script
       echo "    ifconfig \$INTERFACE add \$CLIENT_IP_ADDRESS up" >> iscsi_script
       echo "  fi" >> iscsi_script
       echo "else" >> iscsi_script
       echo "  if [ \$FFA -eq '0' ]; then" >> iscsi_script
       echo "    ifconfig \$INTERFACE \$CLIENT_IP_ADDRESS up" >> iscsi_script
       echo "  fi" >> iscsi_script
       echo "fi" >> iscsi_script
       echo " " >> iscsi_script
       #echo "ifconfig" >> iscsi_script
       echo " " >> iscsi_script
       #echo "sleep 5" >> iscsi_script
       echo "if [ \$IPV6 -ge '1' ]; then" >> iscsi_script  ## IPV6 is enabled
       echo "  COUNTER=8" >> iscsi_script
       echo "  LAST_FIELD=\`echo \$CLIENT_IP_ADDRESS | cut -d : -f \$COUNTER\`" >> iscsi_script
       echo "  while [ -z \$LAST_FIELD ]; do" >> iscsi_script
       echo "    let COUNTER-=1" >> iscsi_script
       echo "    LAST_FIELD=\`echo \$CLIENT_IP_ADDRESS | cut -d : -f \$COUNTER\`" >> iscsi_script
       echo "  done" >> iscsi_script
       echo "  let COUNTER-=1" >> iscsi_script
       echo "  IP_PARTIAL=\`echo \$CLIENT_IP_ADDRESS | cut -d : -f -\$COUNTER\`" >> iscsi_script
       echo "  GOOD_IP=0" >> iscsi_script
       echo "  for i in \`seq 1 9999\`; do" >> iscsi_script
       echo "    LAST_FIELD=\`echo \"obase=16; \$i\" | bc\`" >> iscsi_script
       echo "    IP_FINAL=\$IP_PARTIAL\":\"\$LAST_FIELD" >> iscsi_script
       echo "    ping6 -c 4 \$IP_FINAL > /dev/null" >> iscsi_script
       echo "    if [ \$? -ne 0 ]; then" >> iscsi_script
       echo "      GOOD_IP=1" >> iscsi_script
       echo "      CLIENT_IP_ADDRESS_TEMP=\$CLIENT_IP_ADDRESS" >> iscsi_script
       echo "      CLIENT_IP_ADDRESS=\$IP_FINAL" >> iscsi_script
       echo "      break" >> iscsi_script
       echo "    fi" >> iscsi_script
       echo "  done" >> iscsi_script
       echo "else" >> iscsi_script  ## IPV4 is enabled
       echo "  IP_PARTIAL=\`echo \$CLIENT_IP_ADDRESS | cut -d . -f -3\`" >> iscsi_script
       echo "  LAST_FIELD=\`echo \$CLIENT_IP_ADDRESS | cut -d . -f 4\`" >> iscsi_script
       echo "  GOOD_IP=0" >> iscsi_script
       echo "  for i in \`seq 1 254\`; do" >> iscsi_script
       echo "    if [ \$i == \$LAST_FIELD ]; then" >> iscsi_script
       echo "      continue" >> iscsi_script
       echo "    fi" >> iscsi_script
       echo "    IP_FINAL=\$IP_PARTIAL\".\"\$i" >> iscsi_script
       echo "    ping -c 4 \$IP_FINAL > /dev/null" >> iscsi_script
       echo "    if [ \$? -ne 0 ] ; then" >> iscsi_script
       echo "      GOOD_IP=1" >> iscsi_script
       echo "      CLIENT_IP_ADDRESS_TEMP=\$CLIENT_IP_ADDRESS" >> iscsi_script
       echo "      CLIENT_IP_ADDRESS=\$IP_FINAL" >> iscsi_script
       echo "      break" >> iscsi_script
       echo "    fi" >> iscsi_script
       echo "  done" >> iscsi_script
       echo "fi" >> iscsi_script
       echo " " >> iscsi_script
       echo "if [ \$GOOD_IP == '0' ]; then" >> iscsi_script ## ask user to supply a valid IP address if we fail to find one
       echo "  echo \"Obtain IP address via DHCP(0) or Static(1): \"" >> iscsi_script
       echo "  read DHCPSTATIC" >> iscsi_script
       echo "  while [ \\( \$DHCPSTATIC -ne '0' \\) -a \\( \$DHCPSTATIC -ne '1' \\) ]" >> iscsi_script
       echo "    do" >> iscsi_script
       echo "      echo \"Invalid selection... please enter a valid input: \"" >> iscsi_script
       echo "      read DHCPSTATIC" >> iscsi_script
       echo "    done" >> iscsi_script
       echo "" >> iscsi_script
       echo "  if [ \$DHCPSTATIC -eq '1' ]; then" >> iscsi_script
       echo "    echo \"Enter a static IP address for \$INTERFACE.  This IP address must be on the same subnet as the iSCSI offload device IP address.: \"" >> iscsi_script
       echo "    read USER_IP_ADDRESS" >> iscsi_script
       echo "    CLIENT_IP_ADDRESS_TEMP=\$CLIENT_IP_ADDRESS" >> iscsi_script
       echo "    CLIENT_IP_ADDRESS=\$USER_IP_ADDRESS" >> iscsi_script
       echo "  fi" >> iscsi_script
       echo "fi" >> iscsi_script
       #echo "echo \"L2 CLIENT_IP_ADDRESS    :\" \$CLIENT_IP_ADDRESS" >> iscsi_script
     fi  
     ## End - Determine iSCSI Boot ethernet interface
 
     ## Start - if ipv6, give adapter a chance to setup Link Local
     echo " " >> iscsi_script
     echo "ifconfig \$INTERFACE up > /dev/null" >> iscsi_script
     echo "if [ \$IPV6 -ge '1' ]; then" >> iscsi_script
     echo "  # Give adapter a chance to setup Link Local" >> iscsi_script
     echo "  sleep 10" >> iscsi_script
     echo "fi" >> iscsi_script
     echo " " >> iscsi_script
     ## End - if ipv6 give adapter a chance to setup Link Local

     ## Start - See if DHCP or Static IP
     echo "if [ \$DHCPSTATIC -eq '0' ]; then" >> iscsi_script   ## Static IP is turned off
     echo "  L2_MAC=\`ifconfig -a | grep \$INTERFACE | awk '{print \$5}'\`" >> iscsi_script
     echo "  echo \"#!/bin/nash\" >> network_setup_dhcp.sh" >> iscsi_script
     echo "  echo \"netname \$L2_MAC \$INTERFACE\" >> network_setup_dhcp.sh" >> iscsi_script
     echo "  echo \"network --device \$INTERFACE --bootproto dhcp\" >> network_setup_dhcp.sh" >> iscsi_script
     echo "  chmod 777 network_setup_dhcp.sh" >> iscsi_script
     echo "  ./network_setup_dhcp.sh" >> iscsi_script
     echo "else" >> iscsi_script       ## Static IP is turned on
     echo "  # If VLAN is enabled, load 8021q module and vconfig utility" >> iscsi_script
     echo "  if [ -z \$VLANID ]; then" >> iscsi_script	## if VLAN is disabled
     echo "    if [ \$IPV6 -ge '1' ]; then" >> iscsi_script ## if IPV6 is on
     echo "      if [ \$FFA -eq '0' ]; then" >> iscsi_script
     echo "        ifconfig \$INTERFACE inet6 add \$CLIENT_IP_ADDRESS/\$SUBNET_MASK up" >> iscsi_script
     echo "      fi" >> iscsi_script
     echo "    else" >> iscsi_script  ## if IPV6 is off
     echo "      if [ \$FFA -eq '0' ]; then" >> iscsi_script
     echo "        ifconfig \$INTERFACE \$CLIENT_IP_ADDRESS netmask \$SUBNET_MASK up" >> iscsi_script
     echo "      fi" >> iscsi_script
     echo "    fi" >> iscsi_script
     echo "  else" >> iscsi_script   ## if VLAN is enabled
     echo "    if [ \$VLANID != '0' ]; then" >> iscsi_script   ## if VLAN is enabled
     echo "      if [ \$IPV6 -ge '1' ]; then" >> iscsi_script ## if IPV6 is on
     echo "        ifconfig \$INTERFACE inet6 del \$CLIENT_IP_ADDRESS up" >> iscsi_script
     echo "      else" >> iscsi_script  ## if IPV6 is off
     echo "        ifconfig \$INTERFACE 0 up" >> iscsi_script
     echo "      fi" >> iscsi_script

     echo "      vconfig add \$INTERFACE \$VLANID" >> iscsi_script
     echo "      ifconfig \$INTERFACE.\$VLANID up" >> iscsi_script
     echo "      sleep 5" >> iscsi_script

     echo "      if [ \$IPV6 -ge '1' ]; then" >> iscsi_script   ## if ipv6 is enabled		
     echo "        ifconfig \$INTERFACE.\$VLANID inet6 add \$CLIENT_IP_ADDRESS/\$SUBNET_MASK up" >> iscsi_script
     echo "      else" >> iscsi_script   ## if ipv6 is disabled
     echo "        ifconfig \$INTERFACE.\$VLANID \$CLIENT_IP_ADDRESS netmask \$SUBNET_MASK up" >> iscsi_script
     echo "      fi" >> iscsi_script
     echo "    else" >> iscsi_script   ## if VLAN is disabled
     echo "      if [ \$IPV6 -ge '1' ]; then" >> iscsi_script   ##
     echo "        if [ \$FFA -eq '0' ]; then" >> iscsi_script
     echo "          ifconfig \$INTERFACE inet6 add \$CLIENT_IP_ADDRESS/\$SUBNET_MASK up" >> iscsi_script
     echo "        fi" >> iscsi_script
     echo "      else" >> iscsi_script   ## if ipv6 is disabled
     echo "        if [ \$FFA -eq '0' ]; then" >> iscsi_script
     echo "          ifconfig \$INTERFACE \$CLIENT_IP_ADDRESS netmask \$SUBNET_MASK up" >> iscsi_script
     echo "        fi" >> iscsi_script
     echo "      fi" >> iscsi_script
     echo "    fi" >> iscsi_script
     echo "  fi" >> iscsi_script 

     if [ \( $INITIATOR == '1' \) ]; then ##All OSes offload
       echo "CLIENT_IP_ADDRESS=\$CLIENT_IP_ADDRESS_TEMP" >> iscsi_script
       #echo "echo \"L4 CLIENT_IP_ADDRESS    : \"\$CLIENT_IP_ADDRESS" >> iscsi_script
     #else
       #echo "echo \"L2 CLIENT_IP_ADDRESS    : \"\$CLIENT_IP_ADDRESS" >> iscsi_script
     fi
     #echo "ifconfig" >> iscsi_script
     #echo "sleep 5" >> iscsi_script
     echo "fi ## Static IP Address" >> iscsi_script
     ## End - see if DHCP or Static IP

     ## Start - give adapter a chance to negotiate Link Local
     echo "" >> iscsi_script
     echo "# Give adapter a chance to negotiate the link" >> iscsi_script
     echo "sleep 5" >> iscsi_script
     echo " " >> iscsi_script
     echo "if [ \( \$DEFAULT_GATEWAY != \"0.0.0.0\" \) -a \( \$DEFAULT_GATEWAY != \"0:0:0:0:0:0:0:0\" \) ]; then" >> iscsi_script
     echo "  route add default gw \$DEFAULT_GATEWAY" >> iscsi_script
     echo "fi" >> iscsi_script
     echo "sleep 3" >> iscsi_script
     ## End - give adapter a chance to negotiate Link Local

     ## Start - set adapter speed
     if [ $PARAMS -eq 4 ]; then
       if [ $DEBUG == "debug" ]; then
         echo "ethtool -s \$INTERFACE speed $SPEED duplex $DUPLEX autoneg $AUTONEG" >> iscsi_script
         echo "sleep 5" >> iscsi_script
       fi
     fi
     ## End - set adapter speed
     #echo "echo \"END - LOAD GENERIC MODULES\" " >> iscsi_script
     echo "echo \" \"" >> iscsi_script
     }
  #............................. End - load_generic_modules function.........................

  
  load_generic_modules2 ()
    {
     echo "if [ \$MAC_ADDRESS2 != \"00:00:00:00:00:00\" ]; then " >> iscsi_script
     ## start - load ipv6 module if required
     echo "echo \" \"" >> iscsi_script
     #echo "echo \"BEGIN -LOAD GENERIC MODULES\" " >> iscsi_script
     echo "# Determine IPv62 support based on CLIENT_IP_ADDRESS2 " >> iscsi_script
     echo "IPV62=\`echo \$CLIENT_IP_ADDRESS2 | grep -c :\`" >> iscsi_script
     echo "if [ \$IPV62 -ge '1' ]; then" >> iscsi_script
     if [ \( $OS$VER == 'RedHat5' \) -a \( $UPGRADE -ge '2' \) ]; then
         echo "  insmod /lib/crypto_api.ko > /dev/null 2>&1" >> iscsi_script
         echo "  insmod /lib/xfrm_nalgo.ko > /dev/null 2>&1" >> iscsi_script
     fi
     echo "  echo \"Loading ipv6.ko module\"" >> iscsi_script
     if [ $OS$VER == 'RedHat6' ]; then
       echo "  modprobe ipv6" >> iscsi_script
     else
       if [ $DISTRO == 'SuSE112' ]; then
         echo "  insmod /lib/ipv6_lib.ko > /dev/null 2>&1" >> iscsi_script
       fi
       echo "  insmod /lib/ipv6.ko > /dev/null 2>&1" >> iscsi_script
     fi
     echo "fi" >> iscsi_script
     echo "" >> iscsi_script
     ## End - load ipv6 module if required

     ## start - Determine iSCSI Boot ethernet interface
     if [ \( $INITIATOR == '1' \) ]; then 
       echo "if [ \$L2_MAC_ADDRESS2 == \"00:00:00:00:00:00\" ]; then" >> iscsi_script
       echo "  INTERFACE2=\`ifconfig -a | grep \$MAC_ADDRESS2 | awk '{print \$1}'\`" >> iscsi_script
       echo "else" >> iscsi_script
       echo "  INTERFACE2=\`ifconfig -a | grep \$L2_MAC_ADDRESS2 | awk '{print \$1}'\`" >> iscsi_script
       echo "fi" >> iscsi_script

     else
       echo "  INTERFACE2=\`ifconfig -a | grep \$MAC_ADDRESS2 | awk '{print \$1}'\`" >> iscsi_script
     fi

     if [ $INITIATOR == '1' ]; then
       echo "if [ \$L2_MAC_ADDRESS2 == \$ISCSI_MAC_ADDRESS2 ]; then" >> iscsi_script
       echo "  if [ \$L2_MAC_ADDRESS2 == \"00:00:00:00:00:00\" ]; then" >> iscsi_script
       echo "    FFA2=0" >> iscsi_script
       echo "  else" >> iscsi_script
       echo "    FFA2=1" >> iscsi_script
       echo "  fi" >> iscsi_script
       echo "else" >> iscsi_script
       echo "  FFA2=0" >> iscsi_script
       echo "fi" >> iscsi_script
     else
       echo "FFA2=0" >> iscsi_script
     fi
     echo " " >> iscsi_script  
     
     echo "DHCPSTATIC=1" >> iscsi_script

     echo " " >> iscsi_script
     if [ \( $INITIATOR == '1' \) ]; then ## All OSes offload
       echo " " >> iscsi_script
       echo "ifconfig \$INTERFACE2 up > /dev/null" >> iscsi_script
       echo " " >> iscsi_script
       echo "if [ \$IPV62 -ge '1' ]; then" >> iscsi_script
       echo "  # Give adapter a chance to setup Link Local" >> iscsi_script
       echo "  sleep 10" >> iscsi_script
       echo "  if [ \$FFA2 -eq '0' ]; then" >> iscsi_script
       echo "    ifconfig \$INTERFACE2 add \$CLIENT_IP_ADDRESS2 up" >> iscsi_script
       echo "  fi" >> iscsi_script
       echo "else" >> iscsi_script
       echo "  if [ \$FFA2 -eq '0' ]; then" >> iscsi_script
       echo "    ifconfig \$INTERFACE2 \$CLIENT_IP_ADDRESS2 up" >> iscsi_script
       echo "  fi" >> iscsi_script
       echo "fi" >> iscsi_script
       echo " " >> iscsi_script
       #echo "ifconfig" >> iscsi_script
       echo " " >> iscsi_script
       #echo "sleep 5" >> iscsi_script
       echo "if [ \$IPV62 -ge '1' ]; then" >> iscsi_script  ## IPV6 is enabled
       echo "  COUNTER=8" >> iscsi_script
       echo "  LAST_FIELD=\`echo \$CLIENT_IP_ADDRESS2 | cut -d : -f \$COUNTER\`" >> iscsi_script
       echo "  while [ -z \$LAST_FIELD ]; do" >> iscsi_script
       echo "    let COUNTER-=1" >> iscsi_script
       echo "    LAST_FIELD=\`echo \$CLIENT_IP_ADDRESS2 | cut -d : -f \$COUNTER\`" >> iscsi_script
       echo "  done" >> iscsi_script
       echo "  let COUNTER-=1" >> iscsi_script
       echo "  IP_PARTIAL=\`echo \$CLIENT_IP_ADDRESS2 | cut -d : -f -\$COUNTER\`" >> iscsi_script
       echo "  GOOD_IP=0" >> iscsi_script
       echo "  for i in \`seq 1 9999\`; do" >> iscsi_script
       echo "    LAST_FIELD=\`echo \"obase=16; \$i\" | bc\`" >> iscsi_script
       echo "    IP_FINAL=\$IP_PARTIAL\":\"\$LAST_FIELD" >> iscsi_script
       echo "    ping6 -c 4 \$IP_FINAL > /dev/null" >> iscsi_script
       echo "    if [ \$? -ne 0 ]; then" >> iscsi_script
       echo "      GOOD_IP=1" >> iscsi_script
       echo "      CLIENT_IP_ADDRESS_TEMP2=\$CLIENT_IP_ADDRESS2" >> iscsi_script
       echo "      CLIENT_IP_ADDRESS2=\$IP_FINAL" >> iscsi_script
       echo "      break" >> iscsi_script
       echo "    fi" >> iscsi_script
       echo "  done" >> iscsi_script
       echo "else" >> iscsi_script  ## IPV4 is enabled
       echo "  IP_PARTIAL=\`echo \$CLIENT_IP_ADDRESS2 | cut -d . -f -3\`" >> iscsi_script
       echo "  LAST_FIELD=\`echo \$CLIENT_IP_ADDRESS2 | cut -d . -f 4\`" >> iscsi_script
       echo "  GOOD_IP=0" >> iscsi_script
       echo "  for i in \`seq 1 254\`; do" >> iscsi_script
       echo "    if [ \$i == \$LAST_FIELD ]; then" >> iscsi_script
       echo "      continue" >> iscsi_script
       echo "    fi" >> iscsi_script
       echo "    IP_FINAL=\$IP_PARTIAL\".\"\$i" >> iscsi_script
       echo "    ping -c 4 \$IP_FINAL > /dev/null" >> iscsi_script
       echo "    if [ \$? -ne 0 ] ; then" >> iscsi_script
       echo "      GOOD_IP=1" >> iscsi_script
       echo "      CLIENT_IP_ADDRESS_TEMP2=\$CLIENT_IP_ADDRESS2" >> iscsi_script
       echo "      CLIENT_IP_ADDRESS2=\$IP_FINAL" >> iscsi_script
       echo "      break" >> iscsi_script
       echo "    fi" >> iscsi_script
       echo "  done" >> iscsi_script
       echo "fi" >> iscsi_script
       echo " " >> iscsi_script
       echo "if [ \$GOOD_IP == '0' ]; then" >> iscsi_script ## ask user to supply a valid IP address if we fail to find one
       echo "  echo \"Obtain IP address via DHCP(0) or Static(1): \"" >> iscsi_script
       echo "  read DHCPSTATIC" >> iscsi_script
       echo "  while [ \\( \$DHCPSTATIC -ne '0' \\) -a \\( \$DHCPSTATIC -ne '1' \\) ]" >> iscsi_script
       echo "    do" >> iscsi_script
       echo "      echo \"Invalid selection... please enter a valid input: \"" >> iscsi_script
       echo "      read DHCPSTATIC" >> iscsi_script
       echo "    done" >> iscsi_script
       echo "" >> iscsi_script
       echo "  if [ \$DHCPSTATIC -eq '1' ]; then" >> iscsi_script
       echo "    echo \"Enter a static IP address for \$INTERFACE.  This IP address must be on the same subnet as the iSCSI offload device IP address.: \"" >> iscsi_script
       echo "    read USER_IP_ADDRESS" >> iscsi_script
       echo "    CLIENT_IP_ADDRESS_TEMP2=\$CLIENT_IP_ADDRESS2" >> iscsi_script
       echo "    CLIENT_IP_ADDRESS2=\$USER_IP_ADDRESS" >> iscsi_script
       echo "  fi" >> iscsi_script
       echo "fi" >> iscsi_script
     fi  
     ## End - Determine iSCSI Boot ethernet interface
 
     ## Start - if ipv6, give adapter a chance to setup Link Local
     echo " " >> iscsi_script
     echo "ifconfig \$INTERFACE2 up > /dev/null" >> iscsi_script
     echo "if [ \$IPV62 -ge '1' ]; then" >> iscsi_script
     echo "  # Give adapter a chance to setup Link Local" >> iscsi_script
     echo "  sleep 10" >> iscsi_script
     echo "fi" >> iscsi_script
     echo " " >> iscsi_script
     ## End - if ipv6 give adapter a chance to setup Link Local

     ## Start - See if DHCP or Static IP
     echo "if [ \$DHCPSTATIC -eq '0' ]; then" >> iscsi_script   ## Static IP is turned off
     echo "  L2_MAC=\`ifconfig -a | grep \$INTERFACE2 | awk '{print \$5}'\`" >> iscsi_script
     echo "  echo \"#!/bin/nash\" >> network_setup_dhcp.sh" >> iscsi_script
     echo "  echo \"netname \$L2_MAC \$INTERFACE2\" >> network_setup_dhcp.sh" >> iscsi_script
     echo "  echo \"network --device \$INTERFACE2 --bootproto dhcp\" >> network_setup_dhcp.sh" >> iscsi_script
     echo "  chmod 777 network_setup_dhcp.sh" >> iscsi_script
     echo "  ./network_setup_dhcp.sh" >> iscsi_script
     echo "else" >> iscsi_script       ## Static IP is turned on
     echo "  # If VLAN is enabled, load 8021q module and vconfig utility" >> iscsi_script
     echo "  if [ -z \$VLANID2 ]; then" >> iscsi_script	## if VLAN is disabled
     echo "    if [ \$IPV62 -ge '1' ]; then" >> iscsi_script ## if IPV6 is on
     echo "      if [ \$FFA2 -eq '0' ]; then" >> iscsi_script
     echo "        ifconfig \$INTERFACE2 inet6 add \$CLIENT_IP_ADDRESS2/\$SUBNET_MASK2 up" >> iscsi_script
     echo "      fi" >> iscsi_script
     echo "    else" >> iscsi_script  ## if IPV6 is off
     echo "      if [ \$FFA2 -eq '0' ]; then" >> iscsi_script
     echo "        ifconfig \$INTERFACE2 \$CLIENT_IP_ADDRESS2 netmask \$SUBNET_MASK2 up" >> iscsi_script
     echo "      fi" >> iscsi_script
     echo "    fi" >> iscsi_script
     echo "  else" >> iscsi_script   ## if VLAN is enabled
     echo "    if [ \$VLANID2 != '0' ]; then" >> iscsi_script   ## if VLAN is enabled
     echo "      if [ \$IPV62 -ge '1' ]; then" >> iscsi_script ## if IPV6 is on
     echo "        ifconfig \$INTERFACE2 inet6 del \$CLIENT_IP_ADDRESS2 up" >> iscsi_script
     echo "      else" >> iscsi_script  ## if IPV6 is off
     echo "        ifconfig \$INTERFACE2 0 up" >> iscsi_script
     echo "      fi" >> iscsi_script

     echo "      vconfig add \$INTERFACE2 \$VLANID2" >> iscsi_script
     echo "      ifconfig \$INTERFACE2.\$VLANID2 up" >> iscsi_script
     echo "      sleep 5" >> iscsi_script

     echo "      if [ \$IPV62 -ge '1' ]; then" >> iscsi_script   ## if ipv6 is enabled		
     echo "        ifconfig \$INTERFACE2.\$VLANID2 inet6 add \$CLIENT_IP_ADDRESS2/\$SUBNET_MASK2 up" >> iscsi_script
     echo "      else" >> iscsi_script   ## if ipv6 is disabled
     echo "        ifconfig \$INTERFACE2.\$VLANID2 \$CLIENT_IP_ADDRESS2 netmask \$SUBNET_MASK2 up" >> iscsi_script
     echo "      fi" >> iscsi_script
     echo "    else" >> iscsi_script   ## if VLAN is disabled
     echo "      if [ \$IPV62 -ge '1' ]; then" >> iscsi_script   ##
     echo "        if [ \$FFA2 -eq '0' ]; then" >> iscsi_script
     echo "          ifconfig \$INTERFACE2 inet6 add \$CLIENT_IP_ADDRESS2/\$SUBNET_MASK2 up" >> iscsi_script
     echo "        fi" >> iscsi_script
     echo "      else" >> iscsi_script   ## if ipv6 is disabled
     echo "        if [ \$FFA2 -eq '0' ]; then" >> iscsi_script
     echo "          ifconfig \$INTERFACE2 \$CLIENT_IP_ADDRESS2 netmask \$SUBNET_MASK2 up" >> iscsi_script
     echo "        fi" >> iscsi_script
     echo "      fi" >> iscsi_script
     echo "    fi" >> iscsi_script
     echo "  fi" >> iscsi_script 

     if [ \( $INITIATOR == '1' \) ]; then ##All OSes offload
       echo "CLIENT_IP_ADDRESS2=\$CLIENT_IP_ADDRESS_TEMP2" >> iscsi_script
     fi
     #echo "ifconfig" >> iscsi_script
     #echo "sleep 5" >> iscsi_script
     echo "fi ## Static IP Address" >> iscsi_script
     ## End - see if DHCP or Static IP

     ## Start - give adapter a chance to negotiate Link Local
     echo "" >> iscsi_script
     echo "# Give adapter a chance to negotiate the link" >> iscsi_script
     echo "sleep 5" >> iscsi_script
     echo " " >> iscsi_script
     echo "if [ \( \$DEFAULT_GATEWAY2 != \"0.0.0.0\" \) -a \( \$DEFAULT_GATEWAY2 != \"0:0:0:0:0:0:0:0\" \) ]; then" >> iscsi_script
     echo "  route add default gw \$DEFAULT_GATEWAY2" >> iscsi_script
     echo "fi" >> iscsi_script
     echo "sleep 3" >> iscsi_script
     ## End - give adapter a chance to negotiate Link Local

     echo "echo \" \"" >> iscsi_script
     echo "fi" >> iscsi_script
     }
  #............................. End - load_generic_modules2 function.........................


  #........................... Start - load_ offload_modules function .......................
  load_offload_modules ()
    {
     echo "echo \" \"" >> iscsi_script
     #echo "echo \"BEGIN - LOAD OFFLOAD MODULES\" " >> iscsi_script

     ## Start - Make MAC Address lower case
     echo "#Make MAC Address lower case" >> iscsi_script
     echo "MAC_ADDRESS=\`echo \$MAC_ADDRESS | tr '[:upper:]' '[:lower:]'\`" >> iscsi_script
     echo " " >> iscsi_script
     ## End - Make MAC Address lower case

     ## This function loads various modules required for offload iscsi boot
     echo "# Load iSCSI offload drivers" >> iscsi_script

     if [ \( $OS$VER != 'RedHat6' \) ]; then   ## OS is Red Hat
       echo "insmod /lib/scsi_mod.ko > /dev/null 2>&1" >> iscsi_script
     fi

     echo "insmod /lib/scsi_transport_iscsi.ko > /dev/null 2>&1" >> iscsi_script
     if [ \( $OS$VER == 'RedHat5' \) ]; then   ## OS is Red Hat
       echo "insmod /lib/scsi_transport_iscsi2.ko > /dev/null 2>&1" >> iscsi_script
     fi
     echo "insmod /lib/uio.ko > /dev/null 2>&1" >> iscsi_script
     
     echo "insmod /lib/$LIBISCSI > /dev/null 2>&1" >> iscsi_script

     if [ \( $OS$VER == 'RedHat5' \) ]; then
       echo "insmod /lib/crypto_api.ko > /dev/null 2>&1" >> iscsi_script
       echo "insmod /lib/xfrm_nalgo.ko > /dev/null 2>&1" >> iscsi_script
     fi

     if [ $DISTRO == 'SuSE112' ]; then
       echo "  insmod /lib/ipv6_lib.ko > /dev/null 2>&1" >> iscsi_script
     fi
     echo "insmod /lib/ipv6.ko > /dev/null 2>&1" >> iscsi_script
     if [ $DISTRO == 'SuSE112' ]; then
       echo "rmmod cnic" >> iscsi_script
     fi
     echo "insmod /lib/cnic.ko > /dev/null 2>&1" >> iscsi_script
     if [ $DISTRO == 'SuSE112' ]; then
       echo "rmmod bnx2i" >> iscsi_script
     fi
     echo "insmod /lib/bnx2i.ko > /dev/null 2>&1" >> iscsi_script
     echo "" >> iscsi_script

     echo "TRANSPORT=\"bnx2i\"" >> iscsi_script

     echo "echo \"TRANSPORT = \" \$TRANSPORT" >> iscsi_script
     echo "sleep 2" >> iscsi_script
     echo "" >> iscsi_script

     ETC=etc/iscsi
     echo "echo \"InitiatorName=\$INITIATOR_NAME\" > /$ETC/initiatorname.iscsi" >> iscsi_script
     echo "echo \"InitiatorAlias=ISCSI_ALIAS\" >> /$ETC/initiatorname.iscsi" >> iscsi_script
     echo "" >> iscsi_script

     echo "echo \"root:x:0:0:root:/root:/bin/bash\" > /etc/passwd" >> iscsi_script
     echo "maj_no=\`awk '/uio/{print \$1}' /proc/devices\`" >> iscsi_script
     echo "mknod /dev/uio c \$maj_no 0" >> iscsi_script
     echo "" >> iscsi_script

     echo "echo \"Starting iscsiuio \"" >> iscsi_script
     echo "/bin/iscsiuio -f &" >> iscsi_script
     echo "sleep 5" >> iscsi_script
     echo "" >> iscsi_script

     echo "echo \"Starting iSCSI daemon\"" >> iscsi_script
     echo "/sbin/iscsid -c /etc/iscsi/iscsid.conf -f &" >> iscsi_script
     echo "sleep 5" >> iscsi_script
     echo "" >> iscsi_script

     echo "##ISCSI_VER=\`iscsid -v | awk '{print \$3}' | awk '{gsub(/2.0-/,\"\"); print \$1}'\`" >> iscsi_script
     echo "if [ \$ISCSI_VER -ge '865' ]; then" >> iscsi_script
     echo "  CTGPT=,$TGPT" >> iscsi_script
     echo "else" >> iscsi_script
     echo "  CTGPT=\"\"" >> iscsi_script
     echo "fi" >> iscsi_script
     echo "" >> iscsi_script

     ## Starting with RH6.5 we will use "iscsiadm -m fw -l" to initiate
     ## iSCSI connections.  We will forego IFACE creation as unnecessary

     if [ $USE_FW_LOGIC == 1 ]; then
       echo "iscsiadm -m fw -l" >> iscsi_script
       echo "sleep 9" >> iscsi_script
       echo "exit" >> iscsi_script
     fi

     ## Begin Create IFACE node 
     echo "iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS -o new" >> iscsi_script
     echo "if [ \$VLANID != '0' ]; then" >> iscsi_script
     echo "  #iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS -o update -n iface.net_ifacename -v \$INTERFACE.\$VLANID" >> iscsi_script
     echo "  #iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS -o update -n iface.net_ifacename -v \$INTERFACE" >> iscsi_script
     echo "  iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS -o update -n iface.hwaddress -v \$MAC_ADDRESS" >> iscsi_script
     echo "else" >> iscsi_script
     echo "  #iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS -o update -n iface.net_ifacename -v \$INTERFACE" >> iscsi_script
     echo "  iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS -o update -n iface.hwaddress -v \$MAC_ADDRESS" >> iscsi_script
     echo "fi" >> iscsi_script
     echo "iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS -o update -n iface.transport_name -v \$TRANSPORT" >> iscsi_script
     echo "iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS -o update -n iface.ipaddress -v \$CLIENT_IP_ADDRESS" >> iscsi_script  
     echo "" >> iscsi_script
     echo "sleep 8" >> iscsi_script
     ## End create IFACE ##


     ## Begin Create target node ##
     echo "if [ \$IPV6 -ge '1' ]; then" >> iscsi_script
     echo "  iscsiadm -m node -T \$TARGET_NAME -p [\$TARGET_IP_ADDRESS]:\$TARGET_TCP_PORT\$CTGPT -I iface_brcm\$MAC_ADDRESS -o new" >> iscsi_script
     echo "  TARGET_PORTAL=[\$TARGET_IP_ADDRESS]:\$TARGET_TCP_PORT\$CTGPT" >> iscsi_script
     echo "else" >> iscsi_script
     echo "  iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_IP_ADDRESS:\$TARGET_TCP_PORT\$CTGPT -I iface_brcm\$MAC_ADDRESS -o new" >> iscsi_script
     echo "  TARGET_PORTAL=\$TARGET_IP_ADDRESS:\$TARGET_TCP_PORT\$CTGPT" >> iscsi_script
     echo "fi" >> iscsi_script

     echo "iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -o update -n node.startup -v automatic" >> iscsi_script
     echo "iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -o update -n node.conn[0].startup -v automatic" >> iscsi_script

     echo "if [ \$AUTHEN_MODE == \"CHAP\" ]; then" >> iscsi_script
     echo "  iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -o update -n node.session.auth.authmethod -v \$AUTHEN_MODE" >> iscsi_script
     echo "  iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -o update  -n node.session.auth.username -v \$INITIATOR_ID" >> iscsi_script
     echo "  iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -o update -n node.session.auth.password -v \$INITIATOR_PW" >> iscsi_script
     echo "  # Check if Mutual CHAP is enabled by the existence of \$TARGET_ID" >> iscsi_script
     echo "  if [ -z \$TARGET_ID ]; then" >> iscsi_script
     echo "    echo" >> iscsi_script
     echo "  else" >> iscsi_script
     echo "    iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -o update -n node.session.auth.username_in -v \$TARGET_ID" >> iscsi_script
     echo "    iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -o update -n node.session.auth.password_in -v \$TARGET_PW" >> iscsi_script
     echo "  fi" >> iscsi_script
     echo "fi" >> iscsi_script

     echo "NODE_IFACE=node" >> iscsi_script

     if [ \( $OS$VER == 'RedHat5' \) -o \( $OS$VER == 'RedHat6' \) -o \( $OS$VER == 'SuSE11' \) ]; then
       echo "NODE_IFACE=iface" >> iscsi_script
     else
     ## We do not need to update the TRANSPORT here, since we use IFACE for >=RH5.4
       echo "iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -o update -n \$NODE_IFACE.transport_name -v \$TRANSPORT" >> iscsi_script
     fi

     if [  \( $OS$VER == 'RedHat5' \) -o \( $OS$VER == 'RedHat6' \) -o \( $OS$VER == 'SuSE11' \) ]; then
       echo "if [ -e /dev/uio0 ]; then" >> iscsi_script
       echo "  sleep 3" >> iscsi_script
       echo "else" >> iscsi_script
       echo "  mknod /dev/uio0 c \$maj_no 0" >> iscsi_script
       echo "  sleep 3" >> iscsi_script
       echo "fi" >> iscsi_script
       echo "iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -I iface_brcm\$MAC_ADDRESS -l 2>&1 /dev/null" >> iscsi_script
     else
       echo "if [ \$IPV6 -ge '1' ]; then" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -I iface_brcm\$MAC_ADDRESS -l" >> iscsi_script
     fi

     if [  \( $OS$VER == 'RedHat5' \) -o \( $OS$VER == 'RedHat6' \) -o \( $OS$VER == 'SuSE11' \) ]; then
       echo > /dev/null
     else
       echo "else" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -l" >> iscsi_script
       echo "fi" >> iscsi_script
     fi

     echo "sleep 9" >> iscsi_script

     #if [  \( $OS$VER == 'RedHat5' \) -o \( $OS$VER == 'RedHat6' \) -o \( $OS$VER == 'SuSE11' \) ]; then
     #  echo "  iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -I iface_brcm\$MAC_ADDRESS -l" >> iscsi_script
     #  echo "sleep 9" >> iscsi_script
     #fi
     #echo "echo \"END - LOAD OFFLOAD MODULES\" " >> iscsi_script
     echo "echo \" \"" >> iscsi_script
    }   
  ## End Create target node ##
  #........................... End - load_ offload_modules function .......................

  create_secondary_iface()
    {  
     echo "if [ \$MAC_ADDRESS2 != \"00:00:00:00:00:00\" ]; then " >> iscsi_script
     ## Start - Make MAC Address lower case
     echo "#Make MAC Address lower case" >> iscsi_script
     echo "MAC_ADDRESS2=\`echo \$MAC_ADDRESS2 | tr '[:upper:]' '[:lower:]'\`" >> iscsi_script
     echo " " >> iscsi_script
     ## End - Make MAC Address lower case
     ## Begin Create IFACE node 
     echo "iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS2 -o new" >> iscsi_script
     echo "if [ \$VLANID2 != '0' ]; then" >> iscsi_script
     echo "  #iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS2 -o update -n iface.net_ifacename -v \$INTERFACE2.\$VLANID2" >> iscsi_script
     echo "  #iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS2 -o update -n iface.net_ifacename -v \$INTERFACE2" >> iscsi_script
     echo "  iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS2 -o update -n iface.hwaddress -v \$MAC_ADDRESS2" >> iscsi_script
     echo "else" >> iscsi_script
     echo "  #iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS2 -o update -n iface.net_ifacename -v \$INTERFACE2" >> iscsi_script
     echo "  iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS2 -o update -n iface.hwaddress -v \$MAC_ADDRESS2" >> iscsi_script
     echo "fi" >> iscsi_script
     echo "iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS2 -o update -n iface.transport_name -v \$TRANSPORT" >> iscsi_script
     echo "iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS2 -o update -n iface.ipaddress -v \$CLIENT_IP_ADDRESS2" >> iscsi_script  
     echo "" >> iscsi_script
     echo "sleep 8" >> iscsi_script
     ## End create IFACE ##
     echo "fi" >> iscsi_script
    }  

  create_secondary_target()
    {  
     echo "if [ \$MAC_ADDRESS2 != \"00:00:00:00:00:00\" ]; then " >> iscsi_script
     ## Begin Create target node ##
     echo "if [ \$IPV62 -ge '1' ]; then" >> iscsi_script
     echo "  iscsiadm -m node -T \$TARGET_NAME2 -p [\$TARGET_IP_ADDRESS2]:\$TARGET_TCP_PORT2\$CTGPT -I iface_brcm\$MAC_ADDRESS2 -o new" >> iscsi_script
     echo "  TARGET_PORTAL=[\$TARGET_IP_ADDRESS2]:\$TARGET_TCP_PORT2\$CTGPT" >> iscsi_script
     echo "else" >> iscsi_script
     echo "  iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_IP_ADDRESS2:\$TARGET_TCP_PORT2\$CTGPT -I iface_brcm\$MAC_ADDRESS2 -o new" >> iscsi_script
     echo "  TARGET_PORTAL=\$TARGET_IP_ADDRESS2:\$TARGET_TCP_PORT2\$CTGPT" >> iscsi_script
     echo "fi" >> iscsi_script

     echo "iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -o update -n node.startup -v automatic" >> iscsi_script
     echo "iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -o update -n node.conn[0].startup -v automatic" >> iscsi_script

     echo "if [ \$AUTHEN_MODE2 == \"CHAP\" ]; then" >> iscsi_script
     echo "  iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -o update -n node.session.auth.authmethod -v \$AUTHEN_MODE2" >> iscsi_script
     echo "  iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -o update  -n node.session.auth.username -v \$INITIATOR_ID2" >> iscsi_script
     echo "  iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -o update -n node.session.auth.password -v \$INITIATOR_PW2" >> iscsi_script
     echo "  # Check if Mutual CHAP is enabled by the existence of \$TARGET_ID" >> iscsi_script
     echo "  if [ -z \$TARGET_ID2 ]; then" >> iscsi_script
     echo "    echo" >> iscsi_script
     echo "  else" >> iscsi_script
     echo "    iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -o update -n node.session.auth.username_in -v \$TARGET_ID2" >> iscsi_script
     echo "    iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -o update -n node.session.auth.password_in -v \$TARGET_PW2" >> iscsi_script
     echo "  fi" >> iscsi_script
     echo "fi" >> iscsi_script

     echo "NODE_IFACE=node" >> iscsi_script

     if [ \( $OS$VER == 'RedHat5' \) -o \( $OS$VER == 'RedHat6' \) -o \( $OS$VER == 'SuSE11' \) ]; then
       echo "NODE_IFACE=iface" >> iscsi_script
     else
     ## We do not need to update the TRANSPORT here, since we use IFACE for >=RH5.4
       echo "iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -o update -n \$NODE_IFACE.transport_name -v \$TRANSPORT" >> iscsi_script
     fi

     if [  \( $OS$VER == 'RedHat5' \) -o \( $OS$VER == 'RedHat6' \) -o \( $OS$VER == 'SuSE11' \) ]; then
       echo "if [ -e /dev/uio0 ]; then" >> iscsi_script
       echo "  sleep 3" >> iscsi_script
       echo "else" >> iscsi_script
       echo "  mknod /dev/uio0 c \$maj_no 0" >> iscsi_script
       echo "  sleep 3" >> iscsi_script
       echo "fi" >> iscsi_script
       echo "iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -I iface_brcm\$MAC_ADDRESS2 -l 2>&1 /dev/null" >> iscsi_script
     else
       echo "if [ \$IPV62 -ge '1' ]; then" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -I iface_brcm\$MAC_ADDRESS2 -l" >> iscsi_script
     fi

     if [  \( $OS$VER == 'RedHat5' \) -o \( $OS$VER == 'RedHat6' \) -o \( $OS$VER == 'SuSE11' \) ]; then
       echo > /dev/null
     else
       echo "else" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -l" >> iscsi_script
       echo "fi" >> iscsi_script
     fi

     echo "sleep 9" >> iscsi_script

     #if [  \( $OS$VER == 'RedHat5' \) -o \( $OS$VER == 'RedHat6' \) -o \( $OS$VER == 'SuSE11' \) ]; then
     #  echo "  iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -I iface_brcm\$MAC_ADDRESS -l" >> iscsi_script
     #  echo "sleep 9" >> iscsi_script
     #fi
     #echo "echo \"END - LOAD OFFLOAD MODULES\" " >> iscsi_script
     echo "echo \" \"" >> iscsi_script
     echo "fi" >> iscsi_script
    }   

  #........................ Start - load_nonoffload_openiscsi function ....................
  load_nonoffload_openiscsi ()
    {  
     echo "echo \" \"" >> iscsi_script
     #echo "echo \"BEGIN - LOAD NON-OFFLOAD MODULES OPENISCSI\" " >> iscsi_script
     if [ $OS$VER == 'RedHat6' ]; then
       echo "modprobe scsi_transport_iscsi" >> iscsi_script
     else
       echo "insmod /lib/scsi_transport_iscsi.ko > /dev/null 2>&1" >> iscsi_script
     fi

     if [ \( $DISTRO == 'RedHat54' \) -o \( $DISTRO == 'RedHat55' \) -o \( $DISTRO == 'RedHat56' \) -o \( $DISTRO == 'RedHat57' \) -o \( $DISTRO == 'RedHat58' \) ]; then
       echo "insmod /lib/scsi_transport_iscsi2.ko > /dev/null 2>&1" >> iscsi_script
     fi

     if [ $OS$VER == 'RedHat6' ]; then
       RH6_LIBISCSI=`echo $LIBISCSI | awk '{gsub(/.ko/,""); print $1}'`
       echo "modprobe $RH6_LIBISCSI" >> iscsi_script
     else
       echo "insmod /lib/$LIBISCSI > /dev/null 2>&1" >> iscsi_script
     fi

     if [ \( \( $DISTRO == 'RedHat54' \) -o \( $DISTRO == 'RedHat55' \) -o \( $DISTRO == 'RedHat56' \) -o \( $DISTRO == 'RedHat57' \) -o \( $DISTRO == 'RedHat58' \) -o \( $DISTRO == 'RedHat60' \) -o \( $DISTRO == 'RedHat61' \) -o \( $DISTRO == 'RedHat62' \) -o \( $DISTRO == 'SuSE111' \) -o \( $DISTRO == 'SuSE112' \) \) ]; then
       if [ $OS$VER == 'RedHat6' ]; then
         echo "modprobe libiscsi_tcp" >> iscsi_script
       else
         echo "insmod /lib/libiscsi_tcp.ko > /dev/null 2>&1" >> iscsi_script
       fi
     fi
     
     if [ $OS$VER == 'RedHat6' ]; then
       echo "modprobe iscsi_tcp" >> iscsi_script
     else
       echo "insmod /lib/iscsi_tcp.ko > /dev/null 2>&1" >> iscsi_script
     fi

     if [ \( $OS$VER == 'SuSE10' \) -o \( $OS$VER == 'SuSE11' \) ]; then
       if [ $BNX2X == '0' ]; then
         echo "insmod /lib/libcrc32c.ko > /dev/null 2>&1" >> iscsi_script
       fi
       echo "insmod /lib/crc32c.ko > /dev/null 2>&1" >> iscsi_script     
     elif [ $OS$VER == 'RedHat5' ]; then
       echo "insmod /lib/ib_core.ko > /dev/null 2>&1" >> iscsi_script
       echo "insmod /lib/ib_mad.ko > /dev/null 2>&1" >> iscsi_script
       echo "insmod /lib/ib_sa.ko > /dev/null 2>&1" >> iscsi_script
       echo "insmod /lib/ib_cm.ko > /dev/null 2>&1" >> iscsi_script
       echo "insmod /lib/ib_addr.ko > /dev/null 2>&1" >> iscsi_script
       if [ \( $OS$VER == 'RedHat5' \) -a \( $UPGRADE -ge '1' \) ]; then
         echo "insmod /lib/iw_cm.ko > /dev/null 2>&1" >> iscsi_script
         if [ $UPGRADE == '1' ]; then
           echo "insmod /lib/ib_local_sa.ko > /dev/null 2>&1" >> iscsi_script
         fi
       fi
       echo "insmod /lib/rdma_cm.ko > /dev/null 2>&1" >> iscsi_script
       echo "insmod /lib/ib_iser.ko > /dev/null 2>&1" >> iscsi_script
     else
       sleep 0
     fi

     echo "" >> iscsi_script
     echo "sleep 2" >> iscsi_script
     echo "" >> iscsi_script
     ETC=etc/iscsi
     echo "echo \"InitiatorName=\$INITIATOR_NAME\" > /$ETC/initiatorname.iscsi" >> iscsi_script
     echo "echo \"InitiatorAlias=ISCSI_ALIAS\" >> /$ETC/initiatorname.iscsi" >> iscsi_script
     echo "" >> iscsi_script

     if [ \( $OS$VER == 'RedHat5' \) -o \( $OS$VER == 'RedHat6' \) ]; then
       echo "if [ \$IPV6 == '0' ]; then" >> iscsi_script
       echo "  echo \"Starting iSCSI session\"" >> iscsi_script
       echo "  if [ \$AUTHEN_MODE == \"CHAP\" ]; then" >> iscsi_script
       echo "    if [ -n \$TARGET_ID ]; then" >> iscsi_script
       echo "      /bin/iscsistart --initiatorname=\$INITIATOR_NAME --tgpt=$TGPT --targetname=\$TARGET_NAME --address=\$TARGET_IP_ADDRESS --port=\$TARGET_TCP_PORT --username=\$INITIATOR_ID --password=\$INITIATOR_PW --username_in=\$TARGET_ID --password_in=\$TARGET_PW" >> iscsi_script
       echo "    else" >> iscsi_script
       echo "      /bin/iscsistart --initiatorname=\$INITIATOR_NAME --tgpt=$TGPT --targetname=\$TARGET_NAME --address=\$TARGET_IP_ADDRESS --port=\$TARGET_TCP_PORT --username=\$INITIATOR_ID --password=\$INITIATOR_PW" >> iscsi_script
       echo "    fi" >> iscsi_script
       echo "  else" >> iscsi_script
       echo "    /bin/iscsistart --initiatorname=\$INITIATOR_NAME --tgpt=$TGPT --targetname=\$TARGET_NAME --address=\$TARGET_IP_ADDRESS --port=\$TARGET_TCP_PORT" >> iscsi_script
       echo "  fi" >> iscsi_script
       echo "  sleep 5" >> iscsi_script
       echo "else" >> iscsi_script
       echo "  echo \"root:x:0:0:root:/root:/bin/bash\" > /etc/passwd" >> iscsi_script
       echo "  echo \"Starting iSCSI daemon\"" >> iscsi_script
       echo "  /sbin/iscsid -c /etc/iscsi/iscsid.conf -f &" >> iscsi_script
       echo "  sleep 5" >> iscsi_script
       echo "  ISCSI_VER=\`iscsid -v | awk '{print \$3}' | awk '{gsub(/2.0-/,\"\"); print \$1}'\`" >> iscsi_script
       echo "  CTGPT=\"\"" >> iscsi_script
       echo "  iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS -o new" >> iscsi_script
       echo "  if [ \$VLANID != '0' ]; then" >> iscsi_script
       echo "    iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS -o update -n iface.net_ifacename -v \$INTERFACE.\$VLANID" >> iscsi_script
       echo "    #iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS -o update -n iface.hwaddress -v \$MAC_ADDRESS" >> iscsi_script
       echo "  else" >> iscsi_script
       echo "    iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS -o update -n iface.net_ifacename -v \$INTERFACE" >> iscsi_script
       echo "    #iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS -o update -n iface.hwaddress -v \$MAC_ADDRESS" >> iscsi_script
       echo "  fi" >> iscsi_script
       echo "  iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS -o update -n iface.transport_name -v tcp" >> iscsi_script

       echo "  iscsiadm -m node -T \$TARGET_NAME -p [\$TARGET_IP_ADDRESS]:\$TARGET_TCP_PORT\$CTGPT -I iface_brcm\$MAC_ADDRESS -o new" >> iscsi_script
       echo "  TARGET_PORTAL=[\$TARGET_IP_ADDRESS]:\$TARGET_TCP_PORT\$CTGPT" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -o update -n node.startup -v automatic" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -o update -n node.conn[0].startup -v automatic" >> iscsi_script
       echo "  if [ \$AUTHEN_MODE == \"CHAP\" ]; then" >> iscsi_script
       echo "    iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -o update -n node.session.auth.authmethod -v \$AUTHEN_MODE" >> iscsi_script
       echo "    iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -o update  -n node.session.auth.username -v \$INITIATOR_ID" >> iscsi_script
       echo "    iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -o update -n node.session.auth.password -v \$INITIATOR_PW" >> iscsi_script
       echo "# Check if Mutual CHAP is enabled by the existence of \$TARGET_ID" >> iscsi_script
       echo "    if [ -z \$TARGET_ID ]; then" >> iscsi_script
       echo "      echo" >> iscsi_script
       echo "    else" >> iscsi_script
       echo "      iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -o update -n node.session.auth.username_in -v \$TARGET_ID" >> iscsi_script
       echo "      iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -o update -n node.session.auth.password_in -v \$TARGET_PW" >> iscsi_script
       echo "    fi" >> iscsi_script
       echo "  fi" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -I iface_brcm\$MAC_ADDRESS -l" >> iscsi_script
       echo "  sleep 9" >> iscsi_script
       echo "fi" >> iscsi_script
     fi

     if [ \( $OS$VER == 'SuSE10' \) -o \( $OS$VER == 'SuSE11' \) ]; then
       echo "echo \"Starting iSCSI daemon\"" >> iscsi_script
       echo "/sbin/iscsid -c /etc/iscsi/iscsid.conf -f &" >> iscsi_script
       echo "sleep 5" >> iscsi_script
       echo "ISCSI_VER=\`iscsid -v | awk '{print \$3}' | awk '{gsub(/2.0-/,\"\"); print \$1}'\`" >> iscsi_script
       echo "if [ \$ISCSI_VER -ge '865' ]; then" >> iscsi_script
       echo "  CTGPT=,$TGPT" >> iscsi_script
       echo "else" >> iscsi_script
       echo "  CTGPT=\"\"" >> iscsi_script
       echo "fi" >> iscsi_script
    
       echo "if [ \$IPV6 -ge '1' ]; then" >> iscsi_script
       echo "  iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS -o new" >> iscsi_script
       echo "  if [ \$VLANID != '0' ]; then" >> iscsi_script
       echo "    iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS -o update -n iface.net_ifacename -v \$INTERFACE.\$VLANID" >> iscsi_script
       echo "    #iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS -o update -n iface.hwaddress -v \$MAC_ADDRESS" >> iscsi_script
       echo "  else" >> iscsi_script
       echo "    iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS -o update -n iface.net_ifacename -v \$INTERFACE" >> iscsi_script
       echo "    #iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS -o update -n iface.hwaddress -v \$MAC_ADDRESS" >> iscsi_script
       echo "  fi" >> iscsi_script
       echo "  iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS -o update -n iface.transport_name -v tcp" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME -p [\$TARGET_IP_ADDRESS]:\$TARGET_TCP_PORT\$CTGPT -I iface_brcm\$MAC_ADDRESS -o new" >> iscsi_script
       echo "  TARGET_PORTAL=[\$TARGET_IP_ADDRESS]:\$TARGET_TCP_PORT\$CTGPT" >> iscsi_script
       echo "else" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_IP_ADDRESS:\$TARGET_TCP_PORT\$CTGPT -o new" >> iscsi_script
       echo "  TARGET_PORTAL=\$TARGET_IP_ADDRESS:\$TARGET_TCP_PORT\$CTGPT" >> iscsi_script
       echo "fi" >> iscsi_script
       echo "iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -o update -n node.startup -v automatic" >> iscsi_script
       echo "iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -o update -n node.conn[0].startup -v automatic" >> iscsi_script
       echo "if [ \$AUTHEN_MODE == \"CHAP\" ]; then" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -o update -n node.session.auth.authmethod -v \$AUTHEN_MODE" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -o update  -n node.session.auth.username -v \$INITIATOR_ID" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -o update -n node.session.auth.password -v \$INITIATOR_PW" >> iscsi_script
       echo "  # Check if Mutual CHAP is enabled by the existence of \$TARGET_ID" >> iscsi_script
       echo "  if [ -z \$TARGET_ID ]; then" >> iscsi_script
       echo "    echo" >> iscsi_script
       echo "  else" >> iscsi_script
       echo "    iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -o update -n node.session.auth.username_in -v \$TARGET_ID" >> iscsi_script
       echo "    iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -o update -n node.session.auth.password_in -v \$TARGET_PW" >> iscsi_script
       echo "  fi" >> iscsi_script
       echo "fi" >> iscsi_script
       echo "if [ \$IPV6 -ge '1' ]; then" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -I iface_brcm\$MAC_ADDRESS -l" >> iscsi_script
       echo "else" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME -p \$TARGET_PORTAL -l" >> iscsi_script
       echo "fi" >> iscsi_script
       echo "sleep 9" >> iscsi_script
     fi
     #echo "echo \"END - LOAD NON-OFFLOAD MODULES OPENISCSI\" " >> iscsi_script
     echo "echo \" \"" >> iscsi_script
    }
  #......................... End - load_nonoffload_openiscsi function .....................

  create_nonoffload_secondary_target ()
    {
     echo "if [ \$MAC_ADDRESS2 != \"00:00:00:00:00:00\" ]; then " >> iscsi_script
     if [ \( $OS$VER == 'RedHat5' \) -o \( $OS$VER == 'RedHat6' \) ]; then
       echo "if [ \$IPV62 == '0' ]; then" >> iscsi_script
       echo "  echo \"Starting iSCSI session\"" >> iscsi_script
       echo "  if [ \$AUTHEN_MODE2 == \"CHAP\" ]; then" >> iscsi_script
       echo "    if [ -n \$TARGET_ID2 ]; then" >> iscsi_script
       echo "      /bin/iscsistart --initiatorname=\$INITIATOR_NAME --tgpt=$TGPT --targetname=\$TARGET_NAME2 --address=\$TARGET_IP_ADDRESS2 --port=\$TARGET_TCP_PORT2 --username=\$INITIATOR_ID2 --password=\$INITIATOR_PW2 --username_in=\$TARGET_ID2 --password_in=\$TARGET_PW2" >> iscsi_script
       echo "    else" >> iscsi_script
       echo "      /bin/iscsistart --initiatorname=\$INITIATOR_NAME --tgpt=$TGPT --targetname=\$TARGET_NAME2 --address=\$TARGET_IP_ADDRESS2 --port=\$TARGET_TCP_PORT2 --username=\$INITIATOR_ID2 --password=\$INITIATOR_PW2" >> iscsi_script
       echo "    fi" >> iscsi_script
       echo "  else" >> iscsi_script
       echo "    /bin/iscsistart --initiatorname=\$INITIATOR_NAME --tgpt=$TGPT --targetname=\$TARGET_NAME2 --address=\$TARGET_IP_ADDRESS2 --port=\$TARGET_TCP_PORT2" >> iscsi_script
       echo "  fi" >> iscsi_script
       echo "  sleep 5" >> iscsi_script
       echo "else" >> iscsi_script
       echo "  echo \"root:x:0:0:root:/root:/bin/bash\" > /etc/passwd" >> iscsi_script
       echo "  echo \"Starting iSCSI daemon\"" >> iscsi_script
       echo "  /sbin/iscsid -c /etc/iscsi/iscsid.conf -f &" >> iscsi_script
       echo "  sleep 5" >> iscsi_script
       echo "  ISCSI_VER=\`iscsid -v | awk '{print \$3}' | awk '{gsub(/2.0-/,\"\"); print \$1}'\`" >> iscsi_script
       echo "  CTGPT=\"\"" >> iscsi_script
       echo "  iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS2 -o new" >> iscsi_script
       echo "  if [ \$VLANID2 != '0' ]; then" >> iscsi_script
       echo "    iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS2 -o update -n iface.net_ifacename -v \$INTERFACE2.\$VLANID2" >> iscsi_script
       echo "    #iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS2 -o update -n iface.hwaddress -v \$MAC_ADDRESS2" >> iscsi_script
       echo "  else" >> iscsi_script
       echo "    iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS2 -o update -n iface.net_ifacename -v \$INTERFACE2" >> iscsi_script
       echo "    #iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS2 -o update -n iface.hwaddress -v \$MAC_ADDRESS2" >> iscsi_script
       echo "  fi" >> iscsi_script
       echo "  iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS2 -o update -n iface.transport_name -v tcp" >> iscsi_script

       echo "  iscsiadm -m node -T \$TARGET_NAME2 -p [\$TARGET_IP_ADDRESS2]:\$TARGET_TCP_PORT2\$CTGPT -I iface_brcm\$MAC_ADDRESS2 -o new" >> iscsi_script
       echo "  TARGET_PORTAL=[\$TARGET_IP_ADDRESS2]:\$TARGET_TCP_PORT2\$CTGPT" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -o update -n node.startup -v automatic" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -o update -n node.conn[0].startup -v automatic" >> iscsi_script
       echo "  if [ \$AUTHEN_MODE2 == \"CHAP\" ]; then" >> iscsi_script
       echo "    iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -o update -n node.session.auth.authmethod -v \$AUTHEN_MODE2" >> iscsi_script
       echo "    iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -o update  -n node.session.auth.username -v \$INITIATOR_ID2" >> iscsi_script
       echo "    iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -o update -n node.session.auth.password -v \$INITIATOR_PW2" >> iscsi_script
       echo "# Check if Mutual CHAP is enabled by the existence of \$TARGET_ID" >> iscsi_script
       echo "    if [ -z \$TARGET_ID2 ]; then" >> iscsi_script
       echo "      echo" >> iscsi_script
       echo "    else" >> iscsi_script
       echo "      iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -o update -n node.session.auth.username_in -v \$TARGET_ID2" >> iscsi_script
       echo "      iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -o update -n node.session.auth.password_in -v \$TARGET_PW2" >> iscsi_script
       echo "    fi" >> iscsi_script
       echo "  fi" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -I iface_brcm\$MAC_ADDRESS2 -l" >> iscsi_script
       echo "  sleep 9" >> iscsi_script
       echo "fi" >> iscsi_script
     fi

     if [ \( $OS$VER == 'SuSE10' \) -o \( $OS$VER == 'SuSE11' \) ]; then
       echo "echo \"Starting iSCSI daemon\"" >> iscsi_script
       echo "/sbin/iscsid -c /etc/iscsi/iscsid.conf -f &" >> iscsi_script
       echo "sleep 5" >> iscsi_script
       echo "ISCSI_VER=\`iscsid -v | awk '{print \$3}' | awk '{gsub(/2.0-/,\"\"); print \$1}'\`" >> iscsi_script
       echo "if [ \$ISCSI_VER -ge '865' ]; then" >> iscsi_script
       echo "  CTGPT=,$TGPT" >> iscsi_script
       echo "else" >> iscsi_script
       echo "  CTGPT=\"\"" >> iscsi_script
       echo "fi" >> iscsi_script
    
       echo "if [ \$IPV62 -ge '1' ]; then" >> iscsi_script
       echo "  iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS2 -o new" >> iscsi_script
       echo "  if [ \$VLANID2 != '0' ]; then" >> iscsi_script
       echo "    iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS2 -o update -n iface.net_ifacename -v \$INTERFACE2.\$VLANID2" >> iscsi_script
       echo "    #iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS2 -o update -n iface.hwaddress -v \$MAC_ADDRESS2" >> iscsi_script
       echo "  else" >> iscsi_script
       echo "    iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS2 -o update -n iface.net_ifacename -v \$INTERFACE2" >> iscsi_script
       echo "    #iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS2 -o update -n iface.hwaddress -v \$MAC_ADDRESS2" >> iscsi_script
       echo "  fi" >> iscsi_script
       echo "  iscsiadm -m iface -I iface_brcm\$MAC_ADDRESS2 -o update -n iface.transport_name -v tcp" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME2 -p [\$TARGET_IP_ADDRESS2]:\$TARGET_TCP_PORT2\$CTGPT -I iface_brcm\$MAC_ADDRESS2 -o new" >> iscsi_script
       echo "  TARGET_PORTAL=[\$TARGET_IP_ADDRESS2]:\$TARGET_TCP_PORT2\$CTGPT" >> iscsi_script
       echo "else" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_IP_ADDRESS2:\$TARGET_TCP_PORT2\$CTGPT -o new" >> iscsi_script
       echo "  TARGET_PORTAL=\$TARGET_IP_ADDRESS2:\$TARGET_TCP_PORT2\$CTGPT" >> iscsi_script
       echo "fi" >> iscsi_script
       echo "iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -o update -n node.startup -v automatic" >> iscsi_script
       echo "iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -o update -n node.conn[0].startup -v automatic" >> iscsi_script
       echo "if [ \$AUTHEN_MODE2 == \"CHAP\" ]; then" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -o update -n node.session.auth.authmethod -v \$AUTHEN_MODE2" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -o update  -n node.session.auth.username -v \$INITIATOR_ID2" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -o update -n node.session.auth.password -v \$INITIATOR_PW2" >> iscsi_script
       echo "  # Check if Mutual CHAP is enabled by the existence of \$TARGET_ID" >> iscsi_script
       echo "  if [ -z \$TARGET_ID2 ]; then" >> iscsi_script
       echo "    echo" >> iscsi_script
       echo "  else" >> iscsi_script
       echo "    iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -o update -n node.session.auth.username_in -v \$TARGET_ID2" >> iscsi_script
       echo "    iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -o update -n node.session.auth.password_in -v \$TARGET_PW2" >> iscsi_script
       echo "  fi" >> iscsi_script
       echo "fi" >> iscsi_script
       echo "if [ \$IPV62 -ge '1' ]; then" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -I iface_brcm\$MAC_ADDRESS2 -l" >> iscsi_script
       echo "else" >> iscsi_script
       echo "  iscsiadm -m node -T \$TARGET_NAME2 -p \$TARGET_PORTAL -l" >> iscsi_script
       echo "fi" >> iscsi_script
       echo "sleep 9" >> iscsi_script
     fi
     #echo "echo \"END - LOAD NON-OFFLOAD MODULES OPENISCSI\" " >> iscsi_script
     echo "echo \" \"" >> iscsi_script
      echo "fi" >> iscsi_script
    }


  #........................ Start - load_nonoffload_linuxiscsi function ...................
  load_nonoffload_linuxiscsi ()
    {
     echo "echo \" \"" >> iscsi_script
     #echo "echo \"BEGIN - LOAD NON-OFFLOAD MODULES LINUXISCSI\" " >> iscsi_script
     echo "echo \"InitiatorName=\$INITIATOR_NAME\" > /etc/initiatorname.iscsi" >> iscsi_script
     echo "echo \"DiscoveryAddress=\$TARGET_IP_ADDRESS\" > /etc/iscsi.conf" >> iscsi_script
     echo "if [ \$AUTHEN_MODE == \"CHAP\" ]; then" >> iscsi_script
     echo "  echo \"  OutgoingUsername=\$INITIATOR_ID\" >> /etc/iscsi.conf" >> iscsi_script
     echo "  echo \"  OutgoingPassword=\$INITIATOR_PW\" >> /etc/iscsi.conf" >> iscsi_script
     echo "  # Check if Mutual CHAP is enabled by the existence of \$TARGET_ID" >> iscsi_script
     echo "  if [ -z \$TARGET_ID ]; then" >> iscsi_script
     echo "    echo" >> iscsi_script
     echo "  else" >> iscsi_script
     echo "    echo \"DiscoveryAddress=\$TARGET_IP_ADDRESS\" >> /etc/iscsi.conf" >> iscsi_script
     echo "    echo \"  IncomingUsername=\$TARGET_ID\" >> /etc/iscsi.conf" >> iscsi_script
     echo "    echo \"  IncomingPassword=\$TARGET_PW\" >> /etc/iscsi.conf" >> iscsi_script
     echo "  fi" >> iscsi_script
     echo "fi" >> iscsi_script
     echo "echo \"Enabled=No\" >> /etc/iscsi.conf" >> iscsi_script
     echo "echo \"TargetName=\$TARGET_NAME\" >> /etc/iscsi.conf" >> iscsi_script
     echo "echo \"Enabled=Yes\" >> /etc/iscsi.conf" >> iscsi_script
     echo "" >> iscsi_script
     if [ $OS$VER == 'SuSE9' ]; then
       echo "insmod /lib/iscsi.ko > /dev/null 2>&1" >> iscsi_script
     fi
     if [ $OS$VER == 'RedHat4' ]; then
       echo "insmod /lib/libcrc32c.ko > /dev/null 2>&1" >> iscsi_script 
       echo "insmod /lib/crc32c.ko > /dev/null 2>&1" >> iscsi_script 
       echo "insmod /lib/md5.ko > /dev/null 2>&1" >> iscsi_script 
       echo "insmod /lib/scsi_transport_iscsi.ko > /dev/null 2>&1" >> iscsi_script 
       echo "insmod /lib/iscsi_sfnet.ko > /dev/null 2>&1" >> iscsi_script 
     fi
     echo "" >> iscsi_script
     echo "sleep 2" >> iscsi_script
     echo "" >> iscsi_script
     echo "if [ -e \"/dev/iscsictl\" ]; then" >> iscsi_script
     echo "  rm /dev/iscsictl" >> iscsi_script
     echo "fi" >> iscsi_script
     echo "" >> iscsi_script
     echo "# Following code snippet taken from '/etc/init.d/iscsi' to start linux-iscsi daemon." >> iscsi_script
     echo "if [ ! -f /dev/iscsictl ]; then" >> iscsi_script
     echo "	while read major device " >> iscsi_script
     echo "	do" >> iscsi_script
     echo "	if [ \"\$device\" == \"iscsictl\" ]; then" >> iscsi_script
     echo "	  mknod /dev/\$device c \$major 0" >> iscsi_script
     echo "	fi" >> iscsi_script
     echo "	done < /proc/devices" >> iscsi_script
     echo "fi" >> iscsi_script
     echo "" >> iscsi_script
     echo "echo -n \"Starting iscsid: \" " >> iscsi_script
     echo "/sbin/iscsid -f /etc/iscsi.conf" >> iscsi_script
     echo "# Allow iscsid time to complete startup" >> iscsi_script
     echo "sleep 2" >> iscsi_script
     #echo "echo \"END - LOAD NON-OFFLOAD MODULES LINUXISCSI\" " >> iscsi_script
     echo "echo \" \"" >> iscsi_script

    }
  #........................ End - load_nonoffload_linuxiscsi function ....................

run_query_iscsi

load_NIC_drivers

load_generic_modules

load_generic_modules2

if [ \( $INITIATOR == '1' \) -a \( \( $OS$VER == 'RedHat5' \) -o \( $OS$VER == 'RedHat6' \) -o \( $DISTRO == 'SuSE111' \) -o \( $DISTRO == 'SuSE112' \) \) ]; then
  load_offload_modules
  create_secondary_iface
  create_secondary_target
elif [ \( $INITIATOR == '0' \) -a \( \( $OS$VER == 'RedHat5' \) -o \( $OS$VER == 'RedHat6' \) -o \( $OS$VER == 'SuSE10' \) -o \( $OS$VER == 'SuSE11' \) \) ]; then
  load_nonoffload_openiscsi
  create_nonoffload_secondary_target
elif [ \( $INITIATOR == '0' \) -a \( $OS$VER == 'RedHat4' \) ]; then
  load_nonoffload_linuxiscsi
else
  echo "ERROR: unsupported OS...exiting"
  exit
fi  
}
#**************************** End - iSCSI Script Creation function **********************




#****************************** Start - build_query_iscsi function ***********************
build_query_iscsi ()
{
 HOME=`pwd`
 # Build query_iscsi utility if file is not detected
 if [ ! -e $HOME/query_iscsi/query_iscsi ]; then
   if [ ! -e $HOME/query_iscsi.tar ]; then
     echo "ERROR: Unable to locate query_iscsi.tar file."
     echo "       Please copy file to the current directory"
     rm iscsi_script
     exit
   else
     tar -xf $HOME/query_iscsi.tar > /dev/null
     cd $HOME/query_iscsi
     make clean > /dev/null
     make > /dev/null
     cd $HOME
   fi
 fi

 MOUNT=/mnt/iscsiboot
}
#******************************** End - build_query_iscsi function ************************



#*************************** Start - create_initrd_img function ***************************
create_initrd_img ()
{
  #.......................... Start - copy_common_files function ...........................
  copy_common_files ()
    {    
     # For RedHat6, run 'dracut' utility to create initrd-*.img
     if [ $OS$VER == 'RedHat6' ]; then
       if [ $TG3 -ge '1' ]; then
         RH6TG3=tg3
       fi
       if [ $BNX2 -ge '1' ]; then
         RH6BNX2=bnx2
       fi
       if [ $BNX2X -ge '1' ]; then
         RH6BNX2X=bnx2x
         RH6MDIO=mdio
         RH6LIBCRC32C=libcrc32c
       fi
       if [ -e /boot/initramfs-`uname -r`.img ]; then
         mv /boot/initramfs-`uname -r`.img /boot/initramfs-`uname -r`.org
       fi

       dracut --add-drivers "8021q $RH6TG3 $RH6BNX2 $RH6BNX2X $RH6MDIO $RH6LIBCRC32C iscsi_tcp libiscsi_tcp ib_iser ipv6" --install "/sbin/iscsid /sbin/iscsiadm /sbin/iscsi-iname /sbin/iscsistart /bin/bash /bin/awk /bin/cut /sbin/ifconfig /sbin/route" --force
         mv /boot/initramfs-`uname -r`.img /boot/initrd-`uname -r`.img
         mv /boot/initramfs-`uname -r`.org /boot/initramfs-`uname -r`.img
     fi
     # Create and prepare folder to hold the initrd image files
     UNAME=`uname -r`
     INIT=init
     if [ $OS$VER == 'SuSE11' ]; then
       INIT=run_all.sh
     fi
 
     if [ \( $OS$VER == 'SuSE10' \) -o \( $OS$VER == 'SuSE11' \) ]; then
       gzip -q -d < /boot/initrd-$UNAME > $HOME/initrd.img
     else
       gzip -q -d < /boot/initrd-$UNAME.img > $HOME/initrd.img
       if [ \( $OS$VER == 'RedHat6' \) ]; then
         if [ -e /boot/initrd-`uname -r`.img ]; then
           rm -fr /boot/initrd-`uname -r`.img
         fi
       fi
     fi
  
     mkdir $MOUNT
     cd  $MOUNT
     cpio -idum < $HOME/initrd.img
     rm $HOME/initrd.img
     cd $HOME

     # Copy IPv6 support modules
     if [ $OS$VER == 'RedHat5' ]; then
       if [ $UPGRADE -ge '4' ]; then
         cp /lib/modules/`uname -r`/kernel/crypto/crypto_api.ko $MOUNT/lib
         cp /lib/modules/`uname -r`/kernel/net/xfrm/xfrm_nalgo.ko $MOUNT/lib
       fi
     fi

     if [ $DISTRO == 'SuSE112' ]; then
       cp /lib/modules/`uname -r`/kernel/net/ipv6/ipv6_lib.ko $MOUNT/lib
     fi
     cp /lib/modules/`uname -r`/kernel/net/ipv6/ipv6.ko $MOUNT/lib

     # Copy VLAN support modules
     cp /lib/modules/`uname -r`/kernel/net/8021q/8021q.ko $MOUNT/lib
     if [ $OS == 'SuSE' ]; then
       if [ $OS$VER == 'SuSE11' ]; then
	       if [ \( $DISTRO == 'SuSE111' \) -o \( $DISTRO == 'SuSE112' \) ]; then
           cp /lib/modules/`uname -r`/kernel/net/llc/llc.ko $MOUNT/lib
         fi
         cp /lib/modules/`uname -r`/kernel/net/802/stp.ko $MOUNT/lib
         cp /lib/modules/`uname -r`/kernel/net/802/garp.ko $MOUNT/lib
         cp /sbin/vconfig $MOUNT/bin
       elif [ \( $OS$VER == 'SuSE10' \) ]; then
         cp /usr/sbin/vconfig $MOUNT/bin
       fi
     elif [ $OS == 'RedHat' ]; then
       if [ $OS$VER == 'RedHat6' ]; then
	 cp /lib/modules/`uname -r`/kernel/net/llc/llc.ko $MOUNT/lib
         cp /lib/modules/`uname -r`/kernel/net/802/stp.ko $MOUNT/lib
         cp /lib/modules/`uname -r`/kernel/net/802/garp.ko $MOUNT/lib
       fi
       cp /sbin/vconfig $MOUNT/bin
     else
       echo
     fi

     # Copy query_iscsi utility
     cp $HOME/query_iscsi/query_iscsi $MOUNT/bin

     # Copy common utilties and modules
     if [ \( $OS$VER == 'RedHat5' \) -o \( $OS$VER == 'RedHat6' \) -o \( $OS$VER == 'SuSE10' \) -o \( $OS$VER == 'SuSE11' \) ]; then
       # Create lib folder
       if [ \( $ARCH == 'x86_64' \) -a \( $OS$VER == 'RedHat5' \) ]; then
         mkdir $MOUNT/lib$X64
       fi

       if [ $ARCH == 'x86_64' ]; then
         cp /lib64/ld-linux-x86-64.so.2 $MOUNT/lib64 2> /dev/null
       else
         cp /lib/ld-linux.so.2 $MOUNT/lib
       fi

       if [ $INITIATOR == '1' ]; then
         cp /usr/bin/tail $MOUNT/bin
         cp /usr/bin/cut $MOUNT/bin
         cp /bin/dmesg $MOUNT/bin
         cp /bin/mknod $MOUNT/bin
	 if [ \( $DISTRO == 'RedHat54' \) ]; then
           cp /bin/chmod $MOUNT/bin
         fi
	 if [ \( $DISTRO == 'RedHat55' \) ]; then
           cp /bin/chmod $MOUNT/bin
         fi
         if [ \( $DISTRO == 'RedHat56' \) ]; then
           cp /bin/chmod $MOUNT/bin
         fi
         if [ \( $DISTRO == 'RedHat57' \) ]; then
           cp /bin/chmod $MOUNT/bin
         fi
         if [ \( $DISTRO == 'RedHat58' \) ]; then
           cp /bin/chmod $MOUNT/bin
         fi
	 if [ \( $DISTRO == 'RedHat60' \) ]; then
           cp /bin/chmod $MOUNT/bin
         fi
         if [ \( $DISTRO == 'RedHat61' \) ]; then
           cp /bin/chmod $MOUNT/bin
         fi
         if [ \( $DISTRO == 'RedHat62' \) ]; then
           cp /bin/chmod $MOUNT/bin
         fi
       fi

       if [ \( $OS$VER == 'RedHat5' \) -o \( $OS$VER == 'RedHat6' \)  ]; then
         cp /bin/rm $MOUNT/bin
         cp /bin/sleep $MOUNT/bin
         cp /bin/sh $MOUNT/bin
         cp /usr/bin/killall $MOUNT/bin
         cp /lib$X64/libselinux.so.1 $MOUNT/lib$X64
         cp /lib$X64/libpthread.so.0 $MOUNT/lib$X64 2> /dev/null
         cp /lib$X64/librt.so.1 $MOUNT/lib$X64 2> /dev/null
         cp /lib$X64/libpcre.so.0 $MOUNT/lib$X64 2> /dev/null
         cp /lib$X64/libsepol.so.1 $MOUNT/lib$X64
         if [ $OS$VER == 'RedHat5' ]; then
           cp /lib$X64/libtermcap.so.2 $MOUNT/lib$X64
           cp /usr/lib$X64/libreadline.so.5 $MOUNT/lib$X64
         fi
         cp /lib$X64/libnss* $MOUNT/lib$X64 2> /dev/null
         if [ $UPGRADE -ge '4' ]; then
           cp /lib$X64/libgcc_s.so.1 $MOUNT/lib$X64
         fi
         if [ $OS$VER == 'RedHat6' ]; then
           cp /lib$X64/libidn.so.11 $MOUNT/lib$X64
           cp /lib$X64/libncurses.so.5 $MOUNT/lib$X64
           cp /sbin/insmod $MOUNT/bin
         fi
       fi

       cp /lib$X64/libm.so.6 $MOUNT/lib$X64 2> /dev/null
       cp /lib$X64/libc.so.6 $MOUNT/lib$X64 2> /dev/null
       cp /lib$X64/libdl.so.2 $MOUNT/lib$X64 2> /dev/null
       cp /usr/lib$X64/libz.so.1 $MOUNT/lib$X64 2> /dev/null
       cp /lib$X64/libcrypto.so.6 $MOUNT/lib$X64 2> /dev/null

       if [ $OS$VER != 'RedHat6' ]; then
         cp /lib$X64/libresolv.so.2 $MOUNT/lib$X64
       fi       

       cp /sbin/ifconfig $MOUNT/bin

       cp /bin/grep $MOUNT/bin
       
       cp /usr/bin/tr $MOUNT/bin
       cp /bin/gawk $MOUNT/bin
       if [ $DISTRO == 'SuSE112' ]; then
         cp /sbin/rmmod $MOUNT/bin
       fi
       
       if [ $OS$VER == 'RedHat6' ]; then
         sleep 0
       else
         cp /bin/awk $MOUNT/bin
         cp /bin/bash $MOUNT/bin
       fi

       cp /sbin/route $MOUNT/bin

       cp /usr/bin/bc $MOUNT/bin

       cp /usr/bin/seq $MOUNT/bin
      
       cp /bin/ping $MOUNT/bin

       cp /bin/ping6 $MOUNT/bin
     elif [ \( $OS$VER == 'RedHat4' \) ]; then
       #Red Hat 4
       cp /sbin/iscsid $MOUNT/sbin

       cp /sbin/ifconfig $MOUNT/bin

       cp /bin/ksh $MOUNT/bin

       cp /sbin/route $MOUNT/bin

       mkdir -p $MOUNT/var/run

       if [ $OS$VER == 'RedHat4' ]; then
	   if [ \( $ARCH == 'x86_64' \) ]; then
           mkdir $MOUNT/lib$X64
           cp /lib64/ld-linux-x86-64.so.2 $MOUNT/lib64
         else
           cp /lib/ld-linux.so.2 $MOUNT/lib
         fi

         cp /bin/rm $MOUNT/bin

         cp /bin/mknod $MOUNT/bin

         cp /lib$X64/libselinux.so.1 $MOUNT/lib$X64

         cp /usr/lib$X64/libsysfs.so.1 $MOUNT/lib$X64

         cp /bin/sleep $MOUNT/bin

         mkdir $MOUNT/lib$X64/tls

         cp /lib$X64/tls/libc.so.6 $MOUNT/lib$X64/tls

         cp /lib$X64/tls/libm.so.6 $MOUNT/lib$X64/tls

         cp /lib$X64/tls/libpthread.so.0 $MOUNT/lib$X64/tls

         cp /lib$X64/tls/librt.so.1 $MOUNT/lib$X64/tls

         cp /lib$X64/libpcre.so.0 $MOUNT/lib$X64
       fi
     fi

     if [ \( $OS$VER == 'RedHat6' \) -o \( $OS$VER == 'RedHat5' \) -o \( $OS$VER == 'SuSE11' \) ]; then
       cp /sbin/ethtool $MOUNT/bin
     else
       cp /usr/sbin/ethtool $MOUNT/bin
     fi

     # Modify init/linuxrc file
     if [ $OS$VER == 'SuSE10' ]; then
       INSERTION_LINE=`cat $MOUNT/$INIT | grep -n sd_mod | grep modprobe | awk '{print $1}' | awk '{gsub(/\:modprobe/,""); print}'`
       PARAM_PASS_INSERTION_LINE=`cat $MOUNT/$INIT | grep -n iscsid | grep kill | awk '{print $1}' | cut -d : -f 1`
     elif [ $OS$VER == 'SuSE11' ]; then
       INSERTION_LINE=`cat $MOUNT/$INIT | grep -m 1 -n 11-usb.sh | awk '{print $1}' | awk '{gsub(/\:\[/,""); print}'`
       KILL_ISCSID_LINE=`cat $MOUNT/$INIT | grep -m 1 -n 91-killudev.sh | awk '{print $1}' | awk '{gsub(/\:\[/,""); print}'`
     elif [ $OS$VER == 'RedHat6' ]; then
       INSERTION_LINE=`cat $MOUNT/$INIT | grep -n pre-trigger | grep source_all| awk '{print $1}' | awk '{gsub(/\:source_all/,""); print}'`
     else
       INSERTION_LINE=`cat $MOUNT/$INIT | grep -n sd_mod.ko | grep insmod | awk '{print $1}' | awk '{gsub(/\:insmod/,""); print}'`
     fi

     # Check if /dev/mem node is created
     DEVMEM=`cat $MOUNT/$INIT | grep -i -c /dev/mem`
     if [ $DEVMEM == '0' ]; then
       MEM_INSERTION_LINE=`cat $MOUNT/$INIT | grep -n /dev/null -m 1 | awk '{print $1}' | awk '{gsub(/\:mknod/,""); print}'`
     fi

     # For SuSE 11 or RedHat6, no need to add this node
     if [ \( $OS$VER == 'SuSE11' \) -o \( $OS$VER == 'RedHat6' \) ]; then
       DEVMEM=1
     fi
  
     if [ $OS$VER == 'SuSE11' ]; then
       echo $INSERTION_LINE"i ./iscsi_script" > sed.cmd
     else
       echo $INSERTION_LINE"a ./iscsi_script" > sed.cmd
     fi

     sed -f sed.cmd $MOUNT/$INIT > $MOUNT/$INIT.mod

     rm sed.cmd

     if [ $OS$VER == 'SuSE11' ]; then
       echo $KILL_ISCSID_LINE"i iscsid_pid=\`pidof iscsid\`; kill -TERM \$iscsid_pid;" > sed.cmd
       sed -f sed.cmd $MOUNT/$INIT.mod > $MOUNT/$INIT.mod2
       rm sed.cmd
       mv $MOUNT/$INIT.mod2 $MOUNT/$INIT.mod
     fi

     if [ $OS$VER == 'SuSE11' ]; then
       echo $KILL_ISCSID_LINE"i iscsiuio_pid=\`pidof iscsiuio\`; kill -9 \$iscsiuio_pid;" > sed.cmd
       sed -f sed.cmd $MOUNT/$INIT.mod > $MOUNT/$INIT.mod2
       rm sed.cmd
       mv $MOUNT/$INIT.mod2 $MOUNT/$INIT.mod
     fi

     if [ $DISTRO == 'SuSE112' ]; then
       INITMOD=$INIT.mod
       ISCSISH=`cat  $MOUNT/$INITMOD | grep -m 1 -n 13-iscsi.sh | awk '{print $1}' | awk '{gsub(/\:\[/, ""); print}'`
       if [ $ISCSISH ]; then 
         ISCSISH_COMMENT_LINE=`cat $MOUNT/$INITMOD | grep -m 1 -n 13-iscsi.sh | awk '{print $1}' | awk '{gsub(/\:\[/,""); print}'`
         echo $ISCSISH_COMMENT_LINE"i # Direct DVD installation to iSCSI target detected... \\n# For BRCM iSCSI Boot created INITRD, 13-iscsi.sh script will not be executed \\n# to prevent duplicate session connections." > sed.cmd
         sed -f sed.cmd $MOUNT/$INIT.mod > $MOUNT/$INIT.mod2
         rm sed.cmd
         mv $MOUNT/$INIT.mod2 $MOUNT/$INIT.mod
         ## Rename 13-iscsi.sh to prevent it from being run
         mv $MOUNT/boot/13-iscsi.sh $MOUNT/boot/13-iscsi.sh.org
       fi
     fi

     if [ $DISTRO == RedHat58 ]; then
       INITMOD=$INIT.mod
       FLAG=0
       NETNAME=`cat $MOUNT/$INITMOD | grep -m 1 -n netname | awk '{print $1}' | awk '{gsub(/\:netname/,""); print}'` 
       NETWORK=`cat $MOUNT/$INITMOD | grep -m 1 -n network | awk '{print $1}' | awk '{gsub(/\:network/,""); print}'` 
       ISCSISTART=`cat $MOUNT/$INITMOD | grep -m 1 -n iscsistart | awk '{print $1}' | awk '{gsub(/\:\/bin\/iscsistart/,""); print}'` 

       BRINGING=`cat $MOUNT/$INITMOD | grep -m 1 -n Bringing | awk '{print $1}' | awk '{gsub(/\:echo/,""); print}'` 
       ATTACHING=`cat $MOUNT/$INITMOD | grep -m 1 -n Attaching | awk '{print $1}' | awk '{gsub(/\:echo/,""); print}'` 

       if [ $NETNAME ]; then
         echo $NETNAME"s/^/#/" > sed.cmd
         sed -f sed.cmd $MOUNT/$INIT.mod > $MOUNT/$INIT.mod2
         rm sed.cmd
         mv $MOUNT/$INIT.mod2 $MOUNT/$INIT.mod
         FLAG=1
       fi
       if [ $NETWORK ]; then
         echo $NETWORK"s/^/#/" > sed.cmd
         sed -f sed.cmd $MOUNT/$INIT.mod > $MOUNT/$INIT.mod2
         rm sed.cmd
         mv $MOUNT/$INIT.mod2 $MOUNT/$INIT.mod
         FLAG=1
       fi
       if [ $ISCSISTART ]; then
         echo $ISCSISTART"s/^/#/" > sed.cmd
         sed -f sed.cmd $MOUNT/$INIT.mod > $MOUNT/$INIT.mod2
         rm sed.cmd
         mv $MOUNT/$INIT.mod2 $MOUNT/$INIT.mod
         FLAG=1
       fi
       if [ $BRINGING ]; then
           echo $BRINGING"s/^/#/" > sed.cmd
           sed -f sed.cmd $MOUNT/$INIT.mod > $MOUNT/$INIT.mod2
           rm sed.cmd
           mv $MOUNT/$INIT.mod2 $MOUNT/$INIT.mod
       fi
       if [ $ATTACHING ]; then
           echo $ATTACHING"s/^/#/" > sed.cmd
           sed -f sed.cmd $MOUNT/$INIT.mod > $MOUNT/$INIT.mod2
           rm sed.cmd
           mv $MOUNT/$INIT.mod2 $MOUNT/$INIT.mod
       fi
##       if [ $FLAG == '1' ]; then
##         echo $NETNAME"i # Direct DVD installation to iSCSI target detected... \\n# For BRCM iSCSI Boot created INITRD, do not allow init to bring up interface \\n# to prevent duplicate session connections." > sed.cmd
##         sed -f sed.cmd $MOUNT/$INIT.mod > $MOUNT/$INIT.mod2
##         rm sed.cmd
##         mv $MOUNT/$INIT.mod2 $MOUNT/$INIT.mod
##       fi
     fi


     rm $MOUNT/$INIT
     mv $MOUNT/$INIT.mod $MOUNT/$INIT

     if [ $OS$VER == 'SuSE10' ]; then
       echo $PARAM_PASS_INSERTION_LINE"a cp --force -r /etc/iscsi/nodes/* /root/etc/iscsi/nodes" > sed.cmd
       sed -f sed.cmd $MOUNT/$INIT > $MOUNT/$INIT.mod
       rm sed.cmd
       rm $MOUNT/$INIT
       mv $MOUNT/$INIT.mod $MOUNT/$INIT
     fi

     if [ $DEVMEM == '0' ]; then
       echo $MEM_INSERTION_LINE"a mknod /dev/mem c 1 1" > sed.cmd
       sed -f sed.cmd $MOUNT/$INIT > $MOUNT/$INIT.mod
       rm sed.cmd
       rm $MOUNT/$INIT
       mv $MOUNT/$INIT.mod $MOUNT/$INIT
     fi

     if [ \( \( $OS$VER == 'RedHat6' \) -o \( $OS$VER == 'RedHat5' \) \) ]; then
       if [ $OS$VER == 'RedHat5' ]; then
         INSERTION_LINE=`cat $MOUNT/$INIT | grep -n -i Switching | grep to | grep new | grep root | awk '{print $1}' | awk '{gsub(/\:echo/,""); print}'`
       else
         INSERTION_LINE=`cat $MOUNT/$INIT | grep -n -i Switching | grep root | awk '{print $1}' | awk '{gsub(/\:info/,""); print}'`
       fi
      
       echo $INSERTION_LINE"a killall -9 iscsiuio" > sed.cmd
       sed -f sed.cmd $MOUNT/$INIT > $MOUNT/$INIT.mod
       rm sed.cmd
       rm $MOUNT/$INIT
       mv $MOUNT/$INIT.mod $MOUNT/$INIT
     fi

     if [ \( \( $OS$VER == 'RedHat6' \) -o \( $OS$VER == 'RedHat5' \) \) ]; then
       let INSERTION_LINE=$INSERTION_LINE+1
       echo $INSERTION_LINE"a killall -9 iscsid" > sed.cmd
       sed -f sed.cmd $MOUNT/$INIT > $MOUNT/$INIT.mod
       rm sed.cmd
       rm $MOUNT/$INIT
       mv $MOUNT/$INIT.mod $MOUNT/$INIT
     fi

     chmod 755 $MOUNT/$INIT

     chmod 755 iscsi_script

     cp iscsi_script $MOUNT
     if [ $OS$VER == 'RedHat6' ]; then
       chmod 777 $MOUNT/iscsi_script
     fi
    }
  #........................... End - copy_common_files function ..........................


  #.......................... Start - copy_offload_files function.........................
  copy_offload_files ()
    {
     # Copy Adapter L2 Driver Files
     if [ $BNX2 != '0' ]; then
       if [ -e /lib/modules/`uname -r`/extras/bnx2.ko ]; then
         cp /lib/modules/`uname -r`/extras/bnx2.ko $MOUNT/lib;
       elif [ -e /lib/modules/`uname -r`/updates/bnx2.ko ]; then
         cp /lib/modules/`uname -r`/updates/bnx2.ko $MOUNT/lib;
       else
         cp /lib/modules/`uname -r`/kernel/drivers/net/bnx2.ko $MOUNT/lib
         if [ \( $DISTRO == 'SuSE112' \) ]; then
           mkdir -p $MOUNT/lib/firmware/`uname -r`/bnx2
           cp /lib/firmware/`uname -r`/bnx2/* $MOUNT/lib/firmware/`uname -r`/bnx2 > /dev/null
           cp /lib/firmware/bnx2* $MOUNT/lib/firmware > /dev/null 2>&1
           cp -r /lib/firmware/bnx2 $MOUNT/lib/firmware > /dev/null
         elif [ \( $OS$VER == 'SuSE11' \) ]; then
           cp -r /lib/firmware/`uname -r`/bnx2 $MOUNT/lib/firmware
         fi
       fi
     fi

     if [ $BNX2X != '0' ]; then
       if [ \( $OS$VER == 'SuSE11' \) ]; then
         cp /lib/modules/`uname -r`/kernel/lib/libcrc32c.ko $MOUNT/lib
         cp /lib/modules/`uname -r`/kernel/crypto/crc32c.ko $MOUNT/lib
         cp /lib/modules/`uname -r`/kernel/drivers/net/mdio.ko $MOUNT/lib
       fi

       if [ -e /lib/modules/`uname -r`/extras/bnx2x.ko ]; then
         cp /lib/modules/`uname -r`/extras/bnx2x.ko $MOUNT/lib;
       elif [ -e /lib/modules/`uname -r`/updates/bnx2x.ko ]; then
         cp /lib/modules/`uname -r`/updates/bnx2x.ko $MOUNT/lib;
       else
         if [ \( $DISTRO == 'RedHat61' \) -o  \( $DISTRO == 'RedHat62' \) -o \( $DISTRO == 'SuSE112' \) ]; then    
            cp /lib/modules/`uname -r`/kernel/drivers/net/bnx2x/bnx2x.ko $MOUNT/lib
         else
            cp /lib/modules/`uname -r`/kernel/drivers/net/bnx2x.ko $MOUNT/lib
         fi
         if [ \( $DISTRO == 'SuSE112' \) ]; then
           mkdir -p $MOUNT/lib/firmware/`uname -r`/bnx2x
           cp /lib/firmware/`uname -r`/bnx2x/* $MOUNT/lib/firmware/`uname -r`/bnx2x > /dev/null
           cp /lib/firmware/bnx2x* $MOUNT/lib/firmware > /dev/null 2>&1
           cp -r /lib/firmware/bnx2x $MOUNT/lib/firmware > /dev/null
         elif [ \( $OS$VER == 'SuSE11' \) ]; then
           cp /lib/firmware/`uname -r`/bnx2x* $MOUNT/lib/firmware
         fi
       fi
     fi

     # Copy Open-iscsi and Support Modules Files
     if [ $OS$VER == 'RedHat5' ]; then
       if [ \( $UPGRADE == '4' \) -o \( $UPGRADE == '5' \) -o \( $UPGRADE == '6' \) -o \( $UPGRADE == '7' \) -o \( $UPGRADE == '8' \) ]; then
         cp /lib/modules/`uname -r`/kernel/drivers/scsi/scsi_transport_iscsi2.ko $MOUNT/lib
       fi

       if [ $UPGRADE -ge '4' ]; then
         cp /lib/modules/`uname -r`/kernel/crypto/crypto_api.ko $MOUNT/lib
         cp /lib/modules/`uname -r`/kernel/net/xfrm/xfrm_nalgo.ko $MOUNT/lib
       fi
     fi

     cp /lib/modules/`uname -r`/kernel/drivers/uio/uio.ko $MOUNT/lib

     cp /sbin/iscsiuio $MOUNT/bin

     cp /lib/modules/`uname -r`/kernel/drivers/scsi/$LIBISCSI $MOUNT/lib

     if [ \( $OS$VER != 'RedHat6' \) ]; then 
       cp /lib/modules/`uname -r`/kernel/drivers/scsi/scsi_mod.ko $MOUNT/lib
     fi

     cp /lib/modules/`uname -r`/kernel/drivers/scsi/scsi_transport_iscsi.ko $MOUNT/lib

     if [ $DISTRO == 'SuSE112' ]; then
       cp /lib/modules/`uname -r`/kernel/net/ipv6/ipv6_lib.ko $MOUNT/lib
     fi
     cp /lib/modules/`uname -r`/kernel/net/ipv6/ipv6.ko $MOUNT/lib

     if [ -e /lib/modules/`uname -r`/extras/cnic.ko ]; then
       cp /lib/modules/`uname -r`/extras/cnic.ko $MOUNT/lib;
     elif [ -e /lib/modules/`uname -r`/updates/cnic.ko ]; then
       cp /lib/modules/`uname -r`/updates/cnic.ko $MOUNT/lib;
     else
       cp /lib/modules/`uname -r`/kernel/drivers/net/cnic.ko $MOUNT/lib
     fi

     if [ -e /lib/modules/`uname -r`/extras/bnx2i.ko ]; then
       cp /lib/modules/`uname -r`/extras/bnx2i.ko $MOUNT/lib;
     elif [ -e /lib/modules/`uname -r`/updates/bnx2i.ko ]; then
       cp /lib/modules/`uname -r`/updates/bnx2i.ko $MOUNT/lib;
     elif [ -e /lib/modules/`uname -r`/kernel/drivers/scsi/bnx2i.ko ]; then
       cp /lib/modules/`uname -r`/kernel/drivers/scsi/bnx2i.ko $MOUNT/lib
     else
       cp /lib/modules/`uname -r`/kernel/drivers/scsi/bnx2i/bnx2i.ko $MOUNT/lib
     fi

     cp /sbin/iscsiadm $MOUNT/sbin
  
     cp /sbin/iscsid $MOUNT/sbin

     mkdir -p $MOUNT/var/run
     mkdir -p $MOUNT/var/lock
     mkdir -p $MOUNT/var/lib/iscsi
     mkdir -p $MOUNT/var/log
     mkdir -p $MOUNT/$ETC
     if [ $DISTRO == 'SuSE112' ]; then
     mkdir -p $MOUNT/$ETC/nodes
     mkdir -p $MOUNT/$ETC/ifaces
     fi
     cp /$ETC/iscsid.conf $MOUNT/$ETC
    }
  #.......................... End - copy_offload_files function ..........................
  


  #................... Start - copy_nonoffload_openiscsi_files function ...................
  copy_nonoffload_openiscsi_files ()
    {
     # Copy Adapter L2 driver modules Files
     if [ $TG3 != '0' ]; then
       if [ \( $OS$VER == 'SuSE11' \) -a \( $UPGRADE == '0' \) ]; then
         cp /lib/modules/`uname -r`/kernel/drivers/net/phy/libphy.ko $MOUNT/lib
       fi

       if [ -e /lib/modules/`uname -r`/extras/tg3.ko ]; then
         cp /lib/modules/`uname -r`/extras/tg3.ko $MOUNT/lib;
       elif [ -e /lib/modules/`uname -r`/updates/tg3.ko ]; then
         cp /lib/modules/`uname -r`/updates/tg3.ko $MOUNT/lib;
       else
         cp /lib/modules/`uname -r`/kernel/drivers/net/tg3.ko $MOUNT/lib
       fi
     fi

     if [ $BNX2 != '0' ]; then
       if [ -e /lib/modules/`uname -r`/extras/bnx2.ko ]; then
         cp /lib/modules/`uname -r`/extras/bnx2.ko $MOUNT/lib;
       elif [ -e /lib/modules/`uname -r`/updates/bnx2.ko ]; then
         cp /lib/modules/`uname -r`/updates/bnx2.ko $MOUNT/lib;
       else
         cp /lib/modules/`uname -r`/kernel/drivers/net/bnx2.ko $MOUNT/lib
         if [ \( $DISTRO == 'SuSE112' \) ]; then
           mkdir -p $MOUNT/lib/firmware/`uname -r`/bnx2
           cp /lib/firmware/`uname -r`/bnx2/* $MOUNT/lib/firmware/`uname -r`/bnx2 > /dev/null
           cp /lib/firmware/bnx2* $MOUNT/lib/firmware > /dev/null 2>&1
           cp -r /lib/firmware/bnx2 $MOUNT/lib/firmware > /dev/null
         elif [ \( $OS$VER == 'SuSE11' \) ]; then
           cp -r /lib/firmware/`uname -r`/bnx2 $MOUNT/lib/firmware
         fi
       fi
     fi

     if [ $BNX2X != '0' ]; then
       if [ -e /lib/modules/`uname -r`/extras/bnx2x.ko ]; then
         cp /lib/modules/`uname -r`/extras/bnx2x.ko $MOUNT/lib;
       elif [ -e /lib/modules/`uname -r`/updates/bnx2x.ko ]; then
         cp /lib/modules/`uname -r`/updates/bnx2x.ko $MOUNT/lib;
       else
         if [ \( $DISTRO == 'RedHat61' \) -o \( $DISTRO == 'RedHat62' \) -o \( $DISTRO == 'SuSE112' \) ]; then
            cp /lib/modules/`uname -r`/kernel/drivers/net/bnx2x/bnx2x.ko $MOUNT/lib
         else
            cp /lib/modules/`uname -r`/kernel/drivers/net/bnx2x.ko $MOUNT/lib
         fi
         if [ \( $DISTRO == 'SuSE112' \) ]; then
           mkdir -p $MOUNT/lib/firmware/`uname -r`/bnx2x
           cp /lib/firmware/`uname -r`/bnx2x/* $MOUNT/lib/firmware/`uname -r`/bnx2x > /dev/null
           cp /lib/firmware/bnx2x* $MOUNT/lib/firmware > /dev/null 2>&1
           cp -r /lib/firmware/bnx2x $MOUNT/lib/firmware > /dev/null
         elif [ \( $OS$VER == 'SuSE11' \) ]; then
           cp /lib/firmware/`uname -r`/bnx2x* $MOUNT/lib/firmware
         fi
       fi
     fi

     # Copy Open-iscsi and Support Modules Files
     if [ $OS$VER == 'RedHat6' ]; then
       cp /sbin/iscsistart $MOUNT/bin
       chmod 777 $MOUNT/bin/iscsistart
     fi
     if [ $OS$VER == 'RedHat5' ]; then
       cp /sbin/iscsistart $MOUNT/bin
       
       cp /lib/modules/`uname -r`/kernel/drivers/infiniband/ulp/iser/ib_iser.ko $MOUNT/lib

       cp /lib/modules/`uname -r`/kernel/drivers/infiniband/core/ib_core.ko $MOUNT/lib

       cp /lib/modules/`uname -r`/kernel/drivers/infiniband/core/rdma_cm.ko $MOUNT/lib  

       cp /lib/modules/`uname -r`/kernel/drivers/infiniband/core/ib_addr.ko $MOUNT/lib

       cp /lib/modules/`uname -r`/kernel/drivers/infiniband/core/ib_cm.ko $MOUNT/lib

       cp /lib/modules/`uname -r`/kernel/drivers/infiniband/core/ib_sa.ko $MOUNT/lib

       cp /lib/modules/`uname -r`/kernel/drivers/infiniband/core/ib_mad.ko $MOUNT/lib

       if [ \( $OS$VER == 'RedHat5' \) -a \( $UPGRADE -ge '1' \) ]; then
         cp /lib/modules/`uname -r`/kernel/drivers/infiniband/core/iw_cm.ko $MOUNT/lib
       #  if [ $UPGRADE == '1' ]; then
       #    cp /lib/modules/`uname -r`/kernel/drivers/infiniband/core/ib_local_sa.ko $MOUNT/lib
       #  fi
       fi

       if [ \( $DISTRO == 'RedHat54' \) -o \( $DISTRO == 'RedHat55' \) -o \( $DISTRO == 'RedHat56' \) -o \( $DISTRO == 'RedHat57' \) -o \( $DISTRO == 'RedHat58' \) ]; then
         cp /lib/modules/`uname -r`/kernel/drivers/scsi/scsi_transport_iscsi2.ko $MOUNT/lib
         cp /lib/modules/`uname -r`/kernel/drivers/scsi/libiscsi_tcp.ko $MOUNT/lib
       fi
     elif [ \( $OS$VER == 'SuSE10' \) -o \( $OS$VER == 'SuSE11' \) ]; then
       cp /lib/modules/`uname -r`/kernel/lib/libcrc32c.ko $MOUNT/lib
       cp /lib/modules/`uname -r`/kernel/crypto/crc32c.ko $MOUNT/lib
       if [  \( $DISTRO == 'SuSE111' \) -o \( $DISTRO == 'SuSE112' \) ]; then
         cp /lib/modules/`uname -r`/kernel/drivers/net/mdio.ko $MOUNT/lib
         cp /lib/modules/`uname -r`/kernel/drivers/scsi/libiscsi_tcp.ko $MOUNT/lib
       fi
     else
       sleep 0
     fi
 
     cp /lib/modules/`uname -r`/kernel/drivers/scsi/scsi_transport_iscsi.ko $MOUNT/lib

     cp /lib/modules/`uname -r`/kernel/drivers/scsi/$LIBISCSI $MOUNT/lib

     cp /lib/modules/`uname -r`/kernel/drivers/scsi/iscsi_tcp.ko $MOUNT/lib

     cp /sbin/iscsiadm $MOUNT/bin

     cp /sbin/iscsid $MOUNT/sbin

     mkdir -p $MOUNT/var/run
     mkdir -p $MOUNT/var/lock
     mkdir -p $MOUNT/var/lib/iscsi
     mkdir -p $MOUNT/$ETC
     if [ $DISTRO == 'SuSE112' ]; then
     mkdir -p $MOUNT/$ETC/nodes
     mkdir -p $MOUNT/$ETC/ifaces
     fi
     cp /$ETC/iscsid.conf $MOUNT/$ETC    
    }
  #...................... End - copy_nonoffload_openiscsi_files function ...................


  #.................... Start - copy_nonoffload_linuxiscsi_files function ..................
  copy_nonoffload_linuxiscsi_files ()
    {
     # Copy Adapter L2 Driver Files
     if [ $TG3 != '0' ]; then
       if [ -e /lib/modules/`uname -r`/extras/tg3.ko ]; then
         cp /lib/modules/`uname -r`/extras/tg3.ko $MOUNT/lib;
       elif [ -e /lib/modules/`uname -r`/updates/tg3.ko ]; then
           cp /lib/modules/`uname -r`/updates/tg3.ko $MOUNT/lib;
       else
           cp /lib/modules/`uname -r`/kernel/drivers/net/tg3.ko $MOUNT/lib
       fi
     fi

     if [ $BNX2 != '0' ]; then
       if [ -e /lib/modules/`uname -r`/extras/bnx2.ko ]; then
         cp /lib/modules/`uname -r`/extras/bnx2.ko $MOUNT/lib;
       elif [ -e /lib/modules/`uname -r`/updates/bnx2.ko ]; then
           cp /lib/modules/`uname -r`/updates/bnx2.ko $MOUNT/lib;
       else
           cp /lib/modules/`uname -r`/kernel/drivers/net/bnx2.ko $MOUNT/lib
       fi
     fi

     if [ $BNX2X != '0' ]; then
       if [ -e /lib/modules/`uname -r`/extras/bnx2x.ko ]; then
         cp /lib/modules/`uname -r`/extras/bnx2x.ko $MOUNT/lib;
       elif [ -e /lib/modules/`uname -r`/updates/bnx2x.ko ]; then
         cp /lib/modules/`uname -r`/updates/bnx2x.ko $MOUNT/lib;
       else
         if [ \( $DISTRO == 'RedHat61' \) -o \( $DISTRO == 'RedHat62' \) -o \( $DISTRO == 'SuSE112' \) ]; then
            cp /lib/modules/`uname -r`/kernel/drivers/net/bnx2x/bnx2x.ko $MOUNT/lib
         else
            cp /lib/modules/`uname -r`/kernel/drivers/net/bnx2x.ko $MOUNT/lib
         fi
       fi
     fi
     
     # Copy linux-iscsi and Support Modules Files
     if [ $OS$VER == 'RedHat4' ]; then
       cp /lib/modules/`uname -r`/kernel/drivers/scsi/scsi_transport_iscsi.ko $MOUNT/lib
       cp /lib/modules/`uname -r`/kernel/drivers/scsi/iscsi_sfnet/iscsi_sfnet.ko $MOUNT/lib
       cp /lib/modules/`uname -r`/kernel/lib/libcrc32c.ko $MOUNT/lib
       cp /lib/modules/`uname -r`/kernel/crypto/crc32c.ko $MOUNT/lib
       cp /lib/modules/`uname -r`/kernel/crypto/md5.ko $MOUNT/lib
     elif [ $OS$VER == 'SuSE9' ]; then
       cp /lib/modules/`uname -r`/extra/iscsi.ko $MOUNT/lib
     fi
    }
  #........................ End copy_nonoffload_linuxiscsi_files ...........................

copy_common_files

if [ \( $INITIATOR == '1' \) -a \( \( "$OS$VER" == 'RedHat5' \) -o \( "$OS$VER" == 'RedHat6' \) -o \( "$DISTRO" == 'SuSE111' \) -o \( "$DISTRO" == 'SuSE112' \) \) ]; then
  copy_offload_files
elif [ \( $INITIATOR == '0' \) -a \( \( "$OS$VER" == 'RedHat5' \) -o \( "$OS$VER" == 'RedHat6' \) -o \( "$OS$VER" == 'SuSE10' \) -o \( "$OS$VER" == 'SuSE11' \) \) ]; then
  copy_nonoffload_openiscsi_files
elif [ \( $INITIATOR == '0' \) -a \( \( "$OS$VER" == 'RedHat4' \) ]; then
  copy_nonoffload_linuxiscsi_files
else
  echo"ERROR: OS version is not supported or initiator is not known ...exiting"
  exit
fi
if [ $OS$VER == 'SuSE11' ];then
  cp /etc/modprobe.d/unsupported-modules $MOUNT/etc/modprobe.d/unsupported-modules
fi 
}
#******************************** End - create_initrd_img **********************************


################################# Start - Main Program #####################################

# Clear the screen
 clear

 if [ $# -eq 4 ]; then
   PARAMS=4
   DEBUG=$1
   SPEED=$2
   DUPLEX=$3
   AUTONEG=$4
 fi

# Determine what Operation System is running (Red Hat or SuSE)
 determine_OS

# Determine architecture of you system (x32 vs x64)
 determine_ARCH

# Determine what driver is loaded (bnx2, bnx2x or both)
 determine_NIC

# Determine whether offload or non-offload
 determine_iSCSI_PATH

# Check all required modules
 check_modules

# Get Target Portal Group Tag, to be used for iscsistart/iscsiadm
 echo "Please enter the Target Portal Group Tag:"
 read TGPT

# Create iscsi script
 create_iscsi_script

# Build query_iscsi tool if it does not exist
 build_query_iscsi

# Create initrd image for iscsi boot
 create_initrd_img

# Start- Zip the image
 cd $MOUNT
 find . | cpio --create --format='newc' > $HOME/initrd.img
 cd $HOME
 gzip -c < $HOME/initrd.img > $HOME/iscsi-initrd.img
 rm $HOME/initrd.img
 rm $HOME/iscsi_script
 rm -fr $MOUNT
# End- Zip the image

################################### End - Main Program ###################################
