#!/bin/bash

ctl_c_hdlr()
{
    # Kill the children
    pkill -P $$
    rmmod edrv

    # Restore terminal parameters
    stty $term_cap

    # Suicide
    kill -9 $$
}

MOD_NAME=edrv
LEDIAG_PID=0
USE_INTA=0

if lsmod | grep $MOD_NAME &>/dev/null; then
    rmmod $MOD_NAME
fi

if uname -a | grep xen; then
   echo "Use INTA in XEN kernel"
   USE_INTA=1
fi 

if ! insmod edrv.ko use_inta=$USE_INTA; then
	echo "Failed to load the module (insmod edrv.ko)"
	exit 1
fi


major=`cat /proc/devices | grep diag577xx | cut -d" " -f1`

rm -f /dev/diag577xx

if ! mknod /dev/diag577xx c $major 0; then
	echo "Failed to create a device file (mknod /dev/diag577xx c $major 0)"
	exit 1
fi



# If bnx2x is loaded - start in engineering mode
lsmod | grep bnx2x &>/dev/null

if [[ $? == 0 ]]; then
    echo "bnx2x is loaded - running in engineering mode..."
    extra_arg="-b10eng"
fi

# Save terminal session parameters
term_cap=`stty -g`

trap ctl_c_hdlr TERM INT

./lediag $extra_arg "$@"
ret=$?

rmmod edrv

# Restore terminal parameters (needed if the application has been killed)
stty $term_cap

exit $ret

