#if defined(CONFIG_SMP) && !defined(__SMP__)
#define __SMP__
#endif  // defined(CONFIG_SMP) && !defined(__SMP__)

#include <linux/version.h>

// only one C file can include module headers with __NO_VERSION__
#if defined(MODULE)
#define __NO_VERSION__
#if defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#define MODVERSIONS
#endif  // defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#if defined(MODVERSIONS) && (LINUX_VERSION_CODE < 0x020500)
#include <linux/modversions.h>
#endif  // defined(CONFIG_MODVERSIONS)
#include <linux/module.h>
#endif  // defined(MODULE)

#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/types.h>
#include <linux/fcntl.h>
#include <linux/interrupt.h>        // ???
#include <linux/ptrace.h>           // ???
#include <linux/ioport.h>           // ???
#include <linux/in.h>
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
#include <linux/slab.h>
#else
#include <linux/malloc.h>
#endif
#include <linux/string.h>
#include <linux/init.h>
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(3,4,0))
#include <linux/bitops.h>
#include <linux/io.h>               // ???
#include <asm-generic/dma.h>        // ???
#include <linux/uaccess.h>          // copy_[from|to]_user
#include <linux/atomic.h>
#else
#include <asm/system.h>
#include <asm/bitops.h>
#include <asm/io.h>                 // ???
#include <asm/dma.h>                // ???
#include <asm/uaccess.h>            // copy_[from|to]_user
#include <asm/atomic.h>
#endif
#include <linux/errno.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/inetdevice.h>
#include <linux/skbuff.h>
#include <linux/notifier.h>
#include <linux/string.h>
#include <linux/rtnetlink.h>
#include <linux/proc_fs.h>
#if (LINUX_VERSION_CODE < KERNEL_VERSION(3,0,0)) 
#include <linux/smp_lock.h>
#endif

// version dependent includes
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
#include <linux/spinlock.h>
#else
#include <asm/spinlock.h>
#endif

#include "pal.h"

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
mpd_init_board(
    void *pcidev, 
    char *name
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
mpd_remove_one(
    void *pcidev
    )
{
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
mpd_suspend(
    void *pcidev, 
    u32_t state
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
mpd_resume(
    void *pcidev
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
bcm06_get_dev(
    void **dev_arr,
    u32_t arr_size,
    int *dev_num
    )
{
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
bcm06_get_interface(
    void *bcm_dev,
    u32_t if_type,
    void *interface,
    u32_t if_size,
    u32_t if_ver
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void 
drv_init(
    int enable_l2, 
    int debug_mode, 
    void *lock
    )
{
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
mpd_open(
    PAL_DEVICE dev 
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
mpd_close(
    PAL_DEVICE dev 
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
mpd_get_phy_id(
    PAL_DEVICE dev,
    u32_t *phy_id
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
driver_pulse(
    unsigned long FunctionContext
    )
{
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
poll_for_link(
    unsigned long FunctionContext
    )
{
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int 
mpd_read_phy_reg(
    PAL_DEVICE dev,
    u32_t phy_addr,
    u32_t *phy_data
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
mpd_write_phy_reg(
    PAL_DEVICE dev,
    u32_t phy_addr,
    u32_t phy_data
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
PAL_DEVICE_STAT
mpd_get_stats(
    PAL_DEVICE dev
    )
{
   return (PAL_DEVICE_STAT)0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
um_bdrv_handle_isr(
    void *dev_instance
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
mpd_start_xmit(
    PAL_PACKET pkt,
    PAL_DEVICE dev
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
mpd_set_multicast_list(
    PAL_DEVICE dev 
    )
{
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void 
mpd_vlan_rx_register(
    PAL_DEVICE dev,
    void *vlgrp
    )
{
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void 
mpd_vlan_rx_kill_vid(
    PAL_DEVICE dev,
    u16_t vid
    )
{
}


#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
mpd_get_settings(
    PAL_DEVICE dev,
    u32_t *setting,
    u32_t *advertising,
    u32_t *autoneg
    )
{
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
mpd_set_settings(
    PAL_DEVICE dev, 
    u32_t req_medium, 
    u32_t advertising, 
    u32_t autoneg,
    u32_t selective_autoneg
    )
{
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
mpd_get_drvinfo(
    PAL_DEVICE dev, 
    char **bus_info, 
    u32_t *fw_ver
    )
{
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
mpd_get_wake_magic(
    PAL_DEVICE dev, 
    u32_t *wake_magic, 
    u32_t *enable
    )
{
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
mpd_set_wol(
    PAL_DEVICE dev, 
    u32_t enable
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
mpd_nway_reset(
    PAL_DEVICE dev
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
mpd_get_eeprom_len(
    PAL_DEVICE dev
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
mpd_get_eeprom(
    PAL_DEVICE dev, 
    u32_t offset, 
    u32_t len, 
    u8_t *eebuf
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
mpd_set_eeprom(
    PAL_DEVICE dev, 
    u32_t offset, 
    u32_t len, 
    u8_t *eebuf
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
mpd_get_coalesce(
    PAL_DEVICE dev,
    u32_t *rx_coalesce_usecs, u32_t *rx_max_coalesced_frames, 
    u32_t *rx_coalesce_usecs_irq, u32_t *rx_max_coalesced_frames_irq,
    u32_t *tx_coalesce_usecs, u32_t *tx_max_coalesced_frames, 
    u32_t *tx_coalesce_usecs_irq, u32_t *tx_max_coalesced_frames_irq,
    u32_t *stats_block_coalesce_usecs
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
mpd_get_ringparam(
    PAL_DEVICE dev, 
    u32_t* rx_max_pending, 
    u32_t *tx_max_pending
    )
{
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
mpd_get_pauseparam(
    PAL_DEVICE dev, 
    u32_t *flow_autoneg, 
    u32_t *rx_pause, 
    u32_t *tx_pause
    )
{
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
mpd_set_pauseparam(
    PAL_DEVICE dev,
    u32_t flow_autoneg, 
    u32_t rx_pause, 
    u32_t tx_pause
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
u32_t
mpd_get_rx_csum(
    PAL_DEVICE dev
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
mpd_set_rx_csum(
    PAL_DEVICE dev, 
    u32_t data
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
mpd_get_strings(
    PAL_DEVICE dev, 
    u8_t *buf
    )
{
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
mpd_phys_id(
    PAL_DEVICE dev,
    u32_t data
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
mpd_get_stats_count(
    PAL_DEVICE dev
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
mpd_get_ethtool_stats(
    PAL_DEVICE dev, 
    u64_t *buf
    )
{
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
mpd_change_mac_addr(
    PAL_DEVICE dev, 
    void *sa_data, 
    u32_t addr_len
    )
{
   return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
poll_mpd(
    PAL_DEVICE dev
    )
{
}
