#if defined(CONFIG_SMP) && !defined(__SMP__)
#define __SMP__
#endif  // defined(CONFIG_SMP) && !defined(__SMP__)

#include <linux/version.h>

// only one C file can include module headers with __NO_VERSION__
#if defined(MODULE)
#define __NO_VERSION__
#if defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#define MODVERSIONS
#endif  // defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#if defined(MODVERSIONS) && (LINUX_VERSION_CODE < 0x020500)
#include <linux/modversions.h>
#endif  // defined(CONFIG_MODVERSIONS)
#include <linux/module.h>
#endif  // defined(MODULE)

#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/types.h>
#include <linux/fcntl.h>
#include <linux/interrupt.h>        // ???
#include <linux/ptrace.h>           // ???
#include <linux/ioport.h>           // ???
#include <linux/in.h>
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
#include <linux/slab.h>
#else
#include <linux/malloc.h>
#endif
#include <linux/string.h>
#include <linux/init.h>
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(3,4,0))
#include <linux/bitops.h>
#include <linux/io.h>               // ???
#include <asm-generic/dma.h>        // ???
#include <linux/uaccess.h>          // copy_[from|to]_user
#include <linux/atomic.h>
#else
#include <asm/system.h>
#include <asm/bitops.h>
#include <asm/io.h>                 // ???
#include <asm/dma.h>                // ???
#include <asm/uaccess.h>            // copy_[from|to]_user
#include <asm/atomic.h>
#endif
#include <linux/errno.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/inetdevice.h>
#include <linux/skbuff.h>
#include <linux/notifier.h>
#include <linux/string.h>
#include <linux/rtnetlink.h>
#include <linux/proc_fs.h>
#if (LINUX_VERSION_CODE < 0x30000) 
#include <linux/smp_lock.h>
#endif

// version dependent includes
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
#include <linux/spinlock.h>
#else
#include <asm/spinlock.h>
#endif

#include "diag_pal.h"

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int 
b06diag_open(void **private_data)
{
    return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int 
b06diag_ioctl(void *private_data, u32_t cmd, unsigned long arg)
{
    return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int 
b06diag_close(void *private_data)
{
    return 0;
}

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void *
b06diag_get_map_addr(unsigned long hdl)
{
    return 0;
}
