/****************************************************************************
 * Copyright(c) 2000 Broadcom Corporation, all rights reserved
 * Proprietary and Confidential Information.
 *
 * This source file is the property of Broadcom Corporation, and
 * may not be copied or distributed in any isomorphic form without 
 * the prior written consent of Broadcom Corporation. 
 *
 * Name:        pal.h
 *
 * Description: Platform Abstraction Layer implementation for bxbdrv(mpd)
 *              and related device drivers
 *
 * Author:      John Chen
 *
 ****************************************************************************/
#ifndef __diag_pal_h__
#define __diag_pal_h__

//
// define _MSC_VER here to get rid of the warning of undefined _MSC_VER
// when built on SuSE linux 10(kernel 2.6.16.14-6)
//
#define _MSC_VER 0

#include "bcmtype.h"

//
// macro to force unaligned data structure
//
#define __packed1__ __attribute__ ((packed, aligned(1)))

#define REGPARM(a) __attribute__((regparm (a)))
//#define REGPARM(a)

//
// Platform Abstracted Data Types
//
typedef U8* PAL_SPINLOCK;        // ptr to spinlock_t

#define MAX_06DEV 50

//
// Function prototypes
//
void
bcm_get_dev(
    void **dev_arr,
    u32_t arr_size,
    int *dev_num);

int
bcm_get_interface(
    void *bcm_dev,
    u32_t if_type,
    void *interface,
    u32_t if_size,
    u32_t if_ver);

int
pal_get_interface(
    void *bcm_dev,
    u32_t if_type,
    void *interface,
    u32_t if_size,
    u32_t if_ver
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

PAL_SPINLOCK
pal_get_spinlock_ptr(
    u32_t idx
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void*
pal_memcpy(
    void* dst,
    void* src,
    U32 len
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

int
pal_memcmp(
    void* dst,
    void* src,
    U32 len
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void*
pal_memset(
    void* dst,
    int val,
    U32 len
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void*
pal_malloc(
    U32 len
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void
pal_mfree(
    void* p
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

#define PAL_VERIFY_READ     1
#define PAL_VERIFY_WRITE    2
int
pal_verify_area(
    int verify_type,
    void *addr,
    unsigned long size
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void
pal_copy_from_user(
    void* to,
    void* from,
    U32 len
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void
pal_copy_to_user(
    void* to,
    void* from,
    U32 len
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

int
pal_get_user(
    u32_t *x,
    u32_t *p
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void
pal_put_user(
    u32_t x, 
    u32_t *p
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

int
pal_stricmp(
    char* str1,
    char* str2
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

//
// Spinlock functions
//
void
pal_init_spinlock(
    PAL_SPINLOCK lock
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void
pal_spin_lock_irqsave(
    PAL_SPINLOCK lock,
    unsigned long* flags
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void
pal_spin_lock(
    PAL_SPINLOCK lock
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void
pal_spin_unlock_irqrestore(
    PAL_SPINLOCK lock,
    unsigned long* flags
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void
pal_spin_unlock(
    PAL_SPINLOCK lock
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void *
pal_dma_alloc_coherent(
    void *pcidev,
    u32_t size,
    u64_t *bus_addr
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void 
pal_dma_free_coherent(
    void *dev, 
    u32_t size,
    void *vaddr, 
    u64_t bus_addr
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

#ifndef CONFIG_PPC64
void *
pal_BusToVirt(
    unsigned long page_addr
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif
#endif /* CONFIG_PPC64 */

void
pal_SetPageReserved(
    void *vaddr
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void
pal_ClearPageReserved(
    void *vaddr
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

int
not_sysmem(
    u64_t phy_addr
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

int
pal_virt_addr_valid(
    void *kaddr
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void *
pal_alloc_user_sgl(
    u32_t max_pages
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

int 
pal_map_user_pages(
    void *sgl, 
    const unsigned int max_pages, 
	unsigned long uaddr, 
    u32_t count
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

int 
pal_unmap_user_pages(
    void *sgl, 
    const unsigned int nr_pages
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void
pal_pci_unmap_sg(
    void *pcidev,
    void *sglist,
    int nelems
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void
pal_pci_map_pages(
    void *pcidev,
    void *sgl,
    int nr_pages
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void
pal_pci_unmap_pages(
    void *pcidev,
    void *sgl,
    int nr_pages
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

u64_t
pal_pci_map_single(
    void *pcidev,
    void *addr,
    u32_t size,
    int from_dev
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void
pal_pci_unmap_single(
    void *pcidev,
    u64_t addr,
    u32_t size,
    int from_dev
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

u64_t
pal_sg_dma_address(
    void *sgl,
    int idx
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

u32_t
pal_sg_dma_len(
    void *sgl,
    int idx
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void*
pal_vmalloc(
    u32_t len
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void
pal_vmfree(
    void* p
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

u32_t
pal_get_page_shift(
    void
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

u32_t
pal_get_page_size(
    void
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

u32_t
pal_inl(
    u32_t io_addr
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

u32_t
pal_inw(
    u32_t io_addr
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

u32_t
pal_inb(
    u32_t io_addr
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void
pal_outl(
    u32_t value, 
    u32_t io_addr
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void
pal_outw(
    u32_t value, 
    u32_t io_addr
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void
pal_outb(
    u32_t value, 
    u32_t io_addr
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

u32_t
pal_cpu_to_be32(
    u32_t value 
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

u32_t
pal_cpu_to_le32(
    u32_t value 
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

int 
b06diag_open(
    void **private_data
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

int 
b06diag_close(
    void *private_data
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

int 
b06diag_ioctl(
    void *private_data, 
    u32_t cmd, 
    unsigned long arg
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void *
b06diag_get_map_addr(
    unsigned long hdl
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

//
// Linux module support
//
int
pal_inc_usage(
    void
    );

void
pal_dec_usage(
    void
    );

//
// Debug functions
//
void 
pal_print(
    const char* fmt,
    ...
    );

void
pal_panic(
    const char* msg
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

int
pal_sprintf(
    char* buf,
    const char* fmt,
    ...
    );

#ifdef CONFIG_PPC64
#define pal_break_if(_c)
#else
#define pal_break_if(_c) \
    if(_c) \
    { \
        __asm__("int $129"); \
    }
#endif
#endif  // __diag_pal_h__
