#
# spec file for package qlogic-netxtreme2 (Version 7.8.29)
#
# Copyright (c) 2009 SUSE LINUX Products GmbH, Nuernberg, Germany.
#
# All modifications and additions to the file contributed by third parties
# remain the property of their copyright owners, unless otherwise agreed
# upon. The license for this file, and modifications and additions to the
# file, is the same license as for the pristine package itself (unless the
# license for the pristine package is not an Open Source License, in which
# case the license is the MIT License). An "Open Source License" is a
# license that conforms to the Open Source Definition (Version 1.9)
# published by the Open Source Initiative.

# Please submit bugfixes or comments via http://support.novell.com
#

# norootforbuild
# usedforbuild aaa_base acl attr audit-libs autoconf automake bash binutils brp-check-suse build bzip2 coreutils cpio cpp cpp43 cracklib cvs diffutils file filesystem fillup findutils gawk gcc gcc43 gdbm gettext-runtime gettext-tools glibc glibc-devel glibc-locale gmp grep groff gzip info insserv kernel-source kernel-syms less libacl libattr libbz2-1 libbz2-devel libdb-4_5 libgcc43 libgomp43 libltdl7 libmpfr1 libncurses5 libreadline5 libselinux1 libsepol1 libstdc++43 libtool libuuid1 libvolume_id1 libxcrypt libzio linux-kernel-headers login m4 make man net-tools netcfg pam pam-modules patch perl perl-base permissions popt post-build-checks psmisc rpm rpmlint-Factory rpmlint-mini sed sles-release sles-release-DVD sysvinit tar terminfo-base texinfo timezone util-linux zlib


Name: netxtreme2
Version: 7.13.01
Release: 1.sles11sp4
Group: System Environment/Base
Vendor: QLogic Corporation
URL: http://www.qlogic.com
License: GPLv2
#Summary: QLogic NetXtreme II driver set for Linux
Source0: %name-%version.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-build
BuildRequires: kernel-source kernel-syms sles-release sles-release-DVD
Summary: QLogic 1/10 GbE Multifunction, iSCSI, and FCoE Drivers for Linux
Obsoletes: broadcom-netxtreme2-kmp
Conflicts: broadcom-netxtreme2-kmp


%define sourceinfo "SRPMS available at http://ldriver.qlogic.com/driver-srpms/"
%define gpginfo "RPM public key available at http://ldriver.qlogic.com/RPM-public-key/ and Module public key available at http://ldriver.qlogic.com/Module-public-key/"


%define mod_sign_files /home/nx2-signing
%define module_key %{mod_sign_files}/qlgc_module_signing_key.priv
%define module_cer %{mod_sign_files}/qlgc_module.cer

%define kverrel %(uname -r | awk -F"-" '{print $1"-"$2}')
%define verrel %(rpm -qa|grep %{kverrel}|head -n 1|awk -F%{kverrel} '{print "%{kverrel}"$2}')
%define default %(rpm -q kernel-default-devel-%{verrel}|head -n 1)
%define xen %(rpm -q kernel-xen-devel-%{verrel}|head -n 1)
%define pae %(rpm -q kernel-pae-devel-%{verrel}|head -n 1)

%suse_kernel_module_package ec2 kdump um trace

%description
This package contains the Linux drivers for the QLogic NetXtreme II Family of Server Adapters
%{gpginfo}

%if "%{default}" == "kernel-default-devel-%{verrel}"
%description -n %name-kmp-default
%{sourceinfo}
%{gpginfo}
%endif

%if "%{xen}" == "kernel-xen-devel-%{verrel}"
%description -n %name-kmp-xen
%{sourceinfo}
%{gpginfo}
%endif

%if "%{pae}" == "kernel-pae-devel-%{verrel}"
%description -n %name-kmp-pae
%{sourceinfo}
%{gpginfo}
%endif

%package doc
Summary: Documentation for the QLogic NetXtreme II iSCSI, 1-Gigabit, and 10-Gigabit ethernet drivers
Group: System/Kernel

%description doc
Documentation for the QLogic NetXtreme II iSCSI, 1-Gigabit, and 10-Gigabit ethernet drivers

%prep
%setup
set -- *
mkdir source
mv "$@" source/
cp -f source/bnx2/README.TXT source/README.bnx2.TXT
cp -f source/bnx2/RELEASE.TXT source/RELEASE.bnx2.TXT
cp -f source/bnx2x/README.TXT source/README.bnx2x.TXT
cp -f source/bnx2x/RELEASE.TXT source/RELEASE.bnx2x.TXT
cp -f source/bnx2i/docs/README.TXT source/README.bnx2i.TXT
cp -f source/bnx2i/docs/RELEASE.TXT source/RELEASE.bnx2i.TXT
cp -f source/bnx2fc/docs/README.TXT source/README.bnx2fc.TXT
cp -f source/bnx2fc/docs/RELEASE.TXT source/RELEASE.bnx2fc.TXT
cp -f source/fclibs/RELEASE.TXT source/RELEASE.fclibs.TXT

mkdir obj

%build
export KVER=%{kverrel}
export EXTRA_CFLAGS='-DVERSION="%version"'
for flavor in %flavors_to_build; do
rm -rf obj/$flavor
cp -r source obj/$flavor
kernel_flavor=${KVER}-${flavor}
make -C obj/$flavor KVER=$kernel_flavor
done

%install
export KVER=%{kverrel}
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=updates
for flavor in %flavors_to_build; do
kernel_flavor=${KVER}-${flavor}
dest_dir=${RPM_BUILD_ROOT}/lib/modules/$kernel_flavor/updates
mkdir -p $dest_dir
MAJVER=`grep VERSION /etc/SuSE-release | sed -e 's/.*= //'`
MINVER=`grep PATCHLEVEL /etc/SuSE-release | sed -e 's/.*= //'`

if [ $MAJVER -eq 11 -a $MINVER -ge 3 ] && [ -f %{module_key} ] && [ -f %{module_cer} ]; then
perl /usr/src/linux/scripts/sign-file sha256 %{module_key} %{module_cer} obj/${flavor}/bnx2/src/bnx2.ko
perl /usr/src/linux/scripts/sign-file sha256 %{module_key} %{module_cer} obj/${flavor}/bnx2x/src/bnx2x.ko
perl /usr/src/linux/scripts/sign-file sha256 %{module_key} %{module_cer} obj/${flavor}/bnx2/src/cnic.ko
perl /usr/src/linux/scripts/sign-file sha256 %{module_key} %{module_cer} obj/${flavor}/bnx2i/driver/bnx2i.ko
perl /usr/src/linux/scripts/sign-file sha256 %{module_key} %{module_cer} obj/${flavor}/bnx2fc/driver/bnx2fc.ko
fi

install -m 444 obj/${flavor}/bnx2/src/bnx2.ko $dest_dir
install -m 444 obj/${flavor}/bnx2x/src/bnx2x.ko $dest_dir

if [ $MAJVER -eq 11 -a $MINVER -eq 1 ]; then
install -m 444 obj/${flavor}/bnx2/src/cnic.ko $dest_dir
install -m 444 obj/${flavor}/bnx2i/driver/bnx2i.ko $dest_dir
install -m 444 obj/${flavor}/bnx2fc/driver/bnx2fc.ko $dest_dir
install -m 444 obj/${flavor}/fclibs/libfc/libfc2.ko $dest_dir
install -m 444 obj/${flavor}/fclibs/fcoe/libfcoe2.ko $dest_dir
fi
if [ $MAJVER -eq 11 -a $MINVER -ge 2 ]; then
install -m 444 obj/${flavor}/bnx2/src/cnic.ko $dest_dir
install -m 444 obj/${flavor}/bnx2i/driver/bnx2i.ko $dest_dir
install -m 444 obj/${flavor}/bnx2fc/driver/bnx2fc.ko $dest_dir
fi
done

man_dir=${RPM_BUILD_ROOT}/usr/share/man/man4
mkdir -p ${man_dir}
gzip -c source/bnx2/src/bnx2.4 > ${man_dir}/bnx2.4.gz
gzip -c source/bnx2x/src/bnx2x.4 > ${man_dir}/bnx2x.4.gz

%clean
rm -rf %{buildroot}

%files doc
%defattr(-, root, root)
%doc source/INSTALL.TXT
%doc source/README.bnx2.TXT
%doc source/README.bnx2x.TXT
%doc source/README.bnx2i.TXT
%doc source/README.bnx2fc.TXT
%doc source/RELEASE.bnx2.TXT
%doc source/RELEASE.bnx2x.TXT
%doc source/RELEASE.bnx2i.TXT
%doc source/RELEASE.bnx2fc.TXT
%_mandir/man4/bnx2.4.gz
%_mandir/man4/bnx2x.4.gz

%changelog
* Fri Jul 24 2015 QLogic Build Environment 7.12.37.1
- added RH5.11 support.
- added RH6.6 & RH6.7 support.
- added RH7.0 & RH7.1 support.
- added SLES11-SP4 & SLES12 support.
- added VLAN filtering offload support.
- added Debian GNU/Linux 7 (wheezy) support.
- In RHEL7.0 and 7.1, bnx2x will be rolled back to inbox after system reboot (80071).
- SRIOV : MAC address change inside VM is not allowed unless interface is down (80309).
- RH7.x:  Tunneling offload is not enabled (79269).
- self test fails on 20G adapter (79295).
- VF interface vlan-filtering stopped working (79365).
- Fail to force link speed other than 20G in KR2 (77841).
- Incorrect asymmetric flow-control behavior (75504).
- Dynamic VF enumeration fails for 578xx adapter in SLES11 SP4 (78590).
- Inner-to-outer vlan priority mapping doesn't work (RH6.x [pre 2.6.38 kernels]).
- Packets from a VF with pvid configured which were sent with a different vlan were transmitted instead of being discarded.
- UDP packets cannot pass to the upper application (5709).
- Out of memory issue when the adapter is reset (5709).
- iSCSI offload: Driver displaying incorrect remote port (77842).
- FCoE offload: Initiators failed FLOGI on SLES 11 SP4 RC1 (79704).

* Fri Dec 13 2013 Broadcom Build Environment
-Add RH5.10 support.
-Add RH6.5 support.
-FC-TAPE - Host responds early to a requested resend delay - Linux (70101)
-SLES11 MEZ75 IO halt with Nexus reboot tests (70728)
-SLES 11 blade loses all targets from BLOM port during fabric uplink add/remove (70187)
-KVM gso and gro are not working on hv and vm as expected (70506)
-SRIOV mtu toggle failure (70530)
-SRIOV hv reboots on pf toggle with vfs passed through on it. (70531)
-Guest OS dosent boot after attaching VF in RHEL6.3x64bit for 57840 device. (68426)
-[NET]SUT reboot&MCE report when create 30th/31st VF on 57810 device on SLES11 SP2. (69263)
-RH Cert - RH5 | U8 | v7-1.5-33 | 57810 | Flex Network Test failed. (70427)
-BACS 16.2.0: Show ETS/Priority Tagging/PFC as operational when DCBX is disabled on the switch side. (69690)
-Incorrect port value is displayed for connected/unconnected ports of 57810 for RHEL5.9 64bits. (68627)
-VFs are not getting created for Broadcom adapters in RHEL5.10 OS. (71456)
*Fri Jun 21 2013 Broadcom Build Environment
-Added Linux SRIOV support
-Added iSCSI & FCoE HBA support for specific HP adapters and devices
-Added VC4.10 support
-Added BCV support
-When GRO setting changes while LRO is enabled, don't reload as LRO takes precedence.
-Allow UDP tunneling offload
-Enable IPGRE RSS by default
-Support different GRE RSS modes.

