/*
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 */

/*
* Copyright 2014 QLogic Corporation
* The contents of this file are subject to the terms of the
* QLogic End User License (the "License").
* You may not use this file except in compliance with the License.
*
* You can obtain a copy of the License at
* http://www.qlogic.com/Resources/Documents/DriverDownloadHelp/
* QLogic_End_User_Software_License.txt
* See the License for the specific language governing permissions
* and limitations under the License.
*/


#ifndef BNX_SND_H
#define BNX_SND_H

#include "bnx.h"

int  bnx_txpkts_init( um_device_t * const umdevice );
void bnx_txpkts_flush( um_device_t * const umdevice );
void bnx_txpkts_fini( um_device_t * const umdevice );

#define BNX_SEND_GOODXMIT  0
#define BNX_SEND_LINKDOWN  1
#define BNX_SEND_DEFERPKT  2
#define BNX_SEND_HDWRFULL  3

int  bnx_xmit_pkt_map( um_txpacket_t * const umpacket, mblk_t * mp );

int
bnx_xmit_ring_xmit_qpkt( um_device_t * const umdevice,
                         const unsigned int ringidx );

int
bnx_xmit_ring_xmit_mblk( um_device_t * const umdevice,
                         const unsigned int ringidx,
                         mblk_t * mp );

void
bnx_xmit_ring_reclaim( um_device_t * const umdevice,
                       const unsigned int ringidx, s_list_t * srcq );

void
bnx_xmit_ring_intr( um_device_t * const umdevice,
                    const unsigned int  ringidx );

void
bnx_txpkts_intr( um_device_t * const umdevice );

void
bnx_xmit_ring_post( um_device_t * const umdevice, const unsigned int ringidx );

#endif /* BNX_SND_H */
