/*
 * Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved.
 */

/*
* Copyright 2014 QLogic Corporation
* The contents of this file are subject to the terms of the
* QLogic End User License (the "License").
* You may not use this file except in compliance with the License.
*
* You can obtain a copy of the License at
* http://www.qlogic.com/Resources/Documents/DriverDownloadHelp/
* QLogic_End_User_Software_License.txt
* See the License for the specific language governing permissions
* and limitations under the License.
*/

#include "bnx.h"

#define BNX_BUF_SIZE 256


void debug_break(void * ctx)
{
    um_device_t * um = (um_device_t *)ctx;
    cmn_err(CE_PANIC, "-> %s panic <-", (um) ? um->dev_name : "(unknown)");
}


void debug_msg(void * ctx,
               unsigned long level,
               char * file,
               unsigned long line,
               char * msg,
               ...)
{
    um_device_t * um = (um_device_t *)ctx;
    char buf[BNX_BUF_SIZE];
    va_list argp;

    *buf = 0;

    if (um)
    {
        snprintf(buf, BNX_BUF_SIZE, "%s %s:%lu ", um->dev_name, file, line);
    }
    else
    {
        snprintf(buf, BNX_BUF_SIZE, "%s:%lu ", file, line);
    }

    strncat(buf, msg, BNX_BUF_SIZE);

    va_start(argp, msg);
    vcmn_err(CE_WARN, buf, argp);
    va_end(argp);
}


void debug_msgx(void * ctx,
                unsigned long level,
                char * msg,
                ...)
{
    um_device_t * um = (um_device_t *)ctx;
    char buf[BNX_BUF_SIZE];
    va_list argp;

    *buf = 0;

    if (um)
    {
        snprintf(buf, BNX_BUF_SIZE, "%s ", um->dev_name);
    }

    strncat(buf, msg, BNX_BUF_SIZE);

    va_start(argp, msg);
    vcmn_err(CE_WARN, buf, argp);
    va_end(argp);
}


void BnxDumpMem(um_device_t * pUM,
                char *        pTag,
                u8_t *        pMem,
                u32_t         len)
{
    char buf[256];
    char c[32];
    int  xx;

    //mutex_enter(&bnxGeneralMutex);

    cmn_err(CE_WARN, "%s ++++++++++++ %s", pUM->dev_name, pTag);
    strcpy(buf, "** 000: ");

    for (xx = 0; xx < len; xx++)
    {
        if ((xx != 0) && (xx % 16 == 0))
        {
            cmn_err(CE_WARN, buf);
            strcpy(buf, "** ");
            snprintf(c, sizeof(c), "%03x", xx);
            strcat(buf, c);
            strcat(buf, ": ");
        }

        snprintf(c, sizeof(c), "%02x ", *pMem);
        strcat(buf, c);

        pMem++;
    }

    cmn_err(CE_WARN, buf);
    cmn_err(CE_WARN, "%s ------------ %s", pUM->dev_name, pTag);

    //mutex_exit(&bnxGeneralMutex);
}


void BnxDumpPkt(um_device_t * pUM,
                char *        pTag,
                mblk_t *      pMblk,
                boolean_t     contents)
{
    char buf[256];
    char c[32];
    u8_t * pMem;
    int  i, xx = 0;

    //mutex_enter(&bnxGeneralMutex);

    cmn_err(CE_WARN, "%s ++++++++++++ %s", pUM->dev_name, pTag);

    while (pMblk)
    {
        pMem = pMblk->b_rptr;
        strcpy(buf, "** > ");
        snprintf(c, sizeof(c), "%03x", xx);
        strcat(buf, c);
        strcat(buf, ": ");

        if (contents)
        {
            for (i = 0; i < MBLKL(pMblk); i++)
            {
                if ((xx != 0) && (xx % 16 == 0))
                {
                    cmn_err(CE_WARN, buf);
                    strcpy(buf, "**   ");
                    snprintf(c, sizeof(c), "%03x", xx);
                    strcat(buf, c);
                    strcat(buf, ": ");
                }

                snprintf(c, sizeof(c), "%02x ", *pMem);
                strcat(buf, c);

                pMem++;
                xx++;
            }
        }
        else
        {
            snprintf(c, sizeof(c), "%d", (int)MBLKL(pMblk));
            strcat(buf, c);
            xx += MBLKL(pMblk);
        }

        cmn_err(CE_WARN, buf);
        pMblk = pMblk->b_cont;
    }

    cmn_err(CE_WARN, "%s ------------ %s", pUM->dev_name, pTag);

    //mutex_exit(&bnxGeneralMutex);
}

