/*
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 */

/*
* Copyright 2014 QLogic Corporation
* The contents of this file are subject to the terms of the
* QLogic End User License (the "License").
* You may not use this file except in compliance with the License.
*
* You can obtain a copy of the License at
* http://www.qlogic.com/Resources/Documents/DriverDownloadHelp/
* QLogic_End_User_Software_License.txt
* See the License for the specific language governing permissions
* and limitations under the License.
*/


#ifndef BNX_MM_H
#define BNX_MM_H

#include <atomic.h>

#define mm_read_barrier() membar_consumer()
#define mm_write_barrier() membar_producer()

#include "lm.h"
#include "lm5706.h"

#define FLUSHPOSTEDWRITES(_lmdevice)                                \
    {                                                               \
        volatile uint32_t dummy;                                    \
        REG_RD((_lmdevice), pci_config.pcicfg_int_ack_cmd, &dummy); \
    }

#endif	/* BNX_MM_H */

