#!/bin/bash

srcdir=`pwd`

function fixDU64()
{
    # Put the 64-bit binary in the DU image for Solaris 10
    tmpdir=`mktemp -d`
    cp sol_210/i86pc/Product/bnx.Z $tmpdir

    pushd $tmpdir

    uncompress bnx.Z
    unzip bnx
    rm -f bnx
    cd BRCMbnx

    mkdir reloc/kernel/drv/amd64
    cp $srcdir/bnx64 reloc/kernel/drv/amd64/bnx

    size=`ls -l reloc/kernel/drv/amd64/bnx | awk '{print $5}'`
    sum=`/usr/bin/sum reloc/kernel/drv/amd64/bnx | awk '{print $1}'`

    # Inject the new file into the package map.
    while read -ra pkgline ; do
        echo ${pkgline[*]}
        if [ "${pkgline[3]}" = "kernel/drv/bnx" ]; then
            echo ${pkgline[0]} ${pkgline[1]} ${pkgline[2]} "kernel/drv/amd64/bnx" \
                 ${pkgline[4]} ${pkgline[5]} ${pkgline[6]} $size $sum ${pkgline[9]}
        fi
    done < pkgmap > pkgmap.new

    rm pkgmap
    mv pkgmap.new pkgmap

    cd ..
    zip -r bnx.zip BRCMbnx
    compress < bnx.zip > bnx.Z

    popd

    mv $tmpdir/bnx.Z sol_210/i86pc/Product
    rm -rf $tmpdir
}


TFILE=`mktemp`
mkfile 1474560 ${TFILE}

TLOOP=`lofiadm -a ${TFILE}`
TLOOPRAW=`echo ${TLOOP} | sed 's/lofi/rlofi/'`

yes | mkfs -F pcfs -o nofdisk,size=2880 ${TLOOPRAW}

TDIR=`mktemp -d`
mount -F pcfs ${TLOOP} ${TDIR}

/opt/SUNWpkgd/bin/pkg_drv -A -o ${TDIR} bnx

if [ -d ${TDIR}/DU ]; then

  pushd ${TDIR}/DU > /dev/null

  #echo "Copying directory..."
  # NEW! Support Solaris 29
  #if [ $# != 0 ]; then
  # cp -R sol_210 sol_29
  #fi

  # manually copy 64-bit driver which is required for Solaris 10/11
  fixDU64

  popd > /dev/null

  dd if=${TLOOPRAW} of=bnxdu-$1-i386-$2.img

else

  echo "ERROR: Missing DU directory. Run pkg_drv!"

fi

umount ${TDIR}
lofiadm -d ${TFILE}
rm -rf ${TDIR} ${TFILE}

