/******************************************************************************/
/* Broadcom Corporation.  No part of this file may be reproduced or           */
/* distributed, in any form or by any means for any purpose, without the      */
/* express written permission of Broadcom Corporation.                        */
/*                                                                            */
/* (c) COPYRIGHT 2000-2009 Corporation, ALL RIGHTS RESERVED.                  */
/*                                                                            */
/*  FILE        :  F C B  P A R M S . H                                       */
/*                                                                            */
/*  AUTHOR      :  Kevin Tran                                                 */
/*                                                                            */
/*  DESCRIPTION :  This file contains FCoE Boot global macros definitions.    */
/*                                                                            */
/*  Revision History:                                                         */
/*    Kevin Tran         11/30/2009       Created                             */
/*                                                                            */
/******************************************************************************/

#ifndef __FCBPARMS_H__
#define __FCBPARMS_H__

#define FCOE_HDR_BUF_SIZE          128

/* Size of user's receive buffer */
#define FCB_MAX_RX_PAYLOAD_SIZE     0xffffL

#define FCB_MAX_TX_PDU_SIZE        1536
#define FCB_MAX_CHAP_ID_LENGTH     128
#define FCB_MAX_SPN_NAME_LEN       128
#define FCB_MAX_CHAP_PW_LENGTH     16

#define FCB_MAX_NUM_TARGETS         8

#define FCB_DEFAULT_DCBX_PRIORITY         3

#define FCB_BACKGROUND_TIMER         1

#define FCB_BOOT_TO_TARGET_PROMPT_TIMEOUT      4
#define FCB_PROVISIONING_MODE_PROMPT_TIMEOUT   4

/* Per FC-BB5 (Table 47), VN_Port FIP keep-alive period is 90s */
#define FCB_FKA_VN_PERIOD            90

/* Sent in PLOGI request.  Maximum number of concurrent sequences. */
#define FCB_NX_PORT_CONCURRENT_SEQUENCES  1

/* Sent in PLOGI request. Maximum number of sequences per exchanges */
#define FCB_MAX_OPEN_SEQ_PER_EXCHANGE 1

/* Resource Allocation Time-out value.  The default value is 10s. */
#define FCB_DEFAULT_R_A_TOV   10000

#define FCB_DEFAULT_FCP4_FEATURES  0x2

#define FCB_DEFAULT_SPN "Broadcom FCoE pWWN"

#define FCB_DEFAULT_FCF_RESPONSE_TIMEOUT     4

#define FCB_DEFAULT_TARGET_RESPONSE_TIMEOUT  2
#define FCB_DEFAULT_SENSE_INFO_SIZE          64

#define FCB_MAX_DATA_XFER_SIZE          1024

#define FCB_DEFAULT_LUN_BUSY_RETRY_COUNT 4
#define FCB_DEFAULT_LUN_BUSY_WAIT_TIME   1  /* Wait for 1s */

#define FCB_DEFAULT_WWNN_PREFIX  0x1000
#define FCB_DEFAULT_WWPN_PREFIX  0x2000

#define FCB_MAX_PLOGIN_RETRY   4

#endif /* __FCBPARMS_H__ */
