/******************************************************************************/
/* Broadcom Corporation.  No part of this file may be reproduced or           */
/* distributed, in any form or by any means for any purpose, without the      */
/* express written permission of Broadcom Corporation.                        */
/*                                                                            */
/* (c) COPYRIGHT 2000-2010 Broadcom Corporation, ALL RIGHTS RESERVED.         */
/*                                                                            */
/*  FILE        :  F C B _ N V M  . H                                         */
/*                                                                            */
/*  AUTHOR      :  Kevin Tran                                                 */
/*                                                                            */
/*  DESCRIPTION :  This file contains NVM MAP for FCoE Boot configuration.    */
/*  block.                                                                    */
/*                                                                            */
/*  Revision History:                                                         */
/*    Kevin Tran         11/30/2009       Created                             */
/*                                                                            */
/******************************************************************************/

#ifndef __FCB_NVM_H__
#define __FCB_NVM_H__

#ifndef MFW
#include "types.h"
#endif
#include "fcb_parm.h"

#define NVM_FCB_CFG_BLOCK_SIZE    1024

#if defined(WINPE) || defined(CRASHDUMP_DRIVER) || defined(LINUX) || defined(HII)
#pragma pack(push,1)
#endif

/* 0x0 to 0x7f */
typedef struct NVM_FCB_GENERAL_INFO
{
  u16_t signature;
  #define NVM_FCB_BLOCK_SIGNATURE  0x6662 /* "fb" */ 
  u16_t version;
  #define NVM_FCB_FORMAT_VERSION_MAJOR   1
  #define NVM_FCB_FORMAT_VERSION_MINOR   0

  #define NVM_FCB_FORMAT_VERSION (NVM_FCB_FORMAT_VERSION_MAJOR << 8) |\
    NVM_FCB_FORMAT_VERSION_MINOR

  u32_t ctrl_flags;
   #define NVM_FCB_FLAGS_FIP_VLAN_DISCOVERY   (1 << 1)
   #define NVM_FCB_FLAGS_BOOT_TO_TARGET       (1 << 2)
   #define NVM_FCB_FLAGS_USE_TARGET_HDD_FIRST (1 << 3)
   #define NVM_FCB_FLAGS_HBA_PATH             (1 << 4)
   #define NVM_FCB_FLAGS_B2T_ONE_TIME         (1 << 9)

  u8_t link_up_delay;                /* Offset -- 0x8 */
  u8_t lun_busy_retry_count;         /* Offset -- 0x9 */

  /* Default is 4s */
  u8_t fabric_discovery_timeout;     /* Offset -- 0xa */
  u8_t reserved[117];                /* Offset -- 0xb to 0x7f */
}NVM_FCB_GENERAL_INFO;

/* 0x80 to 0x9f */
typedef struct NVM_FCB_SECONDARY_NIC_INFO
{
  u16_t ctrl_flags;                              /* 0x80 */

   #define NVM_FCB_FLAGS_MPIO_MODE_ENABLE     (1 << 0)
  u8_t mac_address[6]; /* MAC address of secondary interface -- 0x82 */
  u8_t reserved[24];   /* Offset 0x88 ... 0x9f */
}NVM_FCB_SECONDARY_NIC_INFO,*pNVM_FCB_SECONDARY_NIC_INFO;

/* Security Block  : 0xA0 to 0x1ff */
typedef struct NVM_FCB_SECURITY_INFO
{
  u8_t authentication_mode;  /* 0xA0  */
  /*
   * First release, we only support DHCHAP.  We migh support FCAP, FCPAP
   * in the later releases. 
   */
#define NVM_FCB_AUTH_MODE_NONE              0x0
  /* Unidirectional CHAP */
#define NVM_FCB_AUTH_MODE_DHCHAP            0x1 
 /* Bidirectional CHAP - aka Mutual Chap*/ 
#define NVM_FCB_AUTH_MODE_DHCHAP_MUTUAL     0x2 
  /* FC Certificate Authentication Protocol */
#define NVM_FCB_AUTH_MODE_FCAP              0x3  
  /* FC Certificate Password Authentication Protocol */
#define NVM_FCB_AUTH_MODE_FCPAP             0x4  
  
  /* 
   * Diffie-Hellman CHAP information (RFC 2631) per FC-SP. The first phase, 
   * we will support "NULL-DH" algorithm which is basically CHAP (RFC 1994). 
   */
  u8_t chap_id[FCB_MAX_CHAP_ID_LENGTH+1];                /* 0xa1 ... 0x121 */
  u8_t chap_password[FCB_MAX_CHAP_PW_LENGTH+1];          /* 0x122 ... 0x132 */
  u8_t reversed_chap_id[FCB_MAX_CHAP_ID_LENGTH+1];       /* 0x133 ... 0x1b3 */
  u8_t reversed_chap_password[FCB_MAX_CHAP_PW_LENGTH+1]; /* 0x1b4 ... 0x1c4 */
  u8_t reserved[59];                                     /* 0x1c5 ... 0x1ff */
}NVM_FCB_SECURITY_INFO,__FAR__ *pNVM_FCB_SECURITY_INFO;

/* Initiator  : 0x200 to 0x29f */
typedef struct NVM_FCB_INITIATOR_INFO
{
  /*  
   * Bit 15..13 : Priority 
   * Bit 11..0  : VLAN ID.
   * FCoE ROM will use this VLAN ID/priority for FIP VLAN Discovery
   */
  u16_t fip_vlan;                /* 0x200 ... 0x201 */
  /* 
   * This is the WWN node name.  If it's not configured, FCoE ROM will
   * 0x10 0x00 <MAC Address>
   */
  u8_t node_name[8];             /* 0x202... 0x209*/
  /* 
   * This is the WWN Port Name.  If it's not configured, FCoE ROM will
   * 0x20 0x00 <MAC Address>
   */
  u8_t port_name[8];             /* 0x20a.. 0x211 */
  /* Default is "Broadcom FCoE pWWN <port_name>" */
  u8_t symbolic_port_name[FCB_MAX_SPN_NAME_LEN+1]; /* 0x212 ... 0x292 */
  u8_t reserved[109];          /* 0x293 ... 0x2ff */
}NVM_FCB_INITIATOR_INFO,*pNVM_FCB_INITIATOR_INFO;

typedef struct NVM_FCB_TARGET_BLOCK
{
  u16_t ctrl_flags; 
   #define NVM_FCB_FLAGS_TARGET_ENABLE    (1 << 0)
  /* 64-bit World-wide Port name (WWPN) of the FC target. */
  u8_t port_name[8];
  u16_t boot_lun;
  u8_t reserved[4];
}NVM_FCB_TARGET_BLOCK,*pNVM_FCB_TARGET_BLOCK;

/* First Target  : 0x300 to 0x33f */
/* Second Target : 0x340 to 0x37f */
typedef struct NVM_FCB_TARGET_INFO
{
  NVM_FCB_TARGET_BLOCK target[FCB_MAX_NUM_TARGETS];
}NVM_FCB_TARGET_INFO,*pNVM_FCB_TARGET_INFO;

#define NVM_FCB_CFG_BLOCK_RESERVE_SIZE   NVM_FCB_CFG_BLOCK_SIZE - \
   (sizeof(NVM_FCB_GENERAL_INFO) +                                      \
    sizeof(NVM_FCB_SECONDARY_NIC_INFO) +                                \
    sizeof(NVM_FCB_SECURITY_INFO) +                             \
    sizeof(NVM_FCB_INITIATOR_INFO) +                                    \
    sizeof(NVM_FCB_TARGET_INFO) + 4)

typedef struct NVM_FCB_CFG_BLOCK
{
  NVM_FCB_GENERAL_INFO gen;                      /* 0x0   ... 0x7f  */
  NVM_FCB_SECONDARY_NIC_INFO secondary_device;   /* 0x80  ... 0x9f  */
  NVM_FCB_SECURITY_INFO security;                /* 0xa0  ... 0x1ff */
  NVM_FCB_INITIATOR_INFO initiator;              /* 0x200 ... 0x2ff */
  NVM_FCB_TARGET_INFO targets;                   /* 0x300 ... 0x33f */
  u8_t reserved[NVM_FCB_CFG_BLOCK_RESERVE_SIZE];  /* 0x380 to 0x3fb */
  u32_t crc32;                                    /* 0x3fc */
}NVM_FCB_CFG_BLOCK, *pNVM_FCB_CFG_BLOCK;

#define NVM_FCB_OFFSET(x)  (u16_t)(&((pNVM_FCB_CFG_BLOCK)0)->x)

#if defined(WINPE) || defined(CRASHDUMP_DRIVER) || defined(LINUX) || defined(HII)
#pragma pack(pop)
#endif

#endif /* __FCB_NVM_H__ */
