/***************************************************************************
 * Copyright(c) 2000 Broadcom Corporation, all rights reserve
 * Proprietary and Confidential Information.
 *
 * This source file is the property of Broadcom Corporation, and
 * may not be copied or distributed in any isomorphic form without 
 * the prior written consent of Broadcom Corporation. 
 *
 * Name:        pal2.h
 *
 * Description: Platform Abstraction Layer implementation for bxbdrv(mpd)
 *
 * Author:      
 *
 ****************************************************************************/
#ifndef __patch_h__
#define __patch_h__

//#include "bcmtype.h"

void
mm_read_barrier(
    void
    );

void
mm_write_barrier(
    void
    );

#ifdef CONFIG_PPC64

u32_t
pal_readl(
    const volatile void *addr
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void
pal_writel(
    u32_t b,
    volatile void *addr
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void
pal_writew(
    u16_t b,
    volatile void *addr
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

void
pal_writeb(
    u8_t b,
    volatile void *addr
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
    ) REGPARM(3);
#else
    );
#endif

#endif //CONFIG_PPC64

#endif // __patch_h__
