/****************************************************************************
 * Copyright(c) 2005 Broadcom Corporation, all rights reserved
 * Proprietary and Confidential Information.
 *
 * This source file is the property of Broadcom Corporation, and
 * may not be copied or distributed in any isomorphic form without
 * the prior written consent of Broadcom Corporation.
 *
 * Name:        mpd_main.c
 *
 * Description: mpd main module
 *
 * Author:      John Chen
 *
 *
 ****************************************************************************/
#if defined(CONFIG_SMP) && ! defined(__SMP__)
#define __SMP__
#endif
#if defined(CONFIG_MODVERSIONS) && defined(MODULE) && ! defined(MODVERSIONS)
#define MODVERSIONS
#endif

#include <linux/version.h>
#ifdef MODULE
#if defined(MODVERSIONS) && (LINUX_VERSION_CODE < 0x020500)
#include <linux/modversions.h>
#endif
#include <linux/module.h>
#else
#define MODULE_DEVICE_TABLE(pci, pci_tbl)
#endif

#include <linux/pci.h>
#include <linux/init.h>

#include "bdrv_ver.h"
#include "pal.h"

int enable_l2 = 0;
int debug_mode = 0;
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,9))
MODULE_PARM( enable_l2, "i" );
MODULE_PARM( debug_mode, "i" );
#else
module_param(enable_l2, int, 0);
module_param(debug_mode, int, 0);
#endif

spinlock_t global_lock;

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(3,10,0))
static char version[] =
    "Broadcom NetXtreme II Gigabit Ethernet Driver " DRV_MODULE_NAME " v" DRV_MODULE_VERSION " (" DRV_MODULE_RELDATE ")\n";
#else
static char version[] __devinitdata =
    "Broadcom NetXtreme II Gigabit Ethernet Driver " DRV_MODULE_NAME " v" DRV_MODULE_VERSION " (" DRV_MODULE_RELDATE ")\n";
#endif
MODULE_LICENSE("Proprietary");

typedef enum {
    BCM5706 = 0,
    BCM5706S,
    BCM5708,
    BCM5708S,
    BCM5709,
    BCM5709S,
    BCM5716C,
    BCM5716S,
    BCM57728C,
    BCM57728S
} board_t;

/* indexed by board_t, above */
static struct {
    char *name;
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(3,10,0))
} board_info[] = {
#else
} board_info[] __devinitdata = {
#endif
    { "Broadcom NetXtreme II BCM5706 1000Base-T" },
    { "Broadcom NetXtreme II BCM5706 1000Base-SX" },
	{ "Broadcom NetXtreme II BCM5708 1000Base-T" },
	{ "Broadcom NetXtreme II BCM5708 1000Base-SX" },
    { "Broadcom NetXtreme II BCM5709 1000Base-T" },
    { "Broadcom NetXtreme II BCM5709 1000Base-SX" },
    { "Broadcom NetXtreme II BCM5716 1000Base-T" },
    { "Broadcom NetXtreme II BCM5716 1000Base-SX" },
    { "Broadcom NetXtreme II BCM57728 1000Base-T" },
    { "Broadcom NetXtreme II BCM57728 1000Base-SX" },
    { 0 }
    };

static struct pci_device_id bcm5706_pci_tbl[] = {
    { PCI_VENDOR_ID_BROADCOM, 0x164a,
        PCI_ANY_ID, PCI_ANY_ID, 0, 0, BCM5706 },
    { PCI_VENDOR_ID_BROADCOM, 0x16aa,
        PCI_ANY_ID, PCI_ANY_ID, 0, 0, BCM5706S },
	{ PCI_VENDOR_ID_BROADCOM, 0x164c,
        PCI_ANY_ID, PCI_ANY_ID,	0, 0, BCM5708 },
	{ PCI_VENDOR_ID_BROADCOM, 0x16ac,
        PCI_ANY_ID, PCI_ANY_ID,	0, 0, BCM5708S },
    { PCI_VENDOR_ID_BROADCOM, 0x1639,
        PCI_ANY_ID, PCI_ANY_ID, 0, 0, BCM5709 },
    { PCI_VENDOR_ID_BROADCOM, 0x163a,
        PCI_ANY_ID, PCI_ANY_ID, 0, 0, BCM5709S },
    { PCI_VENDOR_ID_BROADCOM, 0x163b,
        PCI_ANY_ID, PCI_ANY_ID, 0, 0, BCM5716C },
    { PCI_VENDOR_ID_BROADCOM, 0x163c,
        PCI_ANY_ID, PCI_ANY_ID, 0, 0, BCM5716S },
    { PCI_VENDOR_ID_BROADCOM, 0x1660,
        PCI_ANY_ID, PCI_ANY_ID, 0, 0, BCM57728C },
    { PCI_VENDOR_ID_BROADCOM, 0x1661,
        PCI_ANY_ID, PCI_ANY_ID, 0, 0, BCM57728S },
    { 0, }
};

MODULE_DEVICE_TABLE(pci, bcm5706_pci_tbl);

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(3,10,0))
static int
bcm5706_init_one(struct pci_dev *pdev, const struct pci_device_id *ent)
#else
static int __devinit
bcm5706_init_one(struct pci_dev *pdev, const struct pci_device_id *ent)
#endif
{
    static int version_printed = 0;
    int rc;

    if (version_printed++ == 0)
        printk(KERN_INFO "%s", version);
    rc = mpd_init_board(pdev, board_info[ent->driver_data].name);
    return rc;
}

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(3,10,0))
static void
bcm5706_remove_one(struct pci_dev *pdev)
#else
static void __devexit
bcm5706_remove_one(struct pci_dev *pdev)
#endif
{
    mpd_remove_one(pdev);
}

#if (LINUX_VERSION_CODE >= 0x2060b)
static int bcm5706_suspend(struct pci_dev *pdev, pm_message_t state)
{
    return mpd_suspend(pdev, pci_choose_state(pdev, state));
}
#else
static int bcm5706_suspend(struct pci_dev *pdev, u32_t state)
{
    return mpd_suspend(pdev, state);
}
#endif

static int bcm5706_resume(struct pci_dev *pdev)
{
    return mpd_resume(pdev);
}

static struct pci_driver bcm5706_pci_driver = {
    name:       DRV_MODULE_NAME,
    id_table:   bcm5706_pci_tbl,
    probe:      bcm5706_init_one,
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(3,10,0))
    remove:     bcm5706_remove_one,
#else
    remove:     __devexit_p(bcm5706_remove_one),
#endif
    suspend:    bcm5706_suspend,
    resume:     bcm5706_resume,
};

static int __init bcm5706_init(void)
{
    drv_init(enable_l2, debug_mode, &global_lock);

#if (LINUX_VERSION_CODE < 0x020613)
    return pci_module_init(&bcm5706_pci_driver);
#else
    return pci_register_driver(&bcm5706_pci_driver);
#endif
}

static void __exit bcm5706_cleanup(void)
{
    pci_unregister_driver(&bcm5706_pci_driver);
}

module_init(bcm5706_init);
module_exit(bcm5706_cleanup);



