/****************************************************************************
 * Copyright(c) 2005 Broadcom Corporation, all rights reserved
 * Proprietary and Confidential Information.
 *
 * This source file is the property of Broadcom Corporation, and
 * may not be copied or distributed in any isomorphic form without 
 * the prior written consent of Broadcom Corporation. 
 *
 * Name:        diag_pal.c
 *
 * Description: Platform Abstraction Layer implementation for 
 *              Linux kdiag device drivers
 *
 * Author:      John Chen
 *
 *
 ****************************************************************************/

#if defined(CONFIG_SMP) && !defined(__SMP__)
#define __SMP__
#endif  // defined(CONFIG_SMP) && !defined(__SMP__)

#include <linux/version.h>

// only one C file can include module headers with __NO_VERSION__
#if defined(MODULE)
#define __NO_VERSION__
#if defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#define MODVERSIONS
#endif  // defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#if defined(MODVERSIONS) && (LINUX_VERSION_CODE < 0x020500)
#include <linux/modversions.h>
#endif  // defined(CONFIG_MODVERSIONS)
#include <linux/module.h>
#endif  // defined(MODULE)

#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/types.h>
#include <linux/fcntl.h>
#include <linux/interrupt.h>        // ???
#include <linux/ptrace.h>           // ???
#include <linux/ioport.h>           // ???
#include <linux/in.h>
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
#include <linux/slab.h>
#else
#include <linux/malloc.h>
#endif
#include <linux/string.h>
#include <linux/init.h>
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(3,4,0))
#include <linux/bitops.h>
#include <linux/io.h>               // ???
#include <asm-generic/dma.h>        // ???
#include <linux/uaccess.h>          // copy_[from|to]_user
#include <linux/atomic.h>
#else
#include <asm/system.h>
#include <asm/bitops.h>
#include <asm/io.h>                 // ???
#include <asm/dma.h>                // ???
#include <asm/uaccess.h>            // copy_[from|to]_user
#include <asm/atomic.h>
#endif
#include <linux/errno.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/inetdevice.h>
#include <linux/skbuff.h>
#include <linux/notifier.h>
#include <linux/string.h>
#include <linux/rtnetlink.h>
#include <linux/proc_fs.h>
#if (LINUX_VERSION_CODE < 0x30000) 
#include <linux/smp_lock.h>
#endif
#ifdef CONFIG_PPC64
#include <linux/vmalloc.h>
#endif

// version dependent includes
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
#include <linux/spinlock.h>
#else
#include <asm/spinlock.h>
#endif

#include <linux/pci.h>
#include <linux/timer.h>
#include <linux/ethtool.h>
#include <linux/mii.h>
#include <linux/if_vlan.h>

#ifdef NETIF_F_TSO
#include <net/ip.h>
#include <net/tcp.h>
#include <net/checksum.h>
#endif

#include <linux/pagemap.h>

#include "diag_pal.h"

//
// linux kernel version check
//
#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
#error KDIAG requires Linux 2.6 kernel
#endif

//
// global variables
//
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,39))
static spinlock_t print_lock = SPIN_LOCK_UNLOCKED;
#else
static DEFINE_SPINLOCK(print_lock);
#endif
static char msg[4096];

static spinlock_t  f_spinlock[MAX_06DEV * 2];

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
pal_get_interface(
    void *bcm_dev,
    u32_t if_type,
    void *interface,
    u32_t if_size,
    u32_t if_ver
    )
{
    return bcm_get_interface(bcm_dev, if_type, interface, if_size, if_ver);
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
PAL_SPINLOCK
pal_get_spinlock_ptr(
    u32_t idx
    )
{
    PAL_SPINLOCK addr = NULL;

    if (idx < (MAX_06DEV * 2))
        addr = (PAL_SPINLOCK)&f_spinlock[idx];
    else
        printk(KERN_ERR "Invalid spin lock index");

    pal_break_if(0 == addr);
    return addr;
}


/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void*
pal_memcpy(
    void* dst,
    void* src,
    U32 len
    )
{
    return memcpy( dst, src, len );
}


/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
pal_memcmp(
    void* dst,
    void* src,
    U32 len
    )
{
    return memcmp( dst, src, len );
}


/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void*
pal_memset(
    void* dst,
    int val,
    U32 len
    )
{
    return memset( dst, val, len );
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void*
pal_malloc(
    U32 len
    )
{
    return kmalloc( len, GFP_ATOMIC );
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
pal_mfree(
    void* p
    )
{
    kfree( p );
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
pal_verify_area(
    int verify_type,
    void *addr,
    unsigned long size
    )
{
    int type;
    
    if (PAL_VERIFY_READ == verify_type)
        type = VERIFY_READ;
    else if (PAL_VERIFY_WRITE == verify_type)
        type = VERIFY_WRITE;
    else 
        type = (VERIFY_WRITE|VERIFY_READ);

    return !access_ok(type, addr, size);
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
pal_copy_from_user(
    void* to,
    void* from,
    U32 len
    )
{
	unsigned long ret;

    ret = copy_from_user( to, from, len ); /* On success, return zero */
	if (ret != 0)
		printk("copy_from_user failed\n");
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
pal_copy_to_user(
    void* to,
    void* from,
    U32 len
    )
{
	unsigned long ret;

    ret = copy_to_user( to, from, len ); /* On success, return zero */
	if (ret != 0) 
		printk("copy_to_user failed\n");
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
pal_get_user(
    u32_t *x,
    u32_t *p
    )
{
   return  __get_user(*x, p);
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
pal_put_user(u32_t x, u32_t *p)
{
    __put_user(x, p);
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
pal_stricmp(
    char* str1,
    char* str2
    )
{
    int rc;

    rc = strlen( str1 ) - strlen( str2 );
    if( rc == 0 )
    {
        rc = strcmp( str1, str2 );
    }

    return rc;
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
pal_init_spinlock(
    PAL_SPINLOCK lock
    )
{
    spin_lock_init( (spinlock_t*)lock );
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
pal_spin_lock_irqsave(
    PAL_SPINLOCK lock,
    unsigned long* flags
    )
{
    spin_lock_irqsave( (spinlock_t*)lock, *flags );
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
pal_spin_lock(
    PAL_SPINLOCK lock
    )
{
    spin_lock((spinlock_t*)lock);
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
pal_spin_unlock_irqrestore(
    PAL_SPINLOCK lock,
    unsigned long* flags
    )
{
    spin_unlock_irqrestore( (spinlock_t*)lock, *flags );
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
pal_spin_unlock(
    PAL_SPINLOCK lock
    )
{
    spin_unlock((spinlock_t*)lock);
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void *
pal_dma_alloc_coherent(
    void *pcidev,
    u32_t size,
    u64_t *bus_addr
    )
{
    return dma_alloc_coherent(&((struct pci_dev *)pcidev)->dev, size, (void *)bus_addr, GFP_KERNEL);
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void 
pal_dma_free_coherent(
    void *pcidev,
    u32_t size,
    void *vaddr, 
    u64_t bus_addr
    )
{
    dma_free_coherent(&((struct pci_dev *)pcidev)->dev, size, vaddr, bus_addr);
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#ifndef CONFIG_PPC64
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void *
pal_BusToVirt(
    unsigned long page_addr)
{
    void *kv_addr;
    kv_addr = bus_to_virt(page_addr);
    return kv_addr;
}
#endif /* CONFIG_PPC64 */

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
pal_SetPageReserved(
    void *vaddr
    )
{
    SetPageReserved(virt_to_page(vaddr));
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
pal_ClearPageReserved(
    void *vaddr
    )
{
    ClearPageReserved(virt_to_page(vaddr));
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
not_sysmem(
    u64_t phy_addr
    )
{
    return (phy_addr >= __pa(high_memory));
}
/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int
pal_virt_addr_valid(void *kaddr)
{
    return(virt_addr_valid(kaddr));
}
/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
pal_pci_unmap_sg(
    void *pcidev,
    void *sglist,
    int nelems
    )
{
    pci_unmap_sg((struct pci_dev *)pcidev, (struct scatterlist *)sglist, 
        nelems, PCI_DMA_TODEVICE);
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void*
pal_vmalloc(
    U32 len
    )
{
    return vmalloc(len);
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
pal_vmfree(
    void* p
    )
{
    vfree( p );
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
int
pal_inc_usage(
    void
    )
{
    int rc = 0;
#if (LINUX_VERSION_CODE >= 0x20600)
    if (!try_module_get(THIS_MODULE)) 
    {  
        rc = -1;
    }
#else
    MOD_INC_USE_COUNT;
#endif
    return rc;
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
void
pal_dec_usage(
    void
    )
{
#if (LINUX_VERSION_CODE >= 0x20600)
    module_put(THIS_MODULE);
#else
    MOD_DEC_USE_COUNT;
#endif
}

/* vvvvvvvv  following code borrowed from st driver's direct IO vvvvvvvvv */
	/* hopefully this generic code will moved to a library */

/* Pin down user pages and put them into a scatter gather list. Returns <= 0 if
   - mapping of all pages not successful
   - any page is above max_pfn
   (i.e., either completely successful or fails)
*/
static int 
st_map_user_pages(struct scatterlist *sgl, const unsigned int max_pages, 
	          unsigned long uaddr, size_t count, int rw,
	          unsigned long max_pfn)
{
	int res, i, j;
	unsigned int nr_pages;
	struct page **pages;

	nr_pages = ((uaddr & ~PAGE_MASK) + count + ~PAGE_MASK) >> PAGE_SHIFT;

	/* User attempted Overflow! */
	if ((uaddr + count) < uaddr)
		return -EINVAL;

	/* Too big */
        if (nr_pages > max_pages)
		return -ENOMEM;

	/* Hmm? */
	if (count == 0)
		return 0;

	if ((pages = kmalloc(max_pages * sizeof(*pages), GFP_ATOMIC)) == NULL)
		return -ENOMEM;

        /* Try to fault in all of the necessary pages */
	down_read(&current->mm->mmap_sem);
        /* rw==READ means read from drive, write into memory area */
	res = get_user_pages(
		current,
		current->mm,
		uaddr,
		nr_pages,
		rw == READ,
		0, /* don't force */
		pages,
		NULL);
	up_read(&current->mm->mmap_sem);

	/* Errors and no page mapped should return here */
	if (res < nr_pages)
		goto out_unmap;

        for (i=0; i < nr_pages; i++) {
                /* FIXME: flush superflous for rw==READ,
                 * probably wrong function for rw==WRITE
                 */
		flush_dcache_page(pages[i]);
		if (page_to_pfn(pages[i]) > max_pfn)
			goto out_unlock;
		/* ?? Is locking needed? I don't think so */
		/* if (TestSetPageLocked(pages[i]))
		   goto out_unlock; */
        }

	/* Populate the scatter/gather list */
#if (LINUX_VERSION_CODE < 0x20618)
	sgl[0].page = pages[0]; 
#else
    sg_assign_page(&sgl[0], pages[0]);
#endif

	sgl[0].offset = uaddr & ~PAGE_MASK;
	if (nr_pages > 1) {
		sgl[0].length = PAGE_SIZE - sgl[0].offset;
		count -= sgl[0].length;
		for (i=1; i < nr_pages ; i++) {
			sgl[i].offset = 0;
#if (LINUX_VERSION_CODE < 0x20618)
			sgl[i].page = pages[i]; 
#else
            sg_assign_page(&sgl[i], pages[i]);
#endif
			sgl[i].length = count < PAGE_SIZE ? count : PAGE_SIZE;
			count -= PAGE_SIZE;
		}
	}
	else {
		sgl[0].length = count;
	}

	kfree(pages);
	return nr_pages;

 out_unlock:
	/* for (j=0; j < i; j++)
	   unlock_page(pages[j]); */
	res = 0;
 out_unmap:
	if (res > 0)
		for (j=0; j < res; j++)
			page_cache_release(pages[j]);
	kfree(pages);
	return res;
}


/* And unmap them... */
static int 
st_unmap_user_pages(struct scatterlist *sgl, const unsigned int nr_pages,
		    int dirtied)
{
	int i;

	for (i=0; i < nr_pages; i++) {
#if (LINUX_VERSION_CODE < 0x20618)
		if (dirtied && !PageReserved(sgl[i].page))
			SetPageDirty(sgl[i].page);
		/* unlock_page(sgl[i].page); */
		/* FIXME: cache flush missing for rw==READ
		 * FIXME: call the correct reference counting function
		 */
		page_cache_release(sgl[i].page);
#else
		if (dirtied && !PageReserved(sg_page(&sgl[i])))
			SetPageDirty(sg_page(&sgl[i]));
		page_cache_release(sg_page(&sgl[i]));
#endif
	}

	return 0;
}

/* ^^^^^^^^  above code borrowed from st driver's direct IO ^^^^^^^^^ */

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void *
pal_alloc_user_sgl(
    u32_t max_pages
    )
{
    void *user_sgl;

    user_sgl = (void *)kmalloc(
                            max_pages * sizeof(struct scatterlist), 
                            GFP_ATOMIC);

    if (NULL == user_sgl)
    {
        pal_sprintf(msg, "user_sgl=0x%x, max_pages=%d, size=0x%x\n", 
            user_sgl, max_pages,
            max_pages * sizeof(struct scatterlist));
        panic( msg );
    }
    return user_sgl;
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int 
pal_map_user_pages(void *sgl, const unsigned int max_pages, 
	          unsigned long uaddr, u32_t count)
{
	return st_map_user_pages(
                        (struct scatterlist *)sgl, 
                        max_pages, 
                        uaddr,
                        count, 
                        PCI_DMA_TODEVICE, 
                        ULONG_MAX);
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
int 
pal_unmap_user_pages(void *sgl, const unsigned int nr_pages)
{
 return (st_unmap_user_pages((struct scatterlist *)sgl, nr_pages, PCI_DMA_TODEVICE));
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
pal_pci_map_pages(
    void *pcidev,
    void *sgl,
    int nr_pages
    )
{
    struct scatterlist *user_sgl = sgl;
    int i;

    for (i=0; i < nr_pages ; i++) 
    {
        user_sgl[i].dma_address  = pci_map_page(
                                            (struct pci_dev *)pcidev, 
#if (LINUX_VERSION_CODE < 0x20618)
                                            user_sgl[i].page,
#else
                                            sg_page(&user_sgl[i]),
#endif
                                            user_sgl[i].offset,
                                            user_sgl[i].length,
                                            PCI_DMA_TODEVICE);
        //printk("dma_address hi = %ld; dma_address lo = %ld; dma_length = %ld;\n",
        //                                    (long int) (user_sgl[i].dma_address >> 32),
        //                                    (long int) (user_sgl[i].dma_address),
        //                                    (long int) (user_sgl[i].length));
    }
}
/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/

#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
pal_pci_unmap_pages(
    void *pcidev,
    void *sgl,
    int nr_pages
    )
{
    struct scatterlist *user_sgl = sgl;
    int i;

    for (i=0; i < nr_pages ; i++) 
    {
        pci_unmap_page((struct pci_dev *)pcidev, 
                       user_sgl[i].dma_address,
                       user_sgl[i].length,
                       PCI_DMA_TODEVICE);
    }
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
u64_t
pal_pci_map_single(
    void *pcidev,
    void *addr,
    u32_t size,
    int from_dev
    )
{
    int direction;

    direction = from_dev ? PCI_DMA_FROMDEVICE : PCI_DMA_TODEVICE;
    return (u64_t)pci_map_single((struct pci_dev *)pcidev,
                addr, size, direction);
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
pal_pci_unmap_single(
    void *pcidev,
    u64_t addr,
    u32_t size,
    int from_dev
    )
{
    int direction;

    direction = from_dev ? PCI_DMA_FROMDEVICE : PCI_DMA_TODEVICE;
    pci_unmap_single((struct pci_dev *)pcidev,
        (dma_addr_t)addr, size, direction);
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
u64_t
pal_sg_dma_address(
    void *sgl,
    int idx
    )
{
    struct scatterlist *user_sgl = sgl;

    return sg_dma_address(&user_sgl[idx]);
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
u32_t
pal_sg_dma_len(
    void *sgl,
    int idx
    )
{
    struct scatterlist *user_sgl = sgl;

    //return sg_dma_len(&user_sgl[idx]);
    return (user_sgl[idx].length);
}


#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
u32_t
pal_cpu_to_be32(
    u32_t value
	)
{
	return cpu_to_be32(value);
}


#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
u32_t
pal_cpu_to_le32(
    u32_t value 
	)
{
	return cpu_to_le32(value);
}


/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
void 
pal_print(
    const char* fmt,
    ...
    )
{
    va_list ap;
    unsigned long flags;

    va_start( ap, fmt );
    spin_lock_irqsave( &print_lock, flags );
    vsprintf( msg, fmt, ap );
    printk( "%s", msg );
    spin_unlock_irqrestore( &print_lock, flags );
    va_end( ap );
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
#if defined(CONFIG_X86) && ! defined(CONFIG_X86_64)
REGPARM(3)
#endif
void
pal_panic(
    const char* msg
    )
{
    panic( msg );
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
int
pal_sprintf(
    char* buf,
    const char* fmt,
    ...
    )
{
    int len;
    va_list ap;
    va_start( ap, fmt );
    len = vsprintf( buf, fmt, ap );
    va_end( ap );
    return len;
}
/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
u32_t
pal_inl(u32_t io_addr)
{
    return inl(io_addr);
}

u32_t
pal_inw(u32_t io_addr)
{
    return inw(io_addr);
}

u32_t
pal_inb(u32_t io_addr)
{
    return inb(io_addr);
}
/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
void
pal_outl(u32_t value, u32_t io_addr)
{
    outl(value, io_addr);
    return;
}

void
pal_outw(u32_t value, u32_t io_addr)
{
    outw((u16_t)value, io_addr);
    return;
}

void
pal_outb(u32_t value, u32_t io_addr)
{
    outb((u8_t)value, io_addr);
    return;
}

/****************************************************************************
 * 
 *
 * 
 *
 * Input;
 *      
 *
 * Output:
 *      
 *
 ****************************************************************************/
unsigned int
pal_get_page_shift(void)
{
    return PAGE_SHIFT;
}

unsigned int
pal_get_page_size(void)
{
    return PAGE_SIZE;
}
