/****************************************************************************
 * Copyright(c) 2000 Broadcom Corporation, all rights reserved
 * Proprietary and Confidential Information.
 *
 * This source file is the property of Broadcom Corporation, and
 * may not be copied or distributed in any isomorphic form without 
 * the prior written consent of Broadcom Corporation. 
 *
 * Name: bcmtype.h
 *
 * Description: Cross-Processor/OS/Compiler data type definition
 *
 * Author: ffan
 *
 * $Log:: /Source/BCM5700/asf/sdk/bcmtype.h                         $
 * 
 * 12    1/25/07 12:16p Shurd
 * Fixes types for Borland compilers
 * 
 * 11    5/04/05 1:06p Mnima
 * going to 64 bit compile and OS support
 * 
 * 10    11/11/04 4:27p Swindell
 * Support non-standard LINUX macro definition, just in case there's
 * some compiler out there that doesn't define __linux__.
 * 
 * 9     11/11/04 4:08p Swindell
 * Use standard macro (__linux__) to detect Linux build target.
 * 
 * 8     10/22/04 10:11a Ffan
 * 
 * 7     3/12/04 7:56p Swindell
 * U16 should be defined as an "unsigned short" (not int) by default.
 * This corresponds to the definition of S16.
 * 
 * 6     6/25/02 3:25p Dtran
 * 
 * 4     7/31/01 10:51a Hyfeng
 * Add few more lines for ASF project.
 * 
 * 3     7/20/01 10:49a Zambrano
 * 
 * 1     4/30/00 2:05p Ffan
 * Initial check-in. Both outbound and inbound load-balance and
 * failover are working.
 *
 ****************************************************************************/
#ifndef __bcmtype_h__
#define __bcmtype_h__

/*
 * define the data model
 */
#if !defined(LP64) && !defined(P64) && !defined(LLP64)
  /* VC 32-bit compiler 5.0 or later */
  #if (_MSC_VER > 800)
    #define P64
  #elif defined(__BORLANDC__)
    #define LP64
  #elif defined(__sun)
    /* Solaris */
    #define LP64
  #elif defined(_HPUX_SOURCE)
    /* HP/UX */
    #define LP64
  #elif defined(__FreeBSD__)
    /* FreeBSD */
    #define LP64
  #elif defined(__linux__) || defined(LINUX)
    /* Linux */
    #define LP64
  #elif defined(__bsdi__)
    /* BSDI */
    #define LP64
  #elif defined(_IRIX)
    #define LP64
  #elif defined(__NETWARE__)
    #define P64
  #endif /* _IRIX */
#endif /* !LP64 && !P64 && !LLP64 */

/*
 * define sized type
 */
#if defined(P64) || defined(LLP64)
  /* P64 */       
  typedef unsigned __int64    U64;
  typedef unsigned int        U32;
  typedef unsigned short      U16;
  typedef unsigned char       U8;
  typedef signed __int64      S64;
  typedef signed int          S32;
  typedef signed short        S16;
  typedef signed char         S8;

  typedef unsigned int        u32;
  typedef unsigned short      u16;
  typedef unsigned char       u8;
  typedef unsigned char       u08;
#elif defined(LP64)
  /* LP64: Sun, HP and etc */
  typedef unsigned long long  U64;
  typedef unsigned int        U32;
  typedef unsigned short      U16;
  typedef unsigned char       U8;
  typedef signed long long    S64;
  typedef signed int          S32;
  typedef signed short        S16;
  typedef signed char         S8;
#elif defined(__WATCOMC__)
  typedef unsigned __int64    U64;
  typedef unsigned long       U32;
  typedef unsigned short      U16;
  typedef unsigned char       U8;
  typedef signed __int64      S64;
  typedef signed long         S32;
  typedef signed short        S16;
  typedef signed char         S8;
#else 
  /* assume others: 16-bit */
  typedef unsigned char       U64[8];
  typedef unsigned long       U32;
  typedef unsigned short      U16;
  typedef unsigned char       U8;
  typedef signed char         S64[8];
  typedef signed long         S32;
  typedef signed short        S16;
  typedef signed char         S8;
#endif /*  */

/*
 * define lower case types
 */
typedef U64 u64_t;
typedef U32 u32_t;
typedef U16 u16_t;
typedef U8  u8_t;

typedef S64 s64_t;
typedef S32 s32_t;
typedef S16 s16_t;
typedef S8  s8_t;


#endif/* __bcmtype_h__ */

