/****************************************************************************
 * Copyright(c) 2000-2014 Broadcom Corporation, all rights reserved
 * Proprietary and Confidential Information.
 *
 * This source file is the property of Broadcom Corporation, and
 * may not be copied or distributed in any isomorphic form without 
 * the prior written consent of Broadcom Corporation. 
 *
 * Name: QLMAPI.h
 *
 * Description: Broadcom Management API.
 *
 * Author: hyfeng
 *
 ****************************************************************************/
#ifndef __QLMAPI_h__
#define __QLMAPI_h__

#ifdef __cplusplus
extern "C" 
{
#endif


// 03/01/2013, Sync up with structures defined in QLMAPI.h in Windows, v7.30.12


/****************************************************************************
 *  Function Return Code
 ****************************************************************************/
#define QLMAPI_OK                        0
#define QLMAPI_MEMALLOC                  1       // memory allocation failed
#define QLMAPI_READCONFIG                2       // read configuration failed
#define QLMAPI_BUFSHORT                  3       // memory buffer too short
#define QLMAPI_INVALID_HANDLE            4       // invalid handle
#define QLMAPI_INVALID_PARAMETER         5       // one or more of parameters
                                                // are invalid
#define QLMAPI_UNSUPPORT_PLATFORM        6       // platform not supported
#define QLMAPI_INVALID_DATA_FROM_DRIVER  7       // driver returned data is not
                                                // correct
#define QLMAPI_INTERNAL_DATA_ERROR       8       // internal data error
#define QLMAPI_INIT_COM_FAILED           9       // initialize COM failed
#define QLMAPI_TEAM_NOT_ENOUGH_NIC       10      // Each team must have at least
                                                // on team member and an
                                                // standby adapter or two team
                                                // members
#define QLMAPI_INVALID_PHY_NIC_HANDLE    11      // an invalid physical NIC
                                                // handle is used
#define QLMAPI_INVALID_TEAM_NAME         12      // the team name is empty or
                                                // has leading space
#define QLMAPI_INVALID_TEAM_MEMBER       13      // all adapters of the same
                                                // driver class must be either
                                                // all assigned to teams or all
                                                // unassigned
#define QLMAPI_INVALID_VLAN_MEMBER       14      // all physical adapters in the
                                                // team MUST be able to do VLAN
                                                // tag. Currently, only
                                                // QLMAPI_ALTEON and
                                                // QLMAPI_BRCM5700 can suppoort
                                                // VLAN
#define QLMAPI_DRIVER_NOT_INSTALLED      15      // intermediate or miniport
                                                // driver not installed
#define QLMAPI_CONFIGURE_REG_FAILED      16      // write registry failed
#define QLMAPI_REBOOT_BEFORE_ADD         17      // reboot machine before add
                                                // adapter
#define QLMAPI_LOAD_LIBRARY_FAILED       18      // load external help library
                                                // failed
#define QLMAPI_CONFIGURE_SYS_FAILED      19      // configure system error
#define QLMAPI_DRIVER_NOT_LOADED         20      // driver is not loaded
#define QLMAPI_DEVIO_CALL_FAILED         21      // DeviceIoControl() failed
#define QLMAPI_BINDING_FAILED            22      // binding is not completed
#define QLMAPI_SERVICE_EXIST             23      // service is installed, users
                                                // may need to reboot machine
#define QLMAPI_SERVICE_MARK_DELETE       24      // service is marked to delete,
                                                // users may need to reboot
                                                // machine
#define QLMAPI_CREATE_SERVICE_FAILED     25      // unable to create service
#define QLMAPI_DELETE_SERVICE_FAILED     26      // unable to delete service
#define QLMAPI_REMOVE_ROUTE_FAILED       27      // RemoveRouteFromNETBIOS()
                                                // failed
#define QLMAPI_DRIVER_COMMUNICATE_ERROR  28      // failed to communicate with
                                                // driver
#define QLMAPI_DEV_IN_DIAG               29      // the device is in diag mode
#define QLMAPI_FUNCTION_NOT_ALLOWED      QLMAPI_DEV_IN_DIAG   // obsolete
#define QLMAPI_INVALID_TEAM_ID           30      // invalid team ID
#define QLMAPI_UPDATE_CONFIG_FAILED      31      // update configuration failed
#define QLMAPI_WRONG_DRIVER_VERSION      32      // the version of driver is not
                                                // supported by BMAPI
#define QLMAPI_NO_MAC_ADDR               33      // no MAC address configured
#define QLMAPI_NO_VIRTUAL_ADAPTER        34      // no virtual adapter
                                                // configured for the team
#define QLMAPI_NO_WRITE_ACCESS_RIGHT     35      // no write access right
#define QLMAPI_NOT_SUPPORTED_NIC         36      // the NIC is not supported
#define QLMAPI_STANDBY_NOT_SUPPORTED     37      // stand by adapter is not
                                                // supported for the team type
#define QLMAPI_CAN_NOT_LOCK_NETCFG       38      // failed to lock network
                                                // configuration in Win2000
#define QLMAPI_QLMAPI_NOT_INITIALIZED     39      // applications did not call
                                                // QLmapiInitialize()
#define QLMAPI_EVENT_FEATURE_INI_FAILED  40      // initializeation for event
                                                // feature failed
#define QLMAPI_DUPLICATE_TEAM_NAME       41      // applications submit
                                                // duplicate team name when
                                                // calling QLmapiApplyLBFOCfg
#define QLMAPI_DUPLICATE_PHY_NIC         42      // applications submit
                                                // duplicate physical NIC in
                                                // team configuration when
                                                // calling QLmapiApplyLBFOCfg
#define QLMAPI_NO_VLAN_NAME              43      // applications submit more
                                                // than one virtual adapter
                                                // for a team and one or more
                                                // virtual adapter doesn't have
                                                // a VLAN name when calling
                                                // QLmapiApplyLBFOCfg
#define QLMAPI_DUPLICATE_VLAN_NAME       44      // applications submit
                                                // duplicate VLAN name in a
                                                // team when calling
                                                // QLmapiApplyLBFOCfg
#define QLMAPI_DUPLICATE_VLAN_ID         45      // applications submit
                                                // duplicate VLAN ID in a
                                                // team when calling
                                                // QLmapiApplyLBFOCfg
#define QLMAPI_INVALID_VLAN_ID           46      // application submit invalid
                                                // VLAN ID when calling
                                                // QLmapiApplyLBFOCfg. Valid
                                                // VLAN ID could be from 0 to
                                                // 4094.
#define QLMAPI_TOO_MANY_TAGGED_VLANS     47      // we only support up to
                                                // QLMAPI_MAXIMUM_MEMBERS_VIR_TEAM - 1
                                                // tagged VLANs plus one
                                                // optional untagged VLAN
#define QLMAPI_TOO_MANY_PHY_NICS         48      // too many physical NICs in
                                                // a team
#define QLMAPI_TOO_MANY_VIR_NICS         49      // too many virtual NICs in
                                                // a team
#define QLMAPI_DUPLICATE_TEAM_ID         50      // applications submit
                                                // duplicate team ID when
                                                // calling QLmapiApplyLBFOCfg
#define QLMAPI_NIC_NOT_FOUND             51      // NIC not found
#define QLMAPI_NIC_NOT_IN_TEAM           52      // NIC is not in the team
#define QLMAPI_SCM_LOCKED                53      // service control manager is
                                                // locked
#define QLMAPI_UNSUPPORTED_VERSION       54      // unsupported version for
                                                // the data structure
#define QLMAPI_UNSUPPORTED_IOCTL         55      // unsupported IOCTL
#define QLMAPI_ASF_NOT_CAPABLE           56      // the NIC is not capable of
                                                // ASF feature
#define QLMAPI_ASF_NOT_CONFIGURED        57      // the NIC is not configured
                                                // for ASF
#define QLMAPI_EEPROM_CORRUPTED          58      // EEPROM of the NIC is
                                                // corrupted
#define QLMAPI_READ_EEPROM_FAILED        59      // read EEPROM failed
#define QLMAPI_ASF_TABLE_CORRUPTED       60      // ASF table in NIC is
                                                // corrupted
#define QLMAPI_SUSPEND_DRIVER_FAILED     61      // failed to suspend driver
                                                // or NIC
#define QLMAPI_WRITE_ASF_TABLE_FAILED    62      // obsolete
#define QLMAPI_LOCK_NIC_FAILED           63      // failed to gain exclusive
                                                // access to a NIC. Try later.
#define QLMAPI_DRIVER_NOT_SUSPENDED      64
#define QLMAPI_REGISTER_TEST_FAILED      65
#define QLMAPI_MII_REGISTER_TEST_FAILED  66
#define QLMAPI_MEMORY_TEST_FAILED        67
#define QLMAPI_TEST_INTERRUPT_FAILED     68
#define QLMAPI_CPU_TEST_FAILED           69
#define QLMAPI_UNABLE_TO_RESET_RX_CPU    70
#define QLMAPI_UNABLE_TO_RESET_TX_CPU    71
#define QLMAPI_RX_CPU_TEST_FAILED        72
#define QLMAPI_TX_CPU_TEST_FAILED        73
#define QLMAPI_RESUME_DRIVER_FAILED      74
#define QLMAPI_UNABLE_TO_GET_SERVICE_NAME    75
#define QLMAPI_UNABLE_TO_LOAD_INTERMEDIATE_DRIVER    76
#define QLMAPI_UNABLE_TO_SET_PACKET_FILTER   77
#define QLMAPI_LOOPBACK_TEST_FAILED      78
#define QLMAPI_NO_DIAG_ACCESS_RIGHT      79      // application did not call
                                                // QLmapiInitDiag() with
                                                // successful return
#define QLMAPI_WRITE_EEPROM_FAILED       80      // write EEPROM failed
#define QLMAPI_ASF_TEST_RESET_FAILED     81      // ASF reset failed
#define QLMAPI_ASF_TEST_RX_EVENT_FAILED  82      // ASF RXCPU event failed
#define QLMAPI_ASF_TEST_TX_EVENT_FAILED  83      // ASF TXCPU event failed
#define QLMAPI_ASF_TEST_POLL_TIMER_FAILED    84  // ASF poll timer failed
#define QLMAPI_ASF_TEST_ATTN_LOC_FAILED  85      // ASF ATTN loc failed
#define QLMAPI_ASF_TEST_HB_TIMER_FAILED  86      // ASF heartbeat timer failed
#define QLMAPI_ASF_TEST_PL_TIMER_FAILED  87      // ASF poll legacy timer failed
#define QLMAPI_ASF_TEST_RT_TIMER_FAILED  88      // ASF retransmit timer failed
#define QLMAPI_ASF_TEST_WD_TIMER_FAILED  89      // ASF watchdog timer failed
#define QLMAPI_ASF_TEST_NO_STAMP         90      // ASF timestamp counter is not
                                                // counting
#define QLMAPI_NO_WRITE_EEPROM_PRIV      91      // No priviledge to write
                                                // EEPROM
#define QLMAPI_FW_NOT_LOADED             92      // Firmware is not loaded
#define QLMAPI_NO_READ_EEPROM_PRIV       93      // No priviledge to read
                                                // EEPROM
#define QLMAPI_NO_SYSTEM_UUID            94      // no system UUID found
#define QLMAPI_NO_ASF_TABLES             95      // no ASF tables found
#define QLMAPI_UNSUPPORTED_FW_VERSION    96      // unsupported firmware version
#define QLMAPI_INVALID_OFFSET_OR_LEN     97      // offset or length must be at
                                                // 32-bit alignment
#define QLMAPI_READ_REGISTER_FAILED      98      // read register failed
#define QLMAPI_WRITE_REGISTER_FAILED     99      // write register failed
#define QLMAPI_NO_READ_NIC_MEM_PRIV      100     // no priviledge to read NIC
                                                // memory
#define QLMAPI_READ_NIC_MEM_FAILED       101     // read NIC memory failed
#define QLMAPI_NO_WRITE_NIC_MEM_PRIV     102     // no priviledge to write NIC
                                                // memory
#define QLMAPI_WRITE_NIC_MEM_FAILED      103     // write NIC memory failed
#define QLMAPI_CREATELOCK_FAILED         104     // create lock fialed
#define QLMAPI_READ_PCI_CONFIG_FAILED    105     // read PCI configuration
#define QLMAPI_FILE_OPEN_FAILED          106     // file open failed
#define QLMAPI_MEM_MAP_FAILED            107     // map mempry failed
#define QLMAPI_NO_IP_INFO                108     // can not find IP information
                                                // for an adapter, could be
                                                // driver is not loaded or
                                                // no IP bind to the adapter
#define QLMAPI_NETTEST_INI_FAILED        109     // NetworkTest init failed
                                                // no IP protocol???
#define QLMAPI_NETTEST_CFG_FAILED        110     // NetworkTest configure test
                                                // failed
#define QLMAPI_NETTEST_ADAPT_NOIP        111     // adapter has no valid IP
#define QLMAPI_NETTEST_ADAPT_BIND        112     // bind to adapter failed
#define QLMAPI_NETTEST_INVALID_DEST      113     // invalid destination address
#define QLMAPI_NETTEST_SEND_FAILED       114     // send packet failed
#define QLMAPI_NETTEST_RECV_FAILED       115     // receive packet failed
#define QLMAPI_NETTEST_TEST_FAILED       116     // no response received
#define QLMAPI_INVALID_TEAMTYPE_CHANGE   117     // unsupported team type
                                                // changed
#define QLMAPI_INVALID_TTCFG_PHY         118     // obsolete
#define QLMAPI_UNSUPPORTED_TT_OS         119     // obsolete
#define QLMAPI_NO_TT_IN_BASP             120     // obsolete
#define QLMAPI_NOT_TT_NIC                121     // obsolete
#define QLMAPI_CONFIG_TT_FAILED          122     // obsolete
#define QLMAPI_INVALID_TEAMTYPE          123     // unsupported team type
#define QLMAPI_NON_TT_DRIVER             124     // obsolete
#define QLMAPI_PHY_OFF                   125     // PHY is off
#define QLMAPI_LOOPBACK_TEST_NOLINK      126     // no link for loopback test
#define QLMAPI_OBSOLETE_API              127     // the API is now obsolete
#define QLMAPI_FILE_NOT_FOUND            128     // dependent file is not found
#define QLMAPI_OS_ACCESS_DENIED          129     // user does not have access
                                                // right
#define QLMAPI_CONNECT_SCM_FAILED        130     // failed to connect to service
                                                // control manager
#define QLMAPI_NOT_SUPPORTED_DRV         131     // the driver is not supported
#define QLMAPI_FEATURE_NOT_AVAILABLE     200     // the request feature is not
                                                // available for the device
#define QLMAPI_REBOOT_REQUIRED           201     // reboot machine is required
                                                // to recover from the failure
#define QLMAPI_RESTART_DEVICE_FAILED     202     // failed to restart a device
#define QLMAPI_CREATE_DEVICE_FAILED      203     // failed to create a device
#define QLMAPI_FIND_DEVICE_FAILED        204     // failed to find an installed
                                                // device. Could be driver is
                                                // not installed yet.
#define QLMAPI_LED_TEST_FAILED           205     // LED test failed
#define QLMAPI_LICENSE_INFO_TIMEOUT      206     // read or write license key
                                                // timeout
#define QLMAPI_LICENSE_INFO_BUSY         207     // another license information
                                                // request pending, try again
                                                // later
#define QLMAPI_LICENSE_KEY_NOTEXIST      208     // the license key does not
                                                // exist
#define QLMAPI_LICENSE_KEY_INVALID       209     // the license key is invalid
#define QLMAPI_NO_VALID_LICENSE_KEY      210     // no valice key cen be found
                                                // in the NIC
#define QLMAPI_CON_EXCEED_HW_MAX         211     // number of reserved
                                                // connections exceeds
                                                // hardware limitation
#define QLMAPI_CON_EXCEED_LIC_MAX        212     // number of reserved
                                                // connections exceeds
                                                // licensed connections
#define QLMAPI_RES_EXCEED_HW_MAX         213     // total reserved resources
                                                // exceeds hardware limitation
#define QLMAPI_RES_NOT_LICENSED          214     // reserved connections are
                                                // not licensed
#define QLMAPI_UNSUPPORTED_ADDR_TYPE     215     // unsupported address type
#define QLMAPI_DUPLICATE_ADDR            216     // duplicate address
#define QLMAPI_PROBE_UNSUPPORTED         217     // probe packe is not supported
#define QLMAPI_NO_TARGET_IP              218     // no target IP configured for
                                                // Probe Packet feature
#define QLMAPI_NO_PHY_PROBE_IP           219     // no IP configured for
                                                // physical NIC for Probe
                                                // Packet feature
#define QLMAPI_CABDIAG_FAIL              220     // cable diag failed
#define QLMAPI_CREATE_THREAD_FAILED      221     // failed to create thread
#define QLMAPI_DOING_DIAGNOSTICS         222     // a diagnostics is running
                                                // already
#define QLMAPI_NO_DIAGNOSTICS            223     // no pending diagnostics
#define QLMAPI_CAN_NOT_STOP_DIAG         224     // failed to stop diagnostics
#define QLMAPI_MANUF_KEY_CRC_ERR         225     // manufacturing key CRC error
#define QLMAPI_UPG_KEY_CRC_ERR           226     // upgrade key CRC error
#define QLMAPI_OTP_ACCESS_NOT_SUPPORTED  227     // OTP access is not supported
// TODO: On Win23, 228 is QLMAPI_INVALID_MBOX_NUM (depracated)
#define QLMAPI_NVRAM_PROGRAM_FAILED      228     // NVRAM download failed
#define QLMAPI_INVALID_PHY_FIRMWARE      229     // Invalid PHY firmware image
#define QLMAPI_UPGRADE_PHY_FW_ERROR      230     // Failed to upgrade PHY firmware
#define QLMAPI_INVALID_TEAM_TYPE_W_ISCSI 231     // invalid team type with iSCSI
#define QLMAPI_APEEVT_TIMEOUT            232     // send APE event time out
#define QLMAPI_APEEVT_MSG_TOO_LONG       233     // send APE event message too
                                                // long
#define QLMAPI_NOT_ENOUGH_DATA           234     // request more that data
                                                // length
#define QLMAPI_DATA_NOT_FOUND            235     // requested data not found
#define QLMAPI_MGMT_FW_UNAVAILABLE       236     // maganement FW not running
#define QLMAPI_APE_NOT_STOP              237     // APE is not stopped
#define QLMAPI_DIR_FOUND                 238
#define QLMAPI_DIR_FULL                  239
#define QLMAPI_INVALID_NVRAM_SIZE        240
#define QLMAPI_NVRAM_FULL                241
#define QLMAPI_CONNECT_WMI_FAILED        242     // failed to connect to WMI
#define QLMAPI_GET_WMI_OBJECT_FAILED     243     // failed to get WMI object
#define QLMAPI_GET_PROPERTY_FAILED       244     // failed to get WMI object
                                                // property
#define QLMAPI_UNSUPPORTED_LICENSE_VER   245     // unsupported license key
                                                // version
#define QLMAPI_TOO_MANY_TEAMS            246     // configure too many teams
#define QLMAPI_NO_NVMDIR_FOUND           247     // can not find a NVRAM
                                                // directory entry
#define QLMAPI_UNSUPPORTED_FW            248     // unsupported FW image
// TODO: This is the Win32 value... do not reuse.
//#define QLMAPI_NVRAM_PROGRAM_FAILED      249     // NVRAM download failed
#define QLMAPI_NO_DIR                    250     // NVRAM image does not support
                                                // directory
#define QLMAPI_BOOT_DEV                  251     // The port is a boot device.
#define QLMAPI_INVALID_TEAM_TYPE_W_FCOE  252     // invalid team type with FCoE
#define QLMAPI_LOW_SYSTEM_RESOURCES      253     // IOCTL failed due to low
                                                // system ressources
// TODO: This is 229 in the Win32 BMAPI.
#define QLMAPI_ISCSI_BOOT_DEV            254     // The NIC is on iSCSI boot.
#define QLMAPI_DEVICE_IS_NOT_UP          255     // The device is not up and running.
#define QLMAPI_PORT_RESET_REQUIRED       256     // port reset is required



/****************************************************************************
 *  Other definitions
 ****************************************************************************/

#define QLMAPI_MAJOR_VERSION             6
#define QLMAPI_MINOR_VERSION             24
#define QLMAPI_BUILD_VERSION             1 

#define QLMAPI_MAX_PRODUCT_LEN           80
#define QLMAPI_MAX_DESC_LEN              80
#define QLMAPI_MAX_VLAN_NAME_LEN         40
#define QLMAPI_MAX_TEAM_NAME_LEN         40
#define QLMAPI_MAX_IP_ADDR_LEN           20
#define QLMAPI_MAX_MEMORY_ADDR_LEN       80
#define QLMAPI_MAX_MAC_ADDR_LEN          20
#define QLMAPI_MAX_TITLE_LEN             80
#define QLMAPI_MAX_MFG_LEN               80
#define QLMAPI_MAX_DRV_NAME              32
#define QLMAPI_MAX_DRV_INT_TYPE          16
#define QLMAPI_MAX_DRVVER_LEN            40
#define QLMAPI_MAX_TEAM                  16

#define QLMAPI_LBFO_MINIPORT_NAME        "Blfm"
#define QLMAPI_LBFO_MINIPORT_DESC        "Broadcom Ndis Miniport Driver"
#define QLMAPI_LBFO_MINIPORT_TITLE       "BASP Virtual Adapter"

#define QLMAPI_INVALID_NIC_HANDLE        0
#define QLMAPI_INVALID_TEAM_HANDLE       0

#define QLMAPI_MAX_VLAN_ID               4094
#define QLMAPI_INVALID_IP_ADDR           223

// return 'status' of QLmapiLBFOSoftwareStatus()
#define QLMAPI_LBFO_STATUS_NOT_INSTALLED 0
#define QLMAPI_LBFO_STATUS_NOT_LOADED    1
#define QLMAPI_LBFO_STATUS_LOADED        2

// Definition for QLmapiEnableDevice()
#define QLMAPI_NIC_DISABLE               0
#define QLMAPI_NIC_ENABLE                1
#define QLMAPI_NIC_PROPCHANGE            2

#define QLMAPI_FW_MAX_DESCRIPTION_LEN    16

// 'uType' definition for QLmapiReadNicMem() and QLmapiWriteNicMem().
#define QLMAPI_INDIRECT_REG_READ         0
#define QLMAPI_INDIRECT_MEM_READ         1
#define QLMAPI_PHY_REG_READ              2
#define QLMAPI_REG_READ                  3
#define QLMAPI_MEM_READ                  4
#define QLMAPI_PCICFG_REG_READ           5   // For ESXi only...

#define QLMAPI_INDIRECT_REG_WRITE        0
#define QLMAPI_INDIRECT_MEM_WRITE        1
#define QLMAPI_PHY_REG_WRITE             2
#define QLMAPI_REG_WRITE                 3
#define QLMAPI_MEM_WRITE                 4

// 'uType' definition for QLmapiGetIpAddrInfo().
#define QLMAPI_IPINFO_IP_LIST            0
#define QLMAPI_IPINFO_SUBNETMASK_LIST    1
#define QLMAPI_IPINFO_GATEWAY_LIST       2

// 'uWhere' definition for QLmapiGetPowerMode().
#define QLMAPI_GET_POWER_MODE_DRIVER     0
#define QLMAPI_GET_POWER_MODE_EEPROM     1

// 'uWhere' definition for QLmapiSetPowerMode().
#define QLMAPI_SET_POWER_MODE_DRIVER     0
#define QLMAPI_SET_POWER_MODE_EEPROM     1
#define QLMAPI_SET_POWER_MODE_BOTH       2       /* EEPROM and driver        */

// Mode definition for QLmapiGetPowerMode and QLmapiSetPowerMode().
#define QLMAPI_POWER_MODE_FULL           0
#define QLMAPI_POWER_MODE_LOW            1

// 'uOption' definition for QLmapiWriteFirmwareInfo().
#define QLMAPI_WR_FW_MANUFAC             0x00000001

#define QLMAPI_MAX_COMMUNITY_NAME_LEN    20

// 'uPhyStatus' definition for QLmapiSetPHYStatus() and QLmapiGetPHYStatus().
#define QLMAPI_PHY_STATUS_ON             0
#define QLMAPI_PHY_STATUS_OFF            1

// Loopback type for QLmapiTestLoopBack() and QLmapiTestLoopBackEx()
#define QLMAPI_LOOPBACK_TYPE_MAC         0
#define QLMAPI_LOOPBACK_TYPE_PHY         1
#define QLMAPI_LOOPBACK_TYPE_TWO_NODE    2
#define QLMAPI_LOOPBACK_TYPE_EXTERNAL    3

// Target type for QLmapiReadFirmware2()
#define QLMAPI_NVRAM_TARGET_ACTIVE       0   // The device currently is using.
#define QLMAPI_NVRAM_TARGET_NVRAM        1   // SEEPROM or flash
#define QLMAPI_NVRAM_TARGET_OTP          2   // OTP

/****************************************************************************
 *  OBSOLETE loopback definition
 ****************************************************************************/
//#define LOOPBACK_TYPE_MAC               QLMAPI_LOOPBACK_TYPE_MAC
//#define LOOPBACK_TYPE_PHY               QLMAPI_LOOPBACK_TYPE_PHY
//#define LOOPBACK_TYPE_TWO_NODE          QLMAPI_LOOPBACK_TYPE_TWO_NODE



/****************************************************************************
 *  OBSOLETE starts here
 ****************************************************************************/
// Used by QLmapiGetMultiBRCMNicParams()
#define QLMAPI_BRCMNIC_PARAM_TYPE_UNKNOWN    0
#define QLMAPI_BRCMNIC_PARAM_TYPE_DWORD      1
#define QLMAPI_BRCMNIC_PARAM_TYPE_BINARY     2   // binary data

#define QLMAPI_BRCMNIC_PARAM_RESULT_OK           0
#define QLMAPI_BRCMNIC_PARAM_RESULT_NOTEXIST     1   // not exist
#define QLMAPI_BRCMNIC_PARAM_RESULT_NOTSUPPORTED 2   // not supported
#define QLMAPI_BRCMNIC_PARAM_RESULT_ERROR        3   // registry reading error
#define QLMAPI_BRCMNIC_PARAM_RESULT_BUFTOOSHORT  4   // buffer too short
#define QLMAPI_BRCMNIC_PARAM_RESULT_WRONGDATALEN 5   // incorrect parameter data length
#define QLMAPI_BRCMNIC_PARAM_RESULT_DATAINVALID  6   // invalid data value for the parameter

// Configurable Broadcom NIC parameters.
#define QLMAPI_BRCMNIC_RXJUMBODESCCNT    0   // type: DWORD, range: 0-255, default: 0
#define QLMAPI_BRCMNIC_TASKOFFLOADCAP    1   // type: DWORD
                                            // value: 0 - None (default)
                                            // value: 21 - Tx TCP/IP Checksum
                                            // value: 42 - Rx TCP/IP Checksum
                                            // value: 63 - Tx/Rx TCP/IP Checksum
#define QLMAPI_BRCMNIC_WAKEUPMODECAP     2   // type: DWORD
                                            // value: 0 - None
                                            // value: 1 - Magic Packet
                                            // value: 2 - Wake Up Frame
                                            // value: 3 - Both (default)
#define QLMAPI_BRCMNIC_FLOWCONTROLCAP    3   // type: DWORD
                                            // value: 0 - Disable (default)
                                            // value: 1 - Rx PAUSE
                                            // value: 2 - Tx PAUSE
                                            // value: 3 - Rx/Tx PAUSE
                                            // value: 2147483648 - Auto
#define QLMAPI_BRCMNIC_ENABLE8021P       4   // type: DWORD
                                            // value: 0 - Disable (default)
                                            // value: 1 - Enable
#define QLMAPI_BRCMNIC_JUMBOFRAMESIZE    5   // type: DWORD
                                            // value: 1500 (bytes) (default)
                                            // value: 2000 (bytes)
                                            // value: 2500 (bytes)
                                            // value: 3000 (bytes)
                                            // value: 3500 (bytes)
                                            // value: 4000 (bytes)
                                            // value: 4500 (bytes)
                                            // value: 5000 (bytes)
                                            // value: 5500 (bytes)
                                            // value: 6000 (bytes)
                                            // value: 6500 (bytes)
                                            // value: 7000 (bytes)
                                            // value: 7500 (bytes)
                                            // value: 8000 (bytes)
#define QLMAPI_BRCMNIC_NETWORKADDRESS    6   // type: binary (6 bytes)
#define QLMAPI_BRCMNIC_WOL_SPEED         7   // type: DWORD
                                            // value: 0 - Auto (default)
                                            // value: 1 - 10 Mb
                                            // value: 2 - 100 Mb

// Parameter values for Broadcom NIC.
#define QLMAPI_BRCMNIC_RXJUMBODESCCNT_MIN                0   // default
#define QLMAPI_BRCMNIC_RXJUMBODESCCNT_MAX                255

#define QLMAPI_BRCMNIC_TASKOFFLOADCAP_NONE               0   // default
#define QLMAPI_BRCMNIC_TASKOFFLOADCAP_TXTCPIPCHKSUM      21
#define QLMAPI_BRCMNIC_TASKOFFLOADCAP_RXTCPIPCHKSUM      42
#define QLMAPI_BRCMNIC_TASKOFFLOADCAP_TXRXTCPIPCHKSUM    63

#define QLMAPI_BRCMNIC_WAKEUPMODECAP_NONE                0
#define QLMAPI_BRCMNIC_WAKEUPMODECAP_MAGICPACKET         1
#define QLMAPI_BRCMNIC_WAKEUPMODECAP_WAKEUPFRAME         2
#define QLMAPI_BRCMNIC_WAKEUPMODECAP_BOTH                3   // default

#define QLMAPI_BRCMNIC_FLOWCONTROLCAP_DISABLE            0   // default
#define QLMAPI_BRCMNIC_FLOWCONTROLCAP_RXPAUSE            1
#define QLMAPI_BRCMNIC_FLOWCONTROLCAP_TXPAUSE            2
#define QLMAPI_BRCMNIC_FLOWCONTROLCAP_RXTXPAUSE          3
#define QLMAPI_BRCMNIC_FLOWCONTROLCAP_AUTO               2147483648

#define QLMAPI_BRCMNIC_ENABLE8021P_DISABLE               0   // default
#define QLMAPI_BRCMNIC_ENABLE8021P_ENABLE                1

#define QLMAPI_BRCMNIC_JUMBOFRAMESIZE_1500               1500    // default
#define QLMAPI_BRCMNIC_JUMBOFRAMESIZE_2000               2000
#define QLMAPI_BRCMNIC_JUMBOFRAMESIZE_2500               2500
#define QLMAPI_BRCMNIC_JUMBOFRAMESIZE_3000               3000
#define QLMAPI_BRCMNIC_JUMBOFRAMESIZE_3500               3500
#define QLMAPI_BRCMNIC_JUMBOFRAMESIZE_4000               4000
#define QLMAPI_BRCMNIC_JUMBOFRAMESIZE_4500               4500
#define QLMAPI_BRCMNIC_JUMBOFRAMESIZE_5000               5000
#define QLMAPI_BRCMNIC_JUMBOFRAMESIZE_5500               5500
#define QLMAPI_BRCMNIC_JUMBOFRAMESIZE_6000               6000
#define QLMAPI_BRCMNIC_JUMBOFRAMESIZE_6500               6500
#define QLMAPI_BRCMNIC_JUMBOFRAMESIZE_7000               7000
#define QLMAPI_BRCMNIC_JUMBOFRAMESIZE_7500               7500
#define QLMAPI_BRCMNIC_JUMBOFRAMESIZE_8000               8000

#define QLMAPI_BRCMNIC_WOL_SPEED_AUTO                    0   // default
#define QLMAPI_BRCMNIC_WOL_SPEED_10MB                    1
#define QLMAPI_BRCMNIC_WOL_SPEED_100MB                   2
/****************************************************************************
 *  OBSOLETE ends here
 ****************************************************************************/


// ASF definition
#define QLMAPI_MAX_ALERTDATA                             8
#define QLMAPI_ASF_SPEC_1_0_ALERTDATA_ELEMENT_LENGTH     12
#define QLMAPI_MAX_CONTROLDATA                           8
#define QLMAPI_MAX_SPEC_1_0_CONTROLDATA_ELEMENT_LENGTH   4

// since structure ASF_ADDR has extra 2 bytes other than FixedSMBusAddresses,
// to align the structure to LONG, QLMAPI_MAX_FIXEDSMBUSADDR should use
// (multiple of 4) - 2. In this case, we are using 14.
#define QLMAPI_MAX_FIXEDSMBUSADDR                        14

// speed defines for QL_ASF_MISC
#define QLMAPI_ASF_SPEED_10_100          0
#define QLMAPI_ASF_SPEED_10              1
#define QLMAPI_ASF_SPEED_100             2
#define QLMAPI_ASF_SPEED_1000            3
#define QLMAPI_ASF_SPEED_ALL             4
#define QLMAPI_ASF_SPEED_MASK            0x7

#define QLMAPI_ASF_HALF_DUPLEX           0x20
#define QLMAPI_ASF_PAUSE_NOT_CAPABLE     0x40
#define QLMAPI_ASF_AUTO_DISABLE          0x80

// Definition for QLmapiEnableDevice()
#define QLMAPI_NIC_DISABLE               0
#define QLMAPI_NIC_ENABLE                1
#define QLMAPI_NIC_PROPCHANGE            2

#define QLMAPI_FW_MAX_DESCRIPTION_LEN    16

// 'uType' definition for QLmapiReadNicMem() and QLmapiWriteNicMem().
#define QLMAPI_INDIRECT_REG_READ         0
#define QLMAPI_INDIRECT_MEM_READ         1
#define QLMAPI_PHY_REG_READ              2
#define QLMAPI_INDIRECT_REG_WRITE        0
#define QLMAPI_INDIRECT_MEM_WRITE        1
#define QLMAPI_PHY_REG_WRITE             2

// 'uType' definition for QLmapiGetIpAddrInfo().
#define QLMAPI_IPINFO_IP_LIST            0
#define QLMAPI_IPINFO_SUBNETMASK_LIST    1
#define QLMAPI_IPINFO_GATEWAY_LIST       2

#if 0
// 'uWhere' definition for QLmapiGetPowerMode().
#define QLMAPI_GET_POWER_MODE_DRIVER     0
#define QLMAPI_GET_POWER_MODE_EEPROM     1

// 'uWhere' definition for QLmapiSetPowerMode().
#define QLMAPI_SET_POWER_MODE_DRIVER     0
#define QLMAPI_SET_POWER_MODE_EEPROM     1
#define QLMAPI_SET_POWER_MODE_BOTH       2       /* EEPROM and driver        */

// Mode definition for QLmapiGetPowerMode and QLmapiSetPowerMode().
#define QLMAPI_POWER_MODE_FULL           0
#define QLMAPI_POWER_MODE_LOW            1
#endif

// 'SupportedFlags' definition for QL_BRCM_ADAPTER_INFO_EX.
#define QLMAPI_DRV_RSS_ENABLED       0x00000004  // 1 if driver is doing RSS, 0 if not
//#define QLMAPI_DRV_ISCSI_BOOT_INTF   0x00000008  // 1 if the interface is an ISCSI boot interface
#define QLMAPI_REMOTE_PHY_CAPABLE    0x00000010  // 1 if the interface capable of remote PHY
#define QLMAPI_REMOTE_PHY_ACTIVE     0x00000020  // 1 if the interface is using remote PHY
// Determine which MFW is currently ruinning in NX2
#define QLMAPI_MFW_RUN_UNKNOWN       0x00000000
#define QLMAPI_MFW_RUN_IPMI          0x00000040
#define QLMAPI_MFW_RUN_UMP           0x00000080
#define QLMAPI_MFW_RUN_NCSI          0x000000c0
#define QLMAPI_MFW_RUN_NONE          0x000001c0
#define QLMAPI_MFW_RUN_MASK          0x000001c0
#define QLMAPI_REMOTE_PHY_MODULE_PRESENT 0x00000200  // 1 if the remote PHY module is present
#define QLMAPI_DRV_ISCSI_BOOT_HBA    0x00000400  // 1 if the interface ISCSI boot from HBA, applicable only for BRCM iSCSI boot
#define QLMAPI_DRV_ISCSI_BOOT_NDIS   0x00000800  // 1 if the interface ISCSI boot from NDIS, applicable only for BRCM iSCSI boot
#define QLMAPI_EXT_PHY               0x00001000  // 1 if the port is using external PHY, applicable only for 57710 family
#define QLMAPI_WOL_NO_VAUX           0x00002000  // 1 if the port does not have Vaux power to support WOL, applicable only for 5706 family
#define QLMAPI_DRV_FCOE_BOOT_HBA     0x00004000  // 1 if the interface ISCSI boot from HBA, applicable only for BRCM FCoE boot
#define QLMAPI_VBD_NO_L4             0x40000000  // 1 if it is VBD but no L4 support.
#define QLMAPI_EXT_INFO_VALID        0x80000000  // 1 if 'intr_info' is valid

// 'uOption' definition for QLmapiWriteFirmwareInfo().
#define QLMAPI_WR_FW_MANUFAC             0x00000001

#define QLMAPI_MAX_COMMUNITY_NAME_LEN    20

// 'uPhyStatus' definition for QLmapiSetPHYStatus() and QLmapiGetPHYStatus().
#define QLMAPI_PHY_STATUS_ON             0
#define QLMAPI_PHY_STATUS_OFF            1



/****************************************************************************/
/* Loopback type.                                                           */
/****************************************************************************/
#define QLMAPI_LOOPBACK_TYPE_MAC         0
#define QLMAPI_LOOPBACK_TYPE_PHY         1
#define QLMAPI_LOOPBACK_TYPE_TWO_NODE    2
#define QLMAPI_LOOPBACK_TYPE_EXTERNAL    3

// Target type for QLmapiReadFirmware2()
#define QLMAPI_NVRAM_TARGET_ACTIVE       0   // The device currently is using.
#define QLMAPI_NVRAM_TARGET_NVRAM        1   // SEEPROM or flash
#define QLMAPI_NVRAM_TARGET_OTP          2   // OTP

/****************************************************************************
 *  OBSOLETE loopback definition
 ****************************************************************************/
#define LOOPBACK_TYPE_MAC               QLMAPI_LOOPBACK_TYPE_MAC
#define LOOPBACK_TYPE_PHY               QLMAPI_LOOPBACK_TYPE_PHY
#define LOOPBACK_TYPE_TWO_NODE          QLMAPI_LOOPBACK_TYPE_TWO_NODE



#ifdef _WIN32

//
// extra_info for EVT_ACTIVE and EVT_INACTIVE
//
#define QLMAPI_EVINFO_ACTIVITY_LINK      0   // active/inactive due to link status
#define QLMAPI_EVINFO_ACTIVITY_MANUAL    1   // active/inactive due to enable/disable
#define QLMAPI_EVINFO_ACTIVITY_ADDREMOVE 2   // active/inactive due to add/remove
#define QLMAPI_EVINFO_ACTIVITY_STANDBY   3   // active/inactive due to standby
#define QLMAPI_EVINFO_ACTIVITY_NONE      0xFFFFFFFF

typedef enum
{
    QLMAPI_EVT_ACTIVE = 0,       // adapter is active
    QLMAPI_EVT_INACTIVE = 1,     // adapter is inactive
    QLMAPI_EVT_LINKUP = 2,       // adapter's link status goes up
    QLMAPI_EVT_LINKDOWN = 3,     // adapter's link status goes down
    QLMAPI_EVT_ENABLE = 4,       // adapter is enabled via management interface
    QLMAPI_EVT_DISABLE = 5,      // adapter is disabled via management interface
    QLMAPI_EVT_ADD = 6,          // adapter is added to a team
    QLMAPI_EVT_REMOVE = 7,       // adapter is removed from a team
    QLMAPI_EVT_ASFCFG_CHG = 100, // adapter's ASF configuration is modified
    QLMAPI_EVT_DEV_ARRIVED = 101,    // a device is arrived or enabled
    QLMAPI_EVT_DEV_REMOVED = 102,    // a device is to be removed

#if defined(__NETWARE__)
    QLMAPI_EVT_DUMMY = 0xFFFFFFF    // make it a 32-bit variable
#else    
    QLMAPI_EVT_DUMMY = 0xFFFFFFFF    // make it a 32-bit variable
#endif    
} QLMAPI_EV_TYPE;


typedef void (*BMAPIEVENTCALLBACK)( U32 event, const S8 *team_name, U32 team_id, const S8 *adapter_service_name, U32 adapter_handle, U32 lb_number, U32 sb_number, U32 extra_info, void *cookie );

#ifndef BOOL
typedef int                 BOOL;
#endif

#else /* Unix */

#ifndef BOOL
typedef int   BOOL;
#endif
#ifndef TRUE
#define TRUE  1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#if defined(__linux__) || defined(LINUX)

#include <endian.h>

#if __BYTE_ORDER == __BIG_ENDIAN
#define BCM_BIG_ENDIAN_HOST 1
#define BIG_ENDIAN_HOST 1
 #ifndef BIG_ENDIAN
  #define BIG_ENDIAN 1
 #endif
#else
 #define BCM_LITTLE_ENDIAN_HOST	1
 #define LITTLE_ENDIAN_HOST 1
 #ifndef LITTLE_ENDIAN
  #define LITTLE_ENDIAN 1
 #endif
#endif

#define ABS_SWAP(w) ((((w) & 0xff000000) >> 24) | (((w) & 0x00ff0000) >> 8) | (((w) & 0x0000ff00) << 8) | (((w) & 0x000000ff) << 24))

#if defined(BIG_ENDIAN) && !defined(BCM_LITTLE_ENDIAN_HOST)
 #define QLMAPI_LENDIAN_SWAP_S(w) (w)
 #define QLMAPI_LENDIAN_SWAP(w) (w)
 #define QLMAPI_BENDIAN_SWAP_S(w)   ((((w) & 0xff00) >> 8) | (((w) & 0x00ff) << 8))
 #define QLMAPI_BENDIAN_SWAP(w) ABS_SWAP(w)
#else

 #define QLMAPI_LENDIAN_SWAP_S(w)   ((((w) & 0xff00) >> 8) | (((w) & 0x00ff) << 8))
 #define QLMAPI_LENDIAN_SWAP(w) ABS_SWAP(w)
 #define QLMAPI_BENDIAN_SWAP_S(w) (w)
 #define QLMAPI_BENDIAN_SWAP(w) (w)
#endif

#endif /* LINUX */

#endif /* Unix */




/****************************************************************************
 *  Data Structures
 ****************************************************************************/
// These are for 'nic_type' phisical devices.
#define QLMAPI_NON_BROADCOM_NIC          0
#define QLMAPI_ALTEON                    1
//#define QLMAPI_BRCM5700                  2
#define QLMAPI_UNKNOWN_NIC               3       // driver is not running
#define QLMAPI_BRCM5706                  4
#define QLMAPI_BRCM57710                 5

// These are the 'nic_type' for virtual devices.
#define QLMAPI_BASP_VIR                  100
#define QLMAPI_VIR_NDIS                  101
#define QLMAPI_VIR_WSD                   102
#define QLMAPI_VIR_ISCSI                 103
#define QLMAPI_VIR_DIAG                  104
#define QLMAPI_VIR_FCOE                  105
#define QLMAPI_5706_NDIS                 QLMAPI_VIR_NDIS
#define QLMAPI_5706_WSD                  QLMAPI_VIR_WSD
#define QLMAPI_5706_ISCSI                QLMAPI_VIR_ISCSI
#define QLMAPI_5706_DIAG                 QLMAPI_VIR_DIAG

// 'member_type' in QL_ADAPTER_INFO
#define QLMAPI_MEMBER_ROLE_LOAD_BALANCE  0
#define QLMAPI_MEMBER_ROLE_STAND_BY      1

// 'state' in QL_ADAPTER_INFO
#define QLMAPI_MEMBER_STATE_UP           0
#define QLMAPI_MEMBER_STATE_DOWN         1
#define QLMAPI_MEMBER_STATE_DISABLED     2

typedef struct _QL_ADAPTER_INFO
{
    // NIC card type. Valid only for physical adapters.
    // QLMAPI_NON_BROADCOM_NIC == non Broadcom NIC,
    // QLMAPI_ALTEON == T2, QLMAPI_BRCM5700 == T3, ...
    U32 nic_type;

    // Application use this handle number to indicate which adapter
    // it is referring to. If handle == QLMAPI_INVALID_NIC_HANDLE,
    // The adapter is not found in current configuration.
    U32 handle;

    // pTitle will be the unique "friendly name" displayed to users.
    S8  title[QLMAPI_MAX_TITLE_LEN];

    // Product name of the adapter. It Is used to IdentIfy whether two
    // adapters belong the same class of driver.
    S8  product_name[QLMAPI_MAX_PRODUCT_LEN];

    // Physical adapter type in a team whether is part of a load
    // balancing team or a fail over adapter.
    // QLMAPI_MEMBER_ROLE_LOAD_BALANCE == use for load balancing or unassigned.
    // QLMAPI_MEMBER_ROLE_STAND_BY == fail over adapter (standby).
    U32 member_type;

    // Description of the adapter. May not be available for all adapters.
    S8  description[QLMAPI_MAX_DESC_LEN];

    // Boolean flag to denote if DHCP is enabled.
    // Not available in non Windows platforms.
    U32 dhcp_enabled;

    // IP address is "192.168.0.1" format. (REG_MULTI_SZ or REG_SZ)
    S8  ip_addr[QLMAPI_MAX_IP_ADDR_LEN];

    // subnet mask is "255.255.0.0" format. (REG_MULTI_SZ or REG_SZ)
    S8  subnet_mask[QLMAPI_MAX_IP_ADDR_LEN];

    // defaule gateway is "192.168.0.1" format. (REG_MULTI_SZ or REG_SZ)
    S8  default_gateway[QLMAPI_MAX_IP_ADDR_LEN];

    // Boolean flag to indicate whether driver is running.
    U32 driver_loaded;

    // These information is valid only driver is running.
    S8  current_mac_addr[QLMAPI_MAX_MAC_ADDR_LEN];

    // On Linux, perm mac address can be retrieved by 
    // QLmapiGetBRCMNicInfoEx()or by bQLmapiGetPhyNic().
    S8  permanent_mac_addr[QLMAPI_MAX_MAC_ADDR_LEN];

#ifdef _WIN32
    U32 major_version_number;
    U32 minor_version_number;
#else /* unix */
    U8  driver_version[QLMAPI_MAX_DRVVER_LEN];
#endif /* unix */

    // VLAN ID should be filled here. VLAN ID should greater or equal
    // to 1. Exist only for virtual adapters.
    U32 vlan_id;
    S8  vlan_name[QLMAPI_MAX_VLAN_NAME_LEN];

    // State of this adapter, can be either up, down or disabled. This
    // is valid only when data is retrieved from QLmapiGetTeamSnapShot().
    // Possible value:
    // QLMAPI_MEMBER_STATE_UP, QLMAPI_MEMBER_STATE_DOWN,
    // QLMAPI_MEMBER_STATE_DISABLED
    U32 state;

    // Link speed of the physical NIC in Mbps, i.e. 10 = 10Mbps. This
    // is valid only when physical NIC card data is retrieved from
    // QLmapiGetTeamSnapShot()
    U32 link_speed;

} QL_ADAPTER_INFO;



typedef struct _QL_OFFLOAD_TCP_IP_CHECKSUM
{
    // boolean value
    // not valid if the field is set to false (0).
    U32             valid;

    union {
        struct
        {
            U32         IpOptionsSupported:1;
            U32         TcpOptionsSupported:1;
            U32         TcpChecksum:1;
            U32         UdpChecksum:1;
            U32         IpChecksum:1;
        } V4Transmit;

        U32     V4Transmit_flags;
    };

    union {
        struct
        {   
            U32         IpOptionsSupported:1;
            U32         TcpOptionsSupported:1;
            U32         TcpChecksum:1;
            U32         UdpChecksum:1;
            U32         IpChecksum:1;
        } V4Receive;

        U32     V4Receive_flags;
    };

    union {
        struct
        {
            U32         IpOptionsSupported:1;
            U32         TcpOptionsSupported:1;
            U32         TcpChecksum:1;
            U32         UdpChecksum:1;

        } V6Transmit;

        U32     V6Transmit_flags;
    };

    union {
        struct
        {   
            U32         IpOptionsSupported:1;
            U32         TcpOptionsSupported:1;
            U32         TcpChecksum:1;
            U32         UdpChecksum:1;
        
        } V6Receive;

        U32     V6Receive_flags;
    };

} QL_OFFLOAD_TCP_IP_CHECKSUM;



typedef struct _QL_OFFLOAD_TCP_LARGE_SEND
{
    // boolean value
    // not valid if the field is set to false (0).
    U32     valid;

    U32     MaxOffLoadSize;
    U32     MinSegmentCount;
    U32     TcpOptions; // boolean value
    U32     IpOptions;  // boolean value

} QL_OFFLOAD_TCP_LARGE_SEND;



typedef struct _QL_OFFLOAD_TCP_CONNECTION
{
    // boolean value
    // not valid if the field is set to false (0).
    U32     valid;

    // These are boolean values. '1' means supported. '0' means
    // not supported.
    // Any of the four fields is set, the NIC is TCP offload capable.
    U32     SupportIp4;
    U32     SupportIp6;
    U32     SupportIp6ExtensionHeaders;
    U32     SupportSack;

    U32     TcpConnectionOffloadCapacity;

} QL_OFFLOAD_TCP_CONNECTION;



typedef enum
{
    QLmapiIpPrefixOriginOther = 0,           // The IPv6 prefix was provided by
                                            // a source other than those
                                            // defined in this enumeration.
    QLmapiIpPrefixOriginManual,              // The IPv6 prefix was manually
                                            // specified.
    QLmapiIpPrefixOriginWellKnown,           // The IPv6 prefix is from a well
                                            // known source.
    QLmapiIpPrefixOriginDhcp,                // The IPv6 prefix was provided by
                                            // DHCP settings.
    QLmapiIpPrefixOriginRouterAdvertisement, // The IPv6 prefix was obtained
                                            // through a router advertisement
                                            // (RA).
} QL_IP_PREFIX_ORIGIN;

typedef enum
{
    QLmapiIpSuffixOriginOther = 0,           // The IPv6 suffix was provided by
                                            // a source other than those
                                            // defined in this enumeration.
    QLmapiIpSuffixOriginManual,              // The IPv6 suffix was manually
                                            // specified.
    QLmapiIpSuffixOriginWellKnown,           // The IPv6 suffix is from a well
                                            // known source.
    QLmapiIpSuffixOriginDhcp,                // The IPv6 suffix was provided by
                                            // DHCP settings.
    QLmapiIpSuffixOriginLinkLayerAddress,    // The IPv6 suffix was obtained
                                            // from the link-layer address.
    QLmapiIpSuffixOriginRandom,              // The IPv6 suffix was obtained
                                            // from a random source.
} QL_IP_SUFFIX_ORIGIN;

typedef enum
{
    QLmapiIpDadStateInvalid = 0,             // The DAD state is invalid.
    QLmapiIpDadStateTentative,               // The DAD state is tentative.
    QLmapiIpDadStateDuplicate,               // A duplicate IPv6 address has
                                            // been detected.
    QLmapiIpDadStateDeprecated,              // The IPv6 address has been
                                            // deprecated.
    QLmapiIpDadStatePreferred,               // The IPv6 address is the
                                            // preferred address.
} QL_IP_DAD_STATE;


#define QLMAPI_IP_ADDR_DNS_ELIGIBLE   0x01   // The address is legal to appear
                                            // in DNS.
#define QLMAPI_IP_ADDR_TRANSIENT      0x02   // The address is a cluster address
                                            // and should not be used by most
                                            // applications.

typedef struct _QL_IP_ADDRESS
{
    // The first two fields should be equivelent to:
    // struct sockaddr_in6
    // {
    //        short   sin6_family;
    //        u_short sin6_port;
    //        u_long  sin6_flowinfo;
    //        struct  in6_addr sin6_addr;
    //        u_long  sin6_scope_id;
    // };
    U16     sa_family;              // address family
    char    sa_data[26];
} QL_IP_ADDRESS;

typedef struct _QL_IP_UNICAST_ADDRESS
{
    // Boolean value. If 0, the data are invalid and shuld NOT be used.
    U32                 valid;

    // Currently, the following values are supported:
    // QLMAPI_IP_ADDR_DNS_ELIGIBLE
    // QLMAPI_IP_ADDR_TRANSIENT
    U32                 Flags;

    // IP address
    QL_IP_ADDRESS       Address;

    // Only available for Vista or later.
    U8                  PrefixLength;

    U8                  reserved1[35];

    QL_IP_PREFIX_ORIGIN PrefixOrigin;
    QL_IP_SUFFIX_ORIGIN SuffixOrigin;
    QL_IP_DAD_STATE     DadState;           // Duplicate Address Detection
                                            // (DAD) state.

    U32                 ValidLifetime;      // Valid lifetime for the address,
                                            // in seconds.
    U32                 PreferredLifetime;  // Preferred lifetime for the
                                            // address, in seconds.
    U32                 LeaseLifetime;      // Lease lifetime for the address,
                                            // in seconds.
    U8                  reserved2[32];
} QL_IP_UNICAST_ADDRESS;



typedef struct _QL_IP_ADAPTER_GATEWAY_ADDRESS {
    // Boolean value. If 0, the data are invalid and shuld NOT be used.
    U32                 valid;

    QL_IP_ADDRESS       Address;
} QL_IP_ADAPTER_GATEWAY_ADDRESS;



#define QL_OFFLOAD_NOT_SUPPORTED            0
#define QL_OFFLOAD_SUPPORTED                1

#define QL_OFFLOAD_SET_NO_CHANGE            0
#define QL_OFFLOAD_SET_ON                   1
#define QL_OFFLOAD_SET_OFF                  2

//
// Encapsulation types that are used during offload in query
//
#define QL_ENCAPSULATION_NOT_SUPPORTED              0x00000000                         
#define QL_ENCAPSULATION_NULL                       0x00000001
#define QL_ENCAPSULATION_IEEE_802_3                 0x00000002
#define QL_ENCAPSULATION_IEEE_802_3_P_AND_Q         0x00000004
#define QL_ENCAPSULATION_IEEE_802_3_P_AND_Q_IN_OOB  0x00000008
#define QL_ENCAPSULATION_IEEE_LLC_SNAP_ROUTED       0x00000010

typedef struct _QL_TCP_LARGE_SEND_OFFLOAD_V1
{

    struct
    {
        U32     Encapsulation;
        U32     MaxOffLoadSize;
        U32     MinSegmentCount;
        U32     TcpOptions;
        U32     IpOptions;
    } IPv4;

} QL_TCP_LARGE_SEND_OFFLOAD_V1;

typedef struct _QL_TCP_IP_CHECKSUM_OFFLOAD
{

    struct
    {
        U32     Encapsulation;
        U32     IpOptionsSupported;
        U32     TcpOptionsSupported;
        U32     TcpChecksum;
        U32     UdpChecksum;
        U32     IpChecksum;
    } IPv4Transmit;

    struct
    {
        U32     Encapsulation;
        U32     IpOptionsSupported;
        U32     TcpOptionsSupported;
        U32     TcpChecksum;
        U32     UdpChecksum;
        U32     IpChecksum;
    } IPv4Receive;


    struct
    {
        U32     Encapsulation;
        U32     IpExtensionHeadersSupported;
        U32     TcpOptionsSupported;
        U32     TcpChecksum;
        U32     UdpChecksum;

    } IPv6Transmit;

    struct
    {
        U32     Encapsulation;
        U32     IpExtensionHeadersSupported;
        U32     TcpOptionsSupported;
        U32     TcpChecksum;
        U32     UdpChecksum;

    } IPv6Receive;

} QL_TCP_IP_CHECKSUM_OFFLOAD;

typedef struct _QL_IPSEC_OFFLOAD_V1
{
    struct
    {
        U32     Encapsulation;
        U32     AhEspCombined;
        U32     TransportTunnelCombined;
        U32     IPv4Options;
        U32     Flags;
    } Supported;

    struct
    {
        U32     Md5;
        U32     Sha_1;
        U32     Transport;
        U32     Tunnel;
        U32     Send;
        U32     Receive;
    } IPv4AH;

    struct
    {
        U32     Des;
        U32     Reserved;
        U32     TripleDes;
        U32     NullEsp;
        U32     Transport;
        U32     Tunnel;
        U32     Send;
        U32     Receive;
    } IPv4ESP;

} QL_IPSEC_OFFLOAD_V1;

typedef struct _QL_TCP_LARGE_SEND_OFFLOAD_V2
{
    struct 
    {
         U32    Encapsulation;
         U32    MaxOffLoadSize;
         U32    MinSegmentCount;
    }IPv4;

    struct 
    {
         U32    Encapsulation;
         U32    MaxOffLoadSize;
         U32    MinSegmentCount;
         U32    IpExtensionHeadersSupported;
         U32    TcpOptionsSupported;
    }IPv6;

} QL_TCP_LARGE_SEND_OFFLOAD_V2;


typedef struct _QL_TASK_OFFLOAD
{
    // Boolean value. If 0, the data are invalid and shuld NOT be used.
    U32                             valid;

    //
    // Checksum Offload information
    //
    QL_TCP_IP_CHECKSUM_OFFLOAD      Checksum;

    //
    // Large Send Offload information
    //
    QL_TCP_LARGE_SEND_OFFLOAD_V1    LsoV1;

    //
    // IPsec Offload Information
    //
    QL_IPSEC_OFFLOAD_V1             IPsecV1;
    //
    // Large Send Offload version 2Information
    //
    QL_TCP_LARGE_SEND_OFFLOAD_V2    LsoV2;

    // reserved
    U32                             Flags;

} QL_TASK_OFFLOAD;



typedef struct _QL_TCP_CONNECTION_OFFLOAD
{
    // Boolean value. If 0, the data are invalid and shuld NOT be used.
    U32     valid;

    U32     Encapsulation;
    U32     SupportIPv4;
    U32     SupportIPv6;
    U32     SupportIPv6ExtensionHeaders;
    U32     SupportSack;
    U32     TcpConnectionOffloadCapacity;
    U32     Flags;
} QL_TCP_CONNECTION_OFFLOAD;



// 'flags' in QL_ADAPTER_INFO_EX
#define QLMAPI_NIC_NO_MINOPORT_DRV       0x00000001
#define QLMAPI_NIC_ASF_POSSIBLE          0x00000002
// Expand the flag to include ASF and TruManage
#define QLMAPI_NIC_MGMT_POSSIBLE         QLMAPI_NIC_ASF_POSSIBLE

// 'team_type' in QL_ADAPTER_INFO_EX, QL_VIR_NIC_INFO_EX, QL_TEAM_INFO
// and QL_TEAM_INFO2
#define QLMAPI_TEAM_BRCM_LBFO            0
#define QLMAPI_TEAM_FEC_GEC              1
#define QLMAPI_TEAM_802_3_AD             2
#define QLMAPI_TEAM_SLB_AFD              4
#define QLMAPI_INVALID_TEAM_TYPE         0xFFFFFFFF

// 'link_status' in QL_ADAPTER_INFO_EX, QL_VIR_NIC_INFO_EX
// and QL_BRCM_ADAPTER_INFO
#define QLMAPI_LM_STATUS_LINK_ACTIVE     4
#define QLMAPI_LM_STATUS_LINK_DOWN       5

// 'media_type' in QL_ADAPTER_INFO_EX and QL_BRCM_ADAPTER_INFO
#define QLMAPI_LM_MEDIA_TYPE_UNKNOWN     ( U32 )-1
#define QLMAPI_LM_MEDIA_TYPE_AUTO        0
#define QLMAPI_LM_MEDIA_TYPE_UTP         1
#define QLMAPI_LM_MEDIA_TYPE_BNC         2
#define QLMAPI_LM_MEDIA_TYPE_AUI         3
#define QLMAPI_LM_MEDIA_TYPE_FIBER       4
#define QLMAPI_LM_MEDIA_TYPE_SERDES      5
#define QLMAPI_LM_MEDIA_TYPE_SERDES_SGMII    6
#define QLMAPI_LM_MEDIA_TYPE_XGXS        7
#define QLMAPI_LM_MEDIA_TYPE_XGXS_SGMII  8

// 'line_speed' in QL_ADAPTER_INFO_EX and QL_BRCM_ADAPTER_INFO
// 'link_speed' in QL_LINK_STATUS
#define QLMAPI_LM_LINE_SPEED_UNKNOWN     0
#define QLMAPI_LM_LINE_SPEED_10MBPS      1
#define QLMAPI_LM_LINE_SPEED_100MBPS     2
#define QLMAPI_LM_LINE_SPEED_1000MBPS    3
#define QLMAPI_LM_LINE_SPEED_2500MBPS    4
#define QLMAPI_LM_LINE_SPEED_10GBPS      5

// 'bus_type' in QL_ADAPTER_INFO_EX
#define QLMAPI_BUS_TYPE_UNKNOWN          0
#define QLMAPI_BUS_TYPE_UNSUPPORTED      1
#define QLMAPI_BUS_TYPE_PCI              2
#define QLMAPI_BUS_TYPE_PCMCIA           3
#define QLMAPI_BUS_TYPE_1394             4
#define QLMAPI_BUS_TYPE_USB              5

// 'arch_type' in QL_ADAPTER_INFO_EX
#define QLMAPI_ARCH_VBD                  1
#define QLMAPI_ARCH_L2_ONLY              2
#define QLMAPI_ARCH_5706_VBD             QLMAPI_ARCH_VBD
#define QLMAPI_ARCH_5706_L2_ONLY         QLMAPI_ARCH_L2_ONLY



#define QLMAPI_ADAPTER_INFO_EX_VER       11

typedef struct _QL_ADAPTER_INFO_EX
{
    //  Version is defined as QLMAPI_ADAPTER_INFO_EX_VER.
    //  'version' is required upon input
    U32                 version;

    U32                 flags;
    QL_ADAPTER_INFO     adap_info;

    // If PCI IDs information is not available, the value will be -1 and
    // 'manufacturer' will be "".
    U32                 vendor_id;
    U32                 device_id;
    U32                 subsystem_vendor_id;
    U32                 subsystem_id;
    U8                  manufacturer[QLMAPI_MAX_MFG_LEN];

    // revision from PCI bus registers 0x08
    U32                 revision;

    // PCI bus information. If these information are not available,
    // data will be set to -1.
    U32                 bus_no;
    U32                 device_no;
    U32                 function_no;

    // PCI slot number labeled next to motherboard. This is an optional
    // field (at least, LOM will not have it). If it is not available,
    // this field will be set to -1.
    U32                 ui_number;

    // PCI information
    // Valid only when vendor_id equal to 0x14E4 and
    // nic_type is QLMAPI_BRCM5700.
    U32                 mem_base_low;
    U32                 mem_base_high;

    // PCI information
    U32                 irq;

    // NIC information
    // Available only when vendor_id equal to 0x14E4 and
    // nic_type is QLMAPI_BRCM5700.
    U32                 phy_id;
    U32                 phy_addr;

    // For nic_type is QLMAPI_BRCM5700.
    //  ChipId:4, ChipRev:4, MetalRev:8
    // For example :
    // 5700 A1 : 0x7000 : chip ID 0x7, chip rev 0x0, metal rev 0x01
    // 5700 B2 : 0x7000 : chip ID 0x7, chip rev 0x1, metal rev 0x02
    // 5701 A3 : 0x0003 : chip ID 0x0, chip rev 0x0, metal rev 0x03
    //
    // For nic_type is QLMAPI_BRCM5706.
    //  ChipId:16, ChipRev:4, MetalRev:8
    U32                 chip_rev_id;

    U32                 media_type;

    // Possible value:
    // QLMAPI_LM_LINE_SPEED_UNKNOWN, QLMAPI_LM_LINE_SPEED_10MBPS,
    // QLMAPI_LM_LINE_SPEED_100MBPS, QLMAPI_LM_LINE_SPEED_1000MBPS
    U32                 line_speed;

    // Possible value:
    // QLMAPI_LM_STATUS_LINK_ACTIVE, QLMAPI_LM_STATUS_LINK_DOWN
    U32                 link_status;

#ifndef _WIN32
    // Possible value:
    // QLMAPI_LM_DUPLEX_MODE_UNKNOWN, QLMAPI_LM_DUPLEX_MODE_HALF
    // QLMAPI_LM_DUPLEX_MODE_FULL
    U32                 duplex_mode;
#endif /* _WIN32 */

    // NIC information
    // Available only when vendor_id equal to 0x14E4.
    U32                 upper_misc_host_ctrl_reg;

    // Driver information
    U8                  driver_name[QLMAPI_MAX_DRV_NAME];
    U32                 driver_size;
    U8                  driver_interface_type[QLMAPI_MAX_DRV_INT_TYPE];
    U32                 driver_interface_version_major;
    U32                 driver_interface_version_minor;

    // NIC information
    // Available only when vendor_id equal to 0x14E4 and
    // nic_type is QLMAPI_BRCM5700.
    U32                 internal_ram_size;

    // Could be QLMAPI_BUS_TYPE_UNKNOWN, QLMAPI_BUS_TYPE_UNSUPPORTED,
    // QLMAPI_BUS_TYPE_PCI or QLMAPI_BUS_TYPE_PCMCIA
    U32                 bus_type;

    // Available only when vendor_id equal to 0x14E4 and
    // nic_type is QLMAPI_BRCM5706.
    // For L2 open source 5706 driver, the only valid value is 
    // QLMAPI_ARCH_5706_L2_ONLY.
    U32                 arch_type;

#ifndef _WIN32
    // bits per second
    U64                 max_speed;

    // MTU: The maximum size of the INFO (non-MAC) field that will be "
    // received or transmitted. (MIB.IETF|BRIDGE-MIB.dot1dTpPortMaxInfo)
    U32                 mtu;

    // in_diag:
    // non-zero if the device is under diagnose
    // zero if the device is NOT under diagnose
    // Available only for Broadcom network controllers.
    U32                 in_diag;

#endif /* _WIN32 */

    // For nic_type QLMAPI_BRCM5706 only.
    // PCI config space BAR size.
    U32                 bar_size;

    // For nic_type QLMAPI_BRCM57710, there will be two BARs per port.
    // Here is the second BAR information.
    U32                 mem_base_low2;
    U32                 mem_base_high2;
    U32                 bar_size2;

    // First IPv6 address found for the NIC.
    // Applications can cast like "( LPSOCKADDR )&ipv6.Address" to API
    // such as WSAAddressToString().
    QL_IP_UNICAST_ADDRESS       ipv6;

    // First IPv6 Gateway address found for the NIC.
    // Only available for Vista or later.
    // Applications can cast like "( LPSOCKADDR )&gateway_v6.Address" to API
    // such as WSAAddressToString(). 
    QL_IP_ADAPTER_GATEWAY_ADDRESS   gateway_v6;

// 'ipv6_flags' in QL_ADAPTER_INFO_EX
#define QLMAPI_IP_ADAPTER_DHCP_ENABLED   0x00000004
    U32                 ipv6_flags;

    // These handles are valid when 'arch_type' is QLMAPI_ARCH_5706_L2_ONLY.
    U32                 iscsi_handle;
    U32                 fcoe_handle;

    // Team name.  Not supported in bmapilnx.
    S8                  team_name[QLMAPI_MAX_TEAM_NAME_LEN];

    // Team ID.  Not supported in bmapilnx.
    U32                 team_id;

    // The unit value is Kbps. The actual speed value will be truncated
    // to the lower bound of Kbps. For example, if the speed is 14.4 Kbps,
    // the value will be 14. If the speed is less than 1 Kbps, the value
    // will be 0.
    U32                 line_speed_Kbps;

    // Team Type. QLMAPI_TEAM_BRCM_LBFO == Broadcom LBFO,
    // QLMAPI_TEAM_802_3_AD == 802.3ad, QLMAPI_TEAM_FEC_GEC == FEC/GEC
    // QLMAPI_TEAM_SLB_AFD == SLB (Auto Fallback Disabled)
    // Not supported in bmapilnx.
    U32                 team_type;

    // For 5706 VBD only. 5706 VBD will have major, minor and build version
    // numbers. major and minor version numver will be in QL_ADAPTER_INFO.
    // This will be the build number.
    // In Linux, for NX2 driver only...
    U32                 drv_build_ver_num;
    U32                 reserved;
// NOT supported in QLmapilnx =====================================Begin
    // 802.3 offload capabilities
    // These three fields valid ONLY for OS prior to (include) Windows 2003.
    // For NDIS 6.0 and later (Vista and Longhorn), use 'ol_task' and
    // 'ol_conn'.
    QL_OFFLOAD_TCP_IP_CHECKSUM  ol_802_3_tcpip_chksum;
    QL_OFFLOAD_TCP_LARGE_SEND   ol_802_3_lso;
    QL_OFFLOAD_TCP_CONNECTION   ol_802_3_tcp_conn;
// NOT supported in QLmapilnx ========================================End

// NOT supported in QLmapilnx =====================================Begin
    // These two fields valid only for NDIS 6.0 and later (Vista and
    // Longhorn).
    QL_TASK_OFFLOAD             ol_task;
    QL_TCP_CONNECTION_OFFLOAD   ol_conn;

    // These handles are valid when 'arch_type' is QLMAPI_ARCH_VBD.
    U32                 ndis_handle;
    U32                 wsd_handle;
    U32                 diag_handle;
// NOT supported in QLmapilnx ========================================End

    // Available for NDIS 6.0 and later.
    // The link speed is in bits per second. A value of -1 in this member
    // indicates that the link speed is unknown.
    U64                 max_xmit_link_speed;
    U64                 max_rcv_link_speed;
    U64                 xmit_link_speed;
    U64                 rcv_link_speed;

// NOT supported in QLmapilnx =====================================Begin
    // Available for NDIS 6.0 and later.
    // Definitions for 'rss_caps'.
#define QLMAPI_RSS_CAPS_MESSAGE_SIGNALED_INTERRUPTS      0x01000000
#define QLMAPI_RSS_CAPS_CLASSIFICATION_AT_ISR            0x02000000
#define QLMAPI_RSS_CAPS_CLASSIFICATION_AT_DPC            0x04000000
#define QLMAPI_RSS_CAPS_HASH_TYPE_TCP_IPV4               0x00000100
#define QLMAPI_RSS_CAPS_HASH_TYPE_TCP_IPV6               0x00000200
#define QLMAPI_RSS_CAPS_HASH_TYPE_TCP_IPV6_EX            0x00000400
#define QLMAPI_RSS_HASHFUNCTIONTOEPLITZ                  0x00000001 // supported hash function 1 -- Main RSS hash function 
    U32                 rss_caps;
    U32                 rss_num_interrupt_msg;
    U32                 rss_num_rcv_que;
// NOT supported in QLmapilnx ========================================End

#ifndef _WIN32
    // In Windows, the following two variables are in QL_ADAPTER_INFO.
    U32 major_version_number;
    U32 minor_version_number;
    U32 domain_no;
#endif

} QL_ADAPTER_INFO_EX;



// This structure is for Broadcom BASP virtual adapter only.
// It is not used in bmapilnx currently.
#define QLMAPI_VIR_NIC_INFO_EX_VER       1

typedef struct _QL_VIR_NIC_INFO_EX
{
    //  Version is defined as QLMAPI_VIR_NIC_INFO_EX_VER.
    //  'version' is required upon input
    U32                 version;

    QL_ADAPTER_INFO     adap_info;

    // Possible value:
    // QLMAPI_LM_STATUS_LINK_ACTIVE, QLMAPI_LM_STATUS_LINK_DOWN
    U32                 link_status;

    // Driver information
    U8                  driver_name[QLMAPI_MAX_DRV_NAME];
    U32                 driver_size;
    U8                  driver_interface_type[QLMAPI_MAX_DRV_INT_TYPE];
    U32                 driver_interface_version_major;
    U32                 driver_interface_version_minor;

    // Team name.
    S8                  team_name[QLMAPI_MAX_TEAM_NAME_LEN];

    // Team ID
    U32                 team_id;

    // The unit value is Kbps. The actual speed value will be truncated
    // to the lower bound of Kbps. For example, if the speed is 14.4 Kbps,
    // the value will be 14. If the speed is less than 1 Kbps, the value
    // will be 0.
    U32                 line_speed_Kbps;

    // Team Type. QLMAPI_TEAM_BRCM_LBFO == Broadcom LBFO,
    // QLMAPI_TEAM_802_3_AD == 802.3ad, QLMAPI_TEAM_FEC_GEC == FEC/GEC
    // QLMAPI_TEAM_SLB_AFD == SLB (Auto Fallback Disabled)
    U32                 team_type;

    // For NDIS devices.
    U32                 mtu;

    // Available for NDIS 6.0 and later.
    // Same as 'duplex_mode' in QL_BRCM_ADAPTER_INFO and QL_LINK_STATUS
    U32                 duplex_mode;

    // Available for NDIS 6.0 and later.
    // Definitions for 'rss_caps' is the same as 'rss_caps' in
    // QL_ADAPTER_INFO_EX.
    U32                 rss_caps;
    U32                 rss_num_interrupt_msg;
    U32                 rss_num_rcv_que;

    U32                 reserved[3];

    // 802.3 offload capabilities
    // These three fields valid ONLY for OS prior to (include) Windows 2003.
    // For NDIS 6.0 and later (Vista and Longhorn), use 'ol_task' and
    // 'ol_conn'.
    QL_OFFLOAD_TCP_IP_CHECKSUM  ol_802_3_tcpip_chksum;
    QL_OFFLOAD_TCP_LARGE_SEND   ol_802_3_lso;
    QL_OFFLOAD_TCP_CONNECTION   ol_802_3_tcp_conn;

    // First IPv6 address found for the NIC.
    // Applications can cast like "( LPSOCKADDR )&ipv6.Address" to API
    // such as WSAAddressToString().
    QL_IP_UNICAST_ADDRESS       ipv6;

    // These two fields valid only for NDIS 6.0 and later (Vista and
    // Longhorn).
    QL_TASK_OFFLOAD             ol_task;
    QL_TCP_CONNECTION_OFFLOAD   ol_conn;

    // Available for NDIS 6.0 and later.
    // The link speed is in bits per second. A value of -1 in this member
    // indicates that the link speed is unknown.
    U64                 max_xmit_link_speed;
    U64                 max_rcv_link_speed;
    U64                 xmit_link_speed;
    U64                 rcv_link_speed;

} QL_VIR_NIC_INFO_EX;



// 'mode' in QL_BRCM_ADAPTER_INFO
#define QLMAPI_LM_BUS_MODE_UNKNOWN           0
#define QLMAPI_LM_BUS_MODE_PCI               1
#define QLMAPI_LM_BUS_MODE_PCI_X             2
#define QLMAPI_LM_BUS_MODE_PCI_E             3

// 'clock' in QL_BRCM_ADAPTER_INFO
#define QLMAPI_LM_BUS_CLOCK_UNKNOWN          0
#define QLMAPI_LM_BUS_CLOCK_33MHZ            1
#define QLMAPI_LM_BUS_CLOCK_66MHZ            2
#define QLMAPI_LM_BUS_CLOCK_133MHZ           3
#define QLMAPI_LM_BUS_CLOCK_100MHZ           4
#define QLMAPI_LM_BUS_CLOCK_50MHZ            5

// 'bus_size' in QL_BRCM_ADAPTER_INFO
#define QLMAPI_LM_BUS_SIZE_UNKNOWN           0
#define QLMAPI_LM_BUS_SIZE_32BIT             1
#define QLMAPI_LM_BUS_SIZE_64BIT             2
#define QLMAPI_LM_BUS_SIZE_PCI_E_1X          3
#define QLMAPI_LM_BUS_SIZE_PCI_E_2X          4
#define QLMAPI_LM_BUS_SIZE_PCI_E_4X          5
#define QLMAPI_LM_BUS_SIZE_PCI_E_8X          6
#define QLMAPI_LM_BUS_SIZE_PCI_E_12X         7
#define QLMAPI_LM_BUS_SIZE_PCI_E_16X         8
#define QLMAPI_LM_BUS_SIZE_PCI_E_32X         9

// 'duplex_mode' in QL_BRCM_ADAPTER_INFO and QL_LINK_STATUS
#define QLMAPI_LM_DUPLEX_MODE_UNKNOWN        0
#define QLMAPI_LM_DUPLEX_MODE_HALF           1
#define QLMAPI_LM_DUPLEX_MODE_FULL           2

// 'drv_state' in QL_BRCM_ADAPTER_INFO
#define QLMAPI_DRV_STATE_NORMAL_MODE         0
#define QLMAPI_DRV_STATE_MEDIA_FAIL          1   // NT 4, HotPlug PCI
#define QLMAPI_DRV_STATE_ADAPTER_CHECK       2   // NT 4, HotPlug PCI
#define QLMAPI_DRV_STATE_DIAG_MODE           5
#define QLMAPI_DRV_STATE_NIC_REMOVED         6   // NT 4, HotPlug PCI
#define QLMAPI_DRV_STATE_LOW_POWER_MODE      7
#define QLMAPI_DRV_STATE_USER_SIMULATE_FAIL  16  // NT 4, HotPlug PCI
#define QLMAPI_DRV_STATE_POWER_OFF_PENDING   32  // NT 4, HotPlug PCI
#define QLMAPI_DRV_STATE_POWER_OFF           48  // NT 4, HotPlug PCI
#define QLMAPI_DRV_STATE_POWER_OFF_FAULT     64  // NT 4, HotPlug PCI
#define QLMAPI_DRV_STATE_POWER_ON_PENDING    80  // NT 4, HotPlug PCI
#define QLMAPI_DRV_STATE_POWER_ON            96  // NT 4, HotPlug PCI
#define QLMAPI_DRV_STATE_POWER_ON_FAULT      112 // NT 4, HotPlug PCI
#define QLMAPI_DRV_STATE_RESETTING           0xFFFFFFFF

typedef struct _QL_BRCM_ADAPTER_INFO
{
    // This structure will host all Broadcom proprietary static data.
    // Ststistic data will be host in separate data structure.

    // PCI information.
    U32 bus_no;
    U32 device_no;
    U32 function_no;
    U32 vendor_id;
    U32 device_id;
    U32 subsystem_vendor_id;
    U32 subsystem_id;
    U32 mem_base_low;
    U32 mem_base_high;

    // Possible value:
    // QLMAPI_LM_BUS_MODE_UNKNOWN, QLMAPI_LM_BUS_MODE_PCI,
    // QLMAPI_LM_BUS_MODE_PCI_X, QLMAPI_LM_BUS_MODE_PCI_E
    U32 mode;

    // Possible value:
    // QLMAPI_LM_BUS_CLOCK_UNKNOWN, QLMAPI_LM_BUS_CLOCK_33MHZ,
    // QLMAPI_LM_BUS_CLOCK_66MHZ, QLMAPI_LM_BUS_CLOCK_133MHZ,
    // QLMAPI_LM_BUS_CLOCK_100MHZ, QLMAPI_LM_BUS_CLOCK_50MHZ
    U32 clock;

    // Possible value:
    // QLMAPI_LM_BUS_SIZE_UNKNOWN, QLMAPI_LM_BUS_SIZE_32BIT,
    // QLMAPI_LM_BUS_SIZE_64BIT, QLMAPI_LM_BUS_SIZE_PCI_E_1X
    // QLMAPI_LM_BUS_SIZE_PCI_E_2X, QLMAPI_LM_BUS_SIZE_PCI_E_4X
    // QLMAPI_LM_BUS_SIZE_PCI_E_8X, QLMAPI_LM_BUS_SIZE_PCI_E_12X
    // QLMAPI_LM_BUS_SIZE_PCI_E_16X, QLMAPI_LM_BUS_SIZE_PCI_E_32X
    U32 bus_size;

    // Chip information.

    // phy_id and phy_addr are not available for 5706 devices.
    /* OUI: bit 31-10;   Model#: bit 9-4;   Rev# bit 3-0. */
    U32 phy_id;

    U32 phy_addr;

    U32 irq;

    // For 570x devices: ChipId:4, ChipRev:4, MetalRev:8
    // For example :
    // 5700 A1 : 0x7000 : chip ID 0x7, chip rev 0x0, metal rev 0x01
    // 5700 B2 : 0x7000 : chip ID 0x7, chip rev 0x1, metal rev 0x02
    // 5701 A3 : 0x0003 : chip ID 0x0, chip rev 0x0, metal rev 0x03
    // 5703 A0 : 0x1000 : chip ID 0x1, chip rev 0x0, metal rev 0x00
    // 5704 A0 : 0x2003 : chip ID 0x2, chip rev 0x0, metal rev 0x00
    //
    // For 5706 devices: ChipId:16, ChipRev:4, MetalRev:8
    // For example :
    // 5706 A0 : 0x5706000 : chip ID 0x5706, chip rev 0x0, metal rev 0x00
    U32 chip_rev;

    U8  mac_address[8];         // Adapter's MAC address.

    // Driver information.
    // not available for 5706 devices.
    U32 mapped_mem_base;

    // Possible value:
    // QLMAPI_LM_MEDIA_TYPE_UNKNOWN, QLMAPI_LM_MEDIA_TYPE_AUTO,
    // QLMAPI_LM_MEDIA_TYPE_UTP, QLMAPI_LM_MEDIA_TYPE_BNC,
    // QLMAPI_LM_MEDIA_TYPE_AUI, QLMAPI_LM_MEDIA_TYPE_FIBER
    U32 media_type;

    // Possible value:
    // QLMAPI_LM_LINE_SPEED_UNKNOWN, QLMAPI_LM_LINE_SPEED_10MBPS,
    // QLMAPI_LM_LINE_SPEED_100MBPS, QLMAPI_LM_LINE_SPEED_1000MBPS
    U32 line_speed;

    // Possible value:
    // QLMAPI_LM_DUPLEX_MODE_UNKNOWN, QLMAPI_LM_DUPLEX_MODE_HALF
    // QLMAPI_LM_DUPLEX_MODE_FULL
    U32 duplex_mode;

    // Possible value:
    // QLMAPI_LM_STATUS_LINK_ACTIVE, QLMAPI_LM_STATUS_LINK_DOWN
    U32 link_status;

    U8  node_address[8];        // Current network address.
    U32 drv_major_ver;
    U32 drv_minor_ver;

    // Possible value:
    // QLMAPI_DRV_STATE_NORMAL_MODE, QLMAPI_DRV_STATE_DIAG_MODE,
    // QLMAPI_DRV_STATE_NIC_REMOVED, QLMAPI_DRV_STATE_LOW_POWER_MODE
    U32 drv_state;

} QL_BRCM_ADAPTER_INFO;



// 'RequestedMediaType' in QL_BRCM_ADAPTER_INFO_EX
// 'requested_media_type' in QL_LINK_STATUS
#define QLMAPI_LM_REQUESTED_MEDIA_TYPE_AUTO                      0
#define QLMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_10MBPS                3
#define QLMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_10MBPS_FULL_DUPLEX    4
#define QLMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_100MBPS               5
#define QLMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_100MBPS_FULL_DUPLEX   6

// Do NOT force speed on 1000Mbps for copper.
#define QLMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_1000MBPS              7
#define QLMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_1000MBPS_FULL_DUPLEX  8

#define QLMAPI_LM_REQUESTED_MEDIA_TYPE_FIBER_1000MBPS                11
#define QLMAPI_LM_REQUESTED_MEDIA_TYPE_FIBER_1000MBPS_FULL_DUPLEX    12
#define QLMAPI_LM_REQUESTED_MEDIA_TYPE_FIBER_2500MBPS                13
#define QLMAPI_LM_REQUESTED_MEDIA_TYPE_FIBER_2500MBPS_FULL_DUPLEX    14
#define QLMAPI_LM_REQUESTED_MEDIA_TYPE_FIBER_AUTONEG_1G_FALLBACK     15
#define QLMAPI_LM_REQUESTED_MEDIA_TYPE_FIBER_AUTONEG_1G_FALLBACK_FULL_DUPLEX     16
#define QLMAPI_LM_REQUESTED_MEDIA_TYPE_FIBER_AUTONEG_2_5G_FALLBACK               17
#define QLMAPI_LM_REQUESTED_MEDIA_TYPE_FIBER_AUTONEG_2_5G_FALLBACK_FULL_DUPLEX   18
#define QLMAPI_LM_REQUESTED_MEDIA_TYPE_FIBER_HARDWARE_DEFAULT                    19
#define QLMAPI_LM_REQUESTED_MEDIA_TYPE_FIBER_10GBPS                  20
#define QLMAPI_LM_REQUESTED_MEDIA_TYPE_FIBER_10GBPS_FULL_DUPLEX      21

// 'flow_ctrl' in QL_BRCM_ADAPTER_INFO_EX
// For both NetXtreme and NetXtreme II products,
// following definitions are valid.
#define QLMAPI_FLOW_CONTROL_NONE             0x00
#define QLMAPI_FLOW_CONTROL_RX_PAUSE         0x01        // Driver setting: Tx_enabled
#define QLMAPI_FLOW_CONTROL_TX_PAUSE         0x02        // Driver setting: Rx_enabled

// For NetXtreme II products ***ONLY***
/*
 * This value can be or-ed with RECEIVE_PAUSE and TRANSMIT_PAUSE.  If the 
 * auto-negotiation is disabled and the RECEIVE_PAUSE and TRANSMIT_PAUSE 
 * bits are set, then flow control is enabled regardless of link partner's 
 * flow control capability.  Otherwise, if this bit is set, then flow 
 * is negotiated with the link partner.  Values 0x80000000 and 0x80000003 are
 * equivalent.
 */
#define QLMAPI_FLOW_CONTROL_AUTO_PAUSE       0x80000000

// 'pcie_speed' in QL_BRCM_ADAPTER_INFO_EX
#define QLMAPI_PCIE_SPEED_UNKNOWN            0
#define QLMAPI_PCIE_SPEED_2_5_G              25
#define QLMAPI_PCIE_SPEED_5_G                50

// 'mode' in QL_BRCM_ADAPTER_INFO
typedef struct _QL_INTERRUPT_INFO
{

    U32                 IntType;
#define QLMAPI_NIC_INTR_TYPE_LINE_BASED  0
#define QLMAPI_NIC_INTR_TYPE_MSI         1

    union
    {
        struct
        {
            U8          IntPin;
            U8          IntLine;
        } LineBased;

        struct
        {
            U8          MsiVersion;
#define QLMAPI_NIC_INTR_MSI_1_0          1
#define QLMAPI_NIC_INTR_MSI_X            2

            U8          Reserved;

            ////////////////////////////////////
            // Availavble only for NX1 devices.
            U16         MsgData;
            U32         MsgAddressLow;
            U32         MsgAddressHigh;
            ////////////////////////////////////

            U32         NumOfEnabledMsgs;
            U32         NumOfCapableMsgs;
        } Msi;
    } Charactristic;
} QL_INTERRUPT_INFO;

#define QLMAPI_BRCM_ADAPTER_INFO_EX_VER      13

typedef struct _QL_BRCM_ADAPTER_INFO_EX
{
    // This structure will host all Broadcom proprietary static data.
    // Ststistic data will be host in separate data structure.

    //  Latest version is defined as QLMAPI_BRCM_ADAPTER_INFO_EX_VER.
    //  'version' is required upon input
    U32                     version;

    QL_BRCM_ADAPTER_INFO    brcm_info;

    // Defined flags:
#define QLMAPI_DRV_RSS_ENABLED       0x00000004  // 1 if driver is doing RSS, 0 if not
#define QLMAPI_DRV_BOOT_INTF         0x00000008  // 1 if the interface is a boot interface
#define QLMAPI_DRV_ISCSI_BOOT_INTF   QLMAPI_DRV_BOOT_INTF
#define QLMAPI_REMOTE_PHY_CAPABLE    0x00000010  // 1 if the interface capable of remote PHY
#define QLMAPI_REMOTE_PHY_ACTIVE     0x00000020  // 1 if the interface is using remote PHY
// Determine which MFW is currently ruinning in NX2
#define QLMAPI_MFW_RUN_UNKNOWN       0x00000000
#define QLMAPI_MFW_RUN_IPMI          0x00000040
#define QLMAPI_MFW_RUN_UMP           0x00000080
#define QLMAPI_MFW_RUN_NCSI          0x000000c0
#define QLMAPI_MFW_RUN_NONE          0x000001c0
#define QLMAPI_MFW_RUN_MASK          0x000001c0
#define QLMAPI_REMOTE_PHY_MODULE_PRESENT 0x00000200  // 1 if the remote PHY module is present
#define QLMAPI_DRV_ISCSI_BOOT_HBA    0x00000400  // 1 if the interface ISCSI boot from HBA, applicable only for BRCM iSCSI boot
#define QLMAPI_DRV_ISCSI_BOOT_NDIS   0x00000800  // 1 if the interface ISCSI boot from NDIS, applicable only for BRCM iSCSI boot
#define QLMAPI_EXT_PHY               0x00001000  // 1 if the port is using external PHY, applicable only for 57710 family
#define QLMAPI_WOL_NO_VAUX           0x00002000  // 1 if the port does not have Vaux power to support WOL, applicable only for 5706 family
#define QLMAPI_DRV_FCOE_BOOT_HBA     0x00004000  // 1 if the interface ISCSI boot from HBA, applicable only for BRCM FCoE boot
#define QLMAPI_VBD_NO_L4             0x40000000  // 1 if it is VBD but no L4 support.
#define QLMAPI_EXT_INFO_VALID        0x80000000  // 1 if 'intr_info' is valid
    U32                     SupportedFlags;

    // Not supported by 57710 based NICs
    U32                     RequestedMediaType;
    U32                     DisableAutoNeg;

    // This data apply to dual port QLMAPI_BRCM5700 NIC only.
    U32                     DualMACCtrlReg;

    // Max. speed for the NIC.
    // Value is the same as 'line_speed'.
    U32                     MaxSpeed;

    // The unit value is Kbps. The actual speed value will be truncated
    // to the lower bound of Kbps. For example, if the speed is 14.4 Kbps,
    // the value will be 14. If the speed is less than 1 Kbps, the value
    // will be 0.
    U32                     line_speed_Kbps;

#ifndef _WIN32
    // Linux driver use 3 digits version format.
    // Major version and minor version are defined in QL_BRCM_ADAPTER_INFO.
    U32                     drv_build_ver;

    // VLAN config
    // 0: VLAN is off
    // 1: VLAN is on
    U32                     vlan_cfg;

    // Wake On Lan config
    // 0: WOL is off
    // 1: WOL is on
    U32                     wol_cfg;

#endif
    // Not applicable for 4401 NICs.
    U32                     bond_id;

    // For Linux:
    // The field is valid only for drivers capable of ethtool interface.
    // For Window:
    // The field is valid only when 'nic_type' is QLMAPI_BRCM5706 and
    // windows vbd driver is v2.8.2 or later.
    U32                     nvram_size;

    // For QLMAPI_BRCM5706 and QLMAPI_BRCM57710 only.
    // 0 for primary port, 1 for secondary port, etc...
    U32                     port_id;

    // For 57711 families only.
    // QLMAPI_MFMODE_SINGLE_FUNC:    single function mode
    // QLMAPI_MFMODE_NPAR_SD:        switch dependent (vlan based)
    // QLMAPI_MFMODE_NPAR_SI:        switch independent (mac based)
    // QLMAPI_MFMODE_VNTAG:          switch dependent (vntag based)
#define QLMAPI_MFMODE_SINGLE_FUNC    0
#define QLMAPI_MFMODE_NPAR_SD        1
#define QLMAPI_MFMODE_NPAR_SI        2
#define QLMAPI_MFMODE_VNTAG          3
#define QLMAPI_MFMODE_UFP            4
    U32                     mf_mode;

    // For 57711 families only.
    // Can be 1, 2 or 4.
    U32                     function_per_port;

    // This field will only be non-zero if the PHY negotiated flow control
    // with the far end.
    U32                     flow_ctrl;

    // PCI-E <-> PCI-X bridge information
    // Currently, only 5708 based devices support this field.
    // Could be: QLMAPI_LM_BUS_SIZE_PCI_E_1X, QLMAPI_LM_BUS_SIZE_PCI_E_2X,
    // QLMAPI_LM_BUS_SIZE_PCI_E_4X, QLMAPI_LM_BUS_SIZE_PCI_E_8X,
    // QLMAPI_LM_BUS_SIZE_PCI_E_12X, QLMAPI_LM_BUS_SIZE_PCI_E_16X,
    // QLMAPI_LM_BUS_SIZE_PCI_E_32X
    U32                     pcie_width;

    // Could be: QLMAPI_PCIE_SPEED_2_5_G
    U32                     pcie_speed;

    // 'intr_info' is valid only when 'QLMAPI_INTR_INFO_VALID' is set
    // in SupportedFlags.
    // 'intr_info' is currently available only when 'QLMAPI_EXT_INFO_VALID'
    // is set.
    QL_INTERRUPT_INFO       intr_info;

    // iSCSI mac address
    // Available only for NX2 devices.
    U8                      iscsi_mac_addr[8];

// NOT supported in QLmapilnx =====================================Begin
    // In virtual function, the boolean value can be used to determine
    // whether the physical link is up or not.
    U32                     physical_link_up;

    // Transceiver data. Available only for QLMAPI_BRCM57710 with EVBD driver.
    U8                      vendor_name[16];
    U8                      model_num[16];
    U8                      serial_num[16];
    U8                      revision_num[4];
    U8                      mfg_date[6];
// NOT supported in QLmapilnx =======================================End

    // External PHY configuration
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_ADDR_MASK            0x000000ff
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_ADDR_SHIFT           0

#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_TYPE_MASK            0x0000ff00
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_TYPE_SHIFT           8
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_TYPE_DIRECT          0x00000000
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_TYPE_BCM8071         0x00000100
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_TYPE_BCM8072         0x00000200
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_TYPE_BCM8073         0x00000300
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_TYPE_BCM8705         0x00000400
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_TYPE_BCM8706         0x00000500
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_TYPE_BCM8726         0x00000600
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_TYPE_BCM8481         0x00000700
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_TYPE_SFX7101         0x00000800
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_TYPE_BCM8727         0x00000900
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_TYPE_BCM8727_NOC     0x00000a00
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_TYPE_BCM84823        0x00000b00
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_TYPE_BCM54640        0x00000c00
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_TYPE_BCM84833        0x00000d00
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_TYPE_BCM54618SE      0x00000e00
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_TYPE_BCM8722         0x00000f00
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_TYPE_BCM54616        0x00001000
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_TYPE_BCM84834        0x00001100
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_TYPE_DIRECT_WC       0x0000fc00
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_TYPE_FAILURE         0x0000fd00
#define QLMAPI_EXT_PHY_XGXS_EXT_PHY_TYPE_NOT_CONN        0x0000ff00

#define QLMAPI_EXT_PHY_SERDES_EXT_PHY_ADDR_MASK          0x00ff0000
#define QLMAPI_EXT_PHY_SERDES_EXT_PHY_ADDR_SHIFT         16

#define QLMAPI_EXT_PHY_SERDES_EXT_PHY_TYPE_MASK          0xff000000
#define QLMAPI_EXT_PHY_SERDES_EXT_PHY_TYPE_SHIFT         24
#define QLMAPI_EXT_PHY_SERDES_EXT_PHY_TYPE_DIRECT        0x00000000
#define QLMAPI_EXT_PHY_SERDES_EXT_PHY_TYPE_BCM5482       0x01000000
#define QLMAPI_EXT_PHY_SERDES_EXT_PHY_TYPE_NOT_CONN      0xff000000
    U32                     ext_phy_config;
    U32                     ext_phy_config2;

    // FCoE mac address
    // Available only for NX2 10G devices.
    U8                      fcoe_mac_addr[8];

    // Available only for NX2 10G devices with FCoE capability.
    U8                      fcoe_wwn_port_name[8];
    U8                      fcoe_wwn_node_name[8];

    // Available only for NX2 10G devices.
    U32                     phy_link_speed_mbps;

    // Available only for NX2 10G devices.
    U32                     uMaxPhyPorts;

	// Determine the Serdes electrical interface
    // Available only for NX2 10G devices.
#define QLMAPI_PORT_HW_CFG_NET_SERDES_IF_MASK            0x0F000000
#define QLMAPI_PORT_HW_CFG_NET_SERDES_IF_SHIFT           24
#define QLMAPI_PORT_HW_CFG_NET_SERDES_IF_SGMII           0x00000000
#define QLMAPI_PORT_HW_CFG_NET_SERDES_IF_XFI             0x01000000
#define QLMAPI_PORT_HW_CFG_NET_SERDES_IF_SFI             0x02000000
#define QLMAPI_PORT_HW_CFG_NET_SERDES_IF_KR              0x03000000
#define QLMAPI_PORT_HW_CFG_NET_SERDES_IF_DXGXS           0x04000000
#define QLMAPI_PORT_HW_CFG_NET_SERDES_IF_KR2             0x05000000
    U32                     port_default_cfg;


	// Available only for NX2 10G devices.
#define QLMAPI_DEV_VIRT_CAPS_VF_DEVICE                   BIT_0   // 0 - PF device; 1 - VF device
#define QLMAPI_DEV_VIRT_CAPS_PF_SRIOV_CAPABLE            BIT_1   // If PF: 0 - no SRIOV; 1 - SRIOV capable
#define QLMAPI_DEV_VIRT_CAPS_PF_SRIOV_HW_SUPPORT         BIT_2   // If PF is SRIOV capable:
                                                                // 0 - SRIOV is not involved/configured;
                                                                // 1 -  configured for SRIOV, SRIOV extended capability is exposed in PCI configuration space
#define QLMAPI_DEV_VIRT_CAPS_PF_SRIOV_OS_SUPPORT         BIT_3   // If PF device involves SRIOV:
                                                                // 0 - OS does not support SRIOV (at does not involve SRIOV for this PF) 
                                                                // 1 - OS provides SRIOV support for this PF, so PF is ready for SRIOV switch functionality 
    U32                     virtualization_caps;

    // Available only for NX2 10G devices.
    // For QLMAPI_DEV_VIRT_CAPS_PF_SRIOV_HW_SUPPORT: Max number of VFs exposed
    // by SRIOV extended capability in PCI configuration space.
    // For QLMAPI_DEV_VIRT_CAPS_VF_DEVICE: type of HOST OS/hyervisor:
    // 0: Windows8 (SW VF/PF interface)
    // 1: VMware/Linux (HW/FW VF/PF) interface
    U32                     virtualization_props;

} QL_BRCM_ADAPTER_INFO_EX;



#define QLMAPI_MAXIMUM_MEMBERS_PHY_TEAM  8
#define QLMAPI_MAXIMUM_MEMBERS_VIR_TEAM  64

// 'mode' in QL_TEAM_INFO2
#define QLMAPI_TEAM_MODE_PRIMARY                 0
#define QLMAPI_TEAM_MODE_STAND_BY                1

#define QLMAPI_TEAM_MEMBER_STATE_UP              0x00000001  // link up if set (link down if not set)
#define QLMAPI_TEAM_MEMBER_STATE_DISABLED        0x00000002  // adapter has been disabled
#define QLMAPI_TEAM_MEMBER_STATE_JOIN_TRAFFIC    0x00000004  // adapter is being used to balance the network traffic
#define QLMAPI_TEAM_MEMBER_STATE_TRUE_PRIMARY    0x00000008  // adapter is a true primary
#define QLMAPI_TEAM_MEMBER_STATE_PROMOTED        0x00000010  // adapter is a currently a promoted primary

typedef struct _QL_TEAM_PHY_INFO
{
    QL_ADAPTER_INFO     nic;

    // The value is set ***ONLY*** via QLmapiGetTeamSnapShot2().
    // state information defined as QLMAPI_TEAM_MEMBER_STATE_???
    // 'state' in QL_ADAPTER_INFO will be IGNORED.
    U32                 state;

    U32                 reserved[7];

} QL_TEAM_PHY_INFO;

typedef struct _QL_TEAM_VIR_INFO
{
    QL_ADAPTER_INFO     nic;

    // The value is set ***ONLY*** via QLmapiGetTeamSnapShot2().
    // state information defined as QLMAPI_TEAM_MEMBER_STATE_???
    // 'state' in QL_ADAPTER_INFO will be IGNORED.
    // can be link up, link down and disable
    U32                 state;

    U32                 reserved[8];

} QL_TEAM_VIR_INFO;


#define QLMAPI_AF_INET       2
#define QLMAPI_AF_INET6      23

typedef struct _QL_IPADDR
{
    // Currently only QLMAPI_AF_INET is supported.
    U16     sin_family;

    union
    {
        // Unused bytes MUST be set to zero.
        U32     addr_ipv4;      // can be cast to in_addr

        U8      addr_ipv6[16];

        // Application can use this field as protocal independent
        // variable to achieve better compatibility between IPv4 and
        // IPv6.
        U8      addr[16];
    };

} QL_IPADDR;


#define QLMAPI_TEAM_INFO2_VER            4

typedef struct _QL_TEAM_INFO2
{
    // version, define as QLMAPI_TEAM_INFO2_VER
    U32                 version;

    // Team name.
    S8                  team_name[QLMAPI_MAX_TEAM_NAME_LEN];

    // Team ID
    U32                 team_id;

    // Team Type. QLMAPI_TEAM_BRCM_LBFO == Broadcom LBFO,
    // QLMAPI_TEAM_802_3_AD == 802.3ad, QLMAPI_TEAM_FEC_GEC == FEC/GEC
    // QLMAPI_TEAM_SLB_AFD == SLB (Auto Fallback Disabled)
    U32                 team_type;

    // NetworkAddress. It is set if team_type == QLMAPI_TEAM_FEC_GEC.
    S8                  network_addr[QLMAPI_MAX_MAC_ADDR_LEN];

    // The value is set ***ONLY*** via QLmapiGetTeamSnapShot2().
    // mode of this team, QLMAPI_TEAM_MODE_PRIMARY or QLMAPI_TEAM_MODE_STAND_BY
    // For team type other than QLMAPI_TEAM_SLB_AFD, this should always be
    // QLMAPI_TEAM_MODE_PRIMARY.
    U32                 mode;

    // Advanced failover is disable or not. True or false value.
    // True to disable the feature.
    // Advanced failover can be enabled only when all members are Broadcom
    // NICs.
    U32                 disable_adfo;

    // Probe Packet is enabled or not. True or false value.
    // Probe packet can be enabled only for QLMAPI_TEAM_BRCM_LBFO and
    // QLMAPI_TEAM_SLB_AFD.
    U32                 probe_enable;

    // The frequency in milliseconds that a probe packet is to be sent.
    // Valid only when 'probe_enable' is enabled.
    U32                 probe_freq;

    // The maximum number of retries before failing a team member.
    // Valid only when 'probe_enable' is enabled.
    U32                 probe_retries;

    // The frequency (in milliseconds) a probe packet is to be sent after
    // a dropped probe packet is detected.
    // Valid only when 'probe_enable' is enabled.
    U32                 probe_retry_freq;

    // This is for BMAPI internal use only.
    U64                 context;

    U32                 reserved;

    // number of valid physical adapters in the team
    U32                 phy_count;

    // information of each team member
    QL_TEAM_PHY_INFO    phy_member[QLMAPI_MAXIMUM_MEMBERS_PHY_TEAM];

    // number of valid virtual adapters in the team
    U32                 vir_count;

    // information for team configuration
    QL_TEAM_VIR_INFO    vir_member[QLMAPI_MAXIMUM_MEMBERS_VIR_TEAM];

    // This is the probe target IP. 
    // Valid only when 'probe_enable' is enabled.
    // If IP is all '0', the value will be deleted from configuration.
    // At leaset one probe target should be configured.
    // The application MUST configure probe target ip as the order from
    // 1 to 4.
    QL_IPADDR           probe_target_ip_1;
    QL_IPADDR           probe_target_ip_2;
    QL_IPADDR           probe_target_ip_3;
    QL_IPADDR           probe_target_ip_4;

    // This the IPv4 for the physical NICs. It is one to one matching.
    // Valid only when 'probe_enable' is enabled.
    // All the IP addresses should be checked for uniqueness (there can
    // not be duplicates for all teams). They also should be different
    // than the IP addresses assigned to the NIC by the OS.
    QL_IPADDR           probe_phy_ip[QLMAPI_MAXIMUM_MEMBERS_PHY_TEAM];

    // Vlan ID (0-4094) for LiveLink. It is a per team configuration.
    U32                 ll_vlan_id;

    // This the IPv6 for the physical NICs. It is one to one matching.
    // Valid only when 'probe_enable' is enabled.
    // All the IP addresses should be checked for uniqueness (there can
    // not be duplicates for all teams). They also should be different
    // than the IP addresses assigned to the NIC by the OS.
    QL_IPADDR           probe_phy_ipv6[QLMAPI_MAXIMUM_MEMBERS_PHY_TEAM];

} QL_TEAM_INFO2;



typedef struct _QL_PHY_NIC_STATISTICS
{
    // Application use this handle number to know which adapter
    // this statistic structure is referring to.
    U32 handle;

    // number of send request completed by miniport
    U32 send_packet;

    // number of send request discarded
    U32 send_discarded;

    // number of send request dispatched to miniport
    U32 send_dispatched;

    // number of receive packets that are indicated to upper layer
    U32 recv_packet;

    // number of receive packets discarded
    U32 recv_discarded;

    // number of receive discarded because it's too big
    U32 recv_oversize;

} QL_PHY_NIC_STATISTICS;



typedef struct _QL_VIR_NIC_STATISTICS
{
    // Application use this handle number to know which adapter
    // this statistic structure is referring to.
    U32 handle;

    // number of send request discarded for various reasons
    U32 send_all_down;

    // number of send request being queued because out of NDIS_PACKET
    U32 send_queued;

    // number of send request completed
    U32 send_completed;

    // number of receive indicated to upper layer successfully 
    U32 recv_indicated;

} QL_VIR_NIC_STATISTICS;



typedef struct _QL_TEAM_STATISTICS
{
    // Team name.
    S8                      team_name[QLMAPI_MAX_TEAM_NAME_LEN];

    // number of send packets that are forwarded to the team members,
    // derived from physical adapter statistics
    U32                     send_packet;

    // number of send packets that are discarded,
    // derived from physical adapter statistics
    U32                     send_discarded;

    // number of send packets that are discarded because all the team 
    // members are malfunctioned, derived from virtual adapter statistics.
    U32                     send_all_down;

    // number of send packets queued by BLF driver waiting for resource
    // derived from virtual adapter statistics.
    U32                     send_queued;

    // number of send packets originated from BLF driver
    U32                     send_adjusted;

    // number of receive packets that are indicated to upper layer,
    // derived from physical adapter statistics
    U32                     recv_packet;

    // number of receive packets discarded, 
    // derived from physical adapter statistics
    U32                     recv_discarded;

    // number of receive discarded because it's too big,
    // derived from physical adapter statistics
    U32                     recv_oversize;

    // number of receive indicated to upper layer successfully 
    // derived from virtual adapter statistics
    U32                     recv_indicated;

    // physical adapter statistics
    // number of valid physical adapters
    U32                     phy_count;

    // statistics of each team member
    QL_PHY_NIC_STATISTICS   phy_member[QLMAPI_MAXIMUM_MEMBERS_PHY_TEAM];

    // virtual adapter statistics
    // number of valid virtual adapters
    U32                     vir_count;

    // statistics of each virtual adapter
    QL_VIR_NIC_STATISTICS   vir_member[QLMAPI_MAXIMUM_MEMBERS_VIR_TEAM];

} QL_TEAM_STATISTICS;



typedef struct
{
    // Application use this handle number to know which adapter
    // this statistic structure is referring to.
    U32 handle;

    // number of send request completed by miniport
    U32 send_packet;

    // number of send request discarded
    U32 send_discarded;

    // number of send request dispatched to miniport
    U32 send_dispatched;

    // number of receive packets that are indicated to upper layer
    U32 recv_packet;

    // number of receive packets discarded
    U32 recv_discarded;

    // number of receive discarded because it's too big
    U32 recv_oversize;

    // Number of probe packets sent for the adapter -
    // Expressed as a quantity.
    U32 probe_sent;

    // The number of retry packets sent for the adapters -
    // Expressed as a quantity.
    U32 probe_retried;

    // The number of time this NIC was activated by LiveLink
    U32 llNicUpCount;

    // The number of time this NIC was de-activated by LiveLink
    U32 llNicDownCount;

    // The number of time this NIC was activated (does not include LiveLink count)
    U32 nicUpCount;

    // The number of time this NIC was de-activated (does not include LiveLink count)
    U32 nicDownCount;

    // reserved for future use
    U32 reserved[60];

} QL_PHY_NIC_STATISTICS_EX;



typedef struct
{
    // Application use this handle number to know which adapter
    // this statistic structure is referring to.
    U32 handle;

    // number of send request discarded for various reasons
    U32 send_all_down;

    // number of send request being queued because out of NDIS_PACKET
    U32 send_queued;

    // number of send request completed
    U32 send_completed;

    // number of receive indicated to upper layer successfully 
    U32 recv_indicated;

    // reserved for future use
    U32 reserved[32];

} QL_VIR_NIC_STATISTICS_EX;



#define QLMAPI_TEAM_STATISTICS_EX_VER    2

typedef struct
{
    //  Version is defined as QLMAPI_TEAM_STATISTICS_EX_VER.
    //  'version' is required upon input
    U32                     version;

    // Team name.
    S8                      team_name[QLMAPI_MAX_TEAM_NAME_LEN];

    // number of send packets that are forwarded to the team members,
    // derived from physical adapter statistics
    U32                     send_packet;

    // number of send packets that are discarded,
    // derived from physical adapter statistics
    U32                     send_discarded;

    // number of send packets that are discarded because all the team 
    // members are malfunctioned, derived from virtual adapter statistics.
    U32                     send_all_down;

    // number of send packets queued by BLF driver waiting for resource
    // derived from virtual adapter statistics.
    U32                     send_queued;

    // number of send packets originated from BLF driver
    U32                     send_adjusted;

    // number of receive packets that are indicated to upper layer,
    // derived from physical adapter statistics
    U32                     recv_packet;

    // number of receive packets discarded, 
    // derived from physical adapter statistics
    U32                     recv_discarded;

    // number of receive discarded because it's too big,
    // derived from physical adapter statistics
    U32                     recv_oversize;

    // number of receive indicated to upper layer successfully 
    // derived from virtual adapter statistics
    U32                     recv_indicated;

    // physical adapter statistics
    // number of valid physical adapters
    U32                     phy_count;

    // statistics of each team member
    QL_PHY_NIC_STATISTICS_EX    phy_member[QLMAPI_MAXIMUM_MEMBERS_PHY_TEAM];

    // virtual adapter statistics
    // number of valid virtual adapters
    U32                     vir_count;

    // statistics of each virtual adapter
    QL_VIR_NIC_STATISTICS_EX    vir_member[QLMAPI_MAXIMUM_MEMBERS_VIR_TEAM];

    // Number of probe packets sent across all adapters for the team -
    // Expressed as a quantity.
    U32                     probe_sent;
    // The number of retry packets sent across all adapters for the team -
    // Expressed as a quantity.
    U32                     probe_retried;

} QL_TEAM_STATISTICS_EX;



typedef struct _QL_GENERAL_STATISTICS
{
    U32 xmit_ok;                // OID_GEN_XMIT_OK
    U32 rcv_ok;                 // OID_GEN_RCV_OK
    U32 xmit_error;             // OID_GEN_XMIT_ERROR
    U32 rcv_error;              // OID_GEN_RCV_ERROR
    U32 rcv_no_buffer;          // OID_GEN_RCV_NO_BUFFER
    U64 directed_bytes_xmit;    // OID_GEN_DIRECTED_BYTES_XMIT
    U32 directed_frames_xmit;   // OID_GEN_DIRECTED_FRAMES_XMIT
    U64 multicast_bytes_xmit;   // OID_GEN_MULTICAST_BYTES_XMIT
    U32 multicast_frames_xmit;  // OID_GEN_MULTICAST_FRAMES_XMIT
    U64 broadcast_bytes_xmit;   // OID_GEN_BROADCAST_BYTES_XMIT
    U32 broadcast_frames_xmit;  // OID_GEN_BROADCAST_FRAMES_XMIT
    U64 directed_bytes_rcv;     // OID_GEN_DIRECTED_BYTES_RCV
    U32 directed_frames_rcv;    // OID_GEN_DIRECTED_FRAMES_RCV
    U64 multicast_bytes_rcv;    // OID_GEN_MULTICAST_BYTES_RCV
    U32 multicast_frames_rcv;   // OID_GEN_MULTICAST_FRAMES_RCV
    U64 broadcast_bytes_rcv;    // OID_GEN_BROADCAST_BYTES_RCV
    U32 broadcast_frames_rcv;   // OID_GEN_BROADCAST_FRAMES_RCV
    U32 rcv_crc_error;          // OID_GEN_RCV_CRC_ERROR
    U32 transimit_queue_length; // OID_GEN_TRANSMIT_QUEUE_LENGTH
} QL_GENERAL_STATISTICS;



typedef struct _QL_GENERAL_STATISTICS64
{
    U64 xmit_ok;                // OID_GEN_XMIT_OK
    U64 rcv_ok;                 // OID_GEN_RCV_OK
    U64 xmit_error;             // OID_GEN_XMIT_ERROR
    U64 rcv_error;              // OID_GEN_RCV_ERROR
    U64 rcv_no_buffer;          // OID_GEN_RCV_NO_BUFFER
    U64 directed_bytes_xmit;    // OID_GEN_DIRECTED_BYTES_XMIT
    U64 directed_frames_xmit;   // OID_GEN_DIRECTED_FRAMES_XMIT
    U64 multicast_bytes_xmit;   // OID_GEN_MULTICAST_BYTES_XMIT
    U64 multicast_frames_xmit;  // OID_GEN_MULTICAST_FRAMES_XMIT
    U64 broadcast_bytes_xmit;   // OID_GEN_BROADCAST_BYTES_XMIT
    U64 broadcast_frames_xmit;  // OID_GEN_BROADCAST_FRAMES_XMIT
    U64 directed_bytes_rcv;     // OID_GEN_DIRECTED_BYTES_RCV
    U64 directed_frames_rcv;    // OID_GEN_DIRECTED_FRAMES_RCV
    U64 multicast_bytes_rcv;    // OID_GEN_MULTICAST_BYTES_RCV
    U64 multicast_frames_rcv;   // OID_GEN_MULTICAST_FRAMES_RCV
    U64 broadcast_bytes_rcv;    // OID_GEN_BROADCAST_BYTES_RCV
    U64 broadcast_frames_rcv;   // OID_GEN_BROADCAST_FRAMES_RCV
    U64 rcv_crc_error;          // OID_GEN_RCV_CRC_ERROR
    U64 transimit_queue_length; // OID_GEN_TRANSMIT_QUEUE_LENGTH
} QL_GENERAL_STATISTICS64;



#define QL_GENERAL_STATISTICS_EX_VER    1

typedef struct _QL_GENERAL_STATISTICS_EX
{
    //  Version is defined as QL_GENERAL_STATISTICS_EX_VER.
    //  'version' is required upon input
    U32 version;

    U64 SupportedStatistics;
    // The value of 'SupportedStatistics' is the bitwise OR of the following
    // flags.
// The data in the 'xmit_ok' member is valid.
#define QLMAPI_STAT_GEN_XMIT_OK                              0x00000001
// The data in the 'rcv_ok' member is valid.
#define QLMAPI_STAT_GEN_RCV_OK                               0x00000002
// The data in the 'xmit_error' member is valid.
#define QLMAPI_STAT_GEN_XMIT_ERROR                           0x00000004
// The data in the 'rcv_error' member is valid.
#define QLMAPI_STAT_GEN_RCV_ERROR                            0x00000008
// The data in the 'rcv_no_buffer' member is valid.
#define QLMAPI_STAT_GEN_RCV_NO_BUFFER                        0x00000010
// The data in the 'directed_bytes_xmit' member is valid.
#define QLMAPI_STAT_GEN_DIRECTED_BYTES_XMIT                  0x00000020
// The data in the 'directed_frames_xmit' member is valid.
#define QLMAPI_STAT_GEN_DIRECTED_FRAMES_XMIT                 0x00000040
// The data in the 'multicast_bytes_xmit' member is valid.
#define QLMAPI_STAT_GEN_MULTICAST_BYTES_XMIT                 0x00000080
// The data in the 'multicast_frames_xmit' member is valid.
#define QLMAPI_STAT_GEN_MULTICAST_FRAMES_XMIT                0x00000100
// The data in the 'broadcast_bytes_xmit' member is valid.
#define QLMAPI_STAT_GEN_BROADCAST_BYTES_XMIT                 0x00000200
// The data in the 'broadcast_frames_xmit' member is valid.
#define QLMAPI_STAT_GEN_BROADCAST_FRAMES_XMIT                0x00000400
// The data in the 'directed_bytes_rcv' member is valid.
#define QLMAPI_STAT_GEN_DIRECTED_BYTES_RCV                   0x00000800
// The data in the 'directed_frames_rcv' member is valid.
#define QLMAPI_STAT_GEN_DIRECTED_FRAMES_RCV                  0x00001000
// The data in the 'multicast_bytes_rcv' member is valid.
#define QLMAPI_STAT_GEN_MULTICAST_BYTES_RCV                  0x00002000
// The data in the 'multicast_frames_rcv' member is valid.
#define QLMAPI_STAT_GEN_MULTICAST_FRAMES_RCV                 0x00004000
// The data in the 'broadcast_bytes_rcv' member is valid.
#define QLMAPI_STAT_GEN_BROADCAST_BYTES_RCV                  0x00008000
// The data in the 'broadcast_frames_rcv' member is valid.
#define QLMAPI_STAT_GEN_BROADCAST_FRAMES_RCV                 0x00010000
// The data in the 'rcv_crc_error' member is valid.
#define QLMAPI_STAT_GEN_RCV_CRC_ERROR                        0x00020000
// The data in the 'transimit_queue_length' member is valid.
#define QLMAPI_STAT_GEN_TRANSMIT_QUEUE_LENGTH                0x00040000
// The data in the 'rcv_discards' member is valid.
#define QLMAPI_STAT_GEN_RCV_DISCARDS                         0x00080000
// The data in the 'bytes_rcv' member is valid.
#define QLMAPI_STAT_GEN_BYTES_RCV                            0x00100000
// The data in the 'bytes_xmit' member is valid.
#define QLMAPI_STAT_GEN_BYTES_XMIT                           0x00200000
// The data in the 'xmit_discards' member is valid.
#define QLMAPI_STAT_GEN_XMIT_DISCARDS                        0x00400000

    U64 xmit_ok;                // OID_GEN_XMIT_OK
    U64 rcv_ok;                 // OID_GEN_RCV_OK
    U64 xmit_error;             // OID_GEN_XMIT_ERROR
    U64 rcv_error;              // OID_GEN_RCV_ERROR
    U64 rcv_no_buffer;          // OID_GEN_RCV_NO_BUFFER
    U64 directed_bytes_xmit;    // OID_GEN_DIRECTED_BYTES_XMIT
    U64 directed_frames_xmit;   // OID_GEN_DIRECTED_FRAMES_XMIT
    U64 multicast_bytes_xmit;   // OID_GEN_MULTICAST_BYTES_XMIT
    U64 multicast_frames_xmit;  // OID_GEN_MULTICAST_FRAMES_XMIT
    U64 broadcast_bytes_xmit;   // OID_GEN_BROADCAST_BYTES_XMIT
    U64 broadcast_frames_xmit;  // OID_GEN_BROADCAST_FRAMES_XMIT
    U64 directed_bytes_rcv;     // OID_GEN_DIRECTED_BYTES_RCV
    U64 directed_frames_rcv;    // OID_GEN_DIRECTED_FRAMES_RCV
    U64 multicast_bytes_rcv;    // OID_GEN_MULTICAST_BYTES_RCV
    U64 multicast_frames_rcv;   // OID_GEN_MULTICAST_FRAMES_RCV
    U64 broadcast_bytes_rcv;    // OID_GEN_BROADCAST_BYTES_RCV
    U64 broadcast_frames_rcv;   // OID_GEN_BROADCAST_FRAMES_RCV
    U64 rcv_crc_error;          // OID_GEN_RCV_CRC_ERROR
    U64 transimit_queue_length; // OID_GEN_TRANSMIT_QUEUE_LENGTH

    ///////////////////////////////////////////////
    // Available only for Vista and later Windows.
    U64 rcv_discards;           // OID_GEN_RCV_DISCARDS
    U64 bytes_rcv;              // OID_GEN_BYTES_RCV
    U64 bytes_xmit;             // OID_GEN_BYTES_XMIT
    U64 xmit_discards;          // OID_GEN_XMIT_DISCARDS
    ///////////////////////////////////////////////

} QL_GENERAL_STATISTICS_EX;



typedef struct _QL_ETHERNET_STATISTICS
{
    U32 rcv_error_alignment;    //OID_802_3_RCV_ERROR_ALIGNMENT
    U32 xmit_one_collision;     //OID_802_3_XMIT_ONE_COLLISION
    U32 xmit_more_collisions;   //OID_802_3_XMIT_MORE_COLLISIONS
    U32 xmit_deferred;          //OID_802_3_XMIT_DEFERRED
    U32 xmit_max_collisions;    //OID_802_3_XMIT_MAX_COLLISIONS
    U32 rcv_overrun;            //OID_802_3_RCV_OVERRUN
    U32 xmit_underrun;          //OID_802_3_XMIT_UNDERRUN
    U32 xmit_heartbeat_failure; //OID_802_3_XMIT_HEARTBEAT_FAILURE
    U32 xmit_times_crs_lost;    //OID_802_3_XMIT_TIMES_CRS_LOST
    U32 xmit_late_collisions;   //OID_802_3_XMIT_LATE_COLLISIONS
} QL_ETHERNET_STATISTICS;



typedef struct _QL_ETHERNET_STATISTICS64
{
    U64 rcv_error_alignment;    //OID_802_3_RCV_ERROR_ALIGNMENT
    U64 xmit_one_collision;     //OID_802_3_XMIT_ONE_COLLISION
    U64 xmit_more_collisions;   //OID_802_3_XMIT_MORE_COLLISIONS
    U64 xmit_deferred;          //OID_802_3_XMIT_DEFERRED
    U64 xmit_max_collisions;    //OID_802_3_XMIT_MAX_COLLISIONS
    U64 rcv_overrun;            //OID_802_3_RCV_OVERRUN
    U64 xmit_underrun;          //OID_802_3_XMIT_UNDERRUN
    U64 xmit_heartbeat_failure; //OID_802_3_XMIT_HEARTBEAT_FAILURE
    U64 xmit_times_crs_lost;    //OID_802_3_XMIT_TIMES_CRS_LOST
    U64 xmit_late_collisions;   //OID_802_3_XMIT_LATE_COLLISIONS
} QL_ETHERNET_STATISTICS64;



#define QL_ETHERNET_STATISTICS_EX_VER   1

typedef struct _QL_ETHERNET_STATISTICS_EX
{
    //  Version is defined as QL_ETHERNET_STATISTICS_EX_VER.
    //  'version' is required upon input
    U32 version;

    U64 SupportedStatistics;
    // The value of 'SupportedStatistics' is the bitwise OR of the following
    // flags.
// The data in the 'rcv_error_alignment' member is valid.
#define QLMAPI_STAT_802_3_RCV_ERROR_ALIGNMENT                0x00000001
// The data in the 'xmit_one_collision' member is valid.
#define QLMAPI_STAT_802_3_XMIT_ONE_COLLISION                 0x00000002
// The data in the 'xmit_more_collisions' member is valid.
#define QLMAPI_STAT_802_3_XMIT_MORE_COLLISIONS               0x00000004
// The data in the 'xmit_deferred' member is valid.
#define QLMAPI_STAT_802_3_XMIT_DEFERRED                      0x00000008
// The data in the 'xmit_max_collisions' member is valid.
#define QLMAPI_STAT_802_3_XMIT_MAX_COLLISIONS                0x00000010
// The data in the 'rcv_overrun' member is valid.
#define QLMAPI_STAT_802_3_RCV_OVERRUN                        0x00000020
// The data in the 'xmit_underrun' member is valid.
#define QLMAPI_STAT_802_3_XMIT_UNDERRUN                      0x00000040
// The data in the 'xmit_heartbeat_failure' member is valid.
#define QLMAPI_STAT_802_3_XMIT_HEARTBEAT_FAILUR              0x00000080
// The data in the 'xmit_times_crs_lost' member is valid.
#define QLMAPI_STAT_802_3_XMIT_TIMES_CRS_LOST                0x00000100
// The data in the 'xmit_late_collisions' member is valid.
#define QLMAPI_STAT_802_3_XMIT_LATE_COLLISIONS               0x00000200

    U64 rcv_error_alignment;    //OID_802_3_RCV_ERROR_ALIGNMENT
    U64 xmit_one_collision;     //OID_802_3_XMIT_ONE_COLLISION
    U64 xmit_more_collisions;   //OID_802_3_XMIT_MORE_COLLISIONS
    U64 xmit_deferred;          //OID_802_3_XMIT_DEFERRED
    U64 xmit_max_collisions;    //OID_802_3_XMIT_MAX_COLLISIONS
    U64 rcv_overrun;            //OID_802_3_RCV_OVERRUN
    U64 xmit_underrun;          //OID_802_3_XMIT_UNDERRUN
    U64 xmit_heartbeat_failure; //OID_802_3_XMIT_HEARTBEAT_FAILURE
    U64 xmit_times_crs_lost;    //OID_802_3_XMIT_TIMES_CRS_LOST
    U64 xmit_late_collisions;   //OID_802_3_XMIT_LATE_COLLISIONS

} QL_ETHERNET_STATISTICS_EX;



#ifdef _WIN32

typedef struct _QL_BRCM_STATISTICS
{
    // Statistics maintained by Receive MAC.
    U64 ifHCInOctets;
    U64 etherStatsFragments;
    U64 ifHCInUcastPkts;
    U64 ifHCInMulticastPkts;
    U64 ifHCInBroadcastPkts;
    U64 dot3StatsFCSErrors;
    U64 dot3StatsAlignmentErrors;
    U64 xonPauseFramesReceived;
    U64 xoffPauseFramesReceived;
    U64 macControlFramesReceived;
    U64 xoffStateEntered;

    //////////////////////////
    // Not available for 57710
    U64 dot3StatsFramesTooLong;
    //////////////////////////

    U64 etherStatsJabbers;
    U64 etherStatsUndersizePkts;

    //////////////////////////
    // Not available for 5706
    // Not available for 57710
    U64 inRangeLengthError;
    U64 outRangeLengthError;
    //////////////////////////

    //////////////////////////
    // Not available for 57710
    U64 etherStatsPkts64Octets;
    U64 etherStatsPkts65Octetsto127Octets;
    U64 etherStatsPkts128Octetsto255Octets;
    U64 etherStatsPkts256Octetsto511Octets;
    U64 etherStatsPkts512Octetsto1023Octets;
    U64 etherStatsPkts1024Octetsto1522Octets;
    //////////////////////////

    //////////////////////////
    // Not available for 57710
    // Not available for 5706
    U64 etherStatsPkts1523Octetsto2047Octets;
    U64 etherStatsPkts2048Octetsto4095Octets;
    U64 etherStatsPkts4096Octetsto8191Octets;
    U64 etherStatsPkts8192Octetsto9022Octets;
    //////////////////////////

    // Statistics maintained by Transmit MAC.
    U64 ifHCOutOctets;
    U64 etherStatsCollisions;
    U64 outXonSent;
    U64 outXoffSent;
    U64 flowControlDone;
    U64 dot3StatsInternalMacTransmitErrors;

    U64 dot3StatsSingleCollisionFrames;
    U64 dot3StatsMultipleCollisionFrames;
    U64 dot3StatsDeferredTransmissions;
    U64 dot3StatsExcessiveCollisions;
    U64 dot3StatsLateCollisions;

    //////////////////////////
    // Not available for 5706
    // Not available for 57710
    U64 dot3Collided2Times;
    U64 dot3Collided3Times;
    U64 dot3Collided4Times;
    U64 dot3Collided5Times;
    U64 dot3Collided6Times;
    U64 dot3Collided7Times;
    U64 dot3Collided8Times;
    U64 dot3Collided9Times;
    U64 dot3Collided10Times;
    U64 dot3Collided11Times;
    U64 dot3Collided12Times;
    U64 dot3Collided13Times;
    U64 dot3Collided14Times;
    U64 dot3Collided15Times;
    //////////////////////////

    U64 ifHCOutUcastPkts;
    U64 ifHCOutMulticastPkts;
    U64 ifHCOutBroadcastPkts;
    U64 dot3StatsCarrierSenseErrors;

    /////////////////////////
    // Not available for 5706
    U64 ifOutDiscards;
    /////////////////////////

    ///////////////////////////////////////////
    // Not available for 5706 monolithic driver
    U64 ifOutErrors;
    ///////////////////////////////////////////

    // Statistics maintained by Receive List Placement.
    //////////////////////////
    // Not available for 5706
    // Not available for 57710
    U64 COSIfHCInPkts[16];
    U64 COSFramesDroppedDueToFilters;
    U64 nicDmaWriteQueueFull;
    U64 nicDmaWriteHighPriQueueFull;
    //////////////////////////

    //////////////////////////
    // Not available for 57710
    U64 nicNoMoreRxBDs;
    //////////////////////////

    //////////////////////////
    // Not available for 5706 VBD
    // Not available for 57710
    U64 ifInDiscards;
    //////////////////////////

    U64 ifInErrors;

    //////////////////////////
    // Not available for 5706
    // Not available for 57710
    U64 nicRecvThresholdHit;
    //////////////////////////

    // Statistics maintained by Send Data Initiator.
    //////////////////////////
    // Not available for 5706
    // Not available for 57710
    U64 COSIfHCOutPkts[16];
    U64 nicDmaReadQueueFull;
    U64 nicDmaReadHighPriQueueFull;
    U64 nicSendDataCompQueueFull;
    //////////////////////////

    // Statistics maintained by Host Coalescing.
    //////////////////////////
    // Not available for 5706
    // Not available for 57710
    U64 nicRingSetSendProdIndex;
    U64 nicRingStatusUpdate;
    U64 nicInterrupts;
    U64 nicAvoidedInterrupts;
    U64 nicSendThresholdHit;
    //////////////////////////

} QL_BRCM_STATISTICS;

#else /* Unix */

#define QL_BRCM_STATISTICS_VER    2

typedef struct _QL_BRCM_STATISTICS
{
    //  Version is defined as QL_BRCM_STATISTICS_VER.
    //  'version' is required on input
    U64 version;

    U64 ifOutOctets;                            // MIB.IETF|RFC1213-MIB.ifOutOctets
    U64 ifInOctets;                             // MIB.IETF|RFC1213-MIB.ifInOctets
    U64 TotalPacketsTransmitted;                // MIF.DMTF|Network Adapter 802 Port|001.6
    U64 TotalPacketsReceived;                   // MIF.DMTF|Network Adapter 802 Port|001.8
    U64 dot3StatsAlignmentErrors;               // MIB.IETF|EtherLike-MIB.dot3StatsAlignmentErrors
    U64 dot3StatsFCSErrors;                     // MIB.IETF|EtherLike-MIB.dot3StatsFCSErrors
    U64 dot3StatsSingleCollisionFrames;         // MIB.IETF|EtherLike-MIB.dot3StatsSingleCollisionFrames
    U64 dot3StatsMultipleCollisionFrames;       // MIB.IETF|EtherLike-MIB.dot3StatsMultipleCollisionFrames
    U64 dot3StatsDeferredTransmissions;         // MIB.IETF|EtherLike-MIB.dot3StatsDeferredTransmissions
    U64 dot3StatsLateCollisions;                // MIB.IETF|EtherLike-MIB.dot3StatsLateCollisions
    U64 dot3StatsExcessiveCollisions;           // MIB.IETF|EtherLike-MIB.dot3StatsExcessiveCollisions
    U64 dot3StatsInternalMacTransmitErrors;     // MIB.IETF|EtherLike-MIB.dot3StatsInternalMacTransmitErrors
    U64 dot3StatsInternalMacReceiveErrors;      // MIB.IETF|EtherLike-MIB.dot3StatsInternalMacReceiveErrors
    U64 dot3StatsCarrierSenseErrors;            // MIB.IETF|EtherLike-MIB.dot3StatsCarrierSenseErrors
    U64 dot3StatsFrameTooLongs;                 // MIB.IETF|EtherLike-MIB.dot3StatsFrameTooLongs

    // Statistics maintained by Receive MAC.
//    U64 ifHCInOctets; // same as ifInOctets
    U64 etherStatsFragments;
    U64 ifHCInUcastPkts;
    U64 ifHCInMulticastPkts;
    U64 ifHCInBroadcastPkts;
//    U64 dot3StatsFCSErrors; // defined already
//    U64 dot3StatsAlignmentErrors; // defined already
    U64 xonPauseFramesReceived;
    U64 xoffPauseFramesReceived;
    U64 macControlFramesReceived;
    U64 xoffStateEntered;

    //////////////////////////
    // Not available for 57710
//    U64 dot3StatsFramesTooLong; // same as dot3StatsFrameTooLongs
    //////////////////////////

    U64 etherStatsJabbers;
    U64 etherStatsUndersizePkts;

    //////////////////////////
    // Not available for 5706
    // Not available for 57710
    U64 inRangeLengthError;
    U64 outRangeLengthError;
    //////////////////////////

    //////////////////////////
    // Not available for 57710
    U64 etherStatsPkts64Octets;
    U64 etherStatsPkts65Octetsto127Octets;
    U64 etherStatsPkts128Octetsto255Octets;
    U64 etherStatsPkts256Octetsto511Octets;
    U64 etherStatsPkts512Octetsto1023Octets;
    U64 etherStatsPkts1024Octetsto1522Octets;
    //////////////////////////

    //////////////////////////
    // Not available for 57710
    // Not available for 5706
    U64 etherStatsPkts1523Octetsto2047Octets;
    U64 etherStatsPkts2048Octetsto4095Octets;
    U64 etherStatsPkts4096Octetsto8191Octets;
    U64 etherStatsPkts8192Octetsto9022Octets;
    //////////////////////////

    // Statistics maintained by Transmit MAC.
//    U64 ifHCOutOctets; // same as ifOutOctets
    U64 etherStatsCollisions;
    U64 outXonSent;
    U64 outXoffSent;
    U64 flowControlDone;
//    U64 dot3StatsInternalMacTransmitErrors; // defined already

//    U64 dot3StatsSingleCollisionFrames; // defined already
//    U64 dot3StatsMultipleCollisionFrames; // defined already
//    U64 dot3StatsDeferredTransmissions; // defined already
//    U64 dot3StatsExcessiveCollisions; // defined already
//    U64 dot3StatsLateCollisions; // defined already

    //////////////////////////
    // Not available for 5706
    // Not available for 57710
    U64 dot3Collided2Times;
    U64 dot3Collided3Times;
    U64 dot3Collided4Times;
    U64 dot3Collided5Times;
    U64 dot3Collided6Times;
    U64 dot3Collided7Times;
    U64 dot3Collided8Times;
    U64 dot3Collided9Times;
    U64 dot3Collided10Times;
    U64 dot3Collided11Times;
    U64 dot3Collided12Times;
    U64 dot3Collided13Times;
    U64 dot3Collided14Times;
    U64 dot3Collided15Times;
    //////////////////////////

    U64 ifHCOutUcastPkts;
    U64 ifHCOutMulticastPkts;
    U64 ifHCOutBroadcastPkts;
//    U64 dot3StatsCarrierSenseErrors; // defined already

    /////////////////////////
    // Not available for 5706
    U64 ifOutDiscards;
    /////////////////////////

    ///////////////////////////////////////////
    // Not available for 5706 monolithic driver
    U64 ifOutErrors;
    ///////////////////////////////////////////

    // Statistics maintained by Receive List Placement.
    //////////////////////////
    // Not available for 5706
    // Not available for 57710
    U64 COSIfHCInPkts[16]; // NOT supported in Linux
    U64 COSFramesDroppedDueToFilters; // NOT supported in Linux
    U64 nicDmaWriteQueueFull;
    U64 nicDmaWriteHighPriQueueFull;
    //////////////////////////

    //////////////////////////
    // Not available for 5706
    // Not available for 57710
    U64 nicNoMoreRxBDs;
    //////////////////////////

    U64 ifInDiscards;

    //////////////////////////
    // Not available for 5706
    // Not available for 57710
    U64 ifInErrors;
    //////////////////////////

    //////////////////////////
    // Not available for 5706
    // Not available for 57710
    U64 nicRecvThresholdHit;
    //////////////////////////

    // Statistics maintained by Send Data Initiator.
    //////////////////////////
    // Not available for 5706
    // Not available for 57710
    U64 COSIfHCOutPkts[16]; // NOT supported in Linux
    U64 nicDmaReadQueueFull;
    U64 nicDmaReadHighPriQueueFull;
    U64 nicSendDataCompQueueFull;
    //////////////////////////

    // Statistics maintained by Host Coalescing.
    //////////////////////////
    // Not available for 5706
    // Not available for 57710
    U64 nicRingSetSendProdIndex;
    U64 nicRingStatusUpdate;
    U64 nicInterrupts;
    U64 nicAvoidedInterrupts;
    U64 nicSendThresholdHit;
    //////////////////////////

} QL_BRCM_STATISTICS;

#endif /* Unix */


#define QL_BRCM_STATISTICS_EX_VER    2

typedef struct _QL_BRCM_STATISTICS_EX
{
    // version must filled on input
    U64                 version;

    QL_BRCM_STATISTICS  brcm_statistics;

    // -1 if driver does not support this counter
    U64                 TxLargeSendFrames;

// NOT supported in QLmapilnx =====================================Begin
    // Available only for 57710 family devices
    U64                 ifInNoBrbBuffer;
    U64                 ifInMBUFDiscards;
// NOT supported in QLmapilnx =======================================End

} QL_BRCM_STATISTICS_EX;



typedef struct _QL_LINK_STATUS
{
    U32 link_status;            // 1 = Link Pass, 0 = Link Fail
    U32 local_Rx_status;        // 1 = Local Receive OK
                                // 0 = Local Receive Error
    U32 remote_Rx_status;       // 1 = Remote Receive OK
                                // 0 = Remote Receive Error
    U32 auto_negotiation_mode;  // 1 = AutoNegotiation is enabled
                                // 0 = Forced speed
    U32 requested_media_type;   // QLMAPI_LM_REQUESTED_MEDIA_TYPE_AUTO
                                // QLMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_10MBPS
                                // QLMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_10MBPS_FULL_DUPLEX
                                // QLMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_100MBPS
                                // QLMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_100MBPS_FULL_DUPLEX
                                // QLMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_1000MBPS
                                // QLMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_1000MBPS_FULL_DUPLEX
    U32 duplex_mode;            // 0 = half duplex
                                // 1 = full duplex
    U32 link_speed;             // QLMAPI_LM_LINE_SPEED_UNKNOWN
                                // QLMAPI_LM_LINE_SPEED_10MBPS
                                // QLMAPI_LM_LINE_SPEED_100MBPS
                                // QLMAPI_LM_LINE_SPEED_1000MBPS

} QL_LINK_STATUS;



#define QLMAPI_LINK_STATUS_EX_VER    3

typedef struct
{
    U32                 version;
    QL_LINK_STATUS      link_status;

    // The unit value is Kbps. The actual speed value will be truncated
    // to the lower bound of Kbps. For example, if the speed is 14.4 Kbps,
    // the value will be 14. If the speed is less than 1 Kbps, the value
    // will be 0.
    U32                 line_speed_Kbps;

    // Boolean flag to indicate whether driver is running.
    U32                 driver_loaded;

    // Driver's major and minor version number.
    U32                 major_version_number;
    U32                 minor_version_number;

    // Boolean flag to denote if DHCP is enabled.
    // Not available in non Windows platforms.
    U32                 dhcp_enabled;

    // IP address is "192.168.0.1" format. (REG_MULTI_SZ or REG_SZ)
    S8                  ip_addr[QLMAPI_MAX_IP_ADDR_LEN];

    // subnet mask is "255.255.0.0" format. (REG_MULTI_SZ or REG_SZ)
    S8                  subnet_mask[QLMAPI_MAX_IP_ADDR_LEN];

    // defaule gateway is "192.168.0.1" format. (REG_MULTI_SZ or REG_SZ)
    S8                  default_gateway[QLMAPI_MAX_IP_ADDR_LEN];

    S8                  current_mac_addr[QLMAPI_MAX_MAC_ADDR_LEN];
    S8                  permanent_mac_addr[QLMAPI_MAX_MAC_ADDR_LEN];

    // First IPv6 address found for the NIC.
    // Applications can cast like "( LPSOCKADDR )&ipv6.Address" to API
    // such as WSAAddressToString().
    QL_IP_UNICAST_ADDRESS       ipv6;
    // The following 802.3 offload capabilities are not supported in Linux...
    // ==================================================================Begin
    // 802.3 offload capabilities
    // These three fields valid ONLY for OS prior to (include) Windows 2003.
    // For NDIS 6.0 and later (Vista and Longhorn), use 'ol_task' and
    // 'ol_conn'.
    QL_OFFLOAD_TCP_IP_CHECKSUM  ol_802_3_tcpip_chksum;
    QL_OFFLOAD_TCP_LARGE_SEND   ol_802_3_lso;
    QL_OFFLOAD_TCP_CONNECTION   ol_802_3_tcp_conn;

    // These two fields valid only for NDIS 6.0 and later (Vista and
    // Longhorn).
    QL_TASK_OFFLOAD             ol_task;
    QL_TCP_CONNECTION_OFFLOAD   ol_conn;
    // ====================================================================End
    // This is the handle to the NIC.
    // The field is added to support QLmapiRetrieveMultiLinkStatus().
    U32                         handle;

    // First IPv6 Gateway address found for the NIC.
    // Only available for Vista or later.
    // Applications can cast like "( LPSOCKADDR )&gateway_v6.Address" to API
    // such as WSAAddressToString(). 
    QL_IP_ADAPTER_GATEWAY_ADDRESS   gateway_v6;

    // 'ipv6_flags' in QL_ADAPTER_INFO_EX
    U32                         ipv6_flags;

    // return code for this structure.
    // The field is added to support QLmapiRetrieveMultiLinkStatus().
    // Applications must check QLmapiRetrieveMultiLinkStatus() to be QLMAPI_OK
    // before using 'return_code' from each individual structure.
    U32                         return_code;

    // Same 'SupportedFlags' definition as in QL_BRCM_ADAPTER_INFO_EX.
    U32                         SupportedFlags;

    // For L2 networking device.
    U32                         mtu;

    // Available only for NX2 10G devices.
    U32                 phy_link_speed_mbps;

    // This field will only be non-zero if the PHY negotiated flow control
    // with the far end.
    // The same as 'flow_ctrl' from QL_BRCM_ADAPTER_INFO_EX.
    U32                 flow_ctrl;

} QL_LINK_STATUS_EX;



/****************************************************************************
 *  OBSOLETE starts here
 ****************************************************************************/
typedef struct _QL_BRCM_NIC_PARAM_REQ
{
    U32     num_of_params;
    U8      param_id_List[1];
} QL_BRCM_NIC_PARAM_REQ;



typedef struct _QL_BRCM_NIC_PARAM_DATA
{
    U32     param_id;
    U32     param_type;
    U32     param_data_len;
    U32     result;
    U32     offset_next_param;
    U8      param_data[1];
} QL_BRCM_NIC_PARAM_DATA;
/****************************************************************************
 *  OBSOLETE ends here
 ****************************************************************************/



#define QLMAPI_NIC_PCI_INFO_VER          2

typedef struct _QL_NIC_PCI_INFO
{
    //  Version is defined as QLMAPI_NIC_PCI_INFO_VER.
    //  'version' is required upon input
    U16     version;

    // If PCI IDs information is not available, the value will be -1 and
    // 'manufacturer' will be "".
    U16     vendor_id;
    U16     device_id;
    U16     subsystem_vendor_id;
    U16     subsystem_id;
    U8      manufacturer[QLMAPI_MAX_MFG_LEN];

    // hardware revision
    U32     revision;

    // PCI bus information. If these information are not available,
    // data will be set to -1.
    U32     bus_no;
    U32     device_no;
    U32     function_no;

    // PCI slot number labeled next to motherboard (W2k only).
    // This is an optional field (at least, LOM will not have it).
    // If it is not available, this field will be set to -1.
    U32     ui_number;

    // PCI information
    // Valid for Broadcom NIC only.
    U32     mem_base_low;
    U32     mem_base_high;

    // PCI information
    // No valid if the NIC is on MSI.
    U32     irq;

} QL_NIC_PCI_INFO;


//  ASF tables (base on ASF 1.0)
// ASF definition
#define QLMAPI_MAX_ALERTDATA                             8
#define QLMAPI_ASF_SPEC_1_0_ALERTDATA_ELEMENT_LENGTH     12
#define QLMAPI_MAX_CONTROLDATA                           8
#define QLMAPI_MAX_SPEC_1_0_CONTROLDATA_ELEMENT_LENGTH   4

// since structure ASF_ADDR has extra 2 bytes other than FixedSMBusAddresses,
// to align the structure to LONG, QLMAPI_MAX_FIXEDSMBUSADDR should use
// (multiple of 4) - 2. In this case, we are using 14.
#define QLMAPI_MAX_FIXEDSMBUSADDR                        14

// speed defines for QL_ASF_MISC
#define QLMAPI_ASF_SPEED_10_100                          0
#define QLMAPI_ASF_SPEED_10                              1
#define QLMAPI_ASF_SPEED_100                             2
#define QLMAPI_ASF_SPEED_1000                            3
#define QLMAPI_ASF_SPEED_ALL                             4
#define QLMAPI_ASF_SPEED_MASK                            0x7

#define QLMAPI_ASF_HALF_DUPLEX                           0x20
#define QLMAPI_ASF_PAUSE_NOT_CAPABLE                     0x40
#define QLMAPI_ASF_AUTO_DISABLE                          0x80

typedef struct _QL_ASF_INFO
{
    U8      MinWatchdogResetValue;
    U8      MinPollingInterval;
    U16     SystemID;

    U8      IANAManufacturerID[4];

    U8      FeatureFlags;       /* added in ASF 2.0 */
    U8      Reserved[3];
} QL_ASF_INFO;

typedef struct _QL_ASF_ALERTDATA
{
    U8      DeviceAddress;
    U8      Command;
    U8      DataMask;
    U8      CompareValue;

    U8      EventSensorType;
    U8      EventType;
    U8      EventOffset;
    U8      EventSourceType;

    U8      EventSeverity;
    U8      SensorNumber;
    U8      Entity;
    U8      EntityInstance;
} QL_ASF_ALERTDATA;

typedef struct _QL_ASF_ALRT
{
    U8                      AssertionEventMask;     /* added in ASF 2.0 */
    U8                      DeassertionEventMask;   /* added in ASF 2.0 */
    U8                      NumberOfAlerts;
    U8                      ArrayElementLength;

    QL_ASF_ALERTDATA        AsfAlertData[QLMAPI_MAX_ALERTDATA];
} QL_ASF_ALRT;

typedef struct _QL_ASF_CONTROLDATA
{
    U8      Function;
    U8      DeviceAddress;
    U8      Command;
    U8      DataValue;
} QL_ASF_CONTROLDATA;

typedef struct _QL_ASF_RCTL
{
    U8                      NumberOfControl;
    U8                      ArrayElementLength;
    /* to align to dword */
    U8                      Reserved[2];
    QL_ASF_CONTROLDATA      AsfControlData[QLMAPI_MAX_CONTROLDATA];
} QL_ASF_RCTL;

typedef struct _QL_ASF_RMCP
{
    U8      RemoteControlCapabilities[7];
    U8      RMCPCompletionCode;

    U8      RMCPIANA[4];

    U8      RMCPSpecialCommand;
    U8      RMCPSpecialCommandParameter[2];
    U8      RMCPBootOptions[2];
    U8      RMCPOEMParameters[2];

    /* to align to dword */
    U8      filler;
} QL_ASF_RMCP;

typedef struct _QL_ASF_ADDR
{
    U8      SEEPROMAddress;
    U8      NumberOfDevices;
    U8      FixedSMBusAddresses[QLMAPI_MAX_FIXEDSMBUSADDR];
} QL_ASF_ADDR;

struct QL_ASF_CFG
{
#if defined(BIG_ENDIAN) && !defined(BCM_LITTLE_ENDIAN_HOST)

    // Bit 31-0

    U32     reserved            : 16;
    // Send OEM specific "ASD Ready" message after initialization
    U32     EnableSendAsdReady  : 1;

    U32     reserved2           : 7;
    U32     EnableSecureOnly    : 1;
    U32     EnableSecureRMCP    : 1; /* ASF 2.0 - Secure RMCP */
    U32     EnableSMBusScan     : 1; /* Enable/Disable our NIC as a passive Slave Mode.  No ARP or Scan on the SMBus */
    U32     EnableASFWoL        : 1; /* Enable/Disable WoL on ARP or RMCP packet, while in OS absent */
    U32     EnablePET           : 1;
    U32     EnableRMCP          : 1;
    U32     EnableHeartBeat     : 1;
    U32     EnableASF           : 1;

    // Send OEM specific "ASD Ready" message after initialization
//    U32     EnableSendAsdReady  : 1;
//    U32     reserved            : 23;

#else
    U32     EnableASF           : 1;    // mirror of QL_FW_FEATURE_CONFIG.asf_enable
    U32     EnableHeartBeat     : 1;
    U32     EnableRMCP          : 1;
    U32     EnablePET           : 1;

    // Enable/Disable WoL on ARP or RMCP packet, while in OS absent
    U32     EnableASFWoL        : 1;

    // Enable/Disable our NIC as a passive Slave Mode.
    // No ARP or Scan on the SMBus.
    U32     EnableSMBusScan     : 1;

    U32     EnableSecureRMCP    : 1;    // ASF 2.0 - Secure RMCP
    U32     EnableSecureOnly    : 1;    // No ASF 1.0 Compatibility

    U32     reserved2           : 7;

    // Send OEM specific "ASD Ready" message after initialization
    U32     EnableSendAsdReady  : 1;

    U32     reserved            : 16;
#endif
};

typedef struct _QL_ASF_MISC
{
    union {
        struct QL_ASF_CFG   Config;
        U32                 ConfigData;
    } cfg;

    U8      UuidGuid[16];

    U16     HeartBeatTimeValue;     /* in second */
    U8      reserved1[2];

    U8      DelayedPollTimeValue;   /* in second */
    U8      Speed;                  /* see speed defines above */
    U8      ReTransmitTimeValue;    /* in second */
    U8      LegacyPollTimeValue;    /* in second */

    U8      SysIP[4];
    U8      ManagementConsolIP[4];
    U8      GateWayIP[4];
    U8      subnetMask[4];
    U8      communityName[QLMAPI_MAX_COMMUNITY_NAME_LEN];
    U8      reserved2[12];
} QL_ASF_MISC;

#define QLMAPI_MAX_INIT_DATA 50

typedef struct _QL_SMB_INIT_DATA
{
    U8      addr;
    U8      index;
    U8      andMask;
    U8      orMask;
} QL_SMB_INIT_DATA;

#define QLMAPI_MAX_KEY_SIZE    20        /* 160 bits */

typedef struct
{
    U32     kgsize;
    U8      kg[QLMAPI_MAX_KEY_SIZE];
    U32     kosize;
    U8      ko[QLMAPI_MAX_KEY_SIZE];
    U32     kasize;
    U8      ka[QLMAPI_MAX_KEY_SIZE];

    /* Security Policy */
#if defined(BIG_ENDIAN) && !defined(BCM_LITTLE_ENDIAN_HOST)

#define QLMAPI_ASF_CAN_POWER_UP          (1<<0)
#define QLMAPI_ASF_CAN_RESET             (1<<1)
#define QLMAPI_ASF_CAN_RESET_POWER       (1<<2)
#define QLMAPI_ASF_CAN_POWER_DOWN        (1<<3)
#define QLMAPI_ASF_RIGHTS_MASK           0x0000000f

#else

#define QLMAPI_ASF_CAN_POWER_UP          (1<<24)
#define QLMAPI_ASF_CAN_RESET             (1<<25)
#define QLMAPI_ASF_CAN_RESET_POWER       (1<<26)
#define QLMAPI_ASF_CAN_POWER_DOWN        (1<<27)
#define QLMAPI_ASF_RIGHTS_MASK           0x0f000000

#endif

    U32     op_rights;      /* operator rights bitfield */
    U32     admin_rights;   /* administrator rights bitfield */
    U32     session_timeout;    /* in seconds */
} QL_ASF20_T;

//  We will use QLMAPI_ASF_T_VERSION to identify the current version of
//  QL_ASF_TABLE.
//  Whenever the table is changed for release, QLMAPI_ASF_T_VERSION should
//  increase.
#define QLMAPI_ASF_T_VERSION         8

typedef struct _QL_ASF_TABLE
{
    U8                  version;    // version of the table

/****************************************************************************
 *  Following fields valid only for ASF and IMPI
 *  For IPMI, only 'EnableASF' in QL_ASF_CFG can be set/clear.
 ****************************************************************************/
    U8                  smbusAddr;  // forced NIC smbus address, 0 means
                                    // use ARP, other value to force 
                                    // smbus address
    U16                 size;
    QL_ASF_INFO         AsfInfo;
    QL_ASF_ALRT         AsfAlert;
    QL_ASF_RCTL         AsfRCtl;
    QL_ASF_RMCP         AsfRmcp;
    QL_ASF_ADDR         AsfAddr;
    QL_ASF_MISC         AsfGui;
    QL_SMB_INIT_DATA    smbInitData[QLMAPI_MAX_INIT_DATA];

    QL_ASF20_T          Asf20;      // Added in version 6 for ASF 2.0,
                                    // ASF 1.0 firware will ignore this field.

    U8                  reserve[1024];

    U32                 chksum;

/****************************************************************************
 *  ASF and IMPI only fields end here.
 ****************************************************************************/

    // Management firmware version description string.
    U8                  firmware_ver_desc[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    U32                 fw_asfcfg_ver;    /* firmware asfcfg version */
    U32                 fw_asfcfg_size;   /* firmware asfcfg size */

#define QL_ASF_2_0_SUPPORT      0x00000001  // ASF Management Firmware with ASF 2.0 support
#define QL_IPMI_SUPPORT         0x00000002  // IPMI Management Firmware
#define QL_UMP_SUPPORT          0x00000004  // UMP Management Firmware
    U32                 flags;

} QL_ASF_TABLE;



/****************************************************************************/
/* Firmware information and definition                                      */
/*                                                                          */
/* ATTENTION:  Firmware is using Big-ENDIAN and Intel PC is using           */
/*             Little-ENDIAN.                                               */
/****************************************************************************/
#define QLMAPI_NTOH32(p)             ( ( U32 )( (*((U8 *) (p)) << 24) | (*((U8 *) (p)+1) << 16) | (*((U8 *) (p)+2) << 8) | *((U8 *) (p)+3) ) )
#define QLMAPI_FW_MAGIC_VALUE            0x669955aa
#define QLMAPI_FW_MEDIA_MAX_LOAD_STAGES  8

typedef struct _QL_FW_MEDIA_BOOTSTRAP_REGION
{
    // a pattern not likely to occur randomly
    U32     magic_value;

    // where to locate boot code (byte addr)
    U32     sram_start_addr;

    // boot code length (in words)
    U32     code_len;

    // location of code on media (media byte addr)
    U32     code_start_addr;

    // 32-bit CRC
    U32     cksum;

} QL_FW_MEDIA_BOOTSTRAP_REGION;


typedef enum {
    QLMAPI_FW_CODE_IMAGE_TYPE_PXE,           /*  0 0x00 */
    QLMAPI_FW_CODE_IMAGE_TYPE_ASF_INIT,      /*  1 0x01 */
    QLMAPI_FW_CODE_IMAGE_TYPE_ASF_CPUA,      /*  2 0x02 */
    QLMAPI_FW_CODE_IMAGE_TYPE_ASF_CPUB,      /*  3 0x03 */
    QLMAPI_FW_CODE_IMAGE_TYPE_ASF_CFG,       /*  4 0x04 */
    QLMAPI_FW_CODE_IMAGE_TYPE_ISCSI_CFG,     /*  5 0x05 */
    QLMAPI_FW_CODE_IMAGE_TYPE_ISCSI_CFG_PRG, /*  6 0x06 */
    QLMAPI_FW_CODE_IMAGE_TYPE_USER_BLOCK,    /*  7 0x07 */
    QLMAPI_FW_CODE_IMAGE_TYPE_BRSF_BLOCK,    /*  8 0x08 */
    QLMAPI_FW_CODE_IMAGE_TYPE_ISCSI_BOOT,    /*  9 0x09 */
    QLMAPI_FW_CODE_IMAGE_TYPE_ASF_MBOX,      /* 10 0x0a */
    QLMAPI_FW_CODE_IMAGE_TYPE_ISCSI_CFG_1,   /* 11 0x0b */
    QLMAPI_FW_CODE_IMAGE_TYPE_APE_CFG,       /* 12 0x0c */
    QLMAPI_FW_CODE_IMAGE_TYPE_APE_CODE,      /* 13 0x0d (APE firmware) */	
    QLMAPI_FW_CODE_IMAGE_TYPE_APE_UPDATE,    /* 14 0x0e (APE firmware update) */
    QLMAPI_FW_CODE_IMAGE_TYPE_EXT_CFG,       /* 15 0x0f */
    QLMAPI_FW_CODE_IMAGE_TYPE_EXT_DIR,       /* 16 0x10 */
    QLMAPI_FW_CODE_IMAGE_TYPE_APE_DATA,      /* 17 0x11 (a.k.a. Opaque Management Data, Offline Mailbox Data) */
    QLMAPI_FW_CODE_IMAGE_TYPE_APE_WEB_DATA,  /* 18 0x12 (Web/HTML interface content) */
    QLMAPI_FW_CODE_IMAGE_TYPE_APE_WORKAROUND,/* 19 0x13 (APE workaround firmware) */
    QLMAPI_FW_CODE_IMAGE_TYPE_EXTENDED_VPD,  /* 20 0x14 */
    QLMAPI_FW_MAX_CODE_IMAGE_TYPE,
} QL_FW_CODE_IMAGE;


typedef struct _QL_FW_MEDIA_CODE_OFFSET_REGION
{
    // where to locate code region (byte addr)
    U32     sram_start_addr;

#define QLMAPI_FW_CODE_LEN_RESERVED          0x00000000      /* all 8 bits are used for types now */
#define QLMAPI_FW_CODE_IMAGE_POS             24
/* Use 8 bits -- supports up to 256 types */
#define QLMAPI_FW_CODE_IMAGE_TYPE(x)         ((x >> QLMAPI_FW_CODE_IMAGE_POS) & 0x00ff)
#define QLMAPI_FW_CODE_IMAGE_TYPE_MASK       0xff000000
#define QLMAPI_FW_CODE_IMAGE_EXECUTE_A       0x00800000
#define QLMAPI_FW_CODE_IMAGE_EXECUTE_B       0x00400000
#define QLMAPI_FW_CODE_IMAGE_EXECUTABLE_A(x) (x & QLMAPI_FW_CODE_IMAGE_EXECUTE_A)
#define QLMAPI_FW_CODE_IMAGE_EXECUTABLE_B(x) (x & QLMAPI_FW_CODE_IMAGE_EXECUTE_B)
#define QLMAPI_FW_CODE_IMAGE_LENGTH(x)       (x & 0x3fffff)

    // code region length (in words)
    // The top 8 bits are used for TYPE field.
    // We use 22 bit for length so that we accumulate up to 16 Mbyte.
    U32     code_len;

    // location of code on media (media byte addr)
    U32     code_start_addr;

} QL_FW_MEDIA_CODE_OFFSET_REGION;


#define QLMAPI_FW_FEATURE_CONFIG_PXE_SPEED_AUTO      0   // Auto
#define QLMAPI_FW_FEATURE_CONFIG_PXE_SPEED_10_H      1   // 10Mbps Half Duplex
#define QLMAPI_FW_FEATURE_CONFIG_PXE_SPEED_10_F      2   // 10Mbps Full Duplex
#define QLMAPI_FW_FEATURE_CONFIG_PXE_SPEED_100_H     3   // 100Mbps Half Duplex
#define QLMAPI_FW_FEATURE_CONFIG_PXE_SPEED_100_F     4   // 100Mbps Full Duplex
#define QLMAPI_FW_FEATURE_CONFIG_PXE_SPEED_1000_H    5   // 1000Mbps Half Duplex
#define QLMAPI_FW_FEATURE_CONFIG_PXE_SPEED_1000_F    6   // 1000Mbps Full Duplex

#define QLMAPI_FW_FEATURE_CONFIG_BOOT_TYPE_PXE       0
#define QLMAPI_FW_FEATURE_CONFIG_BOOT_TYPE_RPL       1
#define QLMAPI_FW_FEATURE_CONFIG_BOOT_TYPE_BOOTP     2
#define QLMAPI_FW_FEATURE_CONFIG_BOOT_TYPE_ISCSI     3

#define QLMAPI_FW_FEATURE_CONFIG_BOOT_STRAP_AUTO     0
#define QLMAPI_FW_FEATURE_CONFIG_BOOT_STRAP_BBS      1
#define QLMAPI_FW_FEATURE_CONFIG_BOOT_STRAP_INT18    2
#define QLMAPI_FW_FEATURE_CONFIG_BOOT_STRAP_INT19    3

#define QLMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_64K    0
#define QLMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_128K   1
#define QLMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_256K   2
#define QLMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_512K   3
#define QLMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_1M     4
#define QLMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_2M     5
#define QLMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_4M     6
#define QLMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_8M     7
#define QLMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_16M    8

#define QLMAPI_FW_WOL_MASK                   0x00000001
#define QLMAPI_FW_PXE_MASK                   0x00000002
#define QLMAPI_FW_MBA_MASK                   0x00000002
#define QLMAPI_FW_PXE_SPEED_MASK             0x0000003c
#define QLMAPI_FW_MBA_SPEED_MASK             0x0000003c
#define QLMAPI_FW_MBA_TYPE_MASK              0x00300000
#define QLMAPI_FW_MBA_PROT_PXE               0x00000000
#define QLMAPI_FW_MBA_PROT_RPL               0x00100000
#define QLMAPI_FW_MBA_PROT_BOOTP             0x00200000
#define QLMAPI_FW_MBA_PROT_ISCSI             0x00300000
#define QLMAPI_FW_MBA_TYPE_SHIFT_POS         20
#define QLMAPI_FW_FORCE_PCI_MODE_MASK        0x00000040
#define QLMAPI_FW_ASF_MASK                   0x00000080
#define QLMAPI_FW_PXE_BAR_SIZE               0x00000f00
#define QLMAPI_FW_EEPROM_WP_MASK             BIT_22
#define QLMAPI_FW_EEPROM_WP_SHIFT_POS        22
#define QLMAPI_FW_WOL_SPEED_LOMIT10          BIT_25
#define QLMAPI_FW_LINK_IDLE_MODE_ENABLE      BIT_26
#define QLMAPI_FW_CABLE_SENSE_ENABLE         BIT_28
#define QLMAPI_LINK_AWARE_MODE_ENABLE        BIT_30
#define QLMAPI_LINK_SPEED_POWER_MODE_ENABLE  BIT_31

#define QLMAPI_FW_PXE_BOOT_TYPE_MASK         0x00300000
#define QLMAPI_FW_BOOT_TYPE_PXE_SHIFT_POS    20
#define QLMAPI_FW_PXE_BOOT_TYPE_PXE          (QLMAPI_FW_FEATURE_CONFIG_BOOT_TYPE_PXE << QLMAPI_FW_BOOT_TYPE_PXE_SHIFT_POS)
#define QLMAPI_FW_PXE_BOOT_TYPE_RPL          (QLMAPI_FW_FEATURE_CONFIG_BOOT_TYPE_RPL << QLMAPI_FW_BOOT_TYPE_PXE_SHIFT_POS)
#define QLMAPI_FW_PXE_BOOT_TYPE_BOOTP        (QLMAPI_FW_FEATURE_CONFIG_BOOT_TYPE_BOOTP << QLMAPI_FW_BOOT_TYPE_PXE_SHIFT_POS)

#define QLMAPI_FW_PXE_BAR_SIZE_SHIFT_POS     8

#define QLMAPI_VAUX_CUTOFF_DELAY_CHOICE(x)   (((x)>>23) & 0x3)

#define QLMAPI_DRIVER_WOL_DISABLE            0
#define QLMAPI_DRIVER_WOL_MAGIC_ENABLE       1
#define QLMAPI_DRIVER_WOL_INT_PKT_ENABLE     2
#define QLMAPI_DRIVER_WOL_BOTH_ENABLE        3



typedef union _QL_FW_FEATURE_CONFIG
{
    struct
    {
#if defined(BIG_ENDIAN) && !defined(BCM_LITTLE_ENDIAN_HOST)
        U32 link_speed_power    :1;     /* link speed power mode for Taishan */
        U32 link_aware          :1;     /* link aware mode for Taishan */
        U32 mba_vlan_enable     :1;     /* bit 29 - Enable VLAN in Multiple Boot Agent */
        U32 cable_sense         :1;
    	U32 pxe_boot_protocol1  :1;     /* bit 27      */
    	U32 link_idle           :1;     /* bit 26      */  /*driver_wol_enable is no longer used by driver and redefined */
        U32 Wol_Limit_10        :1;
        U32 vaux_cutoff_delay   :2;
        U32 lom_design          :1;
        U32 pxe_boot_protocol   :2;
        U32 pxe_timeout_msg     :4;
        U32 pxe_bootstrap_type  :2;     /* This field should be used by */
                                        /* boot code. This is only */
                                        /* referenced by MBA. */
        U32 hot_key_option      :1;     /* bit 13 - configure hot-key option: Ctrl-S or Ctrl-B  */
        U32 disable_setup_msg   :1;     /* bit 12 - Disable setup prompt for MBA configuration */
        U32 pxe_bar_size        :4;
        U32 asf_enable          :1;
        U32 force_pci           :1;
        U32 pxe_speed           :4;
        U32 pxe_enable          :1;
        U32 wol_enable          :1;
#else
        U32 wol_enable          :1;     /* bit 0      */
        U32 pxe_enable          :1;     /* bit 1      */
        U32 pxe_speed           :4;     /* bit 2:5    */
        U32 force_pci           :1;     /* bit 6      */
        U32 asf_enable          :1;     /* bit 7      */
        U32 pxe_bar_size        :4;     /* bit 8:11   */
        U32 disable_setup_msg   :1;     /* bit 12 - Disable setup prompt for MBA configuration */
        U32 hot_key_option      :1;     /* bit 13 - configure hot-key option: Ctrl-S or Ctrl-B  */
        U32 pxe_bootstrap_type  :2;     /* bit 14:15  */
        U32 pxe_timeout_msg     :4;     /* bit 16:19  */
        U32 pxe_boot_protocol   :2;     /* bit 20:21  */ /* This field */
                                        /* should be used by boot code. */
                                        /* This is only referenced by MBA. */
        U32 lom_design          :1;     /* bit 22     */
        U32 vaux_cutoff_delay   :2;     /* bit 23:24  */
        U32 Wol_Limit_10        :1;     /* bit 25     */
        U32 link_idle           :1;     /* bit 26      */  /*driver_wol_enable is no longer used by driver and redefined */
        U32 pxe_boot_protocol1  :1;     /* bit 27      */
        U32 cable_sense         :1;     /* bit 28     */
        U32 mba_vlan_enable     :1;     /* bit 29 - Enable VLAN in Multiple Boot Agent */
        U32 link_aware          :1;     /* for Taishan */
        U32 link_speed_power    :1;     /* link speed power mode for Taishan */
#endif
    } bit;

    U32 word;
} QL_FW_FEATURE_CONFIG;



#define QLMAPI_FW_NIC_HW_CONFIG_PHY_TYPE_UNKNOWN             0
#define QLMAPI_FW_NIC_HW_CONFIG_PHY_TYPE_COPPER              1
#define QLMAPI_FW_NIC_HW_CONFIG_PHY_TYPE_FIBER               2

/* the defines for mode setting in menu */
#define QLMAPI_FW_NIC_HW_CONFIG_LED_MAC_MODE                 0
#define QLMAPI_FW_NIC_HW_CONFIG_LED_MODE_PHY_MODE_1          1
#define QLMAPI_FW_NIC_HW_CONFIG_LED_MODE_PHY_MODE_2          2
#define QLMAPI_FW_NIC_HW_CONFIG_LED_MODE_SHARED_TRAFFIC      3
#define QLMAPI_FW_NIC_HW_CONFIG_LED_MODE_SHASTA_MAC_MODE     4
#define QLMAPI_FW_NIC_HW_CONFIG_LED_MODE_WIRELESS_COMBO_MODE 5  

#define QLMAPI_FW_NIC_HW_CONFIG_LED_MODE_UNKNOWN             0
#define QLMAPI_FW_NIC_HW_CONFIG_LED_MODE_TRIPLE_LINK         1
#define QLMAPI_FW_NIC_HW_CONFIG_LED_MODE_LINK_SPEED          2

#define QLMAPI_FW_NIC_HW_CONFIG_VOLTAGE_1_3_V        0x0
#define QLMAPI_FW_NIC_HW_CONFIG_VOLTAGE_1_8_V        0x1
#define QLMAPI_FW_NIC_HW_CONFIG_VOLTAGE_MASK         0x3
#define QLMAPI_FW_NIC_HW_CONFIG_VOLTAGE_PARM(x)      (x & NIC_HW_CONFIG_VOLTAGE_MASK)

/* Both channel A and B are used */
#define QLMAPI_FW_NIC_HW_CONFIG_DUAL_MAC_NORMAL      0x0
/* Only Channel B is used */
#define QLMAPI_FW_NIC_HW_CONFIG_DUAL_MAC_CHAN_B      0x1
/* Only Channel A is used */
#define QLMAPI_FW_NIC_HW_CONFIG_DUAL_MAC_CHAN_A      0x2
/* Use XBAR. single config. space for both channels. */
#define QLMAPI_FW_NIC_HW_CONFIG_DUAL_MAC_XBAR        0x3

#define QLMAPI_FW_NIC_HW_CONFIG_DAUL_MAC_MASK        0xc00
#define QLMAPI_FW_NIC_DUAL_MAC_SHIFT_POS             10
#define QLMAPI_FW_NIC_HW_CONFIG_DUAL_MAC_PARM(x)     ((x & NIC_HW_CONFIG_DAUL_MAC_MASK) >> NIC_DUAL_MAC_SHIFT_POS)

#define QLMAPI_FW_SHASTA_EXT_LED_LEGACY_MODE                     0
#define QLMAPI_FW_SHASTA_EXT_LED_SHARED_TRAFFIC_LINK_LED_MODE    1
#define QLMAPI_FW_SHASTA_EXT_LED_SHASTA_MAC_MODE                 2
#define QLMAPI_FW_SHASTA_EXT_LED_WIRELESS_COMBO_MODE             3

#define QLMAPI_FW_HW_CFG_VOLTAGE_SOURCE_MASK         (BIT_0 | BIT_1)
#define QLMAPI_FW_HW_CFG_PHY_LED_MODE_MASK           (BIT_2 | BIT_3)
#define QLMAPI_FW_HW_CFG_PHY_TYPE_MASK               (BIT_4 | BIT_5)
#define QLMAPI_FW_HW_CFG_FORCE_MAX_PCI_RETRY         BIT_6
#define QLMAPI_FW_HW_CFG_MAX_PCI_RETRY_MASK          (BIT_7 | BIT_8 | BIT_9)
#define QLMAPI_FW_HW_CFG_DUAL_MAC_MODE_MASK          (BIT_10 | BIT_11)
#define QLMAPI_FW_HW_CFG_REVERSE_WAY                 BIT_12
#define QLMAPI_FW_HW_CFG_MINI_PCI                    BIT_13
#define QLMAPI_FW_HW_CFG_AUTO_POWERDOWN              BIT_14
#define QLMAPI_FW_HW_CFG_EXT_LED_MODE_MASK           (BIT_15 | BIT_16)
#define QLMAPI_FW_HW_CFG_CAPACITIVE_COUPLING         BIT_17
#define QLMAPI_FW_HW_CFG_TXSERDES_OVERRIDE           BIT_18
#define QLMAPI_FW_HW_CFG_L0s_PERFORMANCE_FIX_EN      BIT_19

#define QLMAPI_FW_CAPACITIVE_COUPLING                QLMAPI_FW_HW_CFG_CAPACITIVE_COUPLING



typedef union _QL_FW_NIC_HW_CONFIG
{
    struct
    {
#if defined(BIG_ENDIAN) && !defined(BCM_LITTLE_ENDIAN_HOST)
        U32 reserved                :13;    /* bit 19      */ /* used to be ASPM_L1,ASPM_L0 and clkreq at bit 21, 20 and 19 */
        U32 txSerdesOverride        :1;     /* bit 18      */
        U32 capacitive_coupling     :1;     /* bit 17      */
        U32 shasta_ext_led_mode     :2;     /* bit 15,16   */
        U32 enable_auto_powerdown   :1;     /* bit 14      */
        U32 mini_pci                :1;     /* bit 13      */
        U32 reverse_nway            :1;     /* bit 12      */
        U32 dual_mac_mode           :2;     /* bit 10:11   */
        U32 max_pci_retry           :3;     /* bit 7:9     */
        U32 forced_max_pci_retry    :1;     /* bit 6       */
        U32 phy_type                :2;     /* bit 4:5     */
        U32 phy_led_mode            :2;     /* bit 2:3     */
        U32 voltage_source          :2;     /* bit 0:1     */
#else
        U32 voltage_source          :2;     /* bit 0:1     */
        U32 phy_led_mode            :2;     /* bit 2:3     */
        U32 phy_type                :2;     /* bit 4:5     */
        U32 forced_max_pci_retry    :1;     /* bit 6       */
        U32 max_pci_retry           :3;     /* bit 7:9     */
        U32 dual_mac_mode           :2;     /* bit 10:11   */
        U32 reverse_nway            :1;     /* bit 12      */
        U32 mini_pci                :1;     /* bit 13      */
        U32 enable_auto_powerdown   :1;     /* bit 14      */
        U32 shasta_ext_led_mode     :2;     /* bit 15,16   */
        U32 capacitive_coupling     :1;     /* bit 17      */
        U32 txSerdesOverride        :1;     /* bit 18      */
        U32 reserved                :13;    /* bit 19      */ /* used to be ASPM_L1,ASPM_L0 and clkreq at bit 21, 20 and 19 */
#endif
    } bit;

    U32     word;
} QL_FW_NIC_HW_CONFIG;



typedef union _QL_NIC_SHARED_CONFIG
{
    struct
    {
#if defined(BIG_ENDIAN) && !defined(BCM_LITTLE_ENDIAN_HOST)
        U32 reserved: 4;            /* bit 28:31 */
        U32 TPH_features: 2;        /* bit 26:27 */
        U32 LTR_enable: 1;          /* bit 25 */
        U32 compliance_mode: 1;     /* bit 24 */
        U32 aux_1g_support:1;       /* bit 23 */
        U32 link_flap_avoidance:1;  /* bit 22 */
        U32 MC_SI_SMBus_Speed:1;    /* bit 21 {100(0),400(1)khz}    */
        U32 NC_SI_BMC_con_method:1; /* bit 20 {RMII(0), SMBus(1)}  */
        U32 NC_SI_package_ID : 2;   /* bit 18:19 */
        U32 NC_SI_Package_ID_Method: 1; /* bit 17 */
        U32 gpio2_output_value:1;   /* bit 16 */
        U32 reserved_15:1;          /* bit 15 -- reserved */
        U32 gpio0_output_value:1;   /* bit 14 */
        U32 gpio2_output_enable:1;  /* bit 13 */
        U32 reserved_12:1;          /* bit 12 -- reserved */
        U32 gpio0_output_enable:1;  /* bit 11 */
        U32 reserved_7_10:4;        /* bit 7:10 -- reserved */
        U32 HotPlugPwrBdgtCnt:3;    /* bit 4:6 */
        U32 DisablePowerSaving:1;   /* bit 3 */
        U32 FiberWoLCapable:1;      /* bit 2 */
        U32 L1ASPM_Debounce_En:1;   /* bit 1 it was BothPort100MbpsCapable, now become L1ASPM_Debounce_En*/
        U32 portSwap:1;             /* bit 0 */
#else
        U32 portSwap:1;             /* bit 0 */
        U32 L1ASPM_Debounce_En:1;   /* bit 1 it was BothPort100MbpsCapable, now become L1ASPM_Debounce_En*/
        U32 FiberWoLCapable:1;      /* bit 2 */
        U32 DisablePowerSaving:1;   /* bit 3 */
        U32 HotPlugPwrBdgtCnt:3;    /* bit 4:6 */
        U32 reserved_7_10:4;        /* bit 7:10 -- reserved */
        U32 gpio0_output_enable:1;  /* bit 11 */
        U32 reserved_12:1;          /* bit 12 -- reserved */
        U32 gpio2_output_enable:1;  /* bit 13 */
        U32 gpio0_output_value:1;   /* bit 14 */
        U32 reserved_15:1;          /* bit 15 -- reserved */
        U32 gpio2_output_value:1;   /* bit 16 */
        U32 NC_SI_Package_ID_Method: 1; /* bit 17 */
        U32 NC_SI_package_ID : 2;   /* bit 18:19 */
        U32 NC_SI_BMC_con_method:1; /* bit 20 {RMII(0), SMBus(1)}  */
        U32 MC_SI_SMBus_Speed:1;    /* bit 21 {100(0),400(1)khz}    */
        U32 link_flap_avoidance:1;  /* bit 22 */
        U32 aux_1g_support:1;       /* bit 23 */
        U32 compliance_mode: 1;     /* bit 24 */
        U32 LTR_enable: 1;          /* bit 25 */
        U32 TPH_features: 2;        /* bit 26:27 */
        U32 reserved: 4;            /* bit 28:31 */
#endif
    } bit;

    U32 word;
} QL_NIC_SHARED_CONFIG;

#define QLMAPI_FW_SH_CFG_HOTPLUG_PWRBDGT_CNT_MASK    0x00000070
#define QLMAPI_FW_SH_CFG_DIS_PW_SAVING               BIT_3
#define QLMAPI_FW_SH_CFG_GPIO_MASK                   0x16800



typedef struct _QL_FW_MEDIA_MANUFACT_REGION
{
    // Version format of this data structure
    U8                      manuf_format_rev;

    // Checksum of directory section. When this byte 
    // is zero, the checksum is not calculated.  When  
    // this byte is non-zero, adding all bytes from 0x14-0x73 
    // and this byte should be zero.
    U8                      dir_cksum;

    // length of this structure in bytes
    U16                     length;

    // formerly, it was PHY ID of physical device, no longer in use since 5/1/03
    U32                     reserved2;

    // MAC address
    U8                      mac_address[8];

    // part number. Printable string ending in '\0'.
    U8                      part_number[16];

    // part revision. Two printable ascii char.
    U8                      part_revision[2];

    // single byte acending rev number
    // Lower byte is major version number. (Little-Endian)
    // Higher byte is minor version number. (Little-Endian)
    U16                     bootcode_fw_revision;

    // ascii manufact date, wwyy, \0 by next field
    U8                      manuf_data[4];

    // VLAN ID used in Multiple Boot Agent - Port 1
    U16                     mba_vlan_id;

    // VLAN ID used in Multiple Boot Agent - Port 2
    U16                     mba_vlan_id_b;

    // pci device id
    U16                     pci_dev_id;

    // pci vendor id
    U16                     pci_vend_id;

    // alternate pci subsystem id
    U16                     pci_sub_id;

    // alternate pci subsystem vendor id
    U16                     pci_sub_vend_id;

    // cpu clock speed in Mhz rounded
    U16                     cpu_clk;

    // Port 1 smbus address
    U8                      smbus_addr1;

    // Port 0 smbus address
    U8                      smbus_addr0;

    // Backup permanent MAC address of port 1
    U8                      backup_mac_address[8];

    // Backup permanent MAC address of port 2
    U8                      backup_mac_addressb[8];

    U8                      power_dissipated[4];
    U8                      power_consumed[4];  

    QL_FW_FEATURE_CONFIG    feature_config;

    QL_FW_NIC_HW_CONFIG     hw_config;

    // Second MAC address for second channel in BCM5704
    U8                      mac_addressb[8];

    // second MAC feature_config
    QL_FW_FEATURE_CONFIG    feature_configb;

    // second MAC hw_config
    QL_FW_NIC_HW_CONFIG     hw_configb;

    QL_NIC_SHARED_CONFIG    shared_config;

    U32                     Power_Budget0;
    U32                     Power_Budget1;

    U32                     serworks_use;

    /* Primary MAC Serdes 0:15 override value */
    U16                     mac0_txSerdes_value;

    /* Secondary MAC Serdes 0:15 override value */
    U16                     mac1_txSerdes_value;

    /* size in k (2^10). value 0 = unknown */
    U16                     tpm_nvram_size;

    /* size in k (2^10). value 0 = unknown */
    U16                     mac_nvram_size;

    U32                     Power_Budget2;
    U32                     Power_Budget3;

    // 32-bit CRC
    U32                     cksum;

} QL_FW_MEDIA_MANUFACT_REGION;


#define QLMAPI_FW_MAX_VPD_R_LENGTH           128
#define QLMAPI_FW_MAX_VPD_W_LENGTH           128

typedef struct _QL_FW_MEDIA_VPD_READ
{
    U8  data[QLMAPI_FW_MAX_VPD_R_LENGTH];
} QL_FW_MEDIA_VPD_READ;


typedef struct _QL_FW_MEDIA_VPD_WRITE
{
    U8  data[QLMAPI_FW_MAX_VPD_W_LENGTH];
} QL_FW_MEDIA_VPD_WRITE;


typedef struct _QL_FW_MEDIA_VPD
{
    QL_FW_MEDIA_VPD_READ    vpd_r;
    QL_FW_MEDIA_VPD_WRITE   vpd_w;
} QL_FW_MEDIA_VPD;



typedef struct _QL_FW_EEPROM_INFO
{
    QL_FW_MEDIA_BOOTSTRAP_REGION    bootstrap;
    QL_FW_MEDIA_CODE_OFFSET_REGION  code_offsets[QLMAPI_FW_MEDIA_MAX_LOAD_STAGES];
    QL_FW_MEDIA_MANUFACT_REGION     manufact;
    QL_FW_MEDIA_VPD                 vpd;

} QL_FW_EEPROM_INFO;


#define QLMAPI_FW_INFO_VER   11

typedef struct _QL_FW_INFO
{
    //  Version is defined as QLMAPI_FW_INFO_VER.
    //  'version' is required upon input
    U32                 version;

    // On Linux, perm mac address can be retrieved by 
    // QLmapiGetBRCMNicInfoEx() or by bQLmapiGetPhyNic().
    // 1. Not valid if the NIC is set for selfboot.
    // Use 'is_selfboot' to find out the NIC selfboot or not.
    // 2. If 'has_extended_vpd' is true, do not use 'vpd' filed in
    //    'eeprom_info'. Use new API to get VPD.
    // 3. In near future, 'bootstrap', 'code_offsets' and 'manufact' in
    //    'QL_FW_EEPROM_INFO' will obsolete and not available.
    QL_FW_EEPROM_INFO   eeprom_info;

    // Boot code version description string.
    U8                  firmware_ver_desc[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // PXE version description string.
    // Not valid if the NIC is set for selfboot.
    // Use 'is_selfboot' to find out the NIC selfboot or not.
    U8                  pxe_ver_desc[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // Boolean flag to indicate whether the NIC is SW selfboot or not.
    U32                 is_selfboot;

    // '0' for SW selfboot format 0, '1' for SW selfboot format 1, etc.
    // Not valid if the NIC is NOT selfboot.
    U32                 selfboot_format;

    // iSCSI versions.
    U8                  iscsi[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  iscsi_cprg[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // Boolean flag to indicate whether the NIC is HW selfboot or not.
    U32                 is_hw_selfboot;

    // Management FW version. Can be ASF, IPMI, UMP, NCSI, DASH, etc.
    // Use 'flags' to determine which one it is.
    U8                  mgmt_ver[QLMAPI_FW_MAX_DESCRIPTION_LEN];

#define QL_MGMT_ASF             0x00000001  // ASF Management Firmware
#define QL_MGMT_ASF_2_0         0x00000002  // ASF Management Firmware with ASF 2.0 support
#define QL_MGMT_IPMI            0x00000004  // IPMI Management Firmware
#define QL_MGMT_UMP             0x00000008  // UMP Management Firmware
#define QL_MGMT_DASH            0x00000010  // DASH Management Firmware
#define QL_MGMT_NCSI            0x00000020  // NCSI Management Firmware
#define QL_MGMT_SMASH           0x00000040  // SMASH Management Firmware
    U32                 flags;

    // Boolean flag to indicate whether the NIC is OTP selfboot or not.
    U32                 is_otp_selfboot;

    // If extended VPD exist, do not use 'vpd' filed in 'eeprom_info'.
    // Use new API to get VPD.
    U32                 has_extended_vpd;

    // EFI versions.
    U8                  efi_x86[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  efi_ipf[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  efi_ebc[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  efi_x64[QLMAPI_FW_MAX_DESCRIPTION_LEN];

#define QLMAPI_VF_MBA_SUPPORT    0x2000  /* Indicate that this image support MBA */
    U32                 MbaVendorFlags;

#define QLMAPI_iSCSI_BOOT_IPV4       0x0001
#define QLMAPI_iSCSI_BOOT_IPV6       0x0002
    U32                 iscsi_boot_flags;

    U8                  iscsib_cfg[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  iscsib_cfg2[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  iscsib_cfg3[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  iscsib_cfg4[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // New MBA/PXE version string.
    U8                  mba_ver[QLMAPI_FW_MAX_DESCRIPTION_LEN*2];

    // Fcode versions.
    U8                  fcode[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // CCM version
    U8                  ccm[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // Management FW version (not active). Can be NCSI, DASH, etc.
    U8                  mgmt_ver_na[QLMAPI_FW_MAX_DESCRIPTION_LEN];

} QL_FW_INFO;


#define QLMAPI_FW_INFO_5706_VER      9

typedef struct _QL_FW_INFO_5706
{
    //  Version is defined as QLMAPI_FW_INFO_5706_VER.
    //  'version' is required upon input
    U32                 version;

    // Boot code version string.
    U8                  bc1_ver[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  bc2_ver[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // MBA/PXE version string.
    U8                  pxe_ver[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // L2RXP version string.
    U8                  l2rxp_ver[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // UMP version string.
    U8                  ump_ver[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // IPMI versions.
    U8                  ipmi_cfg[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  ipmi_init[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  ipmi_serv[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // iSCSI versions.
    U8                  iscsi[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  iscsi_cprg[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // NCSI versions.
    U8                  ncsi_common[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  ncsi_lib5706[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // VPD data
    QL_FW_MEDIA_VPD     vpd;

    // iSCSI cfg versions.
    U8                  iscsib_cfg[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  iscsib_cfg2[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // If extended VPD exist, do not use 'vpd' filed.
    // Use new API to get VPD.
    U32                 has_extended_vpd;

    // New MBA/PXE version string.
    U8                  mba_ver[QLMAPI_FW_MAX_DESCRIPTION_LEN*2];

    // Fcode versions.
    U8                  fcode[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // EFI versions.
    U8                  efi_x86[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  efi_ipf[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  efi_ebc[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  efi_x64[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // Same definition in QL_FW_INFO
    U32                 MbaVendorFlags;

    // Same definition in QL_FW_INFO
    U32                 iscsi_boot_flags;

    U8                  ccm[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    // Backup permanent MAC address of port 1
    U8                  backup_mac_address[8];
} QL_FW_INFO_5706;



#define QLMAPI_FW_INFO_57710_VER      9

typedef struct _QL_FW_INFO_57710
{
    //  Version is defined as QLMAPI_FW_INFO_57710_VER.
    //  'version' is required upon input
    U32                 version;

    // Boot code version string.
    U8                  bc1_ver[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  bc2_ver[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // MBA/PXE version string.
    U8                  pxe_ver[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // UMP version string.
    U8                  ump_ver[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // IPMI versions.
    U8                  ipmi_ver[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // iSCSI versions.
    U8                  iscsib[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  iscsi_cprg[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  iscsib_cfg[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  iscsib_cfg2[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // NCSI versions. This is the lib version for 57710 (as ncsi_lib5706
    // for 5706).
    U8                  ncsi_ver[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // TSTORM versions.
    U8                  l2t_ver[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // CSTORM versions.
    U8                  l2c_ver[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // XSTORM versions.
    U8                  l2x_ver[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // USTORM versions.
    U8                  l2u_ver[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // VPD data
    QL_FW_MEDIA_VPD     vpd;

    // External PHY version.
    U8                  ext_phy_fw_ver[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // NCSI versions.
    U8                  ncsi_common[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // FCoE versions.
    U8                  fcoe_boot[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  fcoe_cprg[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  fcoe_cfg[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  fcoe_cfg2[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // If extended VPD exist, do not use 'vpd' filed.
    // Use new API to get VPD.
    U32                 has_extended_vpd;

    // New MBA/PXE version string.
    U8                  mba_ver[QLMAPI_FW_MAX_DESCRIPTION_LEN*2];

    // Fcode versions.
    U8                  fcode[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // EFI versions.
    U8                  efi_x86[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  efi_ipf[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  efi_ebc[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  efi_x64[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // Same definition in QL_FW_INFO
    U32                 MbaVendorFlags;

    U8                  iscsib_cfg3[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  iscsib_cfg4[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  fcoe_cfg3[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  fcoe_cfg4[QLMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  ccm[QLMAPI_FW_MAX_DESCRIPTION_LEN];

    // Same definition in QL_FW_INFO
    U32                 iscsi_boot_flags;
    // Backup permanent MAC address of port 1
    U8                  backup_mac_address[8];

} QL_FW_INFO_57710;



/****************************************************************************
 * 
 *                              ATTENTION
 *
 * Multi-byte fields in QLMAPI_LICENSE_INFO such as 'capability',
 * 'max_toe_conn', 'sn', etc. are in BIG_ENDIAN order. For LITTLE-ENDIAN
 * macine such as 'x86' processor, the bytes for the multi-byte data fields
 * MUST be swapped.
 ****************************************************************************/
// 'key_index' for QLmapiGetLicenseKey() and QLmapiSetLicenseKey().
#define QLMAPI_LICENSE_KEY_IDX_ACTIVE            0   // The key that is currently used by firmware
#define QLMAPI_LICENSE_KEY_IDX_MANUFAC           1
#define QLMAPI_LICENSE_KEY_IDX_UPGRADE           2

typedef struct
{
#define QLMAPI_LICENSE_KEY_TYPE_ENUM_BCM5706     0x0
#define QLMAPI_LICENSE_KEY_TYPE_ENUM_BCM57710    0x2
      U8      key_type;

#define QLMAPI_LICENSE_INFO_VER                  1
      U8      version;

      U8      dword_length;     /* Not including the digest */

#define QLMAPI_LICENSE_OEM_ID_BRCM               0
      U8      oem_id;

#define QLMAPI_LICENSE_CAP_USER_RDMA             0x0002  /* BCM5706 only */
#define QLMAPI_LICENSE_CAP_TOE                   0x0004  /* BCM5706 only */
#define QLMAPI_LICENSE_CAP_ISCSI_INIT            0x0008  /* BCM5706 only */
#define QLMAPI_LICENSE_CAP_ISCSI_TRGT            0x0010  /* BCM5706 only */
#define QLMAPI_LICENSE_CAP_ISER_INIT             0x0020  /* BCM5706 only */
#define QLMAPI_LICENSE_CAP_ISER_TRGT             0x0040  /* BCM5706 only */
#define QLMAPI_LICENSE_CAP_ISCSI_BOOT            0x0080  /* BCM5706 only */
#define QLMAPI_LICENSE_CAP_ISCSI_FULL_ACCL       0x0100  /* BCM5706 only */
#define QLMAPI_LICENSE_CAP_ISCSI_HDR_DGST        0x0200  /* BCM5706 only */
#define QLMAPI_LICENSE_CAP_ISCSI_BODY_DGST       0x0400  /* BCM5706 only */
#define QLMAPI_LICENSE_CAP_SERDES_2_5G           0x0800  /* BCM5706 only */
#define QLMAPI_LICENSE_CAP_SPEED_RSVD            0x0800  /* BCM57710 Only */
#define QLMAPI_LICENSE_CAP_FCOE_INIT             0x1000  /* BCM57710 Only */
#define QLMAPI_LICENSE_CAP_FCOE_TRGT             0x2000  /* BCM57710 Only */
      U16     capability;

#define QLMAPI_LICENSE_CONN_UNLIMITED            0xffff
      U16     max_toe_conn;

      U16     reserved;
      U16     max_um_rdma_conn;
      U16     max_iscsi_init_conn;
      U16     max_iscsi_trgt_conn;
      U16     max_iser_init_conn;
      U16     max_iser_trgt_conn;
      U16     max_fcoe_init_conn;
      U16     max_fcoe_trgt_conn;

      U32     reserved_a[2];
      U32     sn;
      U16     reserved_b;

#define QLMAPI_LICENSE_EXP_NEVER                 0xffff
      U16     expiration;

} QLMAPI_LICENSE_INFO;



#define QLMAPI_RES_CFG_VER         3

typedef struct
{
    // Version is defined as QLMAPI_RES_CFG_VER.
    // 'version' is required upon input
    // All application MUST use verison 2 or later structure.
    U32 version;

#define QLMAPI_RES_RES_CFG_VALID                 0x01        // for QLMAPI_BRCM5706 only
#define QLMAPI_RES_CFG_L2                        0x04
#define QLMAPI_RES_CFG_ISCSI                     0x08
#define QLMAPI_RES_CFG_RDMA                      0x10
#define QLMAPI_RES_CFG_FCOE                      0x20
#define QLMAPI_RES_CFG_FCFS_DISABLED             0x80000000L // for QLMAPI_BRCM5706 only
    // The 'cfg' is to dictate which child nodes driver is configured to
    // (when getting) or will (when setting) enumerate.
    U32 cfg;

    // When IPV6 is set, the # of connections meant for IPV6.
    // If it is clear, the number meant for IPV4. This is for
    // 'QLMAPI_BRCM5706' only.
#define QLMAPI_RES_RES_CFG_TOE_IPV6              (0x1 << 0)  // for QLMAPI_BRCM5706 only
#define QLMAPI_RES_RES_CFG_ISCSI_IPV6            (0x1 << 1)  // for QLMAPI_BRCM5706 only
    U32 flags;

    U32 reserved1;
    U32 reserved2;

    // For QLMAPI_BRCM5706 and QLMAPI_BRCM57710
    U32 toe_licensed_con;       // number of licensed TOE connections

    // For QLMAPI_BRCM5706
    U32 toe_reserved_con;       // number of reserved TOE connections

    U32 reserved3;
    U32 reserved4;

    // For QLMAPI_BRCM5706 and QLMAPI_BRCM57710
    U32 rdma_licensed_con;      // number of licensed RDMA connections

    // For QLMAPI_BRCM5706
    U32 rdma_reserved_con;      // number of reserved RDMA connections

    U32 reserved5;
    U32 reserved6;

    // For QLMAPI_BRCM5706 and QLMAPI_BRCM57710
    U32 iscsi_licensed_con;     // number of licensed iSCSI connections

    // For QLMAPI_BRCM5706
    U32 iscsi_reserved_con;     // number of reserved iSCSI connections

    U32 reserved7;
    U32 reserved8;

    // For QLMAPI_BRCM5706 and QLMAPI_BRCM57710
    U32 iser_licensed_con;      // number of licensed iSER connections

    // For QLMAPI_BRCM5706
    U32 iser_reserved_con;      // number of reserved iSER connections

    // For QLMAPI_BRCM5706 and QLMAPI_BRCM57710
    U32 iscsi_pend_task;        // iSCSI pending tasks per connection
                                // QLMAPI_BRCM5706: range from 32 to 2048
                                // QLMAPI_BRCM57710: range from 64 to 2048
                                // It should be power of 2.

    //////////////////////////
    // For QLMAPI_BRCM57710 ONLY
    U32 ring_size;
    U32 max_toe_cons;
    U32 max_rdma_cons;          // Not supported currently
    U32 max_iscsi_cons;

    U32 toe_cons_limit;

    U32 toe_rss_possible;

    U32 fcoe_init_licensed_con; // number of licensed FCoE connections
    U32 max_fcoe_cons;
    U32 fcoe_pend_task;

    // FCoE must be enumerated already in order to configure this.
    U32 fcoe_pend_task_sess;    // Max pending task per session

    // For QLmapilnx, only prevent_fcoe, prevent_iscsi, and storage_enum
    // are supported for QL_RES_CFG.
    // Act as if the FCoE license is invalid
    // boolean value, read only
    U32 prevent_fcoe;

    // Act as if the iSCSI license is invalid
    // boolean value, read only
    U32 prevent_iscsi;

    // Storage personality enumeration for SF mode only.
    // Any bits that are undefiend will be ignored.
#define QLMAPI_RES_CFG_NVM_ENUM_NONE     0       // 0: VBD will use registry
                                                // value for enumeration
#define QLMAPI_RES_CFG_NVM_ENUM_FCOE     0x01    // enumerate FCoE
#define QLMAPI_RES_CFG_NVM_ENUM_ISCSI    0x02    // enumerate iSCSI
    U32 storage_enum;

    //////////////////////////

} QL_RES_CFG;



#define QLMAPI_OFLD_STACK_INFO_NDIS  0
#define QLMAPI_OFLD_STACK_INFO_ISCSI 2
#define QLMAPI_OFLD_STACK_INFO_WSD   3

#define QLMAPI_OFLD_STACK_INFO_VER   1

typedef struct
{
    //  Version is defined as QLMAPI_OFLD_STACK_INFO_VER.
    //  'version' is required upon input
    U32 version;

    // the numbers of connections offloaded and connections being offloaded
    // but not completed yet
    U32 tcp_list_cnt;

    U32 reserved[18];

} QLMAPI_OFLD_STACK_INFO;



#define QLMAPI_ISCSI_CONFIG_VER      1

typedef struct
{
    //  Version is defined as QLMAPI_ISCSI_CONFIG_VER.
    //  'version' is required on input
    U32 version;

    // 1 to enable DHCP for IPv4, 0 for static IP settings.
    // When DHCP is in use, 'LocalIpv4', 'SubnetMaskIpv4' and
    // 'DefaultGatewayIpv4' will be ignored.
    U32 EnableDHCPIpv4;

    // IPv4 configuration
    U32 LocalIpv4;
    U32 SubnetMaskIpv4;
    U32 DefaultGatewayIpv4;

    U32 VlanID;

    // Process Router Advertisements (BOOLEAN)
    U32 bProcRouteAd;

    // DHCPv6 (BOOLEAN)
    U32 bEnableDHCPIpv6;

    U32 mtu;

} QLMAPI_ISCSI_CONFIG;



typedef struct
{
    U8  ipv6[16];
    U32 prefixlen;
} QL_ISCIS_IPV6_ADDR;

#ifndef MAX_PATH
#define MAX_PATH       256 // same value in internal.h
#endif

#define QLMAPI_ISCSI_CONFIG_LNX_VER      1

typedef struct
{
	U32         		version;
	char				iFaceFileName[MAX_PATH];
	char				InitiatorName[MAX_PATH];

#define QLMAPI_ISCSI_DHCP		 0x01
#define QLMAPI_ISCSI_STATIC		 0x02
#define QLMAPI_ISCSI_UNSPECIFIED  	 0x03
    U32					IPCategory; /*DHCP or STATIC or UNSPECIFIED*/
    U32        			isIPv4;     /*1 if IPv4, 0 if IPv6*/
    U32         		VLAN_ID;
    U32         		IFACE_NUM;
    U32					IPv4Address;
    U32		        	IPv4SubnetMask;
    U32					IPv4DefaultGateway;
    QL_ISCIS_IPV6_ADDR	IPv6Address;
    QL_ISCIS_IPV6_ADDR	IPv6Gateway;

   
    // This field is used only when calling QLmapiSetiSCSIConfig2. 
    // During the set operation, it has to be notified whether the
    // iFACE File needs to created, deleted or updated.
	// ModifiedState should be set to QLMAPI_ISCSI_IFACE_FILE_NOT_UPDATED
	// if iFACE file is not updated or deleted ot creadted

#define QLMAPI_ISCSI_IFACE_FILE_NOT_UPDATED		0x01
#define QLMAPI_ISCSI_IFACE_FILE_UPDATED			0x02
#define QLMAPI_ISCSI_IFACE_FILE_CREATED			0x03
#define QLMAPI_ISCSI_IFACE_FILE_DELETED			0x04
	U32				ModifiedState; //Updated/Created/Deleted/NotUpdated


#define QLMAPI_ISCSI_FAIL                        1
#define QLMAPI_ISCSI_NEED_LOGOUT                 2
#define QLMAPI_ISCSI_NEED_RELOGIN                3

	// errCode is a return value for the call QLmapiSetiSCSIConfig2.
	// After QLmapiSetiSCSIConfig2 returns, errCode should be checked 
	// for each iFACE File.
	// An error can occur while updating/deleting the iFACE File.
    // errCode is set with an error number for the coreccponsding iFACE file.
    // If there is no error, then errCode is set to 0 (Zero) 
    // The caller has to check the errCode after the API returns.
    U32				errCode;  

} QLMAPI_ISCSI_CONFIG_LNX  ;


typedef struct
{
    // handle to an iSCSI node.
    // Must be privided on input.
    U32 handle;

    U32 uNumOfIPV4;
    U32 uNumOfIPV6;

    // Return code for this structure.
    // Applications must check QLmapiGetISCSIRuntimeIPCount() to be QLMAPI_OK
    // before using 'return_code' from each individual structure.
    U32 return_code;

} QL_ISCSI_IP_COUNT;



#define QL_ISCSI_IPV4_RT_VER        1

typedef struct
{
    //  Version is defined as QL_ISCSI_IPV4_RT_VER.
    //  'version' is required upon input
    U32 version;

    // handle to an iSCSI node.
    U32 handle;

    // 'flags' should set to '0' on input.
#define QLMAPI_ISCSI_IPV4_ADDR_INIT      0x0001          // IPv4 address has been initialized
#define QLMAPI_ISCSI_IPV4_ADDR_VALID     0x0002          // IPv4 address is valid
#define QLMAPI_ISCSI_IPV4_HBA_BOOT       0x0004          // HBA boot through 'this' IPV4 address
    U32 flags;

    // This conains the binary IPv4 ip address
    U32 IpV4Address;

    // TRUE if the adapter should use DHCP to discovery its IP address
    // information.
    U32 EnableDHCP;

    // Static Default Gateway IP address
    U32 DefaultGateway;

    // Static Subnet Mask
    U32 SubnetMask;

    // Return code for this structure.
    // Applications must check QLmapiRetrieveMultiLinkStatus() to be QLMAPI_OK
    // before using 'return_code' from each individual structure.
    U32 return_code;

} QL_ISCSI_IPV4_RT;



#define QL_ISCSI_IPV6_RT_VER        1

typedef struct
{
    //  Version is defined as QL_ISCSI_IPV6_RT_VER.
    //  'version' is required upon input
    U32 version;

    // handle to an iSCSI node.
    U32 handle;

    // TRUE if the adapter should use an autogenerated and non routable
    // (link local) address as its IP address.
    U32 UseLinkLocalAddress;

    // 'flags' should set to '0' on input.
#define QLMAPI_ISCSI_IPV6_ADDR_INIT      0x0001          // IPv6 struct init happened
#define QLMAPI_ISCSI_IPV6_ADDR_VALID     0x0002          // IPv6 address is valid
#define QLMAPI_ISCSI_IPV6_GTW_VALID      0x0004          // IPv6 gateway is valid
#define QLMAPI_ISCSI_IPV6_MASK_VALID     0x0008          // IPv6 subnet mask is valid
#define QLMAPI_ISCSI_IPV6_HBA_BOOT       0x0010          // HBA boot through 'this' IPV6 address
    U32 flags;

    // TRUE if the adapter should use DHCP to discovery its IP address
    // information.
    U32 EnableDHCP;

    // IPv6 address of the adapter
    U8  IpV6Address[16];

    // IPV6 flow information
    U32 FlowInfo;

    // IPV6 scope id
    U32 ScopeId;

    // Static Default Gateway IP address
    U8  DefaultGateway[16];

    // Static Subnet Mask
    U8  SubnetMask[16];

    // Return code for this structure.
    // Applications must check QLmapiRetrieveMultiLinkStatus() to be QLMAPI_OK
    // before using 'return_code' from each individual structure.
    U32 return_code;

} QL_ISCSI_IPV6_RT;



#define QL_ISCSI_STATS_VER        1

typedef struct
{
    //  Version is defined as QL_ISCSI_STATS_VER.
    //  'version' is required upon input
    U32 version;

    // handle to an iSCSI node.
    U32 handle;

    // Unique Adapter Id
    U64 UniqueAdapterId;

    // Number of sessions
    U32 SessionCount;

    ////////////////////////////////////
    //////Initiator Login Statistics////
    ////////////////////////////////////
    // Count of Login Accept Responses
    U32 LoginAcceptRsps;

    // Count of Login other failed Responses
    U32 LoginOtherFailRsps;

    // Count of Login Redirect Responses
    U32 LoginRedirectRsps;

    // Count of Login Authentication Failed Responses
    U32 LoginAuthFailRsps;

    // Count of the number of times a login is aborted 
    // due to a target authentication failure
    U32 LoginAuthenticateFails;

    // Count of the number of times login failed due 
    // to negotiation failure with target
    U32 LoginNegotiateFails;

    // Count of Logout command PDU with reason code 0
    U32 LogoutNormals;

    // Count of Logout command PDUs with status code other than 0
    U32 LogoutOtherCodes;

    // The object counts the number of times a login 
    // attempt from this local initiator has failed
    U32 LoginFailures;

    /////////////////////////////////////////
    //////Initiator Instance Statistics//////
    /////////////////////////////////////////
    // Count of Session digest errors
    U32 SessionDigestErrorCount;

    // Count of Session connection timeout error
    U32 SessionConnectionTimeoutErrorCount;

    // Count of Session format error
    U32 SessionFormatErrorCount;

    // Number of Sessions failed belonging to this instance
    U32 SessionFailureCount;

    // Return code for this structure.
    // Applications must check QLmapiGetISCSIRuntimeStatistics() to be QLMAPI_OK
    // before using 'return_code' from each individual structure.
    U32 return_code;

} QL_ISCSI_STATS;



#define QL_ISCSI_SESSION_STATS_VER        1

typedef struct
{
    //  Version is defined as QL_ISCSI_SESSION_STATS_VER.
    //  'version' is required upon input
    U32 version;

    // Unique Adapter Id
    // Must be filled on input. It is available from 'QL_ISCSI_STATS'.
    U64 UniqueAdapterId;

#define QLMAPI_ISCSI_STATS_SESSION_ID        0x00000001  // Request to fill SessionId
#define QLMAPI_ISCSI_STATS_SESSION_NAME_LEN  0x00000002  // Request to fill Session Name Length
#define QLMAPI_ISCSI_STATS_SESSION_NAME      0x00000004  // Request to fill Session Name
#define QLMAPI_ISCSI_STATS_SESSION_STATS     0x00000008  // Request to fill Session Stats
#define QLMAPI_ISCSI_STATS_SESSION_ID_DONE   0x00000010  // Session ID is retrieved
    U32 flags;

    // Unique Session Id
    // If 'QLMAPI_ISCSI_STATS_SESSION_ID' is not set on input, BMAPI expects
    // caller will provide the 'SessionId' as input and BMAPI will use
    // 'SessionId' to find and collect information.
    U64 SessionId;

    // Unique Session Name
    U8 *pSessionName;

    // Unique Session Name Length
    U32 SessionNameLength;
    
    //////////////////////////////
    //////Session Statistics//////
    //////////////////////////////
    // Number of bytes sent over this session
    U64 BytesSent;

    // Number of bytes received over this session
    U64 BytesReceived;

    // Number of PDU sent over this session
    U64 PDUCommandsSent;

    // Number of PDU received over this session
    U64 PDUResponsesReceived;

    // Count of Number of Digest errors occured in this session
    U64 DigestErrors;

    // Count of Number of ConnectionTimeout errors occured in this session
    U64 ConnectionTimeoutErrors;

    // Count of Number of Format errors occured in this session
    U64 FormatErrors;

    // Return code for this structure.
    // Applications must check QLmapiGetISCSISessionStatistics() to be QLMAPI_OK
    // before using 'return_code' from each individual structure.
    U32 return_code;

} QL_ISCSI_SESSION_STATS;



// Management processors definition for QLmapiGetMgmtProcessors()
#define QLMAPI_MGMT_PROC_NONE        0           // no management FW support
#define QLMAPI_MGMT_PROC_RXCPU       0x00000001
#define QLMAPI_MGMT_PROC_TXCPU       0x00000002
#define QLMAPI_MGMT_PROC_APE         0x00000004


//
// LLDP parameters.
//
#define QLMAPI_DCBX_CONFIG_INV_VALUE     (0xFFFFFFFF)

enum
{
    QLMAPI_LLDP_OVERWRITE_SETTINGS_DISABLE  = 0,
    QLMAPI_LLDP_OVERWRITE_SETTINGS_ENABLE   = 1,
    QLMAPI_LLDP_OVERWRITE_SETTINGS_INVALID  = QLMAPI_DCBX_CONFIG_INV_VALUE
};

typedef struct
{
    // Indicates if to use the default NVRAM LLDP settings or to overwrite
    // them by other configurable settings. Default = No.
    U32 overwrite_settings;

    // Defines txTTL = MIN(msg_tx_hold * msg_tx_interva, 65535). Default = 4.
    U32 msg_tx_hold;

    // Timer interval in seconds between transmissions in fast transmission
    // mode. Default = 1.
    U32 msg_fast_tx;

    // The maximum of LLDPDU that can be transmitted consecutively.
    // Default = 5
    U32 tx_credit_max; 

    // Timer interval in seconds between transmissions. Default = 30.
    U32 msg_tx_interval;

    // Determines how many intervals shall take place during fast transmission
    // mode. Default = 4
    U32 tx_fast;

    U32 reserve[20];

} QL_LLDP_CFG_PARAMS;



#define QL_LLDP_PARAMS_VER  2

typedef struct
{
    //  Version is defined as QL_LLDP_PARAMS_VER.
    //  'version' is required upon input
    U32 version;

    QL_LLDP_CFG_PARAMS  cfg;

    // Enumeration defined as following.
#define QLMAPI_LLDP_TX_ONLY  0x01
#define QLMAPI_LLDP_RX_ONLY  0x02
#define QLMAPI_LLDP_TX_RX    0x03
#define QLMAPI_LLDP_DISABLED 0x04
    U32 admin_status;

    // The chassis ID advertised by the peer.
    U32 remote_chassis_id[65];

    // The port ID advertised by the peer.
    U32 remote_port_id[65];

    // The chassis ID advertised by the local machine.
    // port MAC address
    U32 local_chassis_id[2];

    // The port ID advertised by the local machine.
    // function MAC address
    U32 local_port_id[2];

} QL_LLDP_PARAMS;



//
// DCBX protocol parameters.
//

// Local machine priority to application assignment.
// Traffic type enumeration: 0 -EtherType, 1 - port over TCP,
//                           2 - port over UDP, 3 - port over both.
// Default (two valid entries) =
// Priority=3, traffic type=0, app_id=0x8906 (FCoE)
// Priority=4, traffic type=1, app_id=3260 (iSCSI)
typedef struct
{
    U32 valid;

#define QLMAPI_DCBX_INVALID_TRAFFIC_TYPE_PRIORITY    (0xFFFFFFFF)
    U32 priority;

#define QLMAPI_DCBX_TRAFFIC_TYPE_ETH     0
#define QLMAPI_DCBX_TRAFFIC_TYPE_PORT    1
    U32 traffic_type;

    U32 app_id;

    U32 reserve[8];

} QL_DCBX_ADMIN_PRIORITY_APP_TABLE;



typedef struct
{
    // Indicates if to enable DCB. When Enable DCB = enable and
    // admin_dcbx_enable = disable, static configuration is done.
    // This parameter is used only by the driver.
    U32 dcb_enable;

    // Indicates if to enable DCBX negotiation. Default = enable.
    U32 admin_dcbx_enable;

    // Only if the entire DCBX registry set is present and differ from
    // 0xFFFFFFFF (invalid value) the DCBX parameters are taken, otherwise
    // the data are ignored. (Except "admin_dcbx_enable" and "dcb_enable")

    // Indicates if to use the default NVRAM DCBX settings or to overwrite
    // them by other configurable settings. Default = No.
    U32 overwrite_settings;

    // Indicates if to perform negotiation according to CEE or IEEE.
    // Default = CEE.
#define QLMAPI_DCBX_ADMIN_DCBX_VERSION_CEE   0
#define QLMAPI_DCBX_ADMIN_DCBX_VERSION_IEEE  1
    U32 admin_dcbx_version;

    // Indicates if to enable ETS. Default = enable.
    U32 admin_ets_enable;

    // Indicates if to enable PFC. Default = enable.
    U32 admin_pfc_enable;

    // Indicates if to transmit the TC Supported TLV by the local machine.
    // Default = enable.
    U32 admin_tc_supported_tx_enable;

    // Indicates if to transmit the ETS configuration TLV by the local
    // machine. Default = enable. 
    U32 admin_ets_configuration_tx_enable;

    // Indicates if to transmit the ETS recommendation TLV by the local
    // machine. Default = disable.
    U32 admin_ets_recommendation_tx_enable;

    // Indicates if to transmit the PFC TLV by the local machine.
    // Default = enable.
    U32 admin_pfc_tx_enable;

    // Indicates if to transmit the application TLV by the local machine.
    // Default = enable.
    U32 admin_application_priority_tx_enable;

     // Indicates if the local machine is willing to accept the ETS
    // configuration recommended by the peer. Default = willing.
    U32 admin_ets_willing;

    // Indicates if the ETS recommendation sent from the local machine is
    // valid. Default = no.
    U32 admin_ets_reco_valid;

    // Indicates if the local machine is willing to accept PFC configuration
    // from the peer. Default = willing.
    U32 admin_pfc_willing;

    // Indicates if the local machine is willing to accept application
    // priority assignment configuration from the peer. Default = willing.
    U32 admin_app_priority_willing;

    // Local machine bandwidth percentage allocation. For example:
    // Default profile #0: [0,50,50,0,0,0,0,0]
    // Default profile #1 (for OEM1): [0,33,66,0,0,0,0,0]
    // Default profile #2 (for OEM2): [0,33,33,33,0,0,0,0]
    U32 admin_configuration_bw_percentage[8];

    // Local machine priority to priority group assignment.
    // Default profile #0: [0,1,0,2,1,0,0,0]
    // Default profile #1: [0,1,0,2,2,0,0,0]
    // Default profile #2: [0,1,0,2,3,0,0,0]
    U32 admin_configuration_ets_pg[8];

    // Recommendation to peer for bandwidth percentage allocation.
    // Default = zeros.
    U32 admin_recommendation_bw_percentage[8];

    // Recommendation to peer for priority to priority group assignment.
    // Default = zeros.
    U32 admin_recommendation_ets_pg[8];

    // Local machine per-priority PFC enabled/disabled (bitmap).
    // Default profile #0: 00010000b
    // Default profile #1: 00011000b
    // Default profile #2: 01011000b
    U32 admin_pfc_bitmap;

    // Local machine priority to application assignment.
    // Traffic type enumeration: 0 -EtherType, 1 - port over TCP,
    //                           2 - port over UDP, 3 - port over both.
    // Default (two valid entries) =
    // Priority=3, traffic type=0, app_id=0x8906 (FCoE)
    // Priority=4, traffic type=1, app_id=3260 (iSCSI)
    QL_DCBX_ADMIN_PRIORITY_APP_TABLE    admin_priority_app[4];

    // Local machine default priority for applications not defined by the
    // application protocol TLV. Default = 1.
    U32 admin_default_priority;

    U32 reserve[20];

} QL_DCBX_CFG_PARAMS;



#define QL_DCBX_PARAMS_VER  4

typedef struct
{
    //  Version is defined as QL_DCBX_PARAMS_VER.
    //  'version' is required upon input
    U32 version;

    QL_DCBX_CFG_PARAMS  cfg;

    // The number of traffic classes that the local machine supports.
    U32 local_tc_supported;

    // The number of traffic classes that may simultaneously support
    // PFC on the local machine.
    U32 local_pfc_caps;

    // The number of traffic classes that the peer supports.
    U32 remote_tc_supported;

    // The number of traffic classes that may simultaneously support
    // PFC at the peer.
    U32 remote_pfc_cap;

    // Indicates if the peer is willing to accept the ETS configuration
    // recommended by the local machine. 
    U32 remote_ets_willing;

    // Indicates if the ETS recommendation sent from the peer is valid.
    U32 remote_ets_reco_valid;

    // Indicates if the peer is willing to accept PFC configuration.
    U32 remote_pfc_willing;

    // Indicates if the peer is willing to accept application priority
    // assignment configuration.
    U32 remote_app_priority_willing;

    // Peer bandwidth percentage allocation configuration.
    U32 remote_configuration_bw_percentage[8];

    // Peer priority to priority group assignment configuration.
    U32 remote_configuration_ets_pg[8];

    // Peer bandwidth percentage allocation recommendation.
    U32 remote_recommendation_bw_percentage[8];

    // Peer priority to priority group assignment recommendation.
    U32 remote_recommendation_ets_pg[8];

    // Peer per-priority PFC enabled/disabled (bitmap).
    U32 remote_pfc_bitmap;

    // Peer priority to application assignment.
    QL_DCBX_ADMIN_PRIORITY_APP_TABLE remote_priority_app[16];

    // Indicates if ETS is enabled.
    U32 local_ets_enable;

    // Indicates if PFC is enabled.
    U32 local_pfc_enable;

    // Operational bandwidth percentage allocation
    U32 local_configuration_bw_percentage[8];

    // Operational priority to priority group assignment.
    U32 local_configuration_ets_pg[8];

    // Operational per-priority PFC enabled/disabled (bitmap).
    U32 local_pfc_bitmap;

    // Operational priority to application assignment.
    QL_DCBX_ADMIN_PRIORITY_APP_TABLE local_priority_app[16];

    // When set indicates that there was a mis-match between the local
    // machine and the peer PFC configuration.
    U32 pfc_mismatch;

    // When set indicates that there was a mis-match between the local
    // machine and the peer priority to application assignment configuration.
    U32 priority_app_mismatch;

    // Statistics.
    U32 dcbx_frames_sent;
    U32 dcbx_frames_received;
    U64 pfc_frames_sent;
    U64 pfc_frames_received;

#define QLMAPI_DCBX_CURRENT_STATE_IS_SYNC                BIT_0
#define QLMAPI_PFC_IS_CURRENTLY_OPERATIONAL              BIT_1
#define QLMAPI_ETS_IS_CURRENTLY_OPERATIONAL              BIT_2
#define QLMAPI_PRIORITY_TAGGING_IS_CURRENTLY_OPERATIONAL BIT_3
#define QLMAPI_DRIVER_CONFIGURED_BY_OS_QOS               BIT_4
#define QLMAPI_DRIVER_CONFIGURED_BY_OS_QOS_TO_WILLING    BIT_5
    U32 dcb_current_oper_state_bitmap;

    // For Linux only, no valid for Windows.
#define QLMAPI_DCBX_PARAMS_NONE      0
#define QLMAPI_DCBX_PARAMS_DCBNL     1
#define QLMAPI_DCBX_PARAMS_IOCTL     2
    U32 dcb_retrieve_method;

} QL_DCBX_PARAMS;



#define QL_MBA_PARAMS_VER  3

typedef struct
{
    //  Version is defined as QL_MBA_PARAMS_VER.
    //  'version' is a required input field.
    U32 version;

    // boolean value
    // not applicable if no MBA FW in NVRAM
    // not applicable for SW or HW selfboot
    U32 mba_enable;

#define QLMAPI_MBA_BOOT_PROT_NONE    0
#define QLMAPI_MBA_BOOT_PROT_PXE     1   // default
#define QLMAPI_MBA_BOOT_PROT_RPL     2
#define QLMAPI_MBA_BOOT_PROT_BOOTP   3
#define QLMAPI_MBA_BOOT_PROT_ISCSI   4
#define QLMAPI_MBA_BOOT_PROT_FCOE    5   // Only for 57710 type of devices (57712 and later)
    U32 boot_prot;

#define QLMAPI_MBA_BOOTSTRAP_AUTO    0   // default
#define QLMAPI_MBA_BOOTSTRAP_BBS     1
#define QLMAPI_MBA_BOOTSTRAP_INT18H  2
#define QLMAPI_MBA_BOOTSTRAP_INT19H  3
    U32 bootstrap;

    // boolean value
    U32 banner_enable;

    // in seconds (0-15)
    U32 banner_timeout;

    // false for Ctrl-S, true for Ctrl-B
    U32 hot_key;

#define QLMAPI_MBA_SPEED_AUTO        0   // default
#define QLMAPI_MBA_SPEED_10H         1
#define QLMAPI_MBA_SPEED_10F         2
#define QLMAPI_MBA_SPEED_100H        3
#define QLMAPI_MBA_SPEED_100F        4
#define QLMAPI_MBA_SPEED_1000H       5
#define QLMAPI_MBA_SPEED_1000F       6
#define QLMAPI_MBA_SPEED_2_5G        7
#define QLMAPI_MBA_SPEED_10G_CX4     8
#define QLMAPI_MBA_SPEED_20G         9
    // For QLMAPI_BRCM57710, only QLMAPI_MBA_SPEED_AUTO is applicable.
    U32 link_speed;

    // boolean value
    U32 wol_enable;

    // boolean value
    U32 vlan_enable;

    // 0..1023
    U32 vlan_id;

    // number of retry
    // applicable only to NXII
    U32 retry;

    //////////////////////////
    // For QLMAPI_BRCM57710 ONLY

    //  Act as if the FCoE license is invalid
    // boolean value, read only
    U32 prevent_fcoe;

    // Act as if the iSCSI license is invalid
    // boolean value, read only
    U32 prevent_iscsi;

    //////////////////////////

} QL_MBA_PARAMS;



typedef struct
{
// For function 2-7, set if num_of_partition is greater than 1.
// Otherwise, clear the bit.
// For function 0-1, the 'enabled' bit should be always set once the
// configuration had been initialized.
#define QLMAPI_PART_FUNC_CFG_ENABLED         0x00000001

// By default, all functions will have NDIS enumerated.
#define QLMAPI_PART_FUNC_CFG_ETH             0x00000002  // enumerate NDIS

// By default, function 0 and 1 will iSCSI enumerated.
// No more than 2 iSCSI can be enumerated per physical port.
#define QLMAPI_PART_FUNC_CFG_ISCSI           0x00000004  // enumerate iSCSI

// No more than 2 FCoE can be enumerated per physical port.
#define QLMAPI_PART_FUNC_CFG_FCOE            0x00000008  // enumerate FCoE

// pause on host ring
#define QLMAPI_PART_FUNC_CFG_PAUSE_ON_HOST_RING  0x00000080
    U8  flags;

    // minimum bandwidth
    // Value range - 0..100, increments in 100Mbps
    // Default is 0 (not guarantee of bandwidth) for all functions
    // All function add together can not exceed 100 (10G)
    U8  min_bw;

    // maximum bandwidth
    // Value range - 0..100, increments in 100Mbps
    // Default is 100 for function 0-1 and 25 for function 2-7.
    // Can be over-subscribed
    U16 max_bw;

    U64 net_mac_addr;
    U64 iscsi_mac_addr;

    U64 fcoe_mac_addr;
    U64 fcoe_node_wwn;
    U64 fcoe_port_wwn;

	// number of vfs in a function, if 0 - SRIOV disabled
    #define QLMAPI_PART_FUNC_CFG_NUMBER_OF_VFS_MASK      0x000000FF
    #define QLMAPI_PART_FUNC_CFG_NUMBER_OF_VFS_SHIFT     0
    U32 pf_allocation;

    U32 reserved[10];
} QL_PART_FUNC_CFG;

typedef struct
{
#define QLMAPI_PART_PORT_FC_AUTO             0   // Auto flow control (default)
#define QLMAPI_PART_PORT_FC_TX               1   // Tx flow control
#define QLMAPI_PART_PORT_FC_RX               2   // Rx flow control
#define QLMAPI_PART_PORT_FC_BOTH             3   // Rx/Tx flow control
#define QLMAPI_PART_PORT_FC_NONE             4   // No flow control
    U8  flow_control;

    U8  reserved1[3];

    U32 reserved[16];
} QL_PART_PORT_CFG;

#define QL_NIC_PART_CFG_VER     5

typedef struct
{
    //  Version is defined as QL_NIC_PART_CFG_VER.
    //  'version' is a required input field.
    U32                 version;

// 'Enabled' bit should be set if the configuration had been initialized.
// if it is clear, the configuration needs to be initialized to default.
#define QLMAPI_NIC_PART_ENABLED      0x00000001
#define QLMAPI_NIC_PART1_5_ENABLED 	0x00000002
#define QLMAPI_NIC_PART2_0_ENABLED 	0x00000003

    U32                 flags;

    // For 2 physical ports
    // port_cfg[0] for port 0
    // port_cfg[1] for port 1
#define QLMAPI_NPAR_MAX_PORT     2
    QL_PART_PORT_CFG    port_cfg[QLMAPI_NPAR_MAX_PORT];

    // For potential all 8 functions
    // func_cfg: 0, 2, 4, 6 for port0
    // func_cfg: 1, 3, 5, 7 for port1
#define QLMAPI_NPAR_MAX_FUNC     8
    QL_PART_FUNC_CFG    func_cfg[QLMAPI_NPAR_MAX_FUNC];

    // For 4 physical ports
    // port_cfg2[0] for port 2
    // port_cfg2[1] for port 3
    QL_PART_PORT_CFG    port_cfg2[QLMAPI_NPAR_MAX_PORT];

    // Act as if the FCoE license is invalid
    // bollean value, read only
    U32                 prevent_fcoe;

	// SRIOV is enabled or disabled.
    U32                 sriov;

    // SRIOV is supported or not.
    // Boolean value. Read-only.
    U32                 sriov_supported;

    // Act as if the iSCSI license is invalid
    // bollean value, read only
    U32                 prevent_iscsi;

} QL_NIC_PART_CFG;



#define QL_DCB_NVRAM_CFG_VER    1

typedef struct
{
    //  Version is defined as QL_DCB_NVRAM_CFG_VER.
    //  'version' is required upon input
    U32 version;

    // Indicates if to enable DCB.
    U32 dcb_enable;

} QL_DCB_NVRAM_CFG;



#define QL_NIV_MAX_PROFILE_LEN              80
#define QL_NIV_NUM_PROFILES_SUPPORTED       64

typedef struct
{
#define QLMAPI_NIV_PORT_CFG_FC_AUTO          0   // Auto flow control (default)
#define QLMAPI_NIV_PORT_CFG_FC_TX            1   // Tx flow control
#define QLMAPI_NIV_PORT_CFG_FC_RX            2   // Rx flow control
#define QLMAPI_NIV_PORT_CFG_FC_BOTH          3   // Rx/Tx flow control
#define QLMAPI_NIV_PORT_CFG_FC_NONE          4   // No flow control
    U8  flow_control;

    U8  reserved1[3];

    U32 reserved[10];
} QL_NIV_PORT_CFG;

typedef struct
{
    // bandwidth weight
    U32 bw_weight;

    // max bandwidth
    U32 bw_max;

#define QLMAPI_NIV_FUNC_CFG_VIF_ENABLED      0x00000001
#define QLMAPI_NIV_FUNC_CFG_VIF_ETHERNET     0x00000002
#define QLMAPI_NIV_FUNC_CFG_VIF_ISCSI        0x00000004
#define QLMAPI_NIV_FUNC_CFG_VIF_FCOE         0x00000008
#define QLMAPI_NIV_FUNC_CFG_PAUSE_ON_HOST_RING_ENABLED   0x00000080
    U8  flags;

#define QLMAPI_NIV_FUNC_CFG_RBOOT_DISABLED   0x00000000  // Remote boot disabled
#define QLMAPI_NIV_FUNC_CFG_RBOOT_ENABLED    0x00000001  // Remote boot enabled
    U8  remote_boot;

#define QLMAPI_NIV_FUNC_CFG_PROFILE_DISABLED 0x00000000  // Profile disabled
#define QLMAPI_NIV_FUNC_CFG_PROFILEd_ENABLED 0x00000001  // Profile enabled
    U8  profile;

    U8  reserved1[5];

    U64 net_mac_addr;
    U64 iscsi_mac_addr;
    U64 fcoe_mac_addr;
    U64 fcoe_node_wwn;
    U64 fcoe_port_wwn;

#define QLMAPI_NIV_MAX_PROFILE_LEN           80
    U8  profile_name[QLMAPI_NIV_MAX_PROFILE_LEN];

    U32 reserved[10];

} QL_NIV_FUNC_CFG;

#define QL_NIV_CFG_VER      3

typedef struct
{
    //  Version is defined as QL_NIV_CFG_VER.
    //  'version' is a required input field.
    U32                 version;

// 'Enabled' bit should be set if the configuration had been initialized.
// if it is clear, the configuration needs to be initialized to default.
#define QLMAPI_NIV_ENABLED       0x00000001
    U32                 flags;

    U32                 reserved[4];

#define QLMAPI_NIV_MAX_PORT      4
    QL_NIV_PORT_CFG     port_cfg[QLMAPI_NIV_MAX_PORT];   // per port config

#define QLMAPI_NIV_MAX_FUNC      8
    QL_NIV_FUNC_CFG     func_cfg[QLMAPI_NIV_MAX_FUNC];   // per function config

    // Act as if the FCoE license is invalid
    // bollean value, read only
    U32                 prevent_fcoe;

    // Act as if the iSCSI license is invalid
    // bollean value, read only
    U32                 prevent_iscsi;

} QL_NIV_CFG;

#define QL_NIV_PORT_PROFILES_CFG_VER    1

typedef struct
{
    //  Version is defined as QL_NIV_PORT_PROFILES_CFG_VER.
    //  'version' is a required input field.
    U32 version;

    // Each bit corresponding to one Profile entry.
    // Bit0 --> entry 0, Bit1 --> entry 1, etc.
    // The specific profile entry is valid only when the corresponding bit
    // is set
    U64 enable_bits;

#define QLMAPI_NIV_MAX_PROFILE_ENTRIES       64
    U8  profiles_list[QLMAPI_NIV_MAX_PROFILE_ENTRIES][QLMAPI_NIV_MAX_PROFILE_LEN];

} QL_NIV_PORT_PROFILES_CFG;



#define QL_EEE_INFO_VER     1

typedef struct
{
    //  Version is defined as QL_EEE_INFO_VER.
    //  'version' is a required input field.
    U32 version;

    // EEE is enabled in registy or not form driver's last registry read
    // 0: disabled
    U32 enable;

    // This is EE negotiated result.
    // 1: EEE is on (LPI is set)
    // 0: EEE is off
    U32 status;

    // This counter counts the number of times entering into EEE mode.
    U32 eee_mode_cnt;

    // This counter counts the number of times the receive side goes into
    // LPI.
    U32 rx_lpi_cnt;

    // This counter counts the number of times the debounced version of EEE
    // link idle is asserted.
    U32 tx_lpi_cnt;

} QL_EEE_INFO;



#define QL_MAX_SRIOV_NAMES_LENGTH                   256

typedef struct
{
    U16 length;
    U16 name[QL_MAX_SRIOV_NAMES_LENGTH+1];  //wchar_t
} QL_SRIOV_NAME;



#define QL_SRIOV_SWITCH_INFO_VER    1

typedef struct
{
    //  Version is defined as QL_SRIOV_SWITCH_INFO_VER.
    //  'version' is a required input field.
    U32             version;

#define QL_SRIOV_SWITCH_PF_UNBOUND                  0
#define QL_SRIOV_SWITCH_PF_BOUND_WITH_SRIOV_CAPS    1
#define QL_SRIOV_SWITCH_VF                          2
#define QL_SRIOV_REGULAR_PF                         3
#define QL_SRIOV_VMQ_SWITCH                         4
#define QL_SRIOV_SRIOV_SWITCH                       5
    U8              switch_type;

    // For QL_SRIOV_SRIOV_SWITCH: max HW possible VFs reported in SRIOV
    // extended capability of PCI configuration space
    U8              num_of_hw_available_vfs;

    // For QL_SRIOV_SRIOV_SWITCH: real max available VFs number set by OS
    // on SRIOV switch creation. <= num_of_hw_available_vfs
    U8              num_of_available_vfs;

    // For QL_SRIOV_SRIOV_SWITCH: max available (HW configured) VF RSS chains.
    // Default and max value is 16, may be overriden by PF registry parameter
    // "max_chains_per_vf". Set this reistry parameters requires
    // disable/enable cycle of the PF device
    U8              max_vf_chains_per_vf;

    // For QL_SRIOV_SRIOV_SWITCH: a number of available VF chains, VF chains
    // may be devided in asymmetric between VFs of the switch.
    U8              vf_chains_pool_size;

    // For QL_SRIOV_SRIOV_SWITCH: a number of available PF non default VPorts
    // (VMQs of SRIOV Switch).
    // For QL_SRIOV_VMQ_SWITCH: a number of available VMQs.
    U8              vmq_chains_pool_size;

    U8              reserved[2];

    // For QL_SRIOV_VMQ_SWITCH: Friendly name of SRIOV switch provide by OS on
    // RIOV switch creation
    QL_SRIOV_NAME   switch_friendly_name;

} QL_SRIOV_SWITCH_INFO;



#define QL_SRIOV_SWITCH_STATS_VER   1

typedef struct
{
    //  Version is defined as QL_SRIOV_SWITCH_STATS_VER.
    //  'version' is a required input field.
    U32 version;

    // Same as QL_SRIOV_SWITCH_INFO
    U8  switch_type;

    // For QL_SRIOV_SRIOV_SWITCH: a current number of active VFs.
    U8  num_of_active_vfs;

    // For QL_SRIOV_SRIOV_SWITCH: Incremental only (from switch creation
    // till switch deletion) value exposing fails on VF VPort creation
    U8  num_of_rejected_vfs;

    // For QL_SRIOV_SRIOV_SWITCH: Incremental only (from switch creation
    // till switch deletion) value exposing illegal/malicious operation with
    // VFs, security issues
    U8  num_of_malicious_vfs;

    // For QL_SRIOV_SRIOV_SWITCH & QL_SRIOV_VMQ_SWITCH: a current number of
    // active VMQs
    U8  num_of_active_vmqs;

    // For QL_SRIOV_SRIOV_SWITCH & QL_SRIOV_VMQ_SWITCH: Incremental only (from
    // switch creation till switch deletion) value exposing fails of VF non
    // default VPorts/VMQs creation
    U8  num_of_rejected_vmqs;

    U8  reserved[2];

} QL_SRIOV_SWITCH_STATS;



typedef struct
{
    // The number of VF inside PF.
    U8  relative_vf_id;

    // Evbd keeps this value for the VF and increases it on each activation
    // (VPort creation) of this VF. Assuming at any time VF may be released
    // and immediately acquired by other VMNetworkAdapter in othe VM, the
    // parameter allows to recognize VPort delete/create blink. It's useful
    // on frequent retrieving squized structure(s) as statistics one.
    // Generally increasing of the parameter must trigger driver to reread
    // basic/constant VF data.
    U8  vf_port_instance;

    // Reflects a number of really activated VF RSS chains via VF miniport
    // advanced property. If VF was acquired by VM but not in use
    // (evbd/minport disabled/yellow banged), the value is set as 0
    U8  num_of_active_vf_chains;

    // Bits describing VF modes: active RSC, secure mode (anti-spoofing,
    // forced promiscuous), malicious operation.
#define QL_SRIOV_VF_HDR_FLAG_WAS_MALICIOUS  0x00000001
#define QL_SRIOV_VF_HDR_SECURE_MODE         0x00000002
#define QL_SRIOV_VF_HDR_RSC_ACTIVE          0x00000004
    U8  features_flag;

    U32 reserved[7];

} QL_SRIOV_VF_HDR;



#define QL_SRIOV_VF_INFO_VER    1

typedef struct
{
    //  Version is defined as QL_SRIOV_VF_INFO_VER.
    //  'version' is a required input field.
    U32                 version;

    QL_SRIOV_VF_HDR     vf_header;

    // BDF of VF provided to PF/miniport by OS on evbd request during VF
    // creation process.
    U8                  bus_no;
    U8                  device_no;
    U8                  function_no;
    U8                  reserve_1;

    // a number of QPs allowed for VF via Hyper-V manager
    U8                  num_of_QPs_requested_by_VM;

    // a number of QPs requested by VF evbd loaded in VM OS
    U8                  num_of_QPs_requested_by_VF;

    // a number of QPs really allocated for VF
    U8                  num_of_QPs_allocated_to_VF;

    // Different number above may expose some problems required assistance
    // of Host/VM administrators. PF evbd reports about real problem via
    // Windows log. Perhaps duplication report via driver will be effective.
    U8                  QPs_numbers_validator;

    // VF VPort was succsessfully created but VF evbd is not loaded [yet]
    // case itself is item to report: VF resources are allocated but not in
    // use (VF evbd is disabled) num_of_QPs_requested_by_VF = 0;
    // (num_of_QPs_allocated_to_VF < num_of_QPs_requested_by_VM) may be item
    // for report about VF chains pool fully consumed
#define QL_SRIOV_VF_QP_STATE_VF_EVBD_NOT_LOADED     0

    // VF VPort was succsessfully created, VF evbd successfully loaded but VF
    // miniport is not loaded [yet] case itself is item to report: VF
    // resources are allocated but not in use (VF miniport is disabled)
    // (num_of_QPs_allocated_to_VF < num_of_QPs_requested_by_VF) may be item
    // for report about VF chains pool fully consumed
#define QL_SRIOV_VF_QP_STATE_VF_NDIS_MP_NOT_LOADED  1

    // VF is in working state (vf_header::num_of_active_vf_chains <
    // num_of_QPs_allocated_to_VF) may be item to report about non efective
    // resources using on VM side
#define QL_SRIOV_VF_QP_STATE_VF_WORKING             2


    U32                 reserve_2[2];

    QL_SRIOV_NAME       vm_name;
    QL_SRIOV_NAME       vm_friendly_name;
    QL_SRIOV_NAME       vport_name;
    QL_SRIOV_NAME       vf_vport_nic_name;

    U32                 reserve_3[16];

} QL_SRIOV_VF_INFO;



#define QL_SRIOV_VF_STATS_VER   1

typedef struct
{
    //  Version is defined as QL_SRIOV_VF_STATS_VER.
    //  'version' is a required input field.
    U32                 version;

    QL_SRIOV_VF_HDR     vf_header;

    // All below statistics are relevant if
    // vf_header->num_of_active_vf_chains > 0
    U64                 total_sent_bytes;
    U64                 total_sent_pkts;
    U64                 total_recv_bytes;
    U64                 total_recv_pkts;

    U64                 reserve[48];

} QL_SRIOV_VF_STATS;



/****************************************************************************
 *  APIs Definition
 ****************************************************************************/
void    QLmapiGetVersion( U32 *pMajorVersion, U32 *pMinorVersion,
            U32 *pBuildVersion );
U32     QLmapiInitialize( void );
U32     QLmapiUninitialize( void );
U32     QLmapiGetNumPhyNic( U32 *pNumOfPhy );
U32     QLmapiGetAllPhyNic( QL_ADAPTER_INFO *pPhyList, U32 uNumOfPhy );
U32     QLmapiGetServiceName( U32 handle, U8 *pServiceName, U32 uBufLen );
U32     QLmapiInitializeEx( U32 bKeepCom );
U32     QLmapiIsInitialized( void );
U32     QLmapiGetHandleByServiceName( U8 *pServiceName, U32 *handle );
U32     QLmapiGetNicPciInfo( U32 handle, QL_NIC_PCI_INFO *pNicPciInfo );
U32     QLmapiInitDiag( U32 handle );
U32     QLmapiUnInitDiag( U32 handle );
U32     QLmapiGetNumPhyNicEx( U32 *pNumOfPhy );
U32     QLmapiGetAllPhyNicHandles( U32 *pHandleList, U32 uNumOfPhy );
U32     QLmapiGetPhyNic( U32 handle, QL_ADAPTER_INFO_EX *pNicInfoEx );
#if NX1SPLIT
U32     QLmapiGetASFTable( U32 handle, QL_ASF_TABLE *pNicASF );
U32     QLmapiSetASFTable( U32 handle, QL_ASF_TABLE *pNicASF );
#endif
U32     QLmapiGetBIOS( U64 start_addr, void *buffer, U32 length );
U32     QLmapiGetSystemASFTables( QL_ASF_TABLE *pAsfTbls );
U32     QLmapiWriteFirmware( U32 handle, U32 uOffset, U32 *pDataBuf,
            U32 uBufLen, U8 *pChk );
U32     QLmapiWriteFirmware2( U32 handle, U32 uOffset, U32 *pDataBuf,
            U32 uBufLen, U8 *pChk, U32 uTarget );
U32     QLmapiReadFirmware( U32 handle, U32 uOffset, U32 *pDataBuf,
            U32 uBufLen, U8 *pChk );
U32     QLmapiReadFirmware2( U32 handle, U32 uOffset, U32 *pDataBuf,
            U32 uBufLen, U8 *pChk, U32 uTarget );
U32     QLmapiDoNicIOCTL( U32 handle, U32 ioctlCode, void *pInBuf,
                U32 inBufSize, void *pOutBuf, U32 *pOutBufSize,
                U32 *pResult );
U32     QLmapiSuspendDriverEx( U32 handle );
U32     QLmapiResumeDriverEx( U32 handle );
U32     QLmapiEnableDevice( U32 handle, U32 uEnable );
U32     QLmapiTestControlRegistersEx( U32 handle );
U32     QLmapiTestMIIRegistersEx( U32 handle );
U32     QLmapiTestInternalMemoryEx( U32 handle );
//U32     QLmapiTestExternalMemoryEx( U32 handle, U32 ExtMemSize );
U32     QLmapiTestInterruptEx( U32 handle );
U32     QLmapiTestLoopBackEx( U32 handle, U32 Lbtype );
U32     QLmapiTestCPUEx( U32 handle );
U32     QLmapiTestLEDsEx( U32 handle, U32 BlinkDurationSec );
U32     QLmapiTestEEPROMEx( U32 handle );
U32     QLmapiTestASF( U32 handle );
U32     QLmapiRefreshData();
U32     QLmapiGetBRCMNicInfoEx( U32 handle,
                QL_BRCM_ADAPTER_INFO_EX *pBRCMNicInfoEx );
U32     QLmapiReadNicMem( U32 handle, U32 uType, U32 uOffset, U32 *pData,
                U8 *pChk );
U32     QLmapiWriteNicMem( U32 handle, U32 uType, U32 uOffset, U32 uData,
                U8 *pChk );
U32     QLmapiGetBRCMNicStatistics( U32 handle,
                QL_BRCM_STATISTICS *pBrcmStatistics );
U32     QLmapiGetBRCMNicStatisticsEx( U32 handle,
                QL_BRCM_STATISTICS_EX *pBrcmStatisticsEx );
#if NX1SPLIT
U32     QLmapiGetFirmwareInfo( U32 handle, QL_FW_INFO *pFWInfo );
U32     QLmapiWriteFirmwareInfo( U32 handle, QL_FW_INFO *pFWInfo, U32 uOption );
#endif
U32     QLmapiGet5706FwInfo( U32 handle, QL_FW_INFO_5706 *pFwInfo );
U32     QLmapiGet57710FwInfo( U32 handle, QL_FW_INFO_57710 *pFwInfo );
U32     QLmapiWritePhyFirmware( U32 handle, U8 *pDataBuf, U32 uBufLen, U8 *pChk );
#if NX1SPLIT
U32     QLmapiGetMgmtProcessors( U32 handle, U32 *pProc );
U32     QLmapiGetMgmtEnableState( U32 handle, U32 *pEnable );
U32     QLmapiSetMgmtEnableState( U32 handle, U32 bEnable );
U32     QLmapiAssertMgmtEvent( U32 handle, U8 uEventID, U8 uEventData,
                U8 Reserved, void *pMsg, U32 uMsgLen );
U32     QLmapiGetMgmtOTPKeys( U32 handle, U32 *pKey1, U32 *pKey2 );
U32     QLmapiGetMgmtSharedMem( U32 handle, U32 uOffset, void *pBuf,
                U32 uBufLen );
U32     QLmapiGetMgmtConfigLength( U32 handle, U32 *pLength );
U32     QLmapiGetMgmtConfig( U32 handle, void *pBuf, U32 uBufLen );
U32     QLmapiSetMgmtConfig( U32 handle, void *pBuf, U32 uBufLen );
U32     QLmapiCreateMgmtData( U32 handle, U32 uLength );
U32     QLmapiGetMgmtDataLength( U32 handle, U32 *pLength );
U32     QLmapiGetMgmtData( U32 handle, U32 uOffset, void *pBuf, U32 uBufLen );
U32     QLmapiSetMgmtData( U32 handle, U32 uOffset, void *pBuf, U32 uBufLen );
U32     QLmapiCreateMgmtWebData( U32 handle, U32 uLength );
U32     QLmapiGetMgmtWebDataLength( U32 handle, U32 *pLength );
U32     QLmapiGetMgmtWebData( U32 handle, U32 uStart, void *pBuf, U32 uBufLen );
U32     QLmapiSetMgmtWebData( U32 handle, U32 uStart, void *pBuf, U32 uBufLen );
#endif
U32     QLmapiRetrieveLinkStatusEx( U32 handle, QL_LINK_STATUS_EX *pLinkStatusEx );
U32     QLmapiRetrieveMultiLinkStatus( QL_LINK_STATUS_EX **ppLinkStatusEx, U32 uNumOfStruct );

U32     QLmapiGetISCSIConfig2( U32 handle, QLMAPI_ISCSI_CONFIG_LNX *pConfig, U32 *pNumCfg );
U32     QLmapiSetISCSIConfig2( U32 handle, QLMAPI_ISCSI_CONFIG_LNX *pConfig, U32 pNumCfg );
U32     QLmapiGetISCSIRuntimeIPCount( QL_ISCSI_IP_COUNT *pIpCount, U32 uCount );
U32     QLmapiGetISCSIRuntimeIP( QL_ISCSI_IPV4_RT **ppIPv4, U32 uIPv4Len,
            QL_ISCSI_IPV6_RT **ppIPv6, U32 uIPv6Len );
U32     QLmapiGetISCSIRuntimeStatistics( QL_ISCSI_STATS **ppStats, U32 uStatsLen );
U32     QLmapiGetISCSISessionStatistics( QL_ISCSI_SESSION_STATS **ppStats, U32 uStatsLen );
//=======================================================================================

U32     QLmapiGetIpAddrInfo( U32 handle, U32 uType, U8 *pBuf, U32 *pLen );
U32     QLmapiGetNicStatisticsV3( U32 handle,
                QL_GENERAL_STATISTICS_EX *pGenStatistics,
                QL_ETHERNET_STATISTICS_EX *pEthStatistics );
U32     QLmapiGetNicStatistics64Ex( U32 handle,
                QL_GENERAL_STATISTICS64 *pGenStatistics,
                QL_ETHERNET_STATISTICS64 *pEthStatistics );

//=======================================================================================
// These BMAPI APIs are not implemented in QLmapilnx.
// Call to these BMAPI functions will return QLMAPI_FEATURE_NOT_AVAILABLE.
U32     QLmapiGetLicenseKey( U32 handle, U32 key_index, QLMAPI_LICENSE_INFO *pLicense );
U32     QLmapiSetLicenseKey( U32 handle, U32 key_index, U8 *key_buf, U32 key_len );
U32     QLmapiGetResourceConfig( U32 handle, QL_RES_CFG *pResCfg );
U32     QLmapiSetResourceConfig( U32 handle, QL_RES_CFG *pResCfg );
U32     QLmapiGetOffloadStackInfo( U32 handle, U32 uStackIdx, QLMAPI_OFLD_STACK_INFO *pStackInfo );
//=======================================================================================

U32     QLmapiGetLldpParams( U32 handle, QL_LLDP_PARAMS *pLldpParams );
U32     QLmapiGetDcbxParams( U32 handle, QL_DCBX_PARAMS *pDcbxParams );
U32     QLmapiGetDcbxCfgParams( U32 handle, QL_DCBX_PARAMS *pDcbxParams );
U32     QLmapiSetDcbxCfgParams( U32 handle, QL_DCBX_PARAMS *pDcbxParams );
U32     QLmapiCommitDcbxCfgParams( U32 handle, QL_DCBX_PARAMS *pDcbxParams );
U32     QLmapiGetIscsiCfg( U32 handle, U8 *pBuf, U32 *pLen );
U32     QLmapiSetIscsiCfg( U32 handle, U8 *pBuf, U32 uLen );
U32     QLmapiGetFcoeCfg( U32 handle, U8 *pBuf, U32 *pLen );
U32     QLmapiSetFcoeCfg( U32 handle, U8 *pBuf, U32 uLen );
U32     QLmapiGetMBAParams( U32 handle, QL_MBA_PARAMS *pMbaParams );
U32     QLmapiSetMBAParams( U32 handle, QL_MBA_PARAMS *pMbaParams );
U32     QLmapiGetNicPartCfg( U32 handle, QL_NIC_PART_CFG *pNicPart );
U32     QLmapiSetNicPartCfg( U32 handle, QL_NIC_PART_CFG *pNicPart );
U32     QLmapiGetExtVPD( U32 handle, U8 *pBuf, U32 *pLen );
U32     QLmapiSetExtVPD( U32 handle, U8 *pBuf, U32 uLen );
U32     QLmapiGetDcbNvramCfg( U32 handle, QL_DCB_NVRAM_CFG *pDcbNvramCfg );
U32     QLmapiSetDcbNvramCfg( U32 handle, QL_DCB_NVRAM_CFG *pDcbNvramCfg );

U32     QLmapiGetBrcmNicParamList( U32 handle, U8 *pParamList, U32 *pLen );
U32     QLmapiGetBrcmNicParamInfo( U32 handle, U8 *pParam, U8 *pCurVal,
                U32 *pCurValLen, U8 *pParamInfo, U32 *pParamInfoLen,
                U8 *pParamEnum, U32 *pParamEnumLen );
U32     QLmapiSetBrcmNicParam2( U32 handle, U8 *pParam, U8 *pNewVal );

U32     QLmapiGetNivCfg( U32 handle, QL_NIV_CFG *pNivCfg );
U32     QLmapiSetNivCfg( U32 handle, QL_NIV_CFG *pNivCfg );
U32     QLmapiGetNivPortProfile( U32 handle,
                QL_NIV_PORT_PROFILES_CFG *pNivProfile );
U32     QLmapiGetFLRCfg( U32 handle, U32 *pFLRCfg );
U32     QLmapiSetFLRCfg( U32 handle, U32 uFLRCfg );

// Not supported in bmapilnx yet...
//U32     QLmapiGetEEEInfo( U32 handle, QL_EEE_INFO *pEEEInfo );

U32     QLmapiGetSRIOVforSF( U32 handle, U32 *pSriov, U32 *pNumOfVF );
U32     QLmapiSetSRIOVforSF( U32 handle, U32 uSriov, U32 uNumOfVF );
U32     QLmapiGetSRIOVSwitchInfo( U32 handle, QL_SRIOV_SWITCH_INFO *pSwitchInfo );
U32     QLmapiGetSRIOVSwitchStats( U32 handle, QL_SRIOV_SWITCH_STATS *pSwitchStats );
U32     QLmapiGetSRIOVVFInfo( U32 handle, U32 *pNumBuf,  QL_SRIOV_VF_INFO *pVFInfo );
U32     QLmapiGetSRIOVVFStats( U32 handle, QL_SRIOV_SWITCH_STATS *pCurSwitchStats, U32 uNumBuf, 
							 QL_SRIOV_VF_STATS *pVFStats );

U32	QLmapiGetSRIOVVFVC(U32 handle,QL_ADAPTER_INFO_EX *pNicInfoEx,U32 *val );

#ifdef __cplusplus
};
#endif

#endif /* __QLMAPI_h__ */
