#ifndef _everest_pci_h_
#define _everest_pci_h_

#include "bcmtype.h"
#ifdef __LINUX
#include <linux/pci.h>
#endif

/* TBA: add everest content to: 1. enum board_t, 2. board_info 3. evr_info  */
/* TBA: split defined arrays into c file */

typedef enum {
#ifdef UM_DEBUG_SESSION
    BCM5706C,
    BCM5706S,
    BCM5708C,
    BCM5708S,
#endif   
    BCM57710,     /* E1 */
    BCM57711,     /* E1.5 */
    BCM57711E,    /* E1.5 */
    BCM57712,     /* E2 */
    BCM57712E,    /* E2 */
    BCM57713,     /* E2 */
    BCM57713E,    /* E2 */
    BCM57713E_VF, /* E2 VF */
    BCM57810, 	  /* E3 */
    BCM57840_OBSOLETE, 	  /* E3 */
    BCM57800,     /* E3 */
    BCM57810_MF,  /* E3 + NPAR */
    BCM57840_MF_OBSOLETE,  /* E3 + NPAR */  
    BCM57800_MF,  /* E3 + NPAR */ 
    BCM57810_VF,  /* E3_VF */
    BCM57800_VF,  /* E3_VF */ 
    BCM57811,     /* E3 single port */ 
    BCM57811_MF,  /* E3 single port in NPAR mode */ 
    BCM57811_VF,   /* E3 single port VF */ 
    BCM57840_4_10,   
    BCM57840_2_20,   
    BCM57840_MF,   
    BCM57840_VF    
} board_t;


#ifndef PCI_ANY_ID
#define PCI_ANY_ID  0xffff
#endif

#ifndef PCI_VENDOR_ID_BROADCOM
#define PCI_VENDOR_ID_BROADCOM  0x14e4
#endif

#ifndef PCI_VENDOR_ID_QLOGIC
#define PCI_VENDOR_ID_QLOGIC  0x1077
#endif
#ifndef __LINUX
struct pci_device_id {
  u32_t vendor;
  u32_t device;           // Vendor and device ID or PCI_ANY_ID
  u32_t subvendor;
  u32_t subdevice;     // Subsystem ID's or PCI_ANY_ID 
  u32_t class;
  u32_t class_mask;        // (class,subclass,prog-if) triplet 
  u32_t driver_data;             // Data private to the driver 
};
#endif

#ifndef DEFINE_PCI_DEVICE_TABLE
#define DEFINE_PCI_DEVICE_TABLE(tbl) const struct pci_device_id evst_pci_tbl[]
#endif

#ifndef PCI_VDEVICE
#define PCI_VDEVICE(vendor, device)             \
	PCI_VENDOR_ID_##vendor, (device),       \
	PCI_ANY_ID, PCI_ANY_ID, 0, 0
#endif


static DEFINE_PCI_DEVICE_TABLE(evst_pci_tbl) = {
	{ PCI_VDEVICE(BROADCOM, 0x164e), BCM57710 },
	{ PCI_VDEVICE(BROADCOM, 0x164f), BCM57711 },
	{ PCI_VDEVICE(BROADCOM, 0x1650), BCM57711E },
	{ PCI_VDEVICE(BROADCOM, 0x1662), BCM57712 },
	{ PCI_VDEVICE(BROADCOM, 0x1663), BCM57712E },
	{ PCI_VDEVICE(BROADCOM, 0x1651), BCM57713 },
	{ PCI_VDEVICE(BROADCOM, 0x1652), BCM57713E },    
	{ PCI_VDEVICE(BROADCOM, 0x168a), BCM57800 },
	{ PCI_VDEVICE(BROADCOM, 0x16a5), BCM57800_MF },
	{ PCI_VDEVICE(BROADCOM, 0x168e), BCM57810 },
	{ PCI_VDEVICE(BROADCOM, 0x16ae), BCM57810_MF },
	{ PCI_VDEVICE(BROADCOM, 0x168d), BCM57840_OBSOLETE },
	{ PCI_VDEVICE(BROADCOM, 0x16ab), BCM57840_MF_OBSOLETE },
	{ PCI_VDEVICE(BROADCOM, 0x16a9), BCM57800_VF },
	{ PCI_VDEVICE(BROADCOM, 0x16af), BCM57810_VF },
	{ PCI_VDEVICE(BROADCOM, 0x163d), BCM57811 },
	{ PCI_VDEVICE(BROADCOM, 0x163e), BCM57811_MF },
	{ PCI_VDEVICE(BROADCOM, 0x163f), BCM57811_VF },
	{ PCI_VDEVICE(BROADCOM, 0x16a1), BCM57840_4_10 },
	{ PCI_VDEVICE(QLOGIC, 0x16a1), BCM57840_4_10 },
	{ PCI_VDEVICE(BROADCOM, 0x16a2), BCM57840_2_20 },
	{ PCI_VDEVICE(QLOGIC, 0x16a2), BCM57840_2_20 },
	{ PCI_VDEVICE(BROADCOM, 0x16a4), BCM57840_MF },
	{ PCI_VDEVICE(BROADCOM, 0x16ad), BCM57840_VF },  
	{ 0 }
}; 

u8_t um_is_everest_device(
    IN u16_t vid, 
    IN u16_t did, 
    OUT board_t *board
    );


#endif /* _everest_pci_h_ */
