Name : netxtreme2
Version : 7.13.01
Release : 1.rhel7u1
Group : System Environment/Base
Vendor : QLogic Corporation
URL : http://www.qlogic.com
License : GPLv2
Source0 : %{name}-%{version}.tar.gz
Source1 : bcm_preamble
Source2 : netxtreme2.files
Source3 : netxtreme2.conf
BuildRoot: %{_tmppath}/%{name}-buildroot
BuildRequires: %kernel_module_package_buildreqs
Summary : QLogic 1/10 GbE Multifunction, iSCSI, and FCoE Drivers for Linux

%define packinfo "This package contains the QLogic NetXtreme II FCoE (bnx2fc), iSCSI (bnx2i), 1-Gigabit (bnx2), and 10-Gigabit (bnx2x) ethernet drivers."
%define sourceinfo "SRPMS available at http://ldriver.qlogic.com/driver-srpms/"
%define gpginfo "RPM public key available at http://ldriver.qlogic.com/RPM-public-key/ and Module public key available at http://ldriver.qlogic.com/Module-public-key/"
%define docsinfo "Documentation for the QLogic NetXtreme II FCoE, iSCSI, 1-Gigabit, and 10-Gigabit ethernet drivers."
%define debug_package %{nil}

%define _host_vendor redhat

%define mod_sign_files /home/nx2-signing
%define module_key %{mod_sign_files}/qlgc_module_signing_key.priv
%define module_cer %{mod_sign_files}/qlgc_module.cer


%if %{!?KVER:1}%{?KVER:0}
%define flav ""
%endif
%if %{!?KVER:0}%{?KVER:1}
%if "%{lnxdist}" == "rhel7sp0"
%define flav default
%define kverrel %(echo %{KVER} | sed -e 's/([0-9].[0-9]+.[0-9]*-[0-9]*.[Ee][Ll][5-7]*).*/1/')
%else
%define flav %(echo %{KVER} | awk -F"el5" '{print $2}')
%define kverrel %(echo %{KVER} | awk -F"el5" '{print $1"el5"}')
%endif
%if "%{flav}" == ""
%define flav default
%endif
%endif

%kernel_module_package -p %{SOURCE1} -f %{SOURCE2} default

%description
%{packinfo}
%{gpginfo}

%description -n kmod-%name
This package provides the %name kernel modules built for the Linux
kernel %(echo `uname -r`) for the %_target_cpu family of processors.
%{sourceinfo}
%{gpginfo}

%package doc
Summary: Documentation for the QLogic NetXtreme II FCoE, iSCSI, 1-Gigabit, and 10-Gigabit ethernet drivers
Group: System/Kernel

%description doc
%{docsinfo}

%prep
%setup
set -- *
mkdir source
mv "$@" source/

cp -f source/bnx2/README.TXT source/README.bnx2.TXT
cp -f source/bnx2x/README.TXT source/README.bnx2x.TXT
cp -f source/bnx2/RELEASE.TXT source/RELEASE.bnx2.TXT
cp -f source/bnx2x/RELEASE.TXT source/RELEASE.bnx2x.TXT
cp -f source/bnx2i/docs/README.TXT source/README.bnx2i.TXT
cp -f source/bnx2i/docs/RELEASE.TXT source/RELEASE.bnx2i.TXT
cp -f source/bnx2fc/docs/README.TXT source/README.bnx2fc.TXT
cp -f source/bnx2fc/docs/RELEASE.TXT source/RELEASE.bnx2fc.TXT

mkdir obj

%build
export KVER=%{kverrel}
export KABIRPM=1
export EXTRA_CFLAGS='-DVERSION="%version"'

%if %{!?KVER:0}%{?KVER:1}
%define flavors %{flav}
%else
%define flavors %{flavors_to_build}
%endif

for flavor in %{flavors}; do
rm -rf obj/$flavor
cp -r source obj/$flavor
export LINUXSRC=%{kernel_source $flavor}
if [ $flavor == "default" ]; then
kernel_flavor=${KVER}
else
kernel_flavor=${KVER}${flavor}
fi
make -C obj/$flavor KVER=$kernel_flavor
done

%install
export KVER=%{kverrel}
export KABIRPM=1
export EXTRA_CFLAGS='-DVERSION="%version"'

%if %{!?KVER:0}%{?KVER:1}
%define flavors %{flav}
%else
%define flavors %{flavors_to_build}
%endif

for flavor in %{flavors}; do
export LINUXSRC=%{kernel_source $flavor}
if [ $flavor == "default" ]; then
kernel_flavor=${KVER}
else
kernel_flavor=${KVER}${flavor}
fi

if [ -f %{module_key} ] && [ -f %{module_cer} ]; then
perl /usr/src/kernels/`uname -r`/scripts/sign-file sha256 %{module_key} %{module_cer} obj/${flavor}/bnx2/src/bnx2.ko
perl /usr/src/kernels/`uname -r`/scripts/sign-file sha256 %{module_key} %{module_cer} obj/${flavor}/bnx2x/src/bnx2x.ko
perl /usr/src/kernels/`uname -r`/scripts/sign-file sha256 %{module_key} %{module_cer} obj/${flavor}/bnx2/src/cnic.ko
perl /usr/src/kernels/`uname -r`/scripts/sign-file sha256 %{module_key} %{module_cer} obj/${flavor}/bnx2i/driver/bnx2i.ko
perl /usr/src/kernels/`uname -r`/scripts/sign-file sha256 %{module_key} %{module_cer} obj/${flavor}/bnx2fc/driver/bnx2fc.ko
fi

dest_dir=${RPM_BUILD_ROOT}/lib/modules/$kernel_flavor/extra/%{name}

mkdir -p $dest_dir
install -m 444 obj/${flavor}/bnx2/src/bnx2.ko $dest_dir
install -m 444 obj/${flavor}/bnx2x/src/bnx2x.ko $dest_dir
install -m 444 obj/${flavor}/bnx2/src/cnic.ko $dest_dir
install -m 444 obj/${flavor}/bnx2i/driver/bnx2i.ko $dest_dir
install -m 444 obj/${flavor}/bnx2fc/driver/bnx2fc.ko $dest_dir
done

install -m 644 -D %{SOURCE3} $RPM_BUILD_ROOT/etc/depmod.d/%{name}.conf

man_dir=${RPM_BUILD_ROOT}/usr/share/man/man4
mkdir -p ${man_dir}
gzip -c source/bnx2/src/bnx2.4 > ${man_dir}/bnx2.4.gz
gzip -c source/bnx2x/src/bnx2x.4 > ${man_dir}/bnx2x.4.gz

%clean
rm -rf %{buildroot}
rm -rf $RPM_BUILD_ROOT

%files doc
%defattr(-, root, root)
%doc source/INSTALL.TXT
%doc source/README.bnx2.TXT
%doc source/RELEASE.bnx2.TXT
%doc source/README.bnx2x.TXT
%doc source/RELEASE.bnx2x.TXT
%_mandir/man4/bnx2.4.gz
%_mandir/man4/bnx2x.4.gz
%doc source/README.bnx2i.TXT
%doc source/RELEASE.bnx2i.TXT
%doc source/README.bnx2fc.TXT
%doc source/RELEASE.bnx2fc.TXT


%define major_change (Severity:Critical)
%define medium_change (Severity:Medium)
%define minor_change (Severity:Minor)

%changelog
* Fri Jul 24 2015 QLogic Build Environment 7.12.37.1
- added RH5.11 support.
- added RH6.6 & RH6.7 support.
- added RH7.0 & RH7.1 support.
- added SLES11-SP4 & SLES12 support.
- added VLAN filtering offload support.
- added Debian GNU/Linux 7 (wheezy) support.
- In RHEL7.0 and 7.1, bnx2x will be rolled back to inbox after system reboot (80071).
- SRIOV : MAC address change inside VM is not allowed unless interface is down (80309).
- RH7.x:  Tunneling offload is not enabled (79269).
- self test fails on 20G adapter (79295).
- VF interface vlan-filtering stopped working (79365).
- Fail to force link speed other than 20G in KR2 (77841).
- Incorrect asymmetric flow-control behavior (75504).
- Dynamic VF enumeration fails for 578xx adapter in SLES11 SP4 (78590).
- Inner-to-outer vlan priority mapping doesn't work (RH6.x [pre 2.6.38 kernels]).
- Packets from a VF with pvid configured which were sent with a different vlan were transmitted instead of being discarded.
- UDP packets cannot pass to the upper application (5709).
- Out of memory issue when the adapter is reset (5709).
- iSCSI offload: Driver displaying incorrect remote port (77842).
- FCoE offload: Initiators failed FLOGI on SLES 11 SP4 RC1 (79704).

* Fri Dec 13 2013 Broadcom Build Environment
-Add RH5.10 support.
-Add RH6.5 support.
-FC-TAPE - Host responds early to a requested resend delay - Linux (70101)
-SLES11 MEZ75 IO halt with Nexus reboot tests (70728)
-SLES 11 blade loses all targets from BLOM port during fabric uplink add/remove (70187)
-KVM gso and gro are not working on hv and vm as expected (70506)
-SRIOV mtu toggle failure (70530)
-SRIOV hv reboots on pf toggle with vfs passed through on it. (70531)
-Guest OS dosent boot after attaching VF in RHEL6.3x64bit for 57840 device. (68426)
-[NET]SUT reboot&MCE report when create 30th/31st VF on 57810 device on SLES11 SP2. (69263)
-RH Cert - RH5 | U8 | v7-1.5-33 | 57810 | Flex Network Test failed. (70427)
-BACS 16.2.0: Show ETS/Priority Tagging/PFC as operational when DCBX is disabled on the switch side. (69690)
-Incorrect port value is displayed for connected/unconnected ports of 57810 for RHEL5.9 64bits. (68627)
-VFs are not getting created for Broadcom adapters in RHEL5.10 OS. (71456)
*Fri Jun 21 2013 Broadcom Build Environment
-Added Linux SRIOV support
-Added iSCSI & FCoE HBA support for specific HP adapters and devices
-Added VC4.10 support
-Added BCV support
-When GRO setting changes while LRO is enabled, don't reload as LRO takes precedence.
-Allow UDP tunneling offload
-Enable IPGRE RSS by default
-Support different GRE RSS modes.

